/******************************************************************************

  Copyright (C), 2001-2011, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : vou_reg.h
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2011/06/28
  Description   :
  History       :
  1.Date        : 2011/06/28
    Author      : z00185248	
    Modification: Created file

******************************************************************************/
#ifndef __VOU_REG_H__
#define __VOU_REG_H__

#include "hi_type.h"
	
#ifdef __cplusplus
#if __cplusplus
	extern "C"{
#endif
#endif /* End of #ifdef __cplusplus */

// Define the union U_VHDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_2            : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1            : 11   ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCTRL;

// Define the union U_VHDUPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_3            : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDUPD;

// Define the union U_VHDLADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_laddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDLADDR;
// Define the union U_VHDLCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_lcaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDLCADDR;
// Define the union U_VHDCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDCADDR;
// Define the union U_VHDCCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDCCADDR;
// Define the union U_VHDNADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_naddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDNADDR;
// Define the union U_VHDNCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ncaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDNCADDR;
// Define the union U_VHDSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDSTRIDE;

// Define the union U_VHDIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_5            : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDIRESO;

// Define the union U_VHDLKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_6            : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDLKEY;

// Define the union U_VHDCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_8            : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCBMPARA;

// Define the union U_VHDDIEADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dieaddr                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIEADDR;
// Define the union U_VHDWBC1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbc1addr                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDWBC1ADDR;
// Define the union U_VHDWBC1STRD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc1strd              : 16  ; // [15..0]
        HI_U32    req_interval          : 10  ; // [25..16]
        HI_U32    Reserved_9            : 4   ; // [29..26]
        HI_U32    wbc1_dft              : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDWBC1STRD;

// Define the union U_VHDDIESTADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 diestaddr               : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIESTADDR;
// Define the union U_VHDDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_10           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDFPOS;

// Define the union U_VHDDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_12           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDLPOS;

// Define the union U_VHDVFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_13           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDVFPOS;

// Define the union U_VHDVLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_14           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDVLPOS;

// Define the union U_VHDBK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDBK;

// Define the union U_VHDCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc2               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc0               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_15           : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCIDC;

// Define the union U_VHDCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc2               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc0               : 9   ; // [26..18]
        HI_U32    Reserved_17           : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCODC;

// Define the union U_VHDCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_19           : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_18           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCP0;

// Define the union U_VHDCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_21           : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_20           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCP1;

// Define the union U_VHDCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_23           : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_22           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCP2;

// Define the union U_VHDCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_25           : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_24           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCP3;

// Define the union U_VHDCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_26           : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCSCP4;

// Define the union U_VHDACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM0;

// Define the union U_VHDACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_28           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM1;

// Define the union U_VHDACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_29           : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM2;

// Define the union U_VHDACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_30           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM3;

// Define the union U_VHDACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_31           : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM4;

// Define the union U_VHDACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_32           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM5;

// Define the union U_VHDACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_33           : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM6;

// Define the union U_VHDACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_34           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACM7;

// Define the union U_VHDHSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_37           : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_36           : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_35           : 5   ; // [29..25]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDHSP;

// Define the union U_VHDHLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_38           : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDHLOFFSET;

// Define the union U_VHDHCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_39           : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDHCOFFSET;

// Define the union U_VHDVSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_40           : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    Reserved_vchmid_en    : 2   ; // [29..28]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDVSP;

// Define the union U_VHDVSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_42           : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDVSR;

// Define the union U_VHDVOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDVOFFSET;

// Define the union U_VHDZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_43           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDZMEORESO;

// Define the union U_VHDZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_44           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDZMEIRESO;

// Define the union U_VHDZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_45           : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDZMEDBG;

// Define the union U_VHDCOEF00
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_46           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCOEF00;

// Define the union U_VHDCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_47           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCOEF01;

// Define the union U_VHDCOEF10
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_48           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCOEF10;

// Define the union U_VHDCOEF11
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_49           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCOEF11;

// Define the union U_VHDACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCTHD1;

// Define the union U_VHDACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_50           : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCTHD2;

// Define the union U_VHDACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_51           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCLOWN;

// Define the union U_VHDACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_53           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCMEDN;

// Define the union U_VHDACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_55           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCHIGHN;

// Define the union U_VHDACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_57           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCMLN;

// Define the union U_VHDACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_59           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCMHN;

// Define the union U_VHDACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_61           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACC3LOW;

// Define the union U_VHDACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_63           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACC3MED;

// Define the union U_VHDACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_64           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACC3HIGH;

// Define the union U_VHDACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_65           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACC8MLOW;

// Define the union U_VHDACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_66           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACC8MHIGH;

// Define the union U_VHDACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_67           : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDACCTOTAL;

// Define the union U_VHDIFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_69           : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_68           : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDIFIRCOEF01;

// Define the union U_VHDIFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_72           : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_71           : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDIFIRCOEF23;

// Define the union U_VHDIFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_74           : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_73           : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDIFIRCOEF45;

// Define the union U_VHDIFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_76           : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_75           : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDIFIRCOEF67;

// Define the union U_VHDDIECTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_78           : 16  ; // [15..0]
        HI_U32    stinfo_stop           : 1   ; // [16]
        HI_U32    die_rst               : 1   ; // [17]
        HI_U32    Reserved_77           : 6   ; // [23..18]
        HI_U32    die_chmmode           : 2   ; // [25..24]
        HI_U32    die_lmmode            : 2   ; // [27..26]
        HI_U32    die_out_sel_c         : 1   ; // [28]
        HI_U32    die_out_sel_l         : 1   ; // [29]
        HI_U32    die_chroma_en         : 1   ; // [30]
        HI_U32    die_luma_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIECTRL;

// Define the union U_VHDDIELMA0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_qtbl1            : 8   ; // [7..0]
        HI_U32    luma_qtbl2            : 8   ; // [15..8]
        HI_U32    luma_qtbl3            : 8   ; // [23..16]
        HI_U32    scale_ratio_ppd       : 6   ; // [29..24]
        HI_U32    Reserved_80           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIELMA0;

// Define the union U_VHDDIELMA1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_reqtbl0          : 8   ; // [7..0]
        HI_U32    luma_reqtbl1          : 8   ; // [15..8]
        HI_U32    luma_reqtbl2          : 8   ; // [23..16]
        HI_U32    luma_reqtbl3          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIELMA1;

// Define the union U_VHDDIELMA2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_win_size         : 2   ; // [1..0]
        HI_U32    luma_scesdf_max       : 1   ; // [2]
        HI_U32    die_st_qrst_en        : 1   ; // [3]
        HI_U32    die_st_n_en           : 1   ; // [4]
        HI_U32    die_st_m_en           : 1   ; // [5]
        HI_U32    die_st_l_en           : 1   ; // [6]
        HI_U32    die_st_k_en           : 1   ; // [7]
        HI_U32    luma_qrst_max         : 1   ; // [8]
        HI_U32    luma_mf_max           : 1   ; // [9]
        HI_U32    chroma_mf_max         : 1   ; // [10]
        HI_U32    Reserved_82           : 18  ; // [28..11]
        HI_U32    die_st_mode           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIELMA2;

// Define the union U_VHDDIEINTEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir_inten             : 4   ; // [3..0]
        HI_U32    Reserved_84           : 3   ; // [6..4]
        HI_U32    dir_ck_enh            : 1   ; // [7]
        HI_U32    dir_inten_ver         : 4   ; // [11..8]
        HI_U32    Reserved_83           : 4   ; // [15..12]
        HI_U32    ver_min_inten         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIEINTEN;

// Define the union U_VHDDIESCALE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    range_scale           : 8   ; // [7..0]
        HI_U32    Reserved_85           : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIESCALE;

// Define the union U_VHDDIECHECK1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ck_max_range          : 6   ; // [5..0]
        HI_U32    Reserved_88           : 2   ; // [7..6]
        HI_U32    ck_range_gain         : 4   ; // [11..8]
        HI_U32    Reserved_87           : 4   ; // [15..12]
        HI_U32    ck_gain               : 4   ; // [19..16]
        HI_U32    Reserved_86           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIECHECK1;

// Define the union U_VHDDIECHECK2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ck_max_range          : 6   ; // [5..0]
        HI_U32    Reserved_91           : 2   ; // [7..6]
        HI_U32    ck_range_gain         : 4   ; // [11..8]
        HI_U32    Reserved_90           : 4   ; // [15..12]
        HI_U32    ck_gain               : 4   ; // [19..16]
        HI_U32    Reserved_89           : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIECHECK2;

// Define the union U_VHDDIEDIR0_3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir0_mult             : 6   ; // [5..0]
        HI_U32    Reserved_95           : 2   ; // [7..6]
        HI_U32    dir1_mult             : 6   ; // [13..8]
        HI_U32    Reserved_94           : 2   ; // [15..14]
        HI_U32    dir2_mult             : 6   ; // [21..16]
        HI_U32    Reserved_93           : 2   ; // [23..22]
        HI_U32    dir3_mult             : 6   ; // [29..24]
        HI_U32    Reserved_92           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIEDIR0_3;

// Define the union U_VHDDIEDIR4_7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir4_mult             : 6   ; // [5..0]
        HI_U32    Reserved_99           : 2   ; // [7..6]
        HI_U32    dir5_mult             : 6   ; // [13..8]
        HI_U32    Reserved_98           : 2   ; // [15..14]
        HI_U32    dir6_mult             : 6   ; // [21..16]
        HI_U32    Reserved_97           : 2   ; // [23..22]
        HI_U32    dir7_mult             : 6   ; // [29..24]
        HI_U32    Reserved_96           : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIEDIR4_7;

// Define the union U_VHDDIEDIR8_11
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir8_mult             : 6   ; // [5..0]
        HI_U32    Reserved_103          : 2   ; // [7..6]
        HI_U32    dir9_mult             : 6   ; // [13..8]
        HI_U32    Reserved_102          : 2   ; // [15..14]
        HI_U32    dir10_mult            : 6   ; // [21..16]
        HI_U32    Reserved_101          : 2   ; // [23..22]
        HI_U32    dir11_mult            : 6   ; // [29..24]
        HI_U32    Reserved_100          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIEDIR8_11;

// Define the union U_VHDDIEDIR12_14
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir12_mult            : 6   ; // [5..0]
        HI_U32    Reserved_106          : 2   ; // [7..6]
        HI_U32    dir13_mult            : 6   ; // [13..8]
        HI_U32    Reserved_105          : 2   ; // [15..14]
        HI_U32    dir14_mult            : 6   ; // [21..16]
        HI_U32    Reserved_104          : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIEDIR12_14;

// Define the union U_VHDDIESTA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    die_ref_field         : 1   ; // [0]
        HI_U32    Reserved_107          : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDDIESTA;

// Define the union U_VHDDIESTKADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_k_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIESTKADDR;
// Define the union U_VHDDIESTLADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_l_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIESTLADDR;
// Define the union U_VHDDIESTMADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_m_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIESTMADDR;
// Define the union U_VHDDIESTNADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_n_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIESTNADDR;
// Define the union U_VHDDIESTSQTRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_sqtr_addr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDDIESTSQTRADDR;
// Define the union U_VHDCCRSCLR0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    no_ccr_detect_thd     : 8   ; // [7..0]
        HI_U32    no_ccr_detect_max     : 8   ; // [15..8]
        HI_U32    chroma_ma_offset      : 8   ; // [23..16]
        HI_U32    chroma_ccr_en         : 1   ; // [24]
        HI_U32    Reserved_110          : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCCRSCLR0;

// Define the union U_VHDCCRSCLR1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    max_xchroma           : 8   ; // [7..0]
        HI_U32    no_ccr_detect_blend   : 4   ; // [11..8]
        HI_U32    Reserved_111          : 4   ; // [15..12]
        HI_U32    similar_thd           : 8   ; // [23..16]
        HI_U32    similar_max           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDCCRSCLR1;

// Define the union U_VHDPDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_113          : 20  ; // [19..0]
        HI_U32    edge_smooth_ratio     : 8   ; // [27..20]
        HI_U32    Reserved_112          : 1   ; // [28]
        HI_U32    dir_mch_c             : 1   ; // [29]
        HI_U32    edge_smooth_en        : 1   ; // [30]
        HI_U32    dir_mch_l             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDCTRL;

// Define the union U_VHDPDBLKPOS0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    blk_x                 : 12  ; // [11..0]
        HI_U32    blk_y                 : 12  ; // [23..12]
        HI_U32    Reserved_115          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDBLKPOS0;

// Define the union U_VHDPDBLKPOS1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    blk_x                 : 12  ; // [11..0]
        HI_U32    blk_y                 : 12  ; // [23..12]
        HI_U32    Reserved_116          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDBLKPOS1;

// Define the union U_VHDPDBLKTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    stillblk_thd          : 8   ; // [7..0]
        HI_U32    diff_movblk_thd       : 8   ; // [15..8]
        HI_U32    Reserved_117          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDBLKTHD;

// Define the union U_VHDPDHISTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hist_thd0             : 8   ; // [7..0]
        HI_U32    hist_thd1             : 8   ; // [15..8]
        HI_U32    hist_thd2             : 8   ; // [23..16]
        HI_U32    hist_thd3             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDHISTTHD;

// Define the union U_VHDPDUMTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    um_thd0               : 8   ; // [7..0]
        HI_U32    um_thd1               : 8   ; // [15..8]
        HI_U32    um_thd2               : 8   ; // [23..16]
        HI_U32    Reserved_118          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDUMTHD;

// Define the union U_VHDPDPCCCORING
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coring_tkr            : 8   ; // [7..0]
        HI_U32    coring_norm           : 8   ; // [15..8]
        HI_U32    coring_blk            : 8   ; // [23..16]
        HI_U32    Reserved_119          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDPCCCORING;

// Define the union U_VHDPDPCCHTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    pcc_hthd              : 8   ; // [7..0]
        HI_U32    Reserved_120          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDPCCHTHD;

// Define the union U_VHDPDPCCVTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    pcc_vthd0             : 8   ; // [7..0]
        HI_U32    pcc_vthd1             : 8   ; // [15..8]
        HI_U32    pcc_vthd2             : 8   ; // [23..16]
        HI_U32    pcc_vthd3             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDPCCVTHD;

// Define the union U_VHDPDITDIFFVTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    itdiff_vthd0          : 8   ; // [7..0]
        HI_U32    itdiff_vthd1          : 8   ; // [15..8]
        HI_U32    itdiff_vthd2          : 8   ; // [23..16]
        HI_U32    itdiff_vthd3          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDITDIFFVTHD;

// Define the union U_VHDPDLASITHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    lasi_thd              : 8   ; // [7..0]
        HI_U32    edge_thd              : 8   ; // [15..8]
        HI_U32    Reserved_121          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDPDLASITHD;

// Define the union U_VHDPDFRMITDIFF
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 frm_it_diff             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDFRMITDIFF;
// Define the union U_VHDPDSTLBLKSAD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 stlblk_sad              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDSTLBLKSAD;
// Define the union U_VHDPDHISTBIN
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 hsit_bin                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDHISTBIN;
// Define the union U_VHDPDUMMATCH0
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 match_um                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDUMMATCH0;
// Define the union U_VHDPDUMNOMATCH0
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 nomatch_um              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDUMNOMATCH0;
// Define the union U_VHDPDUMMATCH1
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 match_um                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDUMMATCH1;
// Define the union U_VHDPDUMNOMATCH1
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 nomatch_um              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDUMNOMATCH1;
// Define the union U_VHDPDPCCFFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_ffwd                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCFFWD;
// Define the union U_VHDPDPCCFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_fwd                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCFWD;
// Define the union U_VHDPDPCCBWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_bwd                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCBWD;
// Define the union U_VHDPDPCCCRSS
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_crss                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCCRSS;
// Define the union U_VHDPDPCCPW
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_pw                  : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCPW;
// Define the union U_VHDPDPCCFWDTKR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_fwd_tkr             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCFWDTKR;
// Define the union U_VHDPDPCCBWDTKR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_bwd_tkr             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCBWDTKR;
// Define the union U_VHDPDPCCBLKFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_blk_fwd             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCBLKFWD;
// Define the union U_VHDPDPCCBLKBWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_blk_bwd             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDPCCBLKBWD;
// Define the union U_VHDPDLASICNT14
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDLASICNT14;
// Define the union U_VHDPDLASICNT32
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDLASICNT32;
// Define the union U_VHDPDLASICNT34
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDPDLASICNT34;
// Define the union U_VHDP0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_126          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP0RESO;

// Define the union U_VHDP0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP0LADDR;
// Define the union U_VHDP0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP0CADDR;
// Define the union U_VHDP0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP0STRIDE;

// Define the union U_VHDP0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_127          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP0VFPOS;

// Define the union U_VHDP0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_128          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP0VLPOS;

// Define the union U_VHDP1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_129          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP1RESO;

// Define the union U_VHDP1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP1LADDR;
// Define the union U_VHDP1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP1CADDR;
// Define the union U_VHDP1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP1STRIDE;

// Define the union U_VHDP1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_131          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP1VFPOS;

// Define the union U_VHDP1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_132          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP1VLPOS;

// Define the union U_VHDP2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_133          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP2RESO;

// Define the union U_VHDP2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP2LADDR;
// Define the union U_VHDP2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP2CADDR;
// Define the union U_VHDP2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP2STRIDE;

// Define the union U_VHDP2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_135          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP2VFPOS;

// Define the union U_VHDP2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_136          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP2VLPOS;

// Define the union U_VHDP3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_137          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP3RESO;

// Define the union U_VHDP3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP3LADDR;
// Define the union U_VHDP3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP3CADDR;
// Define the union U_VHDP3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP3STRIDE;

// Define the union U_VHDP3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_139          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP3VFPOS;

// Define the union U_VHDP3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_140          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP3VLPOS;

// Define the union U_VHDP4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_141          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP4RESO;

// Define the union U_VHDP4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP4LADDR;
// Define the union U_VHDP4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP4CADDR;
// Define the union U_VHDP4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP4STRIDE;

// Define the union U_VHDP4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_143          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP4VFPOS;

// Define the union U_VHDP4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_144          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP4VLPOS;

// Define the union U_VHDP5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_145          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP5RESO;

// Define the union U_VHDP5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP5LADDR;
// Define the union U_VHDP5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP5CADDR;
// Define the union U_VHDP5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP5STRIDE;

// Define the union U_VHDP5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_147          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP5VFPOS;

// Define the union U_VHDP5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_148          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP5VLPOS;

// Define the union U_VHDP6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_149          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP6RESO;

// Define the union U_VHDP6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP6LADDR;
// Define the union U_VHDP6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP6CADDR;
// Define the union U_VHDP6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP6STRIDE;

// Define the union U_VHDP6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_151          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP6VFPOS;

// Define the union U_VHDP6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_152          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP6VLPOS;

// Define the union U_VHDP7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_153          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP7RESO;

// Define the union U_VHDP7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP7LADDR;
// Define the union U_VHDP7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP7CADDR;
// Define the union U_VHDP7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP7STRIDE;

// Define the union U_VHDP7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_155          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP7VFPOS;

// Define the union U_VHDP7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_156          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP7VLPOS;

// Define the union U_VHDP8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_157          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP8RESO;

// Define the union U_VHDP8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP8LADDR;
// Define the union U_VHDP8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP8CADDR;
// Define the union U_VHDP8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP8STRIDE;

// Define the union U_VHDP8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_159          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP8VFPOS;

// Define the union U_VHDP8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_160          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP8VLPOS;

// Define the union U_VHDP9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_161          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP9RESO;

// Define the union U_VHDP9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP9LADDR;
// Define the union U_VHDP9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP9CADDR;
// Define the union U_VHDP9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP9STRIDE;

// Define the union U_VHDP9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_163          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP9VFPOS;

// Define the union U_VHDP9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_164          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP9VLPOS;

// Define the union U_VHDP10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_165          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP10RESO;

// Define the union U_VHDP10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP10LADDR;
// Define the union U_VHDP10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP10CADDR;
// Define the union U_VHDP10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP10STRIDE;

// Define the union U_VHDP10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_167          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP10VFPOS;

// Define the union U_VHDP10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_168          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP10VLPOS;

// Define the union U_VHDP11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_169          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP11RESO;

// Define the union U_VHDP11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP11LADDR;
// Define the union U_VHDP11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP11CADDR;
// Define the union U_VHDP11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP11STRIDE;

// Define the union U_VHDP11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_171          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP11VFPOS;

// Define the union U_VHDP11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_172          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP11VLPOS;

// Define the union U_VHDP12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_173          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP12RESO;

// Define the union U_VHDP12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP12LADDR;
// Define the union U_VHDP12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP12CADDR;
// Define the union U_VHDP12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP12STRIDE;

// Define the union U_VHDP12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_175          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP12VFPOS;

// Define the union U_VHDP12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_176          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP12VLPOS;

// Define the union U_VHDP13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_177          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP13RESO;

// Define the union U_VHDP13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP13LADDR;
// Define the union U_VHDP13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP13CADDR;
// Define the union U_VHDP13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP13STRIDE;

// Define the union U_VHDP13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_179          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP13VFPOS;

// Define the union U_VHDP13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_180          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP13VLPOS;

// Define the union U_VHDP14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_181          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP14RESO;

// Define the union U_VHDP14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP14LADDR;
// Define the union U_VHDP14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP14CADDR;
// Define the union U_VHDP14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP14STRIDE;

// Define the union U_VHDP14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_183          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP14VFPOS;

// Define the union U_VHDP14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_184          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP14VLPOS;

// Define the union U_VHDP15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_185          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP15RESO;

// Define the union U_VHDP15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP15LADDR;
// Define the union U_VHDP15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP15CADDR;
// Define the union U_VHDP15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP15STRIDE;

// Define the union U_VHDP15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_187          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP15VFPOS;

// Define the union U_VHDP15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_188          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP15VLPOS;

// Define the union U_VHDP16RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_189          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP16RESO;

// Define the union U_VHDP16LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP16LADDR;
// Define the union U_VHDP16CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP16CADDR;
// Define the union U_VHDP16STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP16STRIDE;

// Define the union U_VHDP16VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_191          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP16VFPOS;

// Define the union U_VHDP16VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_192          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP16VLPOS;

// Define the union U_VHDP17RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_193          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP17RESO;

// Define the union U_VHDP17LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP17LADDR;
// Define the union U_VHDP17CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP17CADDR;
// Define the union U_VHDP17STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP17STRIDE;

// Define the union U_VHDP17VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_195          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP17VFPOS;

// Define the union U_VHDP17VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_196          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP17VLPOS;

// Define the union U_VHDP18RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_197          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP18RESO;

// Define the union U_VHDP18LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP18LADDR;
// Define the union U_VHDP18CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP18CADDR;
// Define the union U_VHDP18STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP18STRIDE;

// Define the union U_VHDP18VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_199          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP18VFPOS;

// Define the union U_VHDP18VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_200          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP18VLPOS;

// Define the union U_VHDP19RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_201          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP19RESO;

// Define the union U_VHDP19LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP19LADDR;
// Define the union U_VHDP19CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP19CADDR;
// Define the union U_VHDP19STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP19STRIDE;

// Define the union U_VHDP19VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_203          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP19VFPOS;

// Define the union U_VHDP19VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_204          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP19VLPOS;

// Define the union U_VHDP20RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_205          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP20RESO;

// Define the union U_VHDP20LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP20LADDR;
// Define the union U_VHDP20CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP20CADDR;
// Define the union U_VHDP20STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP20STRIDE;

// Define the union U_VHDP20VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_207          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP20VFPOS;

// Define the union U_VHDP20VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_208          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP20VLPOS;

// Define the union U_VHDP21RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_209          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP21RESO;

// Define the union U_VHDP21LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP21LADDR;
// Define the union U_VHDP21CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP21CADDR;
// Define the union U_VHDP21STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP21STRIDE;

// Define the union U_VHDP21VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_211          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP21VFPOS;

// Define the union U_VHDP21VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_212          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP21VLPOS;

// Define the union U_VHDP22RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_213          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP22RESO;

// Define the union U_VHDP22LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP22LADDR;
// Define the union U_VHDP22CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP22CADDR;
// Define the union U_VHDP22STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP22STRIDE;

// Define the union U_VHDP22VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_215          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP22VFPOS;

// Define the union U_VHDP22VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_216          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP22VLPOS;

// Define the union U_VHDP23RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_217          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP23RESO;

// Define the union U_VHDP23LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP23LADDR;
// Define the union U_VHDP23CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP23CADDR;
// Define the union U_VHDP23STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP23STRIDE;

// Define the union U_VHDP23VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_219          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP23VFPOS;

// Define the union U_VHDP23VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_220          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP23VLPOS;

// Define the union U_VHDP24RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_221          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP24RESO;

// Define the union U_VHDP24LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP24LADDR;
// Define the union U_VHDP24CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP24CADDR;
// Define the union U_VHDP24STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP24STRIDE;

// Define the union U_VHDP24VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_223          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP24VFPOS;

// Define the union U_VHDP24VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_224          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP24VLPOS;

// Define the union U_VHDP25RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_225          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP25RESO;

// Define the union U_VHDP25LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP25LADDR;
// Define the union U_VHDP25CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP25CADDR;
// Define the union U_VHDP25STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP25STRIDE;

// Define the union U_VHDP25VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_227          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP25VFPOS;

// Define the union U_VHDP25VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_228          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP25VLPOS;

// Define the union U_VHDP26RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_229          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP26RESO;

// Define the union U_VHDP26LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP26LADDR;
// Define the union U_VHDP26CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP26CADDR;
// Define the union U_VHDP26STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP26STRIDE;

// Define the union U_VHDP26VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_231          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP26VFPOS;

// Define the union U_VHDP26VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_232          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP26VLPOS;

// Define the union U_VHDP27RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_233          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP27RESO;

// Define the union U_VHDP27LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP27LADDR;
// Define the union U_VHDP27CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP27CADDR;
// Define the union U_VHDP27STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP27STRIDE;

// Define the union U_VHDP27VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_235          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP27VFPOS;

// Define the union U_VHDP27VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_236          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP27VLPOS;

// Define the union U_VHDP28RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_237          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP28RESO;

// Define the union U_VHDP28LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP28LADDR;
// Define the union U_VHDP28CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP28CADDR;
// Define the union U_VHDP28STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP28STRIDE;

// Define the union U_VHDP28VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_239          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP28VFPOS;

// Define the union U_VHDP28VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_240          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP28VLPOS;

// Define the union U_VHDP29RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_241          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP29RESO;

// Define the union U_VHDP29LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP29LADDR;
// Define the union U_VHDP29CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP29CADDR;
// Define the union U_VHDP29STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP29STRIDE;

// Define the union U_VHDP29VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_243          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP29VFPOS;

// Define the union U_VHDP29VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_244          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP29VLPOS;

// Define the union U_VHDP30RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_245          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP30RESO;

// Define the union U_VHDP30LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP30LADDR;
// Define the union U_VHDP30CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP30CADDR;
// Define the union U_VHDP30STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP30STRIDE;

// Define the union U_VHDP30VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_247          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP30VFPOS;

// Define the union U_VHDP30VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_248          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP30VLPOS;

// Define the union U_VHDP31RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_249          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP31RESO;

// Define the union U_VHDP31LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP31LADDR;
// Define the union U_VHDP31CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP31CADDR;
// Define the union U_VHDP31STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP31STRIDE;

// Define the union U_VHDP31VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_251          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP31VFPOS;

// Define the union U_VHDP31VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_252          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP31VLPOS;

// Define the union U_VHDP32RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_253          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP32RESO;

// Define the union U_VHDP32LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP32LADDR;
// Define the union U_VHDP32CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP32CADDR;
// Define the union U_VHDP32STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP32STRIDE;

// Define the union U_VHDP32VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_255          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP32VFPOS;

// Define the union U_VHDP32VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_256          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP32VLPOS;

// Define the union U_VHDP33RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_257          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP33RESO;

// Define the union U_VHDP33LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP33LADDR;
// Define the union U_VHDP33CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP33CADDR;
// Define the union U_VHDP33STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP33STRIDE;

// Define the union U_VHDP33VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_259          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP33VFPOS;

// Define the union U_VHDP33VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_260          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP33VLPOS;

// Define the union U_VHDP34RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_261          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP34RESO;

// Define the union U_VHDP34LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP34LADDR;
// Define the union U_VHDP34CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP34CADDR;
// Define the union U_VHDP34STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP34STRIDE;

// Define the union U_VHDP34VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_263          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP34VFPOS;

// Define the union U_VHDP34VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_264          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP34VLPOS;

// Define the union U_VHDP35RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_265          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP35RESO;

// Define the union U_VHDP35LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP35LADDR;
// Define the union U_VHDP35CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP35CADDR;
// Define the union U_VHDP35STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP35STRIDE;

// Define the union U_VHDP35VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_267          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP35VFPOS;

// Define the union U_VHDP35VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_268          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP35VLPOS;

// Define the union U_VHDP36RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_269          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP36RESO;

// Define the union U_VHDP36LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP36LADDR;
// Define the union U_VHDP36CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP36CADDR;
// Define the union U_VHDP36STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP36STRIDE;

// Define the union U_VHDP36VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_271          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP36VFPOS;

// Define the union U_VHDP36VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_272          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP36VLPOS;

// Define the union U_VHDP37RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_273          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP37RESO;

// Define the union U_VHDP37LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP37LADDR;
// Define the union U_VHDP37CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP37CADDR;
// Define the union U_VHDP37STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP37STRIDE;

// Define the union U_VHDP37VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_275          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP37VFPOS;

// Define the union U_VHDP37VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_276          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP37VLPOS;

// Define the union U_VHDP38RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_277          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP38RESO;

// Define the union U_VHDP38LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP38LADDR;
// Define the union U_VHDP38CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP38CADDR;
// Define the union U_VHDP38STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP38STRIDE;

// Define the union U_VHDP38VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_279          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP38VFPOS;

// Define the union U_VHDP38VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_280          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP38VLPOS;

// Define the union U_VHDP39RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_281          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP39RESO;

// Define the union U_VHDP39LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP39LADDR;
// Define the union U_VHDP39CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP39CADDR;
// Define the union U_VHDP39STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP39STRIDE;

// Define the union U_VHDP39VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_283          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP39VFPOS;

// Define the union U_VHDP39VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_284          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP39VLPOS;

// Define the union U_VHDP40RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_285          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP40RESO;

// Define the union U_VHDP40LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP40LADDR;
// Define the union U_VHDP40CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP40CADDR;
// Define the union U_VHDP40STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP40STRIDE;

// Define the union U_VHDP40VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_287          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP40VFPOS;

// Define the union U_VHDP40VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_288          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP40VLPOS;

// Define the union U_VHDP41RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_289          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP41RESO;

// Define the union U_VHDP41LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP41LADDR;
// Define the union U_VHDP41CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP41CADDR;
// Define the union U_VHDP41STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP41STRIDE;

// Define the union U_VHDP41VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_291          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP41VFPOS;

// Define the union U_VHDP41VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_292          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP41VLPOS;

// Define the union U_VHDP42RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_293          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP42RESO;

// Define the union U_VHDP42LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP42LADDR;
// Define the union U_VHDP42CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP42CADDR;
// Define the union U_VHDP42STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP42STRIDE;

// Define the union U_VHDP42VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_295          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP42VFPOS;

// Define the union U_VHDP42VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_296          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP42VLPOS;

// Define the union U_VHDP43RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_297          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP43RESO;

// Define the union U_VHDP43LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP43LADDR;
// Define the union U_VHDP43CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP43CADDR;
// Define the union U_VHDP43STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP43STRIDE;

// Define the union U_VHDP43VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_299          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP43VFPOS;

// Define the union U_VHDP43VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_300          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP43VLPOS;

// Define the union U_VHDP44RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_301          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP44RESO;

// Define the union U_VHDP44LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP44LADDR;
// Define the union U_VHDP44CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP44CADDR;
// Define the union U_VHDP44STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP44STRIDE;

// Define the union U_VHDP44VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_303          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP44VFPOS;

// Define the union U_VHDP44VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_304          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP44VLPOS;

// Define the union U_VHDP45RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_305          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP45RESO;

// Define the union U_VHDP45LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP45LADDR;
// Define the union U_VHDP45CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP45CADDR;
// Define the union U_VHDP45STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP45STRIDE;

// Define the union U_VHDP45VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_307          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP45VFPOS;

// Define the union U_VHDP45VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_308          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP45VLPOS;

// Define the union U_VHDP46RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_309          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP46RESO;

// Define the union U_VHDP46LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP46LADDR;
// Define the union U_VHDP46CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP46CADDR;
// Define the union U_VHDP46STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP46STRIDE;

// Define the union U_VHDP46VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_311          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP46VFPOS;

// Define the union U_VHDP46VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_312          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP46VLPOS;

// Define the union U_VHDP47RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_313          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP47RESO;

// Define the union U_VHDP47LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP47LADDR;
// Define the union U_VHDP47CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP47CADDR;
// Define the union U_VHDP47STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP47STRIDE;

// Define the union U_VHDP47VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_315          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP47VFPOS;

// Define the union U_VHDP47VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_316          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP47VLPOS;

// Define the union U_VHDP48RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_317          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP48RESO;

// Define the union U_VHDP48LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP48LADDR;
// Define the union U_VHDP48CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP48CADDR;
// Define the union U_VHDP48STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP48STRIDE;

// Define the union U_VHDP48VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_319          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP48VFPOS;

// Define the union U_VHDP48VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_320          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP48VLPOS;

// Define the union U_VHDP49RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_321          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP49RESO;

// Define the union U_VHDP49LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP49LADDR;
// Define the union U_VHDP49CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP49CADDR;
// Define the union U_VHDP49STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP49STRIDE;

// Define the union U_VHDP49VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_323          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP49VFPOS;

// Define the union U_VHDP49VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_324          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP49VLPOS;

// Define the union U_VHDP50RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_325          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP50RESO;

// Define the union U_VHDP50LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP50LADDR;
// Define the union U_VHDP50CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP50CADDR;
// Define the union U_VHDP50STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP50STRIDE;

// Define the union U_VHDP50VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_327          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP50VFPOS;

// Define the union U_VHDP50VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_328          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP50VLPOS;

// Define the union U_VHDP51RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_329          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP51RESO;

// Define the union U_VHDP51LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP51LADDR;
// Define the union U_VHDP51CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP51CADDR;
// Define the union U_VHDP51STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP51STRIDE;

// Define the union U_VHDP51VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_331          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP51VFPOS;

// Define the union U_VHDP51VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_332          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP51VLPOS;

// Define the union U_VHDP52RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_333          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP52RESO;

// Define the union U_VHDP52LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP52LADDR;
// Define the union U_VHDP52CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP52CADDR;
// Define the union U_VHDP52STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP52STRIDE;

// Define the union U_VHDP52VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_335          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP52VFPOS;

// Define the union U_VHDP52VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_336          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP52VLPOS;

// Define the union U_VHDP53RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_337          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP53RESO;

// Define the union U_VHDP53LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP53LADDR;
// Define the union U_VHDP53CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP53CADDR;
// Define the union U_VHDP53STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP53STRIDE;

// Define the union U_VHDP53VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_339          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP53VFPOS;

// Define the union U_VHDP53VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_340          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP53VLPOS;

// Define the union U_VHDP54RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_341          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP54RESO;

// Define the union U_VHDP54LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP54LADDR;
// Define the union U_VHDP54CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP54CADDR;
// Define the union U_VHDP54STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP54STRIDE;

// Define the union U_VHDP54VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_343          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP54VFPOS;

// Define the union U_VHDP54VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_344          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP54VLPOS;

// Define the union U_VHDP55RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_345          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP55RESO;

// Define the union U_VHDP55LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP55LADDR;
// Define the union U_VHDP55CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP55CADDR;
// Define the union U_VHDP55STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP55STRIDE;

// Define the union U_VHDP55VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_347          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP55VFPOS;

// Define the union U_VHDP55VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_348          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP55VLPOS;

// Define the union U_VHDP56RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_349          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP56RESO;

// Define the union U_VHDP56LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP56LADDR;
// Define the union U_VHDP56CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP56CADDR;
// Define the union U_VHDP56STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP56STRIDE;

// Define the union U_VHDP56VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_351          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP56VFPOS;

// Define the union U_VHDP56VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_352          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP56VLPOS;

// Define the union U_VHDP57RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_353          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP57RESO;

// Define the union U_VHDP57LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP57LADDR;
// Define the union U_VHDP57CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP57CADDR;
// Define the union U_VHDP57STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP57STRIDE;

// Define the union U_VHDP57VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_355          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP57VFPOS;

// Define the union U_VHDP57VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_356          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP57VLPOS;

// Define the union U_VHDP58RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_357          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP58RESO;

// Define the union U_VHDP58LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP58LADDR;
// Define the union U_VHDP58CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP58CADDR;
// Define the union U_VHDP58STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP58STRIDE;

// Define the union U_VHDP58VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_359          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP58VFPOS;

// Define the union U_VHDP58VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_360          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP58VLPOS;

// Define the union U_VHDP59RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_361          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP59RESO;

// Define the union U_VHDP59LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP59LADDR;
// Define the union U_VHDP59CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP59CADDR;
// Define the union U_VHDP59STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP59STRIDE;

// Define the union U_VHDP59VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_363          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP59VFPOS;

// Define the union U_VHDP59VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_364          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP59VLPOS;

// Define the union U_VHDP60RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_365          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP60RESO;

// Define the union U_VHDP60LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP60LADDR;
// Define the union U_VHDP60CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP60CADDR;
// Define the union U_VHDP60STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP60STRIDE;

// Define the union U_VHDP60VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_367          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP60VFPOS;

// Define the union U_VHDP60VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_368          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP60VLPOS;

// Define the union U_VHDP61RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_369          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP61RESO;

// Define the union U_VHDP61LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP61LADDR;
// Define the union U_VHDP61CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP61CADDR;
// Define the union U_VHDP61STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP61STRIDE;

// Define the union U_VHDP61VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_371          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP61VFPOS;

// Define the union U_VHDP61VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_372          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP61VLPOS;

// Define the union U_VHDP62RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_373          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP62RESO;

// Define the union U_VHDP62LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP62LADDR;
// Define the union U_VHDP62CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP62CADDR;
// Define the union U_VHDP62STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP62STRIDE;

// Define the union U_VHDP62VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_375          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP62VFPOS;

// Define the union U_VHDP62VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_376          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP62VLPOS;

// Define the union U_VHDP63RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_377          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP63RESO;

// Define the union U_VHDP63LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP63LADDR;
// Define the union U_VHDP63CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHDP63CADDR;
// Define the union U_VHDP63STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP63STRIDE;

// Define the union U_VHDP63VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_379          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP63VFPOS;

// Define the union U_VHDP63VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_380          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHDP63VLPOS;

// Define the union U_VHD64REGIONENH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p32_en                : 1   ; // [0]
        HI_U32    p33_en                : 1   ; // [1]
        HI_U32    p34_en                : 1   ; // [2]
        HI_U32    p35_en                : 1   ; // [3]
        HI_U32    p36_en                : 1   ; // [4]
        HI_U32    p37_en                : 1   ; // [5]
        HI_U32    p38_en                : 1   ; // [6]
        HI_U32    p39_en                : 1   ; // [7]
        HI_U32    p40_en                : 1   ; // [8]
        HI_U32    p41_en                : 1   ; // [9]
        HI_U32    p42_en                : 1   ; // [10]
        HI_U32    p43_en                : 1   ; // [11]
        HI_U32    p44_en                : 1   ; // [12]
        HI_U32    p45_en                : 1   ; // [13]
        HI_U32    p46_en                : 1   ; // [14]
        HI_U32    p47_en                : 1   ; // [15]
        HI_U32    p48_en                : 1   ; // [16]
        HI_U32    p49_en                : 1   ; // [17]
        HI_U32    p50_en                : 1   ; // [18]
        HI_U32    p51_en                : 1   ; // [19]
        HI_U32    p52_en                : 1   ; // [20]
        HI_U32    p53_en                : 1   ; // [21]
        HI_U32    p54_en                : 1   ; // [22]
        HI_U32    p55_en                : 1   ; // [23]
        HI_U32    p56_en                : 1   ; // [24]
        HI_U32    p57_en                : 1   ; // [25]
        HI_U32    p58_en                : 1   ; // [26]
        HI_U32    p59_en                : 1   ; // [27]
        HI_U32    p60_en                : 1   ; // [28]
        HI_U32    p61_en                : 1   ; // [29]
        HI_U32    p62_en                : 1   ; // [30]
        HI_U32    p63_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD64REGIONENH;

// Define the union U_VHD64REGIONENL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    p8_en                 : 1   ; // [8]
        HI_U32    p9_en                 : 1   ; // [9]
        HI_U32    p10_en                : 1   ; // [10]
        HI_U32    p11_en                : 1   ; // [11]
        HI_U32    p12_en                : 1   ; // [12]
        HI_U32    p13_en                : 1   ; // [13]
        HI_U32    p14_en                : 1   ; // [14]
        HI_U32    p15_en                : 1   ; // [15]
        HI_U32    p16_en                : 1   ; // [16]
        HI_U32    p17_en                : 1   ; // [17]
        HI_U32    p18_en                : 1   ; // [18]
        HI_U32    p19_en                : 1   ; // [19]
        HI_U32    p20_en                : 1   ; // [20]
        HI_U32    p21_en                : 1   ; // [21]
        HI_U32    p22_en                : 1   ; // [22]
        HI_U32    p23_en                : 1   ; // [23]
        HI_U32    p24_en                : 1   ; // [24]
        HI_U32    p25_en                : 1   ; // [25]
        HI_U32    p26_en                : 1   ; // [26]
        HI_U32    p27_en                : 1   ; // [27]
        HI_U32    p28_en                : 1   ; // [28]
        HI_U32    p29_en                : 1   ; // [29]
        HI_U32    p30_en                : 1   ; // [30]
        HI_U32    p31_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD64REGIONENL;

// Define the union U_VHD1CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_384          : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_383          : 11  ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CTRL;

// Define the union U_VHD1UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_386          : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1UPD;

// Define the union U_VHD1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_laddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1LADDR;
// Define the union U_VHD1LCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_lcaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1LCADDR;
// Define the union U_VHD1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1CADDR;
// Define the union U_VHD1CCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1CCADDR;
// Define the union U_VHD1NADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_naddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1NADDR;
// Define the union U_VHD1NCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ncaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1NCADDR;
// Define the union U_VHD1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1STRIDE;

// Define the union U_VHD1IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_388          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1IRESO;

// Define the union U_VHD1LKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_389          : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1LKEY;

// Define the union U_VHD1CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_391          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CBMPARA;

// Define the union U_VHD1DIEADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dieaddr                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIEADDR;
// Define the union U_VHD1WBC1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbc1addr                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1WBC1ADDR;
// Define the union U_VHD1WBC1STRD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc1strd              : 16  ; // [15..0]
        HI_U32    req_interval          : 10  ; // [25..16]
        HI_U32    Reserved_392          : 4   ; // [29..26]
        HI_U32    wbc1_dft              : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1WBC1STRD;

// Define the union U_VHD1DIESTADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 diestaddr               : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIESTADDR;
// Define the union U_VHD1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_393          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DFPOS;

// Define the union U_VHD1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_395          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DLPOS;

// Define the union U_VHD1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_396          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1VFPOS;

// Define the union U_VHD1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_397          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1VLPOS;

// Define the union U_VHD1BK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1BK;

// Define the union U_VHD1CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_398          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCIDC;

// Define the union U_VHD1CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_400          : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCODC;

// Define the union U_VHD1CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_402          : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_401          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCP0;

// Define the union U_VHD1CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_404          : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_403          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCP1;

// Define the union U_VHD1CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_406          : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_405          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCP2;

// Define the union U_VHD1CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_408          : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_407          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCP3;

// Define the union U_VHD1CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_409          : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CSCP4;

// Define the union U_VHD1ACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM0;

// Define the union U_VHD1ACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_411          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM1;

// Define the union U_VHD1ACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_412          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM2;

// Define the union U_VHD1ACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_413          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM3;

// Define the union U_VHD1ACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_414          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM4;

// Define the union U_VHD1ACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_415          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM5;

// Define the union U_VHD1ACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_416          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM6;

// Define the union U_VHD1ACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_417          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACM7;

// Define the union U_VHD1HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_420          : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_419          : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_418          : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1HSP;

// Define the union U_VHD1HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_421          : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1HLOFFSET;

// Define the union U_VHD1HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_422          : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1HCOFFSET;

// Define the union U_VHD1VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_423          : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    Reserved_vchmid_en    : 2   ; // [29..28] 
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1VSP;

// Define the union U_VHD1VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_425          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1VSR;

// Define the union U_VHD1VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1VOFFSET;

// Define the union U_VHD1ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_426          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ZMEORESO;

// Define the union U_VHD1ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_427          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ZMEIRESO;

// Define the union U_VHD1ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_428          : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ZMEDBG;

// Define the union U_VHD1COEF00
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_429          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1COEF00;

// Define the union U_VHD1COEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_430          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1COEF01;

// Define the union U_VHD1COEF10
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_431          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1COEF10;

// Define the union U_VHD1COEF11
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_432          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1COEF11;

// Define the union U_VHD1ACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCTHD1;

// Define the union U_VHD1ACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_433          : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCTHD2;

// Define the union U_VHD1ACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_434          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCLOWN;

// Define the union U_VHD1ACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_436          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCMEDN;

// Define the union U_VHD1ACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_438          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCHIGHN;

// Define the union U_VHD1ACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_440          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCMLN;

// Define the union U_VHD1ACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_442          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCMHN;

// Define the union U_VHD1ACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_444          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACC3LOW;

// Define the union U_VHD1ACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_446          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACC3MED;

// Define the union U_VHD1ACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_447          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACC3HIGH;

// Define the union U_VHD1ACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_448          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACC8MLOW;

// Define the union U_VHD1ACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_449          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACC8MHIGH;

// Define the union U_VHD1ACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_450          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1ACCTOTAL;

// Define the union U_VHD1IFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_452          : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_451          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1IFIRCOEF01;

// Define the union U_VHD1IFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_455          : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_454          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1IFIRCOEF23;

// Define the union U_VHD1IFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_457          : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_456          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1IFIRCOEF45;

// Define the union U_VHD1IFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_459          : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_458          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1IFIRCOEF67;

// Define the union U_VHD1DIECTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_461          : 16  ; // [15..0]
        HI_U32    stinfo_stop           : 1   ; // [16]
        HI_U32    die_rst               : 1   ; // [17]
        HI_U32    Reserved_460          : 6   ; // [23..18]
        HI_U32    die_chmmode           : 2   ; // [25..24]
        HI_U32    die_lmmode            : 2   ; // [27..26]
        HI_U32    die_out_sel_c         : 1   ; // [28]
        HI_U32    die_out_sel_l         : 1   ; // [29]
        HI_U32    die_chroma_en         : 1   ; // [30]
        HI_U32    die_luma_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIECTRL;

// Define the union U_VHD1DIELMA0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_qtbl1            : 8   ; // [7..0]
        HI_U32    luma_qtbl2            : 8   ; // [15..8]
        HI_U32    luma_qtbl3            : 8   ; // [23..16]
        HI_U32    scale_ratio_ppd       : 6   ; // [29..24]
        HI_U32    Reserved_463          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIELMA0;

// Define the union U_VHD1DIELMA1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_reqtbl0          : 8   ; // [7..0]
        HI_U32    luma_reqtbl1          : 8   ; // [15..8]
        HI_U32    luma_reqtbl2          : 8   ; // [23..16]
        HI_U32    luma_reqtbl3          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIELMA1;

// Define the union U_VHD1DIELMA2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_win_size         : 2   ; // [1..0]
        HI_U32    luma_scesdf_max       : 1   ; // [2]
        HI_U32    die_st_qrst_en        : 1   ; // [3]
        HI_U32    die_st_n_en           : 1   ; // [4]
        HI_U32    die_st_m_en           : 1   ; // [5]
        HI_U32    die_st_l_en           : 1   ; // [6]
        HI_U32    die_st_k_en           : 1   ; // [7]
        HI_U32    luma_qrst_max         : 1   ; // [8]
        HI_U32    luma_mf_max           : 1   ; // [9]
        HI_U32    chroma_mf_max         : 1   ; // [10]
        HI_U32    Reserved_465          : 18  ; // [28..11]
        HI_U32    die_st_mode           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIELMA2;

// Define the union U_VHD1DIEINTEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir_inten             : 4   ; // [3..0]
        HI_U32    Reserved_467          : 3   ; // [6..4]
        HI_U32    dir_ck_enh            : 1   ; // [7]
        HI_U32    dir_inten_ver         : 4   ; // [11..8]
        HI_U32    Reserved_466          : 4   ; // [15..12]
        HI_U32    ver_min_inten         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIEINTEN;

// Define the union U_VHD1DIESCALE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    range_scale           : 8   ; // [7..0]
        HI_U32    Reserved_468          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIESCALE;

// Define the union U_VHD1DIECHECK1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ck_max_range          : 6   ; // [5..0]
        HI_U32    Reserved_471          : 2   ; // [7..6]
        HI_U32    ck_range_gain         : 4   ; // [11..8]
        HI_U32    Reserved_470          : 4   ; // [15..12]
        HI_U32    ck_gain               : 4   ; // [19..16]
        HI_U32    Reserved_469          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIECHECK1;

// Define the union U_VHD1DIECHECK2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ck_max_range          : 6   ; // [5..0]
        HI_U32    Reserved_474          : 2   ; // [7..6]
        HI_U32    ck_range_gain         : 4   ; // [11..8]
        HI_U32    Reserved_473          : 4   ; // [15..12]
        HI_U32    ck_gain               : 4   ; // [19..16]
        HI_U32    Reserved_472          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIECHECK2;

// Define the union U_VHD1DIEDIR0_3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir0_mult             : 6   ; // [5..0]
        HI_U32    Reserved_478          : 2   ; // [7..6]
        HI_U32    dir1_mult             : 6   ; // [13..8]
        HI_U32    Reserved_477          : 2   ; // [15..14]
        HI_U32    dir2_mult             : 6   ; // [21..16]
        HI_U32    Reserved_476          : 2   ; // [23..22]
        HI_U32    dir3_mult             : 6   ; // [29..24]
        HI_U32    Reserved_475          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIEDIR0_3;

// Define the union U_VHD1DIEDIR4_7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir4_mult             : 6   ; // [5..0]
        HI_U32    Reserved_482          : 2   ; // [7..6]
        HI_U32    dir5_mult             : 6   ; // [13..8]
        HI_U32    Reserved_481          : 2   ; // [15..14]
        HI_U32    dir6_mult             : 6   ; // [21..16]
        HI_U32    Reserved_480          : 2   ; // [23..22]
        HI_U32    dir7_mult             : 6   ; // [29..24]
        HI_U32    Reserved_479          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIEDIR4_7;

// Define the union U_VHD1DIEDIR8_11
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir8_mult             : 6   ; // [5..0]
        HI_U32    Reserved_486          : 2   ; // [7..6]
        HI_U32    dir9_mult             : 6   ; // [13..8]
        HI_U32    Reserved_485          : 2   ; // [15..14]
        HI_U32    dir10_mult            : 6   ; // [21..16]
        HI_U32    Reserved_484          : 2   ; // [23..22]
        HI_U32    dir11_mult            : 6   ; // [29..24]
        HI_U32    Reserved_483          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIEDIR8_11;

// Define the union U_VHD1DIEDIR12_14
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir12_mult            : 6   ; // [5..0]
        HI_U32    Reserved_489          : 2   ; // [7..6]
        HI_U32    dir13_mult            : 6   ; // [13..8]
        HI_U32    Reserved_488          : 2   ; // [15..14]
        HI_U32    dir14_mult            : 6   ; // [21..16]
        HI_U32    Reserved_487          : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIEDIR12_14;

// Define the union U_VHD1DIESTA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    die_ref_field         : 1   ; // [0]
        HI_U32    Reserved_490          : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1DIESTA;

// Define the union U_VHD1DIESTKADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_k_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIESTKADDR;
// Define the union U_VHD1DIESTLADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_l_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIESTLADDR;
// Define the union U_VHD1DIESTMADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_m_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIESTMADDR;
// Define the union U_VHD1DIESTNADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_n_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIESTNADDR;
// Define the union U_VHD1DIESTSQTRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_sqtr_addr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1DIESTSQTRADDR;
// Define the union U_VHD1CCRSCLR0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    no_ccr_detect_thd     : 8   ; // [7..0]
        HI_U32    no_ccr_detect_max     : 8   ; // [15..8]
        HI_U32    chroma_ma_offset      : 8   ; // [23..16]
        HI_U32    chroma_ccr_en         : 1   ; // [24]
        HI_U32    Reserved_493          : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CCRSCLR0;

// Define the union U_VHD1CCRSCLR1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    max_xchroma           : 8   ; // [7..0]
        HI_U32    no_ccr_detect_blend   : 4   ; // [11..8]
        HI_U32    Reserved_494          : 4   ; // [15..12]
        HI_U32    similar_thd           : 8   ; // [23..16]
        HI_U32    similar_max           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1CCRSCLR1;

// Define the union U_VHD1PDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_496          : 20  ; // [19..0]
        HI_U32    edge_smooth_ratio     : 8   ; // [27..20]
        HI_U32    Reserved_495          : 1   ; // [28]
        HI_U32    dir_mch_c             : 1   ; // [29]
        HI_U32    edge_smooth_en        : 1   ; // [30]
        HI_U32    dir_mch_l             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDCTRL;

// Define the union U_VHD1PDBLKPOS0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    blk_x                 : 12  ; // [11..0]
        HI_U32    blk_y                 : 12  ; // [23..12]
        HI_U32    Reserved_498          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDBLKPOS0;

// Define the union U_VHD1PDBLKPOS1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    blk_x                 : 12  ; // [11..0]
        HI_U32    blk_y                 : 12  ; // [23..12]
        HI_U32    Reserved_499          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDBLKPOS1;

// Define the union U_VHD1PDBLKTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    stillblk_thd          : 8   ; // [7..0]
        HI_U32    diff_movblk_thd       : 8   ; // [15..8]
        HI_U32    Reserved_500          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDBLKTHD;

// Define the union U_VHD1PDHISTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hist_thd0             : 8   ; // [7..0]
        HI_U32    hist_thd1             : 8   ; // [15..8]
        HI_U32    hist_thd2             : 8   ; // [23..16]
        HI_U32    hist_thd3             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDHISTTHD;

// Define the union U_VHD1PDUMTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    um_thd0               : 8   ; // [7..0]
        HI_U32    um_thd1               : 8   ; // [15..8]
        HI_U32    um_thd2               : 8   ; // [23..16]
        HI_U32    Reserved_501          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDUMTHD;

// Define the union U_VHD1PDPCCCORING
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coring_tkr            : 8   ; // [7..0]
        HI_U32    coring_norm           : 8   ; // [15..8]
        HI_U32    coring_blk            : 8   ; // [23..16]
        HI_U32    Reserved_502          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDPCCCORING;

// Define the union U_VHD1PDPCCHTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    pcc_hthd              : 8   ; // [7..0]
        HI_U32    Reserved_503          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDPCCHTHD;

// Define the union U_VHD1PDPCCVTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    pcc_vthd0             : 8   ; // [7..0]
        HI_U32    pcc_vthd1             : 8   ; // [15..8]
        HI_U32    pcc_vthd2             : 8   ; // [23..16]
        HI_U32    pcc_vthd3             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDPCCVTHD;

// Define the union U_VHD1PDITDIFFVTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    itdiff_vthd0          : 8   ; // [7..0]
        HI_U32    itdiff_vthd1          : 8   ; // [15..8]
        HI_U32    itdiff_vthd2          : 8   ; // [23..16]
        HI_U32    itdiff_vthd3          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDITDIFFVTHD;

// Define the union U_VHD1PDLASITHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    lasi_thd              : 8   ; // [7..0]
        HI_U32    edge_thd              : 8   ; // [15..8]
        HI_U32    Reserved_504          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1PDLASITHD;

// Define the union U_VHD1PDFRMITDIFF
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 frm_it_diff             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDFRMITDIFF;
// Define the union U_VHD1PDSTLBLKSAD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 stlblk_sad              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDSTLBLKSAD;
// Define the union U_VHD1PDHISTBIN
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 hsit_bin                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDHISTBIN;
// Define the union U_VHD1PDUMMATCH0
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 match_um                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDUMMATCH0;
// Define the union U_VHD1PDUMNOMATCH0
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 nomatch_um              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDUMNOMATCH0;
// Define the union U_VHD1PDUMMATCH1
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 match_um                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDUMMATCH1;
// Define the union U_VHD1PDUMNOMATCH1
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 nomatch_um              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDUMNOMATCH1;
// Define the union U_VHD1PDPCCFFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_ffwd                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCFFWD;
// Define the union U_VHD1PDPCCFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_fwd                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCFWD;
// Define the union U_VHD1PDPCCBWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_bwd                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCBWD;
// Define the union U_VHD1PDPCCCRSS
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_crss                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCCRSS;
// Define the union U_VHD1PDPCCPW
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_pw                  : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCPW;
// Define the union U_VHD1PDPCCFWDTKR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_fwd_tkr             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCFWDTKR;
// Define the union U_VHD1PDPCCBWDTKR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_bwd_tkr             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCBWDTKR;
// Define the union U_VHD1PDPCCBLKFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_blk_fwd             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCBLKFWD;
// Define the union U_VHD1PDPCCBLKBWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_blk_bwd             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDPCCBLKBWD;
// Define the union U_VHD1PDLASICNT14
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDLASICNT14;
// Define the union U_VHD1PDLASICNT32
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDLASICNT32;
// Define the union U_VHD1PDLASICNT34
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1PDLASICNT34;
// Define the union U_VHD1P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_509          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P0RESO;

// Define the union U_VHD1P0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P0LADDR;
// Define the union U_VHD1P0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P0CADDR;
// Define the union U_VHD1P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P0STRIDE;

// Define the union U_VHD1P0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_510          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P0VFPOS;

// Define the union U_VHD1P0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_511          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P0VLPOS;

// Define the union U_VHD1P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_512          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P1RESO;

// Define the union U_VHD1P1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P1LADDR;
// Define the union U_VHD1P1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P1CADDR;
// Define the union U_VHD1P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P1STRIDE;

// Define the union U_VHD1P1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_514          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P1VFPOS;

// Define the union U_VHD1P1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_515          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P1VLPOS;

// Define the union U_VHD1P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_516          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P2RESO;

// Define the union U_VHD1P2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P2LADDR;
// Define the union U_VHD1P2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P2CADDR;
// Define the union U_VHD1P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P2STRIDE;

// Define the union U_VHD1P2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_518          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P2VFPOS;

// Define the union U_VHD1P2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_519          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P2VLPOS;

// Define the union U_VHD1P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_520          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P3RESO;

// Define the union U_VHD1P3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P3LADDR;
// Define the union U_VHD1P3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P3CADDR;
// Define the union U_VHD1P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P3STRIDE;

// Define the union U_VHD1P3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_522          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P3VFPOS;

// Define the union U_VHD1P3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_523          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P3VLPOS;

// Define the union U_VHD1P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_524          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P4RESO;

// Define the union U_VHD1P4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P4LADDR;
// Define the union U_VHD1P4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P4CADDR;
// Define the union U_VHD1P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P4STRIDE;

// Define the union U_VHD1P4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_526          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P4VFPOS;

// Define the union U_VHD1P4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_527          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P4VLPOS;

// Define the union U_VHD1P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_528          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P5RESO;

// Define the union U_VHD1P5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P5LADDR;
// Define the union U_VHD1P5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P5CADDR;
// Define the union U_VHD1P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P5STRIDE;

// Define the union U_VHD1P5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_530          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P5VFPOS;

// Define the union U_VHD1P5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_531          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P5VLPOS;

// Define the union U_VHD1P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_532          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P6RESO;

// Define the union U_VHD1P6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P6LADDR;
// Define the union U_VHD1P6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P6CADDR;
// Define the union U_VHD1P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P6STRIDE;

// Define the union U_VHD1P6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_534          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P6VFPOS;

// Define the union U_VHD1P6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_535          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P6VLPOS;

// Define the union U_VHD1P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_536          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P7RESO;

// Define the union U_VHD1P7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P7LADDR;
// Define the union U_VHD1P7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P7CADDR;
// Define the union U_VHD1P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P7STRIDE;

// Define the union U_VHD1P7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_538          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P7VFPOS;

// Define the union U_VHD1P7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_539          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P7VLPOS;

// Define the union U_VHD1P8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_540          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P8RESO;

// Define the union U_VHD1P8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P8LADDR;
// Define the union U_VHD1P8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P8CADDR;
// Define the union U_VHD1P8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P8STRIDE;

// Define the union U_VHD1P8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_542          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P8VFPOS;

// Define the union U_VHD1P8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_543          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P8VLPOS;

// Define the union U_VHD1P9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_544          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P9RESO;

// Define the union U_VHD1P9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P9LADDR;
// Define the union U_VHD1P9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P9CADDR;
// Define the union U_VHD1P9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P9STRIDE;

// Define the union U_VHD1P9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_546          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P9VFPOS;

// Define the union U_VHD1P9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_547          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P9VLPOS;

// Define the union U_VHD1P10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_548          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P10RESO;

// Define the union U_VHD1P10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P10LADDR;
// Define the union U_VHD1P10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P10CADDR;
// Define the union U_VHD1P10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P10STRIDE;

// Define the union U_VHD1P10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_550          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P10VFPOS;

// Define the union U_VHD1P10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_551          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P10VLPOS;

// Define the union U_VHD1P11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_552          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P11RESO;

// Define the union U_VHD1P11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P11LADDR;
// Define the union U_VHD1P11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P11CADDR;
// Define the union U_VHD1P11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P11STRIDE;

// Define the union U_VHD1P11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_554          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P11VFPOS;

// Define the union U_VHD1P11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_555          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P11VLPOS;

// Define the union U_VHD1P12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_556          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P12RESO;

// Define the union U_VHD1P12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P12LADDR;
// Define the union U_VHD1P12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P12CADDR;
// Define the union U_VHD1P12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P12STRIDE;

// Define the union U_VHD1P12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_558          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P12VFPOS;

// Define the union U_VHD1P12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_559          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P12VLPOS;

// Define the union U_VHD1P13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_560          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P13RESO;

// Define the union U_VHD1P13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P13LADDR;
// Define the union U_VHD1P13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P13CADDR;
// Define the union U_VHD1P13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P13STRIDE;

// Define the union U_VHD1P13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_562          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P13VFPOS;

// Define the union U_VHD1P13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_563          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P13VLPOS;

// Define the union U_VHD1P14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_564          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P14RESO;

// Define the union U_VHD1P14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P14LADDR;
// Define the union U_VHD1P14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P14CADDR;
// Define the union U_VHD1P14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P14STRIDE;

// Define the union U_VHD1P14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_566          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P14VFPOS;

// Define the union U_VHD1P14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_567          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P14VLPOS;

// Define the union U_VHD1P15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_568          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P15RESO;

// Define the union U_VHD1P15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P15LADDR;
// Define the union U_VHD1P15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P15CADDR;
// Define the union U_VHD1P15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P15STRIDE;

// Define the union U_VHD1P15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_570          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P15VFPOS;

// Define the union U_VHD1P15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_571          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P15VLPOS;

// Define the union U_VHD1P16RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_572          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P16RESO;

// Define the union U_VHD1P16LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P16LADDR;
// Define the union U_VHD1P16CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P16CADDR;
// Define the union U_VHD1P16STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P16STRIDE;

// Define the union U_VHD1P16VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_574          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P16VFPOS;

// Define the union U_VHD1P16VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_575          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P16VLPOS;

// Define the union U_VHD1P17RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_576          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P17RESO;

// Define the union U_VHD1P17LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P17LADDR;
// Define the union U_VHD1P17CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P17CADDR;
// Define the union U_VHD1P17STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P17STRIDE;

// Define the union U_VHD1P17VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_578          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P17VFPOS;

// Define the union U_VHD1P17VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_579          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P17VLPOS;

// Define the union U_VHD1P18RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_580          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P18RESO;

// Define the union U_VHD1P18LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P18LADDR;
// Define the union U_VHD1P18CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P18CADDR;
// Define the union U_VHD1P18STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P18STRIDE;

// Define the union U_VHD1P18VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_582          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P18VFPOS;

// Define the union U_VHD1P18VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_583          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P18VLPOS;

// Define the union U_VHD1P19RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_584          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P19RESO;

// Define the union U_VHD1P19LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P19LADDR;
// Define the union U_VHD1P19CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P19CADDR;
// Define the union U_VHD1P19STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P19STRIDE;

// Define the union U_VHD1P19VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_586          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P19VFPOS;

// Define the union U_VHD1P19VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_587          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P19VLPOS;

// Define the union U_VHD1P20RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_588          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P20RESO;

// Define the union U_VHD1P20LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P20LADDR;
// Define the union U_VHD1P20CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P20CADDR;
// Define the union U_VHD1P20STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P20STRIDE;

// Define the union U_VHD1P20VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_590          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P20VFPOS;

// Define the union U_VHD1P20VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_591          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P20VLPOS;

// Define the union U_VHD1P21RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_592          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P21RESO;

// Define the union U_VHD1P21LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P21LADDR;
// Define the union U_VHD1P21CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P21CADDR;
// Define the union U_VHD1P21STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P21STRIDE;

// Define the union U_VHD1P21VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_594          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P21VFPOS;

// Define the union U_VHD1P21VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_595          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P21VLPOS;

// Define the union U_VHD1P22RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_596          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P22RESO;

// Define the union U_VHD1P22LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P22LADDR;
// Define the union U_VHD1P22CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P22CADDR;
// Define the union U_VHD1P22STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P22STRIDE;

// Define the union U_VHD1P22VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_598          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P22VFPOS;

// Define the union U_VHD1P22VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_599          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P22VLPOS;

// Define the union U_VHD1P23RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_600          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P23RESO;

// Define the union U_VHD1P23LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P23LADDR;
// Define the union U_VHD1P23CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P23CADDR;
// Define the union U_VHD1P23STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P23STRIDE;

// Define the union U_VHD1P23VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_602          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P23VFPOS;

// Define the union U_VHD1P23VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_603          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P23VLPOS;

// Define the union U_VHD1P24RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_604          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P24RESO;

// Define the union U_VHD1P24LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P24LADDR;
// Define the union U_VHD1P24CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P24CADDR;
// Define the union U_VHD1P24STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P24STRIDE;

// Define the union U_VHD1P24VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_606          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P24VFPOS;

// Define the union U_VHD1P24VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_607          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P24VLPOS;

// Define the union U_VHD1P25RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_608          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P25RESO;

// Define the union U_VHD1P25LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P25LADDR;
// Define the union U_VHD1P25CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P25CADDR;
// Define the union U_VHD1P25STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P25STRIDE;

// Define the union U_VHD1P25VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_610          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P25VFPOS;

// Define the union U_VHD1P25VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_611          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P25VLPOS;

// Define the union U_VHD1P26RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_612          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P26RESO;

// Define the union U_VHD1P26LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P26LADDR;
// Define the union U_VHD1P26CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P26CADDR;
// Define the union U_VHD1P26STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P26STRIDE;

// Define the union U_VHD1P26VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_614          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P26VFPOS;

// Define the union U_VHD1P26VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_615          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P26VLPOS;

// Define the union U_VHD1P27RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_616          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P27RESO;

// Define the union U_VHD1P27LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P27LADDR;
// Define the union U_VHD1P27CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P27CADDR;
// Define the union U_VHD1P27STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P27STRIDE;

// Define the union U_VHD1P27VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_618          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P27VFPOS;

// Define the union U_VHD1P27VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_619          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P27VLPOS;

// Define the union U_VHD1P28RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_620          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P28RESO;

// Define the union U_VHD1P28LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P28LADDR;
// Define the union U_VHD1P28CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P28CADDR;
// Define the union U_VHD1P28STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P28STRIDE;

// Define the union U_VHD1P28VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_622          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P28VFPOS;

// Define the union U_VHD1P28VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_623          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P28VLPOS;

// Define the union U_VHD1P29RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_624          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P29RESO;

// Define the union U_VHD1P29LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P29LADDR;
// Define the union U_VHD1P29CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P29CADDR;
// Define the union U_VHD1P29STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P29STRIDE;

// Define the union U_VHD1P29VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_626          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P29VFPOS;

// Define the union U_VHD1P29VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_627          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P29VLPOS;

// Define the union U_VHD1P30RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_628          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P30RESO;

// Define the union U_VHD1P30LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P30LADDR;
// Define the union U_VHD1P30CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P30CADDR;
// Define the union U_VHD1P30STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P30STRIDE;

// Define the union U_VHD1P30VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_630          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P30VFPOS;

// Define the union U_VHD1P30VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_631          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P30VLPOS;

// Define the union U_VHD1P31RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_632          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P31RESO;

// Define the union U_VHD1P31LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P31LADDR;
// Define the union U_VHD1P31CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P31CADDR;
// Define the union U_VHD1P31STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P31STRIDE;

// Define the union U_VHD1P31VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_634          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P31VFPOS;

// Define the union U_VHD1P31VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_635          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P31VLPOS;

// Define the union U_VHD1P32RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_636          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P32RESO;

// Define the union U_VHD1P32LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P32LADDR;
// Define the union U_VHD1P32CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P32CADDR;
// Define the union U_VHD1P32STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P32STRIDE;

// Define the union U_VHD1P32VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_638          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P32VFPOS;

// Define the union U_VHD1P32VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_639          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P32VLPOS;

// Define the union U_VHD1P33RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_640          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P33RESO;

// Define the union U_VHD1P33LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P33LADDR;
// Define the union U_VHD1P33CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P33CADDR;
// Define the union U_VHD1P33STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P33STRIDE;

// Define the union U_VHD1P33VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_642          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P33VFPOS;

// Define the union U_VHD1P33VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_643          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P33VLPOS;

// Define the union U_VHD1P34RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_644          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P34RESO;

// Define the union U_VHD1P34LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P34LADDR;
// Define the union U_VHD1P34CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P34CADDR;
// Define the union U_VHD1P34STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P34STRIDE;

// Define the union U_VHD1P34VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_646          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P34VFPOS;

// Define the union U_VHD1P34VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_647          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P34VLPOS;

// Define the union U_VHD1P35RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_648          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P35RESO;

// Define the union U_VHD1P35LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P35LADDR;
// Define the union U_VHD1P35CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P35CADDR;
// Define the union U_VHD1P35STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P35STRIDE;

// Define the union U_VHD1P35VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_650          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P35VFPOS;

// Define the union U_VHD1P35VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_651          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P35VLPOS;

// Define the union U_VHD1P36RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_652          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P36RESO;

// Define the union U_VHD1P36LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P36LADDR;
// Define the union U_VHD1P36CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P36CADDR;
// Define the union U_VHD1P36STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P36STRIDE;

// Define the union U_VHD1P36VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_654          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P36VFPOS;

// Define the union U_VHD1P36VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_655          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P36VLPOS;

// Define the union U_VHD1P37RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_656          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P37RESO;

// Define the union U_VHD1P37LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P37LADDR;
// Define the union U_VHD1P37CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P37CADDR;
// Define the union U_VHD1P37STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P37STRIDE;

// Define the union U_VHD1P37VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_658          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P37VFPOS;

// Define the union U_VHD1P37VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_659          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P37VLPOS;

// Define the union U_VHD1P38RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_660          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P38RESO;

// Define the union U_VHD1P38LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P38LADDR;
// Define the union U_VHD1P38CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P38CADDR;
// Define the union U_VHD1P38STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P38STRIDE;

// Define the union U_VHD1P38VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_662          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P38VFPOS;

// Define the union U_VHD1P38VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_663          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P38VLPOS;

// Define the union U_VHD1P39RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_664          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P39RESO;

// Define the union U_VHD1P39LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P39LADDR;
// Define the union U_VHD1P39CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P39CADDR;
// Define the union U_VHD1P39STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P39STRIDE;

// Define the union U_VHD1P39VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_666          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P39VFPOS;

// Define the union U_VHD1P39VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_667          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P39VLPOS;

// Define the union U_VHD1P40RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_668          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P40RESO;

// Define the union U_VHD1P40LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P40LADDR;
// Define the union U_VHD1P40CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P40CADDR;
// Define the union U_VHD1P40STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P40STRIDE;

// Define the union U_VHD1P40VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_670          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P40VFPOS;

// Define the union U_VHD1P40VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_671          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P40VLPOS;

// Define the union U_VHD1P41RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_672          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P41RESO;

// Define the union U_VHD1P41LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P41LADDR;
// Define the union U_VHD1P41CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P41CADDR;
// Define the union U_VHD1P41STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P41STRIDE;

// Define the union U_VHD1P41VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_674          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P41VFPOS;

// Define the union U_VHD1P41VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_675          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P41VLPOS;

// Define the union U_VHD1P42RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_676          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P42RESO;

// Define the union U_VHD1P42LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P42LADDR;
// Define the union U_VHD1P42CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P42CADDR;
// Define the union U_VHD1P42STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P42STRIDE;

// Define the union U_VHD1P42VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_678          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P42VFPOS;

// Define the union U_VHD1P42VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_679          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P42VLPOS;

// Define the union U_VHD1P43RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_680          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P43RESO;

// Define the union U_VHD1P43LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P43LADDR;
// Define the union U_VHD1P43CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P43CADDR;
// Define the union U_VHD1P43STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P43STRIDE;

// Define the union U_VHD1P43VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_682          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P43VFPOS;

// Define the union U_VHD1P43VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_683          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P43VLPOS;

// Define the union U_VHD1P44RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_684          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P44RESO;

// Define the union U_VHD1P44LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P44LADDR;
// Define the union U_VHD1P44CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P44CADDR;
// Define the union U_VHD1P44STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P44STRIDE;

// Define the union U_VHD1P44VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_686          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P44VFPOS;

// Define the union U_VHD1P44VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_687          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P44VLPOS;

// Define the union U_VHD1P45RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_688          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P45RESO;

// Define the union U_VHD1P45LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P45LADDR;
// Define the union U_VHD1P45CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P45CADDR;
// Define the union U_VHD1P45STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P45STRIDE;

// Define the union U_VHD1P45VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_690          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P45VFPOS;

// Define the union U_VHD1P45VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_691          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P45VLPOS;

// Define the union U_VHD1P46RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_692          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P46RESO;

// Define the union U_VHD1P46LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P46LADDR;
// Define the union U_VHD1P46CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P46CADDR;
// Define the union U_VHD1P46STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P46STRIDE;

// Define the union U_VHD1P46VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_694          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P46VFPOS;

// Define the union U_VHD1P46VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_695          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P46VLPOS;

// Define the union U_VHD1P47RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_696          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P47RESO;

// Define the union U_VHD1P47LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P47LADDR;
// Define the union U_VHD1P47CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P47CADDR;
// Define the union U_VHD1P47STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P47STRIDE;

// Define the union U_VHD1P47VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_698          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P47VFPOS;

// Define the union U_VHD1P47VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_699          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P47VLPOS;

// Define the union U_VHD1P48RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_700          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P48RESO;

// Define the union U_VHD1P48LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P48LADDR;
// Define the union U_VHD1P48CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P48CADDR;
// Define the union U_VHD1P48STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P48STRIDE;

// Define the union U_VHD1P48VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_702          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P48VFPOS;

// Define the union U_VHD1P48VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_703          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P48VLPOS;

// Define the union U_VHD1P49RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_704          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P49RESO;

// Define the union U_VHD1P49LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P49LADDR;
// Define the union U_VHD1P49CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P49CADDR;
// Define the union U_VHD1P49STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P49STRIDE;

// Define the union U_VHD1P49VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_706          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P49VFPOS;

// Define the union U_VHD1P49VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_707          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P49VLPOS;

// Define the union U_VHD1P50RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_708          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P50RESO;

// Define the union U_VHD1P50LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P50LADDR;
// Define the union U_VHD1P50CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P50CADDR;
// Define the union U_VHD1P50STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P50STRIDE;

// Define the union U_VHD1P50VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_710          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P50VFPOS;

// Define the union U_VHD1P50VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_711          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P50VLPOS;

// Define the union U_VHD1P51RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_712          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P51RESO;

// Define the union U_VHD1P51LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P51LADDR;
// Define the union U_VHD1P51CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P51CADDR;
// Define the union U_VHD1P51STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P51STRIDE;

// Define the union U_VHD1P51VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_714          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P51VFPOS;

// Define the union U_VHD1P51VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_715          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P51VLPOS;

// Define the union U_VHD1P52RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_716          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P52RESO;

// Define the union U_VHD1P52LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P52LADDR;
// Define the union U_VHD1P52CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P52CADDR;
// Define the union U_VHD1P52STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P52STRIDE;

// Define the union U_VHD1P52VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_718          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P52VFPOS;

// Define the union U_VHD1P52VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_719          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P52VLPOS;

// Define the union U_VHD1P53RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_720          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P53RESO;

// Define the union U_VHD1P53LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P53LADDR;
// Define the union U_VHD1P53CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P53CADDR;
// Define the union U_VHD1P53STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P53STRIDE;

// Define the union U_VHD1P53VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_722          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P53VFPOS;

// Define the union U_VHD1P53VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_723          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P53VLPOS;

// Define the union U_VHD1P54RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_724          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P54RESO;

// Define the union U_VHD1P54LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P54LADDR;
// Define the union U_VHD1P54CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P54CADDR;
// Define the union U_VHD1P54STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P54STRIDE;

// Define the union U_VHD1P54VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_726          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P54VFPOS;

// Define the union U_VHD1P54VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_727          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P54VLPOS;

// Define the union U_VHD1P55RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_728          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P55RESO;

// Define the union U_VHD1P55LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P55LADDR;
// Define the union U_VHD1P55CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P55CADDR;
// Define the union U_VHD1P55STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P55STRIDE;

// Define the union U_VHD1P55VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_730          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P55VFPOS;

// Define the union U_VHD1P55VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_731          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P55VLPOS;

// Define the union U_VHD1P56RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_732          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P56RESO;

// Define the union U_VHD1P56LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P56LADDR;
// Define the union U_VHD1P56CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P56CADDR;
// Define the union U_VHD1P56STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P56STRIDE;

// Define the union U_VHD1P56VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_734          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P56VFPOS;

// Define the union U_VHD1P56VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_735          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P56VLPOS;

// Define the union U_VHD1P57RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_736          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P57RESO;

// Define the union U_VHD1P57LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P57LADDR;
// Define the union U_VHD1P57CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P57CADDR;
// Define the union U_VHD1P57STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P57STRIDE;

// Define the union U_VHD1P57VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_738          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P57VFPOS;

// Define the union U_VHD1P57VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_739          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P57VLPOS;

// Define the union U_VHD1P58RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_740          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P58RESO;

// Define the union U_VHD1P58LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P58LADDR;
// Define the union U_VHD1P58CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P58CADDR;
// Define the union U_VHD1P58STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P58STRIDE;

// Define the union U_VHD1P58VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_742          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P58VFPOS;

// Define the union U_VHD1P58VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_743          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P58VLPOS;

// Define the union U_VHD1P59RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_744          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P59RESO;

// Define the union U_VHD1P59LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P59LADDR;
// Define the union U_VHD1P59CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P59CADDR;
// Define the union U_VHD1P59STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P59STRIDE;

// Define the union U_VHD1P59VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_746          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P59VFPOS;

// Define the union U_VHD1P59VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_747          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P59VLPOS;

// Define the union U_VHD1P60RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_748          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P60RESO;

// Define the union U_VHD1P60LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P60LADDR;
// Define the union U_VHD1P60CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P60CADDR;
// Define the union U_VHD1P60STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P60STRIDE;

// Define the union U_VHD1P60VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_750          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P60VFPOS;

// Define the union U_VHD1P60VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_751          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P60VLPOS;

// Define the union U_VHD1P61RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_752          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P61RESO;

// Define the union U_VHD1P61LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P61LADDR;
// Define the union U_VHD1P61CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P61CADDR;
// Define the union U_VHD1P61STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P61STRIDE;

// Define the union U_VHD1P61VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_754          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P61VFPOS;

// Define the union U_VHD1P61VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_755          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P61VLPOS;

// Define the union U_VHD1P62RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_756          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P62RESO;

// Define the union U_VHD1P62LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P62LADDR;
// Define the union U_VHD1P62CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P62CADDR;
// Define the union U_VHD1P62STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P62STRIDE;

// Define the union U_VHD1P62VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_758          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P62VFPOS;

// Define the union U_VHD1P62VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_759          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P62VLPOS;

// Define the union U_VHD1P63RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_760          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P63RESO;

// Define the union U_VHD1P63LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P63LADDR;
// Define the union U_VHD1P63CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD1P63CADDR;
// Define the union U_VHD1P63STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P63STRIDE;

// Define the union U_VHD1P63VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_762          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P63VFPOS;

// Define the union U_VHD1P63VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_763          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD1P63VLPOS;

// Define the union U_VHD164REGIONENH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p32_en                : 1   ; // [0]
        HI_U32    p33_en                : 1   ; // [1]
        HI_U32    p34_en                : 1   ; // [2]
        HI_U32    p35_en                : 1   ; // [3]
        HI_U32    p36_en                : 1   ; // [4]
        HI_U32    p37_en                : 1   ; // [5]
        HI_U32    p38_en                : 1   ; // [6]
        HI_U32    p39_en                : 1   ; // [7]
        HI_U32    p40_en                : 1   ; // [8]
        HI_U32    p41_en                : 1   ; // [9]
        HI_U32    p42_en                : 1   ; // [10]
        HI_U32    p43_en                : 1   ; // [11]
        HI_U32    p44_en                : 1   ; // [12]
        HI_U32    p45_en                : 1   ; // [13]
        HI_U32    p46_en                : 1   ; // [14]
        HI_U32    p47_en                : 1   ; // [15]
        HI_U32    p48_en                : 1   ; // [16]
        HI_U32    p49_en                : 1   ; // [17]
        HI_U32    p50_en                : 1   ; // [18]
        HI_U32    p51_en                : 1   ; // [19]
        HI_U32    p52_en                : 1   ; // [20]
        HI_U32    p53_en                : 1   ; // [21]
        HI_U32    p54_en                : 1   ; // [22]
        HI_U32    p55_en                : 1   ; // [23]
        HI_U32    p56_en                : 1   ; // [24]
        HI_U32    p57_en                : 1   ; // [25]
        HI_U32    p58_en                : 1   ; // [26]
        HI_U32    p59_en                : 1   ; // [27]
        HI_U32    p60_en                : 1   ; // [28]
        HI_U32    p61_en                : 1   ; // [29]
        HI_U32    p62_en                : 1   ; // [30]
        HI_U32    p63_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD164REGIONENH;

// Define the union U_VHD164REGIONENL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    p8_en                 : 1   ; // [8]
        HI_U32    p9_en                 : 1   ; // [9]
        HI_U32    p10_en                : 1   ; // [10]
        HI_U32    p11_en                : 1   ; // [11]
        HI_U32    p12_en                : 1   ; // [12]
        HI_U32    p13_en                : 1   ; // [13]
        HI_U32    p14_en                : 1   ; // [14]
        HI_U32    p15_en                : 1   ; // [15]
        HI_U32    p16_en                : 1   ; // [16]
        HI_U32    p17_en                : 1   ; // [17]
        HI_U32    p18_en                : 1   ; // [18]
        HI_U32    p19_en                : 1   ; // [19]
        HI_U32    p20_en                : 1   ; // [20]
        HI_U32    p21_en                : 1   ; // [21]
        HI_U32    p22_en                : 1   ; // [22]
        HI_U32    p23_en                : 1   ; // [23]
        HI_U32    p24_en                : 1   ; // [24]
        HI_U32    p25_en                : 1   ; // [25]
        HI_U32    p26_en                : 1   ; // [26]
        HI_U32    p27_en                : 1   ; // [27]
        HI_U32    p28_en                : 1   ; // [28]
        HI_U32    p29_en                : 1   ; // [29]
        HI_U32    p30_en                : 1   ; // [30]
        HI_U32    p31_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD164REGIONENL;

// Define the union U_VHD2CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_767          : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_766          : 11  ; // [30..20] 
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CTRL;

// Define the union U_VHD2UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_769          : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2UPD;

// Define the union U_VHD2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_laddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2LADDR;
// Define the union U_VHD2LCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_lcaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2LCADDR;
// Define the union U_VHD2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2CADDR;
// Define the union U_VHD2CCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2CCADDR;
// Define the union U_VHD2NADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_naddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2NADDR;
// Define the union U_VHD2NCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ncaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2NCADDR;
// Define the union U_VHD2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2STRIDE;

// Define the union U_VHD2IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_771          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2IRESO;

// Define the union U_VHD2LKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_772          : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2LKEY;

// Define the union U_VHD2CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_774          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CBMPARA;

// Define the union U_VHD2DIEADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dieaddr                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIEADDR;
// Define the union U_VHD2WBC1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbc1addr                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2WBC1ADDR;
// Define the union U_VHD2WBC1STRD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc1strd              : 16  ; // [15..0]
        HI_U32    req_interval          : 10  ; // [25..16]
        HI_U32    Reserved_775          : 4   ; // [29..26]
        HI_U32    wbc1_dft              : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2WBC1STRD;

// Define the union U_VHD2DIESTADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 diestaddr               : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIESTADDR;
// Define the union U_VHD2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_776          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DFPOS;

// Define the union U_VHD2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_778          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DLPOS;

// Define the union U_VHD2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_779          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2VFPOS;

// Define the union U_VHD2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_780          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2VLPOS;

// Define the union U_VHD2BK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2BK;

// Define the union U_VHD2CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_781          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCIDC;

// Define the union U_VHD2CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_783          : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCODC;

// Define the union U_VHD2CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_785          : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_784          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCP0;

// Define the union U_VHD2CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_787          : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_786          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCP1;

// Define the union U_VHD2CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_789          : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_788          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCP2;

// Define the union U_VHD2CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_791          : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_790          : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCP3;

// Define the union U_VHD2CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_792          : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CSCP4;

// Define the union U_VHD2ACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM0;

// Define the union U_VHD2ACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_794          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM1;

// Define the union U_VHD2ACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_795          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM2;

// Define the union U_VHD2ACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_796          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM3;

// Define the union U_VHD2ACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_797          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM4;

// Define the union U_VHD2ACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_798          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM5;

// Define the union U_VHD2ACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_799          : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM6;

// Define the union U_VHD2ACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_800          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACM7;

// Define the union U_VHD2HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_803          : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_802          : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_801          : 3   ; // [27..25]
        HI_U32    Reserved_hchmid_en    : 2   ; // [29..28]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2HSP;

// Define the union U_VHD2HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_804          : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2HLOFFSET;

// Define the union U_VHD2HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_805          : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2HCOFFSET;

// Define the union U_VHD2VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_806          : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2VSP;

// Define the union U_VHD2VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_808          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2VSR;

// Define the union U_VHD2VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2VOFFSET;

// Define the union U_VHD2ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_809          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ZMEORESO;

// Define the union U_VHD2ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_810          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ZMEIRESO;

// Define the union U_VHD2ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_811          : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ZMEDBG;

// Define the union U_VHD2COEF00
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_812          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2COEF00;

// Define the union U_VHD2COEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_813          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2COEF01;

// Define the union U_VHD2COEF10
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_814          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2COEF10;

// Define the union U_VHD2COEF11
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef00                : 10  ; // [9..0]
        HI_U32    coef01                : 10  ; // [19..10]
        HI_U32    Reserved_815          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2COEF11;

// Define the union U_VHD2ACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCTHD1;

// Define the union U_VHD2ACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_816          : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCTHD2;

// Define the union U_VHD2ACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_817          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCLOWN;

// Define the union U_VHD2ACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_819          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCMEDN;

// Define the union U_VHD2ACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_821          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCHIGHN;

// Define the union U_VHD2ACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_823          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCMLN;

// Define the union U_VHD2ACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_825          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCMHN;

// Define the union U_VHD2ACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_827          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACC3LOW;

// Define the union U_VHD2ACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_829          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACC3MED;

// Define the union U_VHD2ACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_830          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACC3HIGH;

// Define the union U_VHD2ACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_831          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACC8MLOW;

// Define the union U_VHD2ACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_832          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACC8MHIGH;

// Define the union U_VHD2ACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_833          : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2ACCTOTAL;

// Define the union U_VHD2IFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_835          : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_834          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2IFIRCOEF01;

// Define the union U_VHD2IFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_838          : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_837          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2IFIRCOEF23;

// Define the union U_VHD2IFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_840          : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_839          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2IFIRCOEF45;

// Define the union U_VHD2IFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_842          : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_841          : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2IFIRCOEF67;

// Define the union U_VHD2DIECTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_844          : 16  ; // [15..0]
        HI_U32    stinfo_stop           : 1   ; // [16]
        HI_U32    die_rst               : 1   ; // [17]
        HI_U32    Reserved_843          : 6   ; // [23..18]
        HI_U32    die_chmmode           : 2   ; // [25..24]
        HI_U32    die_lmmode            : 2   ; // [27..26]
        HI_U32    die_out_sel_c         : 1   ; // [28]
        HI_U32    die_out_sel_l         : 1   ; // [29]
        HI_U32    die_chroma_en         : 1   ; // [30]
        HI_U32    die_luma_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIECTRL;

// Define the union U_VHD2DIELMA0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_qtbl1            : 8   ; // [7..0]
        HI_U32    luma_qtbl2            : 8   ; // [15..8]
        HI_U32    luma_qtbl3            : 8   ; // [23..16]
        HI_U32    scale_ratio_ppd       : 6   ; // [29..24]
        HI_U32    Reserved_846          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIELMA0;

// Define the union U_VHD2DIELMA1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_reqtbl0          : 8   ; // [7..0]
        HI_U32    luma_reqtbl1          : 8   ; // [15..8]
        HI_U32    luma_reqtbl2          : 8   ; // [23..16]
        HI_U32    luma_reqtbl3          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIELMA1;

// Define the union U_VHD2DIELMA2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_win_size         : 2   ; // [1..0]
        HI_U32    luma_scesdf_max       : 1   ; // [2]
        HI_U32    die_st_qrst_en        : 1   ; // [3]
        HI_U32    die_st_n_en           : 1   ; // [4]
        HI_U32    die_st_m_en           : 1   ; // [5]
        HI_U32    die_st_l_en           : 1   ; // [6]
        HI_U32    die_st_k_en           : 1   ; // [7]
        HI_U32    luma_qrst_max         : 1   ; // [8]
        HI_U32    luma_mf_max           : 1   ; // [9]
        HI_U32    chroma_mf_max         : 1   ; // [10]
        HI_U32    Reserved_848          : 18  ; // [28..11]
        HI_U32    die_st_mode           : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIELMA2;

// Define the union U_VHD2DIEINTEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir_inten             : 4   ; // [3..0]
        HI_U32    Reserved_850          : 3   ; // [6..4]
        HI_U32    dir_ck_enh            : 1   ; // [7]
        HI_U32    dir_inten_ver         : 4   ; // [11..8]
        HI_U32    Reserved_849          : 4   ; // [15..12]
        HI_U32    ver_min_inten         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIEINTEN;

// Define the union U_VHD2DIESCALE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    range_scale           : 8   ; // [7..0]
        HI_U32    Reserved_851          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIESCALE;

// Define the union U_VHD2DIECHECK1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ck_max_range          : 6   ; // [5..0]
        HI_U32    Reserved_854          : 2   ; // [7..6]
        HI_U32    ck_range_gain         : 4   ; // [11..8]
        HI_U32    Reserved_853          : 4   ; // [15..12]
        HI_U32    ck_gain               : 4   ; // [19..16]
        HI_U32    Reserved_852          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIECHECK1;

// Define the union U_VHD2DIECHECK2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ck_max_range          : 6   ; // [5..0]
        HI_U32    Reserved_857          : 2   ; // [7..6]
        HI_U32    ck_range_gain         : 4   ; // [11..8]
        HI_U32    Reserved_856          : 4   ; // [15..12]
        HI_U32    ck_gain               : 4   ; // [19..16]
        HI_U32    Reserved_855          : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIECHECK2;

// Define the union U_VHD2DIEDIR0_3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir0_mult             : 6   ; // [5..0]
        HI_U32    Reserved_861          : 2   ; // [7..6]
        HI_U32    dir1_mult             : 6   ; // [13..8]
        HI_U32    Reserved_860          : 2   ; // [15..14]
        HI_U32    dir2_mult             : 6   ; // [21..16]
        HI_U32    Reserved_859          : 2   ; // [23..22]
        HI_U32    dir3_mult             : 6   ; // [29..24]
        HI_U32    Reserved_858          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIEDIR0_3;

// Define the union U_VHD2DIEDIR4_7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir4_mult             : 6   ; // [5..0]
        HI_U32    Reserved_865          : 2   ; // [7..6]
        HI_U32    dir5_mult             : 6   ; // [13..8]
        HI_U32    Reserved_864          : 2   ; // [15..14]
        HI_U32    dir6_mult             : 6   ; // [21..16]
        HI_U32    Reserved_863          : 2   ; // [23..22]
        HI_U32    dir7_mult             : 6   ; // [29..24]
        HI_U32    Reserved_862          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIEDIR4_7;

// Define the union U_VHD2DIEDIR8_11
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir8_mult             : 6   ; // [5..0]
        HI_U32    Reserved_869          : 2   ; // [7..6]
        HI_U32    dir9_mult             : 6   ; // [13..8]
        HI_U32    Reserved_868          : 2   ; // [15..14]
        HI_U32    dir10_mult            : 6   ; // [21..16]
        HI_U32    Reserved_867          : 2   ; // [23..22]
        HI_U32    dir11_mult            : 6   ; // [29..24]
        HI_U32    Reserved_866          : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIEDIR8_11;

// Define the union U_VHD2DIEDIR12_14
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dir12_mult            : 6   ; // [5..0]
        HI_U32    Reserved_872          : 2   ; // [7..6]
        HI_U32    dir13_mult            : 6   ; // [13..8]
        HI_U32    Reserved_871          : 2   ; // [15..14]
        HI_U32    dir14_mult            : 6   ; // [21..16]
        HI_U32    Reserved_870          : 10  ; // [31..22]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIEDIR12_14;

// Define the union U_VHD2DIESTA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    die_ref_field         : 1   ; // [0]
        HI_U32    Reserved_873          : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2DIESTA;

// Define the union U_VHD2DIESTKADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_k_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIESTKADDR;
// Define the union U_VHD2DIESTLADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_l_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIESTLADDR;
// Define the union U_VHD2DIESTMADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_m_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIESTMADDR;
// Define the union U_VHD2DIESTNADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_n_addr              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIESTNADDR;
// Define the union U_VHD2DIESTSQTRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 die_sqtr_addr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2DIESTSQTRADDR;
// Define the union U_VHD2CCRSCLR0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    no_ccr_detect_thd     : 8   ; // [7..0]
        HI_U32    no_ccr_detect_max     : 8   ; // [15..8]
        HI_U32    chroma_ma_offset      : 8   ; // [23..16]
        HI_U32    chroma_ccr_en         : 1   ; // [24]
        HI_U32    Reserved_876          : 7   ; // [31..25]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CCRSCLR0;

// Define the union U_VHD2CCRSCLR1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    max_xchroma           : 8   ; // [7..0]
        HI_U32    no_ccr_detect_blend   : 4   ; // [11..8]
        HI_U32    Reserved_877          : 4   ; // [15..12]
        HI_U32    similar_thd           : 8   ; // [23..16]
        HI_U32    similar_max           : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2CCRSCLR1;

// Define the union U_VHD2PDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_879          : 20  ; // [19..0]
        HI_U32    edge_smooth_ratio     : 8   ; // [27..20]
        HI_U32    Reserved_878          : 1   ; // [28]
        HI_U32    dir_mch_c             : 1   ; // [29]
        HI_U32    edge_smooth_en        : 1   ; // [30]
        HI_U32    dir_mch_l             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDCTRL;

// Define the union U_VHD2PDBLKPOS0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    blk_x                 : 12  ; // [11..0]
        HI_U32    blk_y                 : 12  ; // [23..12]
        HI_U32    Reserved_881          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDBLKPOS0;

// Define the union U_VHD2PDBLKPOS1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    blk_x                 : 12  ; // [11..0]
        HI_U32    blk_y                 : 12  ; // [23..12]
        HI_U32    Reserved_882          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDBLKPOS1;

// Define the union U_VHD2PDBLKTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    stillblk_thd          : 8   ; // [7..0]
        HI_U32    diff_movblk_thd       : 8   ; // [15..8]
        HI_U32    Reserved_883          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDBLKTHD;

// Define the union U_VHD2PDHISTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hist_thd0             : 8   ; // [7..0]
        HI_U32    hist_thd1             : 8   ; // [15..8]
        HI_U32    hist_thd2             : 8   ; // [23..16]
        HI_U32    hist_thd3             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDHISTTHD;

// Define the union U_VHD2PDUMTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    um_thd0               : 8   ; // [7..0]
        HI_U32    um_thd1               : 8   ; // [15..8]
        HI_U32    um_thd2               : 8   ; // [23..16]
        HI_U32    Reserved_884          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDUMTHD;

// Define the union U_VHD2PDPCCCORING
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coring_tkr            : 8   ; // [7..0]
        HI_U32    coring_norm           : 8   ; // [15..8]
        HI_U32    coring_blk            : 8   ; // [23..16]
        HI_U32    Reserved_885          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDPCCCORING;

// Define the union U_VHD2PDPCCHTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    pcc_hthd              : 8   ; // [7..0]
        HI_U32    Reserved_886          : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDPCCHTHD;

// Define the union U_VHD2PDPCCVTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    pcc_vthd0             : 8   ; // [7..0]
        HI_U32    pcc_vthd1             : 8   ; // [15..8]
        HI_U32    pcc_vthd2             : 8   ; // [23..16]
        HI_U32    pcc_vthd3             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDPCCVTHD;

// Define the union U_VHD2PDITDIFFVTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    itdiff_vthd0          : 8   ; // [7..0]
        HI_U32    itdiff_vthd1          : 8   ; // [15..8]
        HI_U32    itdiff_vthd2          : 8   ; // [23..16]
        HI_U32    itdiff_vthd3          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDITDIFFVTHD;

// Define the union U_VHD2PDLASITHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    lasi_thd              : 8   ; // [7..0]
        HI_U32    edge_thd              : 8   ; // [15..8]
        HI_U32    Reserved_887          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2PDLASITHD;

// Define the union U_VHD2PDFRMITDIFF
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 frm_it_diff             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDFRMITDIFF;
// Define the union U_VHD2PDSTLBLKSAD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 stlblk_sad              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDSTLBLKSAD;
// Define the union U_VHD2PDHISTBIN
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 hsit_bin                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDHISTBIN;
// Define the union U_VHD2PDUMMATCH0
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 match_um                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDUMMATCH0;
// Define the union U_VHD2PDUMNOMATCH0
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 nomatch_um              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDUMNOMATCH0;
// Define the union U_VHD2PDUMMATCH1
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 match_um                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDUMMATCH1;
// Define the union U_VHD2PDUMNOMATCH1
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 nomatch_um              : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDUMNOMATCH1;
// Define the union U_VHD2PDPCCFFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_ffwd                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCFFWD;
// Define the union U_VHD2PDPCCFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_fwd                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCFWD;
// Define the union U_VHD2PDPCCBWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_bwd                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCBWD;
// Define the union U_VHD2PDPCCCRSS
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_crss                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCCRSS;
// Define the union U_VHD2PDPCCPW
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_pw                  : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCPW;
// Define the union U_VHD2PDPCCFWDTKR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_fwd_tkr             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCFWDTKR;
// Define the union U_VHD2PDPCCBWDTKR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_bwd_tkr             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCBWDTKR;
// Define the union U_VHD2PDPCCBLKFWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_blk_fwd             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCBLKFWD;
// Define the union U_VHD2PDPCCBLKBWD
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 pcc_blk_bwd             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDPCCBLKBWD;
// Define the union U_VHD2PDLASICNT14
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDLASICNT14;
// Define the union U_VHD2PDLASICNT32
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDLASICNT32;
// Define the union U_VHD2PDLASICNT34
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 lasi_cnt                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2PDLASICNT34;
// Define the union U_VHD2P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_892          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P0RESO;

// Define the union U_VHD2P0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P0LADDR;
// Define the union U_VHD2P0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P0CADDR;
// Define the union U_VHD2P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P0STRIDE;

// Define the union U_VHD2P0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_893          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P0VFPOS;

// Define the union U_VHD2P0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_894          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P0VLPOS;

// Define the union U_VHD2P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_895          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P1RESO;

// Define the union U_VHD2P1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P1LADDR;
// Define the union U_VHD2P1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P1CADDR;
// Define the union U_VHD2P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P1STRIDE;

// Define the union U_VHD2P1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_897          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P1VFPOS;

// Define the union U_VHD2P1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_898          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P1VLPOS;

// Define the union U_VHD2P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_899          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P2RESO;

// Define the union U_VHD2P2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P2LADDR;
// Define the union U_VHD2P2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P2CADDR;
// Define the union U_VHD2P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P2STRIDE;

// Define the union U_VHD2P2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_901          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P2VFPOS;

// Define the union U_VHD2P2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_902          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P2VLPOS;

// Define the union U_VHD2P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_903          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P3RESO;

// Define the union U_VHD2P3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P3LADDR;
// Define the union U_VHD2P3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P3CADDR;
// Define the union U_VHD2P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P3STRIDE;

// Define the union U_VHD2P3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_905          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P3VFPOS;

// Define the union U_VHD2P3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_906          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P3VLPOS;

// Define the union U_VHD2P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_907          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P4RESO;

// Define the union U_VHD2P4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P4LADDR;
// Define the union U_VHD2P4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P4CADDR;
// Define the union U_VHD2P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P4STRIDE;

// Define the union U_VHD2P4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_909          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P4VFPOS;

// Define the union U_VHD2P4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_910          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P4VLPOS;

// Define the union U_VHD2P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_911          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P5RESO;

// Define the union U_VHD2P5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P5LADDR;
// Define the union U_VHD2P5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P5CADDR;
// Define the union U_VHD2P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P5STRIDE;

// Define the union U_VHD2P5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_913          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P5VFPOS;

// Define the union U_VHD2P5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_914          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P5VLPOS;

// Define the union U_VHD2P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_915          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P6RESO;

// Define the union U_VHD2P6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P6LADDR;
// Define the union U_VHD2P6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P6CADDR;
// Define the union U_VHD2P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P6STRIDE;

// Define the union U_VHD2P6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_917          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P6VFPOS;

// Define the union U_VHD2P6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_918          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P6VLPOS;

// Define the union U_VHD2P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_919          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P7RESO;

// Define the union U_VHD2P7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P7LADDR;
// Define the union U_VHD2P7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P7CADDR;
// Define the union U_VHD2P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P7STRIDE;

// Define the union U_VHD2P7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_921          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P7VFPOS;

// Define the union U_VHD2P7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_922          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P7VLPOS;

// Define the union U_VHD2P8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_923          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P8RESO;

// Define the union U_VHD2P8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P8LADDR;
// Define the union U_VHD2P8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P8CADDR;
// Define the union U_VHD2P8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P8STRIDE;

// Define the union U_VHD2P8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_925          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P8VFPOS;

// Define the union U_VHD2P8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_926          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P8VLPOS;

// Define the union U_VHD2P9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_927          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P9RESO;

// Define the union U_VHD2P9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P9LADDR;
// Define the union U_VHD2P9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P9CADDR;
// Define the union U_VHD2P9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P9STRIDE;

// Define the union U_VHD2P9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_929          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P9VFPOS;

// Define the union U_VHD2P9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_930          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P9VLPOS;

// Define the union U_VHD2P10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_931          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P10RESO;

// Define the union U_VHD2P10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P10LADDR;
// Define the union U_VHD2P10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P10CADDR;
// Define the union U_VHD2P10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P10STRIDE;

// Define the union U_VHD2P10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_933          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P10VFPOS;

// Define the union U_VHD2P10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_934          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P10VLPOS;

// Define the union U_VHD2P11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_935          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P11RESO;

// Define the union U_VHD2P11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P11LADDR;
// Define the union U_VHD2P11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P11CADDR;
// Define the union U_VHD2P11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P11STRIDE;

// Define the union U_VHD2P11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_937          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P11VFPOS;

// Define the union U_VHD2P11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_938          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P11VLPOS;

// Define the union U_VHD2P12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_939          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P12RESO;

// Define the union U_VHD2P12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P12LADDR;
// Define the union U_VHD2P12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P12CADDR;
// Define the union U_VHD2P12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P12STRIDE;

// Define the union U_VHD2P12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_941          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P12VFPOS;

// Define the union U_VHD2P12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_942          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P12VLPOS;

// Define the union U_VHD2P13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_943          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P13RESO;

// Define the union U_VHD2P13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P13LADDR;
// Define the union U_VHD2P13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P13CADDR;
// Define the union U_VHD2P13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P13STRIDE;

// Define the union U_VHD2P13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_945          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P13VFPOS;

// Define the union U_VHD2P13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_946          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P13VLPOS;

// Define the union U_VHD2P14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_947          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P14RESO;

// Define the union U_VHD2P14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P14LADDR;
// Define the union U_VHD2P14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P14CADDR;
// Define the union U_VHD2P14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P14STRIDE;

// Define the union U_VHD2P14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_949          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P14VFPOS;

// Define the union U_VHD2P14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_950          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P14VLPOS;

// Define the union U_VHD2P15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_951          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P15RESO;

// Define the union U_VHD2P15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P15LADDR;
// Define the union U_VHD2P15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P15CADDR;
// Define the union U_VHD2P15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P15STRIDE;

// Define the union U_VHD2P15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_953          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P15VFPOS;

// Define the union U_VHD2P15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_954          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P15VLPOS;

// Define the union U_VHD2P16RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_955          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P16RESO;

// Define the union U_VHD2P16LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P16LADDR;
// Define the union U_VHD2P16CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P16CADDR;
// Define the union U_VHD2P16STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P16STRIDE;

// Define the union U_VHD2P16VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_957          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P16VFPOS;

// Define the union U_VHD2P16VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_958          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P16VLPOS;

// Define the union U_VHD2P17RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_959          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P17RESO;

// Define the union U_VHD2P17LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P17LADDR;
// Define the union U_VHD2P17CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P17CADDR;
// Define the union U_VHD2P17STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P17STRIDE;

// Define the union U_VHD2P17VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_961          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P17VFPOS;

// Define the union U_VHD2P17VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_962          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P17VLPOS;

// Define the union U_VHD2P18RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_963          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P18RESO;

// Define the union U_VHD2P18LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P18LADDR;
// Define the union U_VHD2P18CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P18CADDR;
// Define the union U_VHD2P18STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P18STRIDE;

// Define the union U_VHD2P18VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_965          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P18VFPOS;

// Define the union U_VHD2P18VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_966          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P18VLPOS;

// Define the union U_VHD2P19RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_967          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P19RESO;

// Define the union U_VHD2P19LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P19LADDR;
// Define the union U_VHD2P19CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P19CADDR;
// Define the union U_VHD2P19STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P19STRIDE;

// Define the union U_VHD2P19VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_969          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P19VFPOS;

// Define the union U_VHD2P19VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_970          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P19VLPOS;

// Define the union U_VHD2P20RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_971          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P20RESO;

// Define the union U_VHD2P20LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P20LADDR;
// Define the union U_VHD2P20CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P20CADDR;
// Define the union U_VHD2P20STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P20STRIDE;

// Define the union U_VHD2P20VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_973          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P20VFPOS;

// Define the union U_VHD2P20VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_974          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P20VLPOS;

// Define the union U_VHD2P21RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_975          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P21RESO;

// Define the union U_VHD2P21LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P21LADDR;
// Define the union U_VHD2P21CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P21CADDR;
// Define the union U_VHD2P21STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P21STRIDE;

// Define the union U_VHD2P21VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_977          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P21VFPOS;

// Define the union U_VHD2P21VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_978          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P21VLPOS;

// Define the union U_VHD2P22RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_979          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P22RESO;

// Define the union U_VHD2P22LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P22LADDR;
// Define the union U_VHD2P22CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P22CADDR;
// Define the union U_VHD2P22STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P22STRIDE;

// Define the union U_VHD2P22VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_981          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P22VFPOS;

// Define the union U_VHD2P22VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_982          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P22VLPOS;

// Define the union U_VHD2P23RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_983          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P23RESO;

// Define the union U_VHD2P23LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P23LADDR;
// Define the union U_VHD2P23CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P23CADDR;
// Define the union U_VHD2P23STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P23STRIDE;

// Define the union U_VHD2P23VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_985          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P23VFPOS;

// Define the union U_VHD2P23VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_986          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P23VLPOS;

// Define the union U_VHD2P24RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_987          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P24RESO;

// Define the union U_VHD2P24LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P24LADDR;
// Define the union U_VHD2P24CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P24CADDR;
// Define the union U_VHD2P24STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P24STRIDE;

// Define the union U_VHD2P24VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_989          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P24VFPOS;

// Define the union U_VHD2P24VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_990          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P24VLPOS;

// Define the union U_VHD2P25RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_991          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P25RESO;

// Define the union U_VHD2P25LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P25LADDR;
// Define the union U_VHD2P25CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P25CADDR;
// Define the union U_VHD2P25STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P25STRIDE;

// Define the union U_VHD2P25VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_993          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P25VFPOS;

// Define the union U_VHD2P25VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_994          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P25VLPOS;

// Define the union U_VHD2P26RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_995          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P26RESO;

// Define the union U_VHD2P26LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P26LADDR;
// Define the union U_VHD2P26CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P26CADDR;
// Define the union U_VHD2P26STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P26STRIDE;

// Define the union U_VHD2P26VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_997          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P26VFPOS;

// Define the union U_VHD2P26VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_998          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P26VLPOS;

// Define the union U_VHD2P27RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_999          : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P27RESO;

// Define the union U_VHD2P27LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P27LADDR;
// Define the union U_VHD2P27CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P27CADDR;
// Define the union U_VHD2P27STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P27STRIDE;

// Define the union U_VHD2P27VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1001         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P27VFPOS;

// Define the union U_VHD2P27VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1002         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P27VLPOS;

// Define the union U_VHD2P28RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1003         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P28RESO;

// Define the union U_VHD2P28LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P28LADDR;
// Define the union U_VHD2P28CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P28CADDR;
// Define the union U_VHD2P28STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P28STRIDE;

// Define the union U_VHD2P28VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1005         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P28VFPOS;

// Define the union U_VHD2P28VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1006         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P28VLPOS;

// Define the union U_VHD2P29RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1007         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P29RESO;

// Define the union U_VHD2P29LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P29LADDR;
// Define the union U_VHD2P29CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P29CADDR;
// Define the union U_VHD2P29STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P29STRIDE;

// Define the union U_VHD2P29VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1009         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P29VFPOS;

// Define the union U_VHD2P29VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1010         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P29VLPOS;

// Define the union U_VHD2P30RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1011         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P30RESO;

// Define the union U_VHD2P30LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P30LADDR;
// Define the union U_VHD2P30CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P30CADDR;
// Define the union U_VHD2P30STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P30STRIDE;

// Define the union U_VHD2P30VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1013         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P30VFPOS;

// Define the union U_VHD2P30VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1014         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P30VLPOS;

// Define the union U_VHD2P31RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1015         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P31RESO;

// Define the union U_VHD2P31LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P31LADDR;
// Define the union U_VHD2P31CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P31CADDR;
// Define the union U_VHD2P31STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P31STRIDE;

// Define the union U_VHD2P31VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1017         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P31VFPOS;

// Define the union U_VHD2P31VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1018         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P31VLPOS;

// Define the union U_VHD2P32RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1019         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P32RESO;

// Define the union U_VHD2P32LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P32LADDR;
// Define the union U_VHD2P32CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P32CADDR;
// Define the union U_VHD2P32STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P32STRIDE;

// Define the union U_VHD2P32VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1021         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P32VFPOS;

// Define the union U_VHD2P32VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1022         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P32VLPOS;

// Define the union U_VHD2P33RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1023         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P33RESO;

// Define the union U_VHD2P33LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P33LADDR;
// Define the union U_VHD2P33CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P33CADDR;
// Define the union U_VHD2P33STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P33STRIDE;

// Define the union U_VHD2P33VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1025         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P33VFPOS;

// Define the union U_VHD2P33VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1026         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P33VLPOS;

// Define the union U_VHD2P34RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1027         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P34RESO;

// Define the union U_VHD2P34LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P34LADDR;
// Define the union U_VHD2P34CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P34CADDR;
// Define the union U_VHD2P34STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P34STRIDE;

// Define the union U_VHD2P34VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1029         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P34VFPOS;

// Define the union U_VHD2P34VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1030         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P34VLPOS;

// Define the union U_VHD2P35RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1031         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P35RESO;

// Define the union U_VHD2P35LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P35LADDR;
// Define the union U_VHD2P35CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P35CADDR;
// Define the union U_VHD2P35STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P35STRIDE;

// Define the union U_VHD2P35VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1033         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P35VFPOS;

// Define the union U_VHD2P35VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1034         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P35VLPOS;

// Define the union U_VHD2P36RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1035         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P36RESO;

// Define the union U_VHD2P36LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P36LADDR;
// Define the union U_VHD2P36CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P36CADDR;
// Define the union U_VHD2P36STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P36STRIDE;

// Define the union U_VHD2P36VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1037         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P36VFPOS;

// Define the union U_VHD2P36VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1038         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P36VLPOS;

// Define the union U_VHD2P37RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1039         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P37RESO;

// Define the union U_VHD2P37LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P37LADDR;
// Define the union U_VHD2P37CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P37CADDR;
// Define the union U_VHD2P37STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P37STRIDE;

// Define the union U_VHD2P37VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1041         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P37VFPOS;

// Define the union U_VHD2P37VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1042         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P37VLPOS;

// Define the union U_VHD2P38RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1043         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P38RESO;

// Define the union U_VHD2P38LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P38LADDR;
// Define the union U_VHD2P38CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P38CADDR;
// Define the union U_VHD2P38STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P38STRIDE;

// Define the union U_VHD2P38VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1045         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P38VFPOS;

// Define the union U_VHD2P38VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1046         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P38VLPOS;

// Define the union U_VHD2P39RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1047         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P39RESO;

// Define the union U_VHD2P39LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P39LADDR;
// Define the union U_VHD2P39CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P39CADDR;
// Define the union U_VHD2P39STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P39STRIDE;

// Define the union U_VHD2P39VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1049         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P39VFPOS;

// Define the union U_VHD2P39VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1050         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P39VLPOS;

// Define the union U_VHD2P40RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1051         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P40RESO;

// Define the union U_VHD2P40LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P40LADDR;
// Define the union U_VHD2P40CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P40CADDR;
// Define the union U_VHD2P40STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P40STRIDE;

// Define the union U_VHD2P40VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1053         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P40VFPOS;

// Define the union U_VHD2P40VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1054         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P40VLPOS;

// Define the union U_VHD2P41RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1055         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P41RESO;

// Define the union U_VHD2P41LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P41LADDR;
// Define the union U_VHD2P41CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P41CADDR;
// Define the union U_VHD2P41STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P41STRIDE;

// Define the union U_VHD2P41VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1057         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P41VFPOS;

// Define the union U_VHD2P41VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1058         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P41VLPOS;

// Define the union U_VHD2P42RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1059         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P42RESO;

// Define the union U_VHD2P42LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P42LADDR;
// Define the union U_VHD2P42CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P42CADDR;
// Define the union U_VHD2P42STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P42STRIDE;

// Define the union U_VHD2P42VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1061         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P42VFPOS;

// Define the union U_VHD2P42VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1062         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P42VLPOS;

// Define the union U_VHD2P43RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1063         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P43RESO;

// Define the union U_VHD2P43LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P43LADDR;
// Define the union U_VHD2P43CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P43CADDR;
// Define the union U_VHD2P43STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P43STRIDE;

// Define the union U_VHD2P43VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1065         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P43VFPOS;

// Define the union U_VHD2P43VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1066         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P43VLPOS;

// Define the union U_VHD2P44RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1067         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P44RESO;

// Define the union U_VHD2P44LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P44LADDR;
// Define the union U_VHD2P44CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P44CADDR;
// Define the union U_VHD2P44STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P44STRIDE;

// Define the union U_VHD2P44VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1069         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P44VFPOS;

// Define the union U_VHD2P44VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1070         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P44VLPOS;

// Define the union U_VHD2P45RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1071         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P45RESO;

// Define the union U_VHD2P45LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P45LADDR;
// Define the union U_VHD2P45CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P45CADDR;
// Define the union U_VHD2P45STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P45STRIDE;

// Define the union U_VHD2P45VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1073         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P45VFPOS;

// Define the union U_VHD2P45VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1074         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P45VLPOS;

// Define the union U_VHD2P46RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1075         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P46RESO;

// Define the union U_VHD2P46LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P46LADDR;
// Define the union U_VHD2P46CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P46CADDR;
// Define the union U_VHD2P46STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P46STRIDE;

// Define the union U_VHD2P46VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1077         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P46VFPOS;

// Define the union U_VHD2P46VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1078         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P46VLPOS;

// Define the union U_VHD2P47RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1079         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P47RESO;

// Define the union U_VHD2P47LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P47LADDR;
// Define the union U_VHD2P47CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P47CADDR;
// Define the union U_VHD2P47STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P47STRIDE;

// Define the union U_VHD2P47VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1081         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P47VFPOS;

// Define the union U_VHD2P47VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1082         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P47VLPOS;

// Define the union U_VHD2P48RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1083         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P48RESO;

// Define the union U_VHD2P48LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P48LADDR;
// Define the union U_VHD2P48CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P48CADDR;
// Define the union U_VHD2P48STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P48STRIDE;

// Define the union U_VHD2P48VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1085         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P48VFPOS;

// Define the union U_VHD2P48VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1086         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P48VLPOS;

// Define the union U_VHD2P49RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1087         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P49RESO;

// Define the union U_VHD2P49LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P49LADDR;
// Define the union U_VHD2P49CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P49CADDR;
// Define the union U_VHD2P49STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P49STRIDE;

// Define the union U_VHD2P49VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1089         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P49VFPOS;

// Define the union U_VHD2P49VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1090         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P49VLPOS;

// Define the union U_VHD2P50RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1091         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P50RESO;

// Define the union U_VHD2P50LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P50LADDR;
// Define the union U_VHD2P50CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P50CADDR;
// Define the union U_VHD2P50STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P50STRIDE;

// Define the union U_VHD2P50VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1093         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P50VFPOS;

// Define the union U_VHD2P50VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1094         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P50VLPOS;

// Define the union U_VHD2P51RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1095         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P51RESO;

// Define the union U_VHD2P51LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P51LADDR;
// Define the union U_VHD2P51CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P51CADDR;
// Define the union U_VHD2P51STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P51STRIDE;

// Define the union U_VHD2P51VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1097         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P51VFPOS;

// Define the union U_VHD2P51VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1098         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P51VLPOS;

// Define the union U_VHD2P52RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1099         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P52RESO;

// Define the union U_VHD2P52LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P52LADDR;
// Define the union U_VHD2P52CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P52CADDR;
// Define the union U_VHD2P52STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P52STRIDE;

// Define the union U_VHD2P52VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1101         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P52VFPOS;

// Define the union U_VHD2P52VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1102         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P52VLPOS;

// Define the union U_VHD2P53RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1103         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P53RESO;

// Define the union U_VHD2P53LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P53LADDR;
// Define the union U_VHD2P53CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P53CADDR;
// Define the union U_VHD2P53STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P53STRIDE;

// Define the union U_VHD2P53VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1105         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P53VFPOS;

// Define the union U_VHD2P53VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1106         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P53VLPOS;

// Define the union U_VHD2P54RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1107         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P54RESO;

// Define the union U_VHD2P54LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P54LADDR;
// Define the union U_VHD2P54CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P54CADDR;
// Define the union U_VHD2P54STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P54STRIDE;

// Define the union U_VHD2P54VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1109         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P54VFPOS;

// Define the union U_VHD2P54VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1110         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P54VLPOS;

// Define the union U_VHD2P55RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1111         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P55RESO;

// Define the union U_VHD2P55LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P55LADDR;
// Define the union U_VHD2P55CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P55CADDR;
// Define the union U_VHD2P55STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P55STRIDE;

// Define the union U_VHD2P55VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1113         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P55VFPOS;

// Define the union U_VHD2P55VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1114         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P55VLPOS;

// Define the union U_VHD2P56RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1115         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P56RESO;

// Define the union U_VHD2P56LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P56LADDR;
// Define the union U_VHD2P56CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P56CADDR;
// Define the union U_VHD2P56STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P56STRIDE;

// Define the union U_VHD2P56VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1117         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P56VFPOS;

// Define the union U_VHD2P56VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1118         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P56VLPOS;

// Define the union U_VHD2P57RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1119         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P57RESO;

// Define the union U_VHD2P57LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P57LADDR;
// Define the union U_VHD2P57CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P57CADDR;
// Define the union U_VHD2P57STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P57STRIDE;

// Define the union U_VHD2P57VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1121         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P57VFPOS;

// Define the union U_VHD2P57VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1122         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P57VLPOS;

// Define the union U_VHD2P58RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1123         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P58RESO;

// Define the union U_VHD2P58LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P58LADDR;
// Define the union U_VHD2P58CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P58CADDR;
// Define the union U_VHD2P58STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P58STRIDE;

// Define the union U_VHD2P58VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1125         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P58VFPOS;

// Define the union U_VHD2P58VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1126         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P58VLPOS;

// Define the union U_VHD2P59RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1127         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P59RESO;

// Define the union U_VHD2P59LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P59LADDR;
// Define the union U_VHD2P59CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P59CADDR;
// Define the union U_VHD2P59STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P59STRIDE;

// Define the union U_VHD2P59VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1129         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P59VFPOS;

// Define the union U_VHD2P59VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1130         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P59VLPOS;

// Define the union U_VHD2P60RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1131         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P60RESO;

// Define the union U_VHD2P60LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P60LADDR;
// Define the union U_VHD2P60CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P60CADDR;
// Define the union U_VHD2P60STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P60STRIDE;

// Define the union U_VHD2P60VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1133         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P60VFPOS;

// Define the union U_VHD2P60VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1134         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P60VLPOS;

// Define the union U_VHD2P61RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1135         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P61RESO;

// Define the union U_VHD2P61LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P61LADDR;
// Define the union U_VHD2P61CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P61CADDR;
// Define the union U_VHD2P61STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P61STRIDE;

// Define the union U_VHD2P61VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1137         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P61VFPOS;

// Define the union U_VHD2P61VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1138         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P61VLPOS;

// Define the union U_VHD2P62RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1139         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P62RESO;

// Define the union U_VHD2P62LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P62LADDR;
// Define the union U_VHD2P62CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P62CADDR;
// Define the union U_VHD2P62STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P62STRIDE;

// Define the union U_VHD2P62VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1141         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P62VFPOS;

// Define the union U_VHD2P62VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1142         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P62VLPOS;

// Define the union U_VHD2P63RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1143         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P63RESO;

// Define the union U_VHD2P63LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P63LADDR;
// Define the union U_VHD2P63CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VHD2P63CADDR;
// Define the union U_VHD2P63STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P63STRIDE;

// Define the union U_VHD2P63VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1145         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P63VFPOS;

// Define the union U_VHD2P63VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1146         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD2P63VLPOS;

// Define the union U_VHD264REGIONENH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p32_en                : 1   ; // [0]
        HI_U32    p33_en                : 1   ; // [1]
        HI_U32    p34_en                : 1   ; // [2]
        HI_U32    p35_en                : 1   ; // [3]
        HI_U32    p36_en                : 1   ; // [4]
        HI_U32    p37_en                : 1   ; // [5]
        HI_U32    p38_en                : 1   ; // [6]
        HI_U32    p39_en                : 1   ; // [7]
        HI_U32    p40_en                : 1   ; // [8]
        HI_U32    p41_en                : 1   ; // [9]
        HI_U32    p42_en                : 1   ; // [10]
        HI_U32    p43_en                : 1   ; // [11]
        HI_U32    p44_en                : 1   ; // [12]
        HI_U32    p45_en                : 1   ; // [13]
        HI_U32    p46_en                : 1   ; // [14]
        HI_U32    p47_en                : 1   ; // [15]
        HI_U32    p48_en                : 1   ; // [16]
        HI_U32    p49_en                : 1   ; // [17]
        HI_U32    p50_en                : 1   ; // [18]
        HI_U32    p51_en                : 1   ; // [19]
        HI_U32    p52_en                : 1   ; // [20]
        HI_U32    p53_en                : 1   ; // [21]
        HI_U32    p54_en                : 1   ; // [22]
        HI_U32    p55_en                : 1   ; // [23]
        HI_U32    p56_en                : 1   ; // [24]
        HI_U32    p57_en                : 1   ; // [25]
        HI_U32    p58_en                : 1   ; // [26]
        HI_U32    p59_en                : 1   ; // [27]
        HI_U32    p60_en                : 1   ; // [28]
        HI_U32    p61_en                : 1   ; // [29]
        HI_U32    p62_en                : 1   ; // [30]
        HI_U32    p63_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD264REGIONENH;

// Define the union U_VHD264REGIONENL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    Reserved_p8_en        : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VHD264REGIONENL;

// Define the union U_VSDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_1150         : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1149         : 11  ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCTRL;

// Define the union U_VSDUPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1152         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDUPD;

// Define the union U_VSDCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDCADDR;
// Define the union U_VSDCCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDCCADDR;
// Define the union U_VSDSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDSTRIDE;

// Define the union U_VSDIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1155         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDIRESO;

// Define the union U_VSDLKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_1156         : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDLKEY;

// Define the union U_VSDCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_1158         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCBMPARA;

// Define the union U_VSDDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1159         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDDFPOS;

// Define the union U_VSDDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1161         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDDLPOS;

// Define the union U_VSDVFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1162         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDVFPOS;

// Define the union U_VSDVLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1163         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDVLPOS;

// Define the union U_VSDBK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDBK;

// Define the union U_VSDCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc2               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc0               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1164         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCIDC;

// Define the union U_VSDCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc2               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc0               : 9   ; // [26..18]
        HI_U32    Reserved_1166         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCODC;

// Define the union U_VSDCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_1168         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_1167         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCP0;

// Define the union U_VSDCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_1170         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_1169         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCP1;

// Define the union U_VSDCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_1172         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_1171         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCP2;

// Define the union U_VSDCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_1174         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_1173         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCP3;

// Define the union U_VSDCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_1175         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDCSCP4;

// Define the union U_VSDACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM0;

// Define the union U_VSDACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_1177         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM1;

// Define the union U_VSDACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1178         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM2;

// Define the union U_VSDACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1179         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM3;

// Define the union U_VSDACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1180         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM4;

// Define the union U_VSDACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1181         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM5;

// Define the union U_VSDACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1182         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM6;

// Define the union U_VSDACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1183         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACM7;

// Define the union U_VSDHSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1186         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1185         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1184         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDHSP;

// Define the union U_VSDHLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1187         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDHLOFFSET;

// Define the union U_VSDHCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1188         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDHCOFFSET;

// Define the union U_VSDVSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1189         : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDVSP;

// Define the union U_VSDVSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1191         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDVSR;

// Define the union U_VSDVOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDVOFFSET;

// Define the union U_VSDZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1192         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDZMEORESO;

// Define the union U_VSDZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1193         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDZMEIRESO;

// Define the union U_VSDZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1194         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDZMEDBG;

// Define the union U_VSDMOSAIC
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 Reserved_1195           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDMOSAIC;
// Define the union U_VSDACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCTHD1;

// Define the union U_VSDACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_1197         : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCTHD2;

// Define the union U_VSDACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1198         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCLOWN;

// Define the union U_VSDACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1200         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCMEDN;

// Define the union U_VSDACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1202         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCHIGHN;

// Define the union U_VSDACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1204         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCMLN;

// Define the union U_VSDACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1206         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCMHN;

// Define the union U_VSDACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_1208         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACC3LOW;

// Define the union U_VSDACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_1210         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACC3MED;

// Define the union U_VSDACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_1211         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACC3HIGH;

// Define the union U_VSDACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_1212         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACC8MLOW;

// Define the union U_VSDACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_1213         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACC8MHIGH;

// Define the union U_VSDACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_1214         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDACCTOTAL;

// Define the union U_VSDIFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_1216         : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_1215         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDIFIRCOEF01;

// Define the union U_VSDIFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_1219         : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_1218         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDIFIRCOEF23;

// Define the union U_VSDIFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_1221         : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_1220         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDIFIRCOEF45;

// Define the union U_VSDIFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_1223         : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_1222         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDIFIRCOEF67;

// Define the union U_VSDP0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1224         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP0RESO;

// Define the union U_VSDP0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP0LADDR;
// Define the union U_VSDP0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP0CADDR;
// Define the union U_VSDP0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP0STRIDE;

// Define the union U_VSDP0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1226         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP0VFPOS;

// Define the union U_VSDP0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1227         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP0VLPOS;

// Define the union U_VSDP1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1228         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP1RESO;

// Define the union U_VSDP1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP1LADDR;
// Define the union U_VSDP1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP1CADDR;
// Define the union U_VSDP1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP1STRIDE;

// Define the union U_VSDP1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1230         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP1VFPOS;

// Define the union U_VSDP1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1231         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP1VLPOS;

// Define the union U_VSDP2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1232         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP2RESO;

// Define the union U_VSDP2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP2LADDR;
// Define the union U_VSDP2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP2CADDR;
// Define the union U_VSDP2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP2STRIDE;

// Define the union U_VSDP2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1234         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP2VFPOS;

// Define the union U_VSDP2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1235         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP2VLPOS;

// Define the union U_VSDP3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1236         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP3RESO;

// Define the union U_VSDP3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP3LADDR;
// Define the union U_VSDP3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP3CADDR;
// Define the union U_VSDP3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP3STRIDE;

// Define the union U_VSDP3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1238         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP3VFPOS;

// Define the union U_VSDP3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1239         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP3VLPOS;

// Define the union U_VSDP4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1240         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP4RESO;

// Define the union U_VSDP4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP4LADDR;
// Define the union U_VSDP4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP4CADDR;
// Define the union U_VSDP4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP4STRIDE;

// Define the union U_VSDP4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1242         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP4VFPOS;

// Define the union U_VSDP4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1243         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP4VLPOS;

// Define the union U_VSDP5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1244         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP5RESO;

// Define the union U_VSDP5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP5LADDR;
// Define the union U_VSDP5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP5CADDR;
// Define the union U_VSDP5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP5STRIDE;

// Define the union U_VSDP5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1246         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP5VFPOS;

// Define the union U_VSDP5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1247         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP5VLPOS;

// Define the union U_VSDP6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1248         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP6RESO;

// Define the union U_VSDP6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP6LADDR;
// Define the union U_VSDP6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP6CADDR;
// Define the union U_VSDP6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP6STRIDE;

// Define the union U_VSDP6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1250         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP6VFPOS;

// Define the union U_VSDP6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1251         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP6VLPOS;

// Define the union U_VSDP7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1252         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP7RESO;

// Define the union U_VSDP7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP7LADDR;
// Define the union U_VSDP7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP7CADDR;
// Define the union U_VSDP7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP7STRIDE;

// Define the union U_VSDP7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1254         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP7VFPOS;

// Define the union U_VSDP7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1255         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP7VLPOS;

// Define the union U_VSDP8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1256         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP8RESO;

// Define the union U_VSDP8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP8LADDR;
// Define the union U_VSDP8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP8CADDR;
// Define the union U_VSDP8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP8STRIDE;

// Define the union U_VSDP8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1258         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP8VFPOS;

// Define the union U_VSDP8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1259         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP8VLPOS;

// Define the union U_VSDP9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1260         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP9RESO;

// Define the union U_VSDP9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP9LADDR;
// Define the union U_VSDP9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP9CADDR;
// Define the union U_VSDP9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP9STRIDE;

// Define the union U_VSDP9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1262         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP9VFPOS;

// Define the union U_VSDP9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1263         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP9VLPOS;

// Define the union U_VSDP10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1264         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP10RESO;

// Define the union U_VSDP10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP10LADDR;
// Define the union U_VSDP10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP10CADDR;
// Define the union U_VSDP10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP10STRIDE;

// Define the union U_VSDP10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1266         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP10VFPOS;

// Define the union U_VSDP10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1267         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP10VLPOS;

// Define the union U_VSDP11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1268         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP11RESO;

// Define the union U_VSDP11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP11LADDR;
// Define the union U_VSDP11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP11CADDR;
// Define the union U_VSDP11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP11STRIDE;

// Define the union U_VSDP11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1270         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP11VFPOS;

// Define the union U_VSDP11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1271         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP11VLPOS;

// Define the union U_VSDP12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1272         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP12RESO;

// Define the union U_VSDP12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP12LADDR;
// Define the union U_VSDP12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP12CADDR;
// Define the union U_VSDP12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP12STRIDE;

// Define the union U_VSDP12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1274         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP12VFPOS;

// Define the union U_VSDP12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1275         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP12VLPOS;

// Define the union U_VSDP13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1276         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP13RESO;

// Define the union U_VSDP13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP13LADDR;
// Define the union U_VSDP13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP13CADDR;
// Define the union U_VSDP13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP13STRIDE;

// Define the union U_VSDP13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1278         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP13VFPOS;

// Define the union U_VSDP13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1279         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP13VLPOS;

// Define the union U_VSDP14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1280         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP14RESO;

// Define the union U_VSDP14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP14LADDR;
// Define the union U_VSDP14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP14CADDR;
// Define the union U_VSDP14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP14STRIDE;

// Define the union U_VSDP14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1282         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP14VFPOS;

// Define the union U_VSDP14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1283         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP14VLPOS;

// Define the union U_VSDP15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1284         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP15RESO;

// Define the union U_VSDP15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP15LADDR;
// Define the union U_VSDP15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSDP15CADDR;
// Define the union U_VSDP15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP15STRIDE;

// Define the union U_VSDP15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1286         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP15VFPOS;

// Define the union U_VSDP15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1287         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSDP15VLPOS;

// Define the union U_VSD16REGIONEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    Reserved_1288         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD16REGIONEN;

// Define the union U_VSD1CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_1292         : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1291         : 11  ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CTRL;

// Define the union U_VSD1UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1294         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1UPD;

// Define the union U_VSD1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1CADDR;
// Define the union U_VSD1CCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1CCADDR;
// Define the union U_VSD1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1STRIDE;

// Define the union U_VSD1IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1297         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1IRESO;

// Define the union U_VSD1LKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_1298         : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1LKEY;

// Define the union U_VSD1CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_1300         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CBMPARA;

// Define the union U_VSD1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1301         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1DFPOS;

// Define the union U_VSD1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1303         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1DLPOS;

// Define the union U_VSD1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1304         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1VFPOS;

// Define the union U_VSD1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1305         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1VLPOS;

// Define the union U_VSD1BK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1BK;

// Define the union U_VSD1CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1306         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCIDC;

// Define the union U_VSD1CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_1308         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCODC;

// Define the union U_VSD1CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_1310         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_1309         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCP0;

// Define the union U_VSD1CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_1312         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_1311         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCP1;

// Define the union U_VSD1CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_1314         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_1313         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCP2;

// Define the union U_VSD1CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_1316         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_1315         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCP3;

// Define the union U_VSD1CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_1317         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1CSCP4;

// Define the union U_VSD1ACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM0;

// Define the union U_VSD1ACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_1319         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM1;

// Define the union U_VSD1ACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1320         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM2;

// Define the union U_VSD1ACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1321         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM3;

// Define the union U_VSD1ACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1322         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM4;

// Define the union U_VSD1ACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1323         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM5;

// Define the union U_VSD1ACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1324         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM6;

// Define the union U_VSD1ACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1325         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACM7;

// Define the union U_VSD1HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1328         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1327         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1326         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1HSP;

// Define the union U_VSD1HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1329         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1HLOFFSET;

// Define the union U_VSD1HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1330         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1HCOFFSET;

// Define the union U_VSD1VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1331         : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1VSP;

// Define the union U_VSD1VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1333         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1VSR;

// Define the union U_VSD1VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1VOFFSET;

// Define the union U_VSD1ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1334         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ZMEORESO;

// Define the union U_VSD1ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1335         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ZMEIRESO;

// Define the union U_VSD1ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1336         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ZMEDBG;

// Define the union U_VSD1MOSAIC
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 Reserved_1337           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1MOSAIC;
// Define the union U_VSD1ACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCTHD1;

// Define the union U_VSD1ACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_1339         : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCTHD2;

// Define the union U_VSD1ACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1340         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCLOWN;

// Define the union U_VSD1ACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1342         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCMEDN;

// Define the union U_VSD1ACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1344         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCHIGHN;

// Define the union U_VSD1ACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1346         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCMLN;

// Define the union U_VSD1ACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1348         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCMHN;

// Define the union U_VSD1ACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_1350         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACC3LOW;

// Define the union U_VSD1ACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_1352         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACC3MED;

// Define the union U_VSD1ACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_1353         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACC3HIGH;

// Define the union U_VSD1ACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_1354         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACC8MLOW;

// Define the union U_VSD1ACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_1355         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACC8MHIGH;

// Define the union U_VSD1ACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_1356         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1ACCTOTAL;

// Define the union U_VSD1IFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_1358         : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_1357         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1IFIRCOEF01;

// Define the union U_VSD1IFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_1361         : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_1360         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1IFIRCOEF23;

// Define the union U_VSD1IFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_1363         : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_1362         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1IFIRCOEF45;

// Define the union U_VSD1IFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_1365         : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_1364         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1IFIRCOEF67;

// Define the union U_VSD1P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1366         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P0RESO;

// Define the union U_VSD1P0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P0LADDR;
// Define the union U_VSD1P0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P0CADDR;
// Define the union U_VSD1P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P0STRIDE;

// Define the union U_VSD1P0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1368         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P0VFPOS;

// Define the union U_VSD1P0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1369         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P0VLPOS;

// Define the union U_VSD1P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1370         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P1RESO;

// Define the union U_VSD1P1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P1LADDR;
// Define the union U_VSD1P1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P1CADDR;
// Define the union U_VSD1P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P1STRIDE;

// Define the union U_VSD1P1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1372         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P1VFPOS;

// Define the union U_VSD1P1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1373         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P1VLPOS;

// Define the union U_VSD1P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1374         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P2RESO;

// Define the union U_VSD1P2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P2LADDR;
// Define the union U_VSD1P2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P2CADDR;
// Define the union U_VSD1P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P2STRIDE;

// Define the union U_VSD1P2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1376         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P2VFPOS;

// Define the union U_VSD1P2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1377         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P2VLPOS;

// Define the union U_VSD1P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1378         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P3RESO;

// Define the union U_VSD1P3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P3LADDR;
// Define the union U_VSD1P3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P3CADDR;
// Define the union U_VSD1P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P3STRIDE;

// Define the union U_VSD1P3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1380         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P3VFPOS;

// Define the union U_VSD1P3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1381         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P3VLPOS;

// Define the union U_VSD1P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1382         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P4RESO;

// Define the union U_VSD1P4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P4LADDR;
// Define the union U_VSD1P4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P4CADDR;
// Define the union U_VSD1P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P4STRIDE;

// Define the union U_VSD1P4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1384         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P4VFPOS;

// Define the union U_VSD1P4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1385         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P4VLPOS;

// Define the union U_VSD1P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1386         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P5RESO;

// Define the union U_VSD1P5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P5LADDR;
// Define the union U_VSD1P5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P5CADDR;
// Define the union U_VSD1P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P5STRIDE;

// Define the union U_VSD1P5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1388         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P5VFPOS;

// Define the union U_VSD1P5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1389         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P5VLPOS;

// Define the union U_VSD1P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1390         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P6RESO;

// Define the union U_VSD1P6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P6LADDR;
// Define the union U_VSD1P6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P6CADDR;
// Define the union U_VSD1P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P6STRIDE;

// Define the union U_VSD1P6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1392         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P6VFPOS;

// Define the union U_VSD1P6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1393         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P6VLPOS;

// Define the union U_VSD1P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1394         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P7RESO;

// Define the union U_VSD1P7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P7LADDR;
// Define the union U_VSD1P7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P7CADDR;
// Define the union U_VSD1P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P7STRIDE;

// Define the union U_VSD1P7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1396         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P7VFPOS;

// Define the union U_VSD1P7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1397         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P7VLPOS;

// Define the union U_VSD1P8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1398         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P8RESO;

// Define the union U_VSD1P8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P8LADDR;
// Define the union U_VSD1P8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P8CADDR;
// Define the union U_VSD1P8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P8STRIDE;

// Define the union U_VSD1P8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1400         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P8VFPOS;

// Define the union U_VSD1P8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1401         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P8VLPOS;

// Define the union U_VSD1P9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1402         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P9RESO;

// Define the union U_VSD1P9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P9LADDR;
// Define the union U_VSD1P9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P9CADDR;
// Define the union U_VSD1P9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P9STRIDE;

// Define the union U_VSD1P9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1404         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P9VFPOS;

// Define the union U_VSD1P9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1405         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P9VLPOS;

// Define the union U_VSD1P10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1406         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P10RESO;

// Define the union U_VSD1P10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P10LADDR;
// Define the union U_VSD1P10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P10CADDR;
// Define the union U_VSD1P10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P10STRIDE;

// Define the union U_VSD1P10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1408         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P10VFPOS;

// Define the union U_VSD1P10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1409         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P10VLPOS;

// Define the union U_VSD1P11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1410         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P11RESO;

// Define the union U_VSD1P11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P11LADDR;
// Define the union U_VSD1P11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P11CADDR;
// Define the union U_VSD1P11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P11STRIDE;

// Define the union U_VSD1P11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1412         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P11VFPOS;

// Define the union U_VSD1P11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1413         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P11VLPOS;

// Define the union U_VSD1P12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1414         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P12RESO;

// Define the union U_VSD1P12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P12LADDR;
// Define the union U_VSD1P12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P12CADDR;
// Define the union U_VSD1P12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P12STRIDE;

// Define the union U_VSD1P12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1416         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P12VFPOS;

// Define the union U_VSD1P12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1417         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P12VLPOS;

// Define the union U_VSD1P13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1418         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P13RESO;

// Define the union U_VSD1P13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P13LADDR;
// Define the union U_VSD1P13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P13CADDR;
// Define the union U_VSD1P13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P13STRIDE;

// Define the union U_VSD1P13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1420         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P13VFPOS;

// Define the union U_VSD1P13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1421         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P13VLPOS;

// Define the union U_VSD1P14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1422         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P14RESO;

// Define the union U_VSD1P14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P14LADDR;
// Define the union U_VSD1P14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P14CADDR;
// Define the union U_VSD1P14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P14STRIDE;

// Define the union U_VSD1P14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1424         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P14VFPOS;

// Define the union U_VSD1P14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1425         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P14VLPOS;

// Define the union U_VSD1P15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1426         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P15RESO;

// Define the union U_VSD1P15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P15LADDR;
// Define the union U_VSD1P15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD1P15CADDR;
// Define the union U_VSD1P15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P15STRIDE;

// Define the union U_VSD1P15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1428         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P15VFPOS;

// Define the union U_VSD1P15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1429         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD1P15VLPOS;

// Define the union U_VSD116REGIONEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    Reserved_1430         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD116REGIONEN;

// Define the union U_VSD2CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_1434         : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1433         : 11  ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CTRL;

// Define the union U_VSD2UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1436         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2UPD;

// Define the union U_VSD2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2CADDR;
// Define the union U_VSD2CCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2CCADDR;
// Define the union U_VSD2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2STRIDE;

// Define the union U_VSD2IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1439         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2IRESO;

// Define the union U_VSD2LKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_1440         : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2LKEY;

// Define the union U_VSD2CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_1442         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CBMPARA;

// Define the union U_VSD2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1443         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2DFPOS;

// Define the union U_VSD2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1445         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2DLPOS;

// Define the union U_VSD2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1446         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2VFPOS;

// Define the union U_VSD2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1447         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2VLPOS;

// Define the union U_VSD2BK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2BK;

// Define the union U_VSD2CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1448         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCIDC;

// Define the union U_VSD2CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_1450         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCODC;

// Define the union U_VSD2CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_1452         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_1451         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCP0;

// Define the union U_VSD2CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_1454         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_1453         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCP1;

// Define the union U_VSD2CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_1456         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_1455         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCP2;

// Define the union U_VSD2CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_1458         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_1457         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCP3;

// Define the union U_VSD2CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_1459         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2CSCP4;

// Define the union U_VSD2ACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM0;

// Define the union U_VSD2ACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_1461         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM1;

// Define the union U_VSD2ACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1462         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM2;

// Define the union U_VSD2ACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1463         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM3;

// Define the union U_VSD2ACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1464         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM4;

// Define the union U_VSD2ACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1465         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM5;

// Define the union U_VSD2ACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1466         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM6;

// Define the union U_VSD2ACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1467         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACM7;

// Define the union U_VSD2HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1470         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1469         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1468         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2HSP;

// Define the union U_VSD2HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1471         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2HLOFFSET;

// Define the union U_VSD2HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1472         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2HCOFFSET;

// Define the union U_VSD2VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1473         : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2VSP;

// Define the union U_VSD2VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1475         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2VSR;

// Define the union U_VSD2VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2VOFFSET;

// Define the union U_VSD2ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1476         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ZMEORESO;

// Define the union U_VSD2ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1477         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ZMEIRESO;

// Define the union U_VSD2ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1478         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ZMEDBG;

// Define the union U_VSD2MOSAIC
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 Reserved_1479           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2MOSAIC;
// Define the union U_VSD2ACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCTHD1;

// Define the union U_VSD2ACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_1481         : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCTHD2;

// Define the union U_VSD2ACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1482         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCLOWN;

// Define the union U_VSD2ACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1484         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCMEDN;

// Define the union U_VSD2ACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1486         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCHIGHN;

// Define the union U_VSD2ACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1488         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCMLN;

// Define the union U_VSD2ACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1490         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCMHN;

// Define the union U_VSD2ACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_1492         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACC3LOW;

// Define the union U_VSD2ACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_1494         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACC3MED;

// Define the union U_VSD2ACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_1495         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACC3HIGH;

// Define the union U_VSD2ACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_1496         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACC8MLOW;

// Define the union U_VSD2ACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_1497         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACC8MHIGH;

// Define the union U_VSD2ACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_1498         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2ACCTOTAL;

// Define the union U_VSD2IFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_1500         : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_1499         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2IFIRCOEF01;

// Define the union U_VSD2IFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_1503         : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_1502         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2IFIRCOEF23;

// Define the union U_VSD2IFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_1505         : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_1504         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2IFIRCOEF45;

// Define the union U_VSD2IFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_1507         : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_1506         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2IFIRCOEF67;

// Define the union U_VSD2P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1508         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P0RESO;

// Define the union U_VSD2P0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P0LADDR;
// Define the union U_VSD2P0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P0CADDR;
// Define the union U_VSD2P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P0STRIDE;

// Define the union U_VSD2P0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1510         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P0VFPOS;

// Define the union U_VSD2P0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1511         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P0VLPOS;

// Define the union U_VSD2P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1512         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P1RESO;

// Define the union U_VSD2P1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P1LADDR;
// Define the union U_VSD2P1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P1CADDR;
// Define the union U_VSD2P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P1STRIDE;

// Define the union U_VSD2P1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1514         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P1VFPOS;

// Define the union U_VSD2P1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1515         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P1VLPOS;

// Define the union U_VSD2P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1516         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P2RESO;

// Define the union U_VSD2P2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P2LADDR;
// Define the union U_VSD2P2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P2CADDR;
// Define the union U_VSD2P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P2STRIDE;

// Define the union U_VSD2P2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1518         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P2VFPOS;

// Define the union U_VSD2P2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1519         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P2VLPOS;

// Define the union U_VSD2P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1520         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P3RESO;

// Define the union U_VSD2P3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P3LADDR;
// Define the union U_VSD2P3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P3CADDR;
// Define the union U_VSD2P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P3STRIDE;

// Define the union U_VSD2P3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1522         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P3VFPOS;

// Define the union U_VSD2P3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1523         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P3VLPOS;

// Define the union U_VSD2P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1524         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P4RESO;

// Define the union U_VSD2P4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P4LADDR;
// Define the union U_VSD2P4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P4CADDR;
// Define the union U_VSD2P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P4STRIDE;

// Define the union U_VSD2P4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1526         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P4VFPOS;

// Define the union U_VSD2P4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1527         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P4VLPOS;

// Define the union U_VSD2P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1528         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P5RESO;

// Define the union U_VSD2P5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P5LADDR;
// Define the union U_VSD2P5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P5CADDR;
// Define the union U_VSD2P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P5STRIDE;

// Define the union U_VSD2P5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1530         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P5VFPOS;

// Define the union U_VSD2P5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1531         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P5VLPOS;

// Define the union U_VSD2P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1532         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P6RESO;

// Define the union U_VSD2P6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P6LADDR;
// Define the union U_VSD2P6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P6CADDR;
// Define the union U_VSD2P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P6STRIDE;

// Define the union U_VSD2P6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1534         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P6VFPOS;

// Define the union U_VSD2P6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1535         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P6VLPOS;

// Define the union U_VSD2P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1536         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P7RESO;

// Define the union U_VSD2P7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P7LADDR;
// Define the union U_VSD2P7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P7CADDR;
// Define the union U_VSD2P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P7STRIDE;

// Define the union U_VSD2P7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1538         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P7VFPOS;

// Define the union U_VSD2P7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1539         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P7VLPOS;

// Define the union U_VSD2P8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1540         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P8RESO;

// Define the union U_VSD2P8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P8LADDR;
// Define the union U_VSD2P8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P8CADDR;
// Define the union U_VSD2P8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P8STRIDE;

// Define the union U_VSD2P8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1542         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P8VFPOS;

// Define the union U_VSD2P8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1543         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P8VLPOS;

// Define the union U_VSD2P9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1544         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P9RESO;

// Define the union U_VSD2P9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P9LADDR;
// Define the union U_VSD2P9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P9CADDR;
// Define the union U_VSD2P9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P9STRIDE;

// Define the union U_VSD2P9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1546         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P9VFPOS;

// Define the union U_VSD2P9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1547         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P9VLPOS;

// Define the union U_VSD2P10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1548         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P10RESO;

// Define the union U_VSD2P10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P10LADDR;
// Define the union U_VSD2P10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P10CADDR;
// Define the union U_VSD2P10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P10STRIDE;

// Define the union U_VSD2P10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1550         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P10VFPOS;

// Define the union U_VSD2P10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1551         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P10VLPOS;

// Define the union U_VSD2P11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1552         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P11RESO;

// Define the union U_VSD2P11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P11LADDR;
// Define the union U_VSD2P11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P11CADDR;
// Define the union U_VSD2P11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P11STRIDE;

// Define the union U_VSD2P11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1554         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P11VFPOS;

// Define the union U_VSD2P11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1555         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P11VLPOS;

// Define the union U_VSD2P12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1556         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P12RESO;

// Define the union U_VSD2P12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P12LADDR;
// Define the union U_VSD2P12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P12CADDR;
// Define the union U_VSD2P12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P12STRIDE;

// Define the union U_VSD2P12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1558         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P12VFPOS;

// Define the union U_VSD2P12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1559         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P12VLPOS;

// Define the union U_VSD2P13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1560         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P13RESO;

// Define the union U_VSD2P13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P13LADDR;
// Define the union U_VSD2P13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P13CADDR;
// Define the union U_VSD2P13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P13STRIDE;

// Define the union U_VSD2P13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1562         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P13VFPOS;

// Define the union U_VSD2P13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1563         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P13VLPOS;

// Define the union U_VSD2P14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1564         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P14RESO;

// Define the union U_VSD2P14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P14LADDR;
// Define the union U_VSD2P14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P14CADDR;
// Define the union U_VSD2P14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P14STRIDE;

// Define the union U_VSD2P14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1566         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P14VFPOS;

// Define the union U_VSD2P14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1567         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P14VLPOS;

// Define the union U_VSD2P15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1568         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P15RESO;

// Define the union U_VSD2P15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P15LADDR;
// Define the union U_VSD2P15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD2P15CADDR;
// Define the union U_VSD2P15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P15STRIDE;

// Define the union U_VSD2P15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1570         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P15VFPOS;

// Define the union U_VSD2P15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1571         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD2P15VLPOS;

// Define the union U_VSD216REGIONEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    Reserved_1572         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD216REGIONEN;

// Define the union U_VSD3CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_1576         : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1575         : 11  ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CTRL;

// Define the union U_VSD3UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1578         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3UPD;

// Define the union U_VSD3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3CADDR;
// Define the union U_VSD3CCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3CCADDR;
// Define the union U_VSD3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3STRIDE;

// Define the union U_VSD3IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1581         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3IRESO;

// Define the union U_VSD3LKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_1582         : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3LKEY;

// Define the union U_VSD3CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_1584         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CBMPARA;

// Define the union U_VSD3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1585         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3DFPOS;

// Define the union U_VSD3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1587         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3DLPOS;

// Define the union U_VSD3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1588         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3VFPOS;

// Define the union U_VSD3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1589         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3VLPOS;

// Define the union U_VSD3BK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3BK;

// Define the union U_VSD3CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1590         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCIDC;

// Define the union U_VSD3CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_1592         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCODC;

// Define the union U_VSD3CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_1594         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_1593         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCP0;

// Define the union U_VSD3CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_1596         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_1595         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCP1;

// Define the union U_VSD3CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_1598         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_1597         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCP2;

// Define the union U_VSD3CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_1600         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_1599         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCP3;

// Define the union U_VSD3CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_1601         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3CSCP4;

// Define the union U_VSD3ACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM0;

// Define the union U_VSD3ACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_1603         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM1;

// Define the union U_VSD3ACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1604         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM2;

// Define the union U_VSD3ACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1605         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM3;

// Define the union U_VSD3ACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1606         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM4;

// Define the union U_VSD3ACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1607         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM5;

// Define the union U_VSD3ACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1608         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM6;

// Define the union U_VSD3ACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1609         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACM7;

// Define the union U_VSD3HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1612         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1611         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1610         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3HSP;

// Define the union U_VSD3HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1613         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3HLOFFSET;

// Define the union U_VSD3HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1614         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3HCOFFSET;

// Define the union U_VSD3VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1615         : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3VSP;

// Define the union U_VSD3VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1617         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3VSR;

// Define the union U_VSD3VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3VOFFSET;

// Define the union U_VSD3ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1618         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ZMEORESO;

// Define the union U_VSD3ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1619         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ZMEIRESO;

// Define the union U_VSD3ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1620         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ZMEDBG;

// Define the union U_VSD3MOSAIC
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 Reserved_1621           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3MOSAIC;
// Define the union U_VSD3ACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCTHD1;

// Define the union U_VSD3ACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_1623         : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCTHD2;

// Define the union U_VSD3ACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1624         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCLOWN;

// Define the union U_VSD3ACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1626         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCMEDN;

// Define the union U_VSD3ACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1628         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCHIGHN;

// Define the union U_VSD3ACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1630         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCMLN;

// Define the union U_VSD3ACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1632         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCMHN;

// Define the union U_VSD3ACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_1634         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACC3LOW;

// Define the union U_VSD3ACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_1636         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACC3MED;

// Define the union U_VSD3ACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_1637         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACC3HIGH;

// Define the union U_VSD3ACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_1638         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACC8MLOW;

// Define the union U_VSD3ACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_1639         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACC8MHIGH;

// Define the union U_VSD3ACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_1640         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3ACCTOTAL;

// Define the union U_VSD3IFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_1642         : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_1641         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3IFIRCOEF01;

// Define the union U_VSD3IFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_1645         : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_1644         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3IFIRCOEF23;

// Define the union U_VSD3IFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_1647         : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_1646         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3IFIRCOEF45;

// Define the union U_VSD3IFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_1649         : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_1648         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3IFIRCOEF67;

// Define the union U_VSD3P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1650         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P0RESO;

// Define the union U_VSD3P0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P0LADDR;
// Define the union U_VSD3P0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P0CADDR;
// Define the union U_VSD3P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P0STRIDE;

// Define the union U_VSD3P0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1652         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P0VFPOS;

// Define the union U_VSD3P0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1653         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P0VLPOS;

// Define the union U_VSD3P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1654         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P1RESO;

// Define the union U_VSD3P1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P1LADDR;
// Define the union U_VSD3P1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P1CADDR;
// Define the union U_VSD3P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P1STRIDE;

// Define the union U_VSD3P1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1656         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P1VFPOS;

// Define the union U_VSD3P1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1657         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P1VLPOS;

// Define the union U_VSD3P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1658         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P2RESO;

// Define the union U_VSD3P2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P2LADDR;
// Define the union U_VSD3P2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P2CADDR;
// Define the union U_VSD3P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P2STRIDE;

// Define the union U_VSD3P2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1660         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P2VFPOS;

// Define the union U_VSD3P2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1661         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P2VLPOS;

// Define the union U_VSD3P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1662         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P3RESO;

// Define the union U_VSD3P3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P3LADDR;
// Define the union U_VSD3P3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P3CADDR;
// Define the union U_VSD3P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P3STRIDE;

// Define the union U_VSD3P3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1664         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P3VFPOS;

// Define the union U_VSD3P3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1665         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P3VLPOS;

// Define the union U_VSD3P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1666         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P4RESO;

// Define the union U_VSD3P4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P4LADDR;
// Define the union U_VSD3P4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P4CADDR;
// Define the union U_VSD3P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P4STRIDE;

// Define the union U_VSD3P4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1668         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P4VFPOS;

// Define the union U_VSD3P4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1669         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P4VLPOS;

// Define the union U_VSD3P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1670         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P5RESO;

// Define the union U_VSD3P5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P5LADDR;
// Define the union U_VSD3P5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P5CADDR;
// Define the union U_VSD3P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P5STRIDE;

// Define the union U_VSD3P5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1672         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P5VFPOS;

// Define the union U_VSD3P5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1673         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P5VLPOS;

// Define the union U_VSD3P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1674         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P6RESO;

// Define the union U_VSD3P6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P6LADDR;
// Define the union U_VSD3P6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P6CADDR;
// Define the union U_VSD3P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P6STRIDE;

// Define the union U_VSD3P6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1676         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P6VFPOS;

// Define the union U_VSD3P6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1677         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P6VLPOS;

// Define the union U_VSD3P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1678         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P7RESO;

// Define the union U_VSD3P7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P7LADDR;
// Define the union U_VSD3P7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P7CADDR;
// Define the union U_VSD3P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P7STRIDE;

// Define the union U_VSD3P7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1680         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P7VFPOS;

// Define the union U_VSD3P7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1681         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P7VLPOS;

// Define the union U_VSD3P8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1682         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P8RESO;

// Define the union U_VSD3P8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P8LADDR;
// Define the union U_VSD3P8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P8CADDR;
// Define the union U_VSD3P8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P8STRIDE;

// Define the union U_VSD3P8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1684         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P8VFPOS;

// Define the union U_VSD3P8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1685         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P8VLPOS;

// Define the union U_VSD3P9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1686         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P9RESO;

// Define the union U_VSD3P9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P9LADDR;
// Define the union U_VSD3P9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P9CADDR;
// Define the union U_VSD3P9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P9STRIDE;

// Define the union U_VSD3P9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1688         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P9VFPOS;

// Define the union U_VSD3P9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1689         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P9VLPOS;

// Define the union U_VSD3P10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1690         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P10RESO;

// Define the union U_VSD3P10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P10LADDR;
// Define the union U_VSD3P10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P10CADDR;
// Define the union U_VSD3P10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P10STRIDE;

// Define the union U_VSD3P10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1692         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P10VFPOS;

// Define the union U_VSD3P10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1693         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P10VLPOS;

// Define the union U_VSD3P11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1694         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P11RESO;

// Define the union U_VSD3P11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P11LADDR;
// Define the union U_VSD3P11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P11CADDR;
// Define the union U_VSD3P11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P11STRIDE;

// Define the union U_VSD3P11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1696         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P11VFPOS;

// Define the union U_VSD3P11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1697         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P11VLPOS;

// Define the union U_VSD3P12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1698         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P12RESO;

// Define the union U_VSD3P12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P12LADDR;
// Define the union U_VSD3P12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P12CADDR;
// Define the union U_VSD3P12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P12STRIDE;

// Define the union U_VSD3P12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1700         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P12VFPOS;

// Define the union U_VSD3P12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1701         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P12VLPOS;

// Define the union U_VSD3P13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1702         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P13RESO;

// Define the union U_VSD3P13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P13LADDR;
// Define the union U_VSD3P13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P13CADDR;
// Define the union U_VSD3P13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P13STRIDE;

// Define the union U_VSD3P13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1704         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P13VFPOS;

// Define the union U_VSD3P13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1705         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P13VLPOS;

// Define the union U_VSD3P14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1706         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P14RESO;

// Define the union U_VSD3P14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P14LADDR;
// Define the union U_VSD3P14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P14CADDR;
// Define the union U_VSD3P14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P14STRIDE;

// Define the union U_VSD3P14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1708         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P14VFPOS;

// Define the union U_VSD3P14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1709         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P14VLPOS;

// Define the union U_VSD3P15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1710         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P15RESO;

// Define the union U_VSD3P15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P15LADDR;
// Define the union U_VSD3P15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD3P15CADDR;
// Define the union U_VSD3P15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P15STRIDE;

// Define the union U_VSD3P15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1712         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P15VFPOS;

// Define the union U_VSD3P15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1713         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD3P15VLPOS;

// Define the union U_VSD316REGIONEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    Reserved_1714         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD316REGIONEN;

// Define the union U_VSD4CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_1718         : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    vup_mode              : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1717         : 11  ; // [30..20]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CTRL;

// Define the union U_VSD4UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1720         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4UPD;

// Define the union U_VSD4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4CADDR;
// Define the union U_VSD4CCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4CCADDR;
// Define the union U_VSD4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4STRIDE;

// Define the union U_VSD4IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1723         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4IRESO;

// Define the union U_VSD4LKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_1724         : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4LKEY;

// Define the union U_VSD4CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_1726         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CBMPARA;

// Define the union U_VSD4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1727         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4DFPOS;

// Define the union U_VSD4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1729         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4DLPOS;

// Define the union U_VSD4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1730         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4VFPOS;

// Define the union U_VSD4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1731         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4VLPOS;

// Define the union U_VSD4BK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4BK;

// Define the union U_VSD4CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1732         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCIDC;

// Define the union U_VSD4CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_1734         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCODC;

// Define the union U_VSD4CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_1736         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_1735         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCP0;

// Define the union U_VSD4CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_1738         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_1737         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCP1;

// Define the union U_VSD4CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_1740         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_1739         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCP2;

// Define the union U_VSD4CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_1742         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_1741         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCP3;

// Define the union U_VSD4CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_1743         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4CSCP4;

// Define the union U_VSD4ACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM0;

// Define the union U_VSD4ACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_1745         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM1;

// Define the union U_VSD4ACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1746         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM2;

// Define the union U_VSD4ACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1747         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM3;

// Define the union U_VSD4ACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1748         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM4;

// Define the union U_VSD4ACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1749         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM5;

// Define the union U_VSD4ACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1750         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM6;

// Define the union U_VSD4ACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1751         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACM7;

// Define the union U_VSD4HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1754         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1753         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1752         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4HSP;

// Define the union U_VSD4HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1755         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4HLOFFSET;

// Define the union U_VSD4HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1756         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4HCOFFSET;

// Define the union U_VSD4VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1757         : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4VSP;

// Define the union U_VSD4VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1759         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4VSR;

// Define the union U_VSD4VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4VOFFSET;

// Define the union U_VSD4ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1760         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ZMEORESO;

// Define the union U_VSD4ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1761         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ZMEIRESO;

// Define the union U_VSD4ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1762         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ZMEDBG;

// Define the union U_VSD4MOSAIC
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 Reserved_1763           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4MOSAIC;
// Define the union U_VSD4ACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCTHD1;

// Define the union U_VSD4ACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_1765         : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCTHD2;

// Define the union U_VSD4ACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1766         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCLOWN;

// Define the union U_VSD4ACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1768         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCMEDN;

// Define the union U_VSD4ACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1770         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCHIGHN;

// Define the union U_VSD4ACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1772         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCMLN;

// Define the union U_VSD4ACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1774         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCMHN;

// Define the union U_VSD4ACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_1776         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACC3LOW;

// Define the union U_VSD4ACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_1778         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACC3MED;

// Define the union U_VSD4ACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_1779         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACC3HIGH;

// Define the union U_VSD4ACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_1780         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACC8MLOW;

// Define the union U_VSD4ACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_1781         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACC8MHIGH;

// Define the union U_VSD4ACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_1782         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4ACCTOTAL;

// Define the union U_VSD4IFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_1784         : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_1783         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4IFIRCOEF01;

// Define the union U_VSD4IFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_1787         : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_1786         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4IFIRCOEF23;

// Define the union U_VSD4IFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_1789         : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_1788         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4IFIRCOEF45;

// Define the union U_VSD4IFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_1791         : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_1790         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4IFIRCOEF67;

// Define the union U_VSD4P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1792         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P0RESO;

// Define the union U_VSD4P0LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P0LADDR;
// Define the union U_VSD4P0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P0CADDR;
// Define the union U_VSD4P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P0STRIDE;

// Define the union U_VSD4P0VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1794         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P0VFPOS;

// Define the union U_VSD4P0VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1795         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P0VLPOS;

// Define the union U_VSD4P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1796         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P1RESO;

// Define the union U_VSD4P1LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P1LADDR;
// Define the union U_VSD4P1CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P1CADDR;
// Define the union U_VSD4P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P1STRIDE;

// Define the union U_VSD4P1VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1798         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P1VFPOS;

// Define the union U_VSD4P1VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1799         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P1VLPOS;

// Define the union U_VSD4P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1800         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P2RESO;

// Define the union U_VSD4P2LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P2LADDR;
// Define the union U_VSD4P2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P2CADDR;
// Define the union U_VSD4P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P2STRIDE;

// Define the union U_VSD4P2VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1802         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P2VFPOS;

// Define the union U_VSD4P2VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1803         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P2VLPOS;

// Define the union U_VSD4P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1804         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P3RESO;

// Define the union U_VSD4P3LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P3LADDR;
// Define the union U_VSD4P3CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P3CADDR;
// Define the union U_VSD4P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P3STRIDE;

// Define the union U_VSD4P3VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1806         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P3VFPOS;

// Define the union U_VSD4P3VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1807         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P3VLPOS;

// Define the union U_VSD4P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1808         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P4RESO;

// Define the union U_VSD4P4LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P4LADDR;
// Define the union U_VSD4P4CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P4CADDR;
// Define the union U_VSD4P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P4STRIDE;

// Define the union U_VSD4P4VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1810         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P4VFPOS;

// Define the union U_VSD4P4VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1811         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P4VLPOS;

// Define the union U_VSD4P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1812         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P5RESO;

// Define the union U_VSD4P5LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P5LADDR;
// Define the union U_VSD4P5CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P5CADDR;
// Define the union U_VSD4P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P5STRIDE;

// Define the union U_VSD4P5VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1814         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P5VFPOS;

// Define the union U_VSD4P5VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1815         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P5VLPOS;

// Define the union U_VSD4P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1816         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P6RESO;

// Define the union U_VSD4P6LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P6LADDR;
// Define the union U_VSD4P6CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P6CADDR;
// Define the union U_VSD4P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P6STRIDE;

// Define the union U_VSD4P6VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1818         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P6VFPOS;

// Define the union U_VSD4P6VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1819         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P6VLPOS;

// Define the union U_VSD4P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1820         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P7RESO;

// Define the union U_VSD4P7LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P7LADDR;
// Define the union U_VSD4P7CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P7CADDR;
// Define the union U_VSD4P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P7STRIDE;

// Define the union U_VSD4P7VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1822         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P7VFPOS;

// Define the union U_VSD4P7VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1823         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P7VLPOS;

// Define the union U_VSD4P8RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1824         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P8RESO;

// Define the union U_VSD4P8LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P8LADDR;
// Define the union U_VSD4P8CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P8CADDR;
// Define the union U_VSD4P8STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P8STRIDE;

// Define the union U_VSD4P8VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1826         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P8VFPOS;

// Define the union U_VSD4P8VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1827         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P8VLPOS;

// Define the union U_VSD4P9RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1828         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P9RESO;

// Define the union U_VSD4P9LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P9LADDR;
// Define the union U_VSD4P9CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P9CADDR;
// Define the union U_VSD4P9STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P9STRIDE;

// Define the union U_VSD4P9VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1830         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P9VFPOS;

// Define the union U_VSD4P9VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1831         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P9VLPOS;

// Define the union U_VSD4P10RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1832         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P10RESO;

// Define the union U_VSD4P10LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P10LADDR;
// Define the union U_VSD4P10CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P10CADDR;
// Define the union U_VSD4P10STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P10STRIDE;

// Define the union U_VSD4P10VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1834         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P10VFPOS;

// Define the union U_VSD4P10VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1835         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P10VLPOS;

// Define the union U_VSD4P11RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1836         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P11RESO;

// Define the union U_VSD4P11LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P11LADDR;
// Define the union U_VSD4P11CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P11CADDR;
// Define the union U_VSD4P11STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P11STRIDE;

// Define the union U_VSD4P11VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1838         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P11VFPOS;

// Define the union U_VSD4P11VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1839         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P11VLPOS;

// Define the union U_VSD4P12RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1840         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P12RESO;

// Define the union U_VSD4P12LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P12LADDR;
// Define the union U_VSD4P12CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P12CADDR;
// Define the union U_VSD4P12STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P12STRIDE;

// Define the union U_VSD4P12VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1842         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P12VFPOS;

// Define the union U_VSD4P12VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1843         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P12VLPOS;

// Define the union U_VSD4P13RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1844         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P13RESO;

// Define the union U_VSD4P13LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P13LADDR;
// Define the union U_VSD4P13CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P13CADDR;
// Define the union U_VSD4P13STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P13STRIDE;

// Define the union U_VSD4P13VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1846         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P13VFPOS;

// Define the union U_VSD4P13VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1847         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P13VLPOS;

// Define the union U_VSD4P14RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1848         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P14RESO;

// Define the union U_VSD4P14LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P14LADDR;
// Define the union U_VSD4P14CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P14CADDR;
// Define the union U_VSD4P14STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P14STRIDE;

// Define the union U_VSD4P14VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1850         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P14VFPOS;

// Define the union U_VSD4P14VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1851         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P14VLPOS;

// Define the union U_VSD4P15RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_1852         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P15RESO;

// Define the union U_VSD4P15LADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P15LADDR;
// Define the union U_VSD4P15CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VSD4P15CADDR;
// Define the union U_VSD4P15STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P15STRIDE;

// Define the union U_VSD4P15VFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1854         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P15VFPOS;

// Define the union U_VSD4P15VLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1855         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD4P15VLPOS;

// Define the union U_VSD416REGIONEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    Reserved_1856         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VSD416REGIONEN;

// Define the union U_WBC0CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    req_interval          : 10  ; // [9..0]
        HI_U32    Reserved_1859         : 2   ; // [11..10]
        HI_U32    wbc0_dft              : 2   ; // [13..12]
        HI_U32    Reserved_1858         : 17  ; // [30..14]
        HI_U32    wbc0_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0CTRL;

// Define the union U_WBC0UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1861         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0UPD;

// Define the union U_WBC0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbcaddr                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_WBC0ADDR;
// Define the union U_WBC0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc0stride            : 16  ; // [15..0]
        HI_U32    Reserved_1862         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0STRIDE;

// Define the union U_WBC0ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1863         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0ORESO;

// Define the union U_WBC0CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbccaddr                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_WBC0CADDR;
// Define the union U_WBC0CSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc0cstride           : 16  ; // [15..0]
        HI_U32    Reserved_1865         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0CSTRIDE;

// Define the union U_WBC0HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1868         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1867         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1866         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0HSP;

// Define the union U_WBC0HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1870         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0HLOFFSET;

// Define the union U_WBC0HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1871         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0HCOFFSET;

// Define the union U_WBC0VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1872         : 22  ; // [21..0]
        HI_U32    vsc_out_420           : 1   ; // [22]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0VSP;

// Define the union U_WBC0VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1874         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0VSR;

// Define the union U_WBC0VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0VOFFSET;

// Define the union U_WBC0ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1875         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0ZMEORESO;

// Define the union U_WBC0ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1876         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0ZMEIRESO;

// Define the union U_WBC0ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1877         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC0ZMEDBG;

// Define the union U_WBC2CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    req_interval          : 10  ; // [9..0]
        HI_U32    Reserved_1879         : 2   ; // [11..10]
        HI_U32    wbc0_dft              : 2   ; // [13..12]
        HI_U32    Reserved_1878         : 17  ; // [30..14]
        HI_U32    wbc0_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2CTRL;

// Define the union U_WBC2UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1881         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2UPD;

// Define the union U_WBC2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbcaddr                 : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_WBC2ADDR;
// Define the union U_WBC2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc0stride            : 16  ; // [15..0]
        HI_U32    Reserved_1882         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2STRIDE;

// Define the union U_WBC2ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1883         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2ORESO;

// Define the union U_WBC2CADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 wbccaddr                : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_WBC2CADDR;
// Define the union U_WBC2CSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    wbc0cstride           : 16  ; // [15..0]
        HI_U32    Reserved_1885         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2CSTRIDE;

// Define the union U_WBC2HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1888         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1887         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1886         : 5   ; // [29..25]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2HSP;

// Define the union U_WBC2HLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1890         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2HLOFFSET;

// Define the union U_WBC2HCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1891         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2HCOFFSET;

// Define the union U_WBC2VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1892         : 22  ; // [21..0]
        HI_U32    vsc_out_420           : 1   ; // [22]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    Reserved_vchmid_en    : 2   ; // [29..28]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2VSP;

// Define the union U_WBC2VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1894         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2VSR;

// Define the union U_WBC2VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2VOFFSET;

// Define the union U_WBC2ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1895         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2ZMEORESO;

// Define the union U_WBC2ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1896         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2ZMEIRESO;

// Define the union U_WBC2ZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1897         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_WBC2ZMEDBG;

// Define the union U_VADCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 4   ; // [3..0]
        HI_U32    time_out              : 4   ; // [7..4]
        HI_U32    Reserved_1901         : 4   ; // [11..8]
        HI_U32    chm_rmode             : 2   ; // [13..12]
        HI_U32    lm_rmode              : 2   ; // [15..14]
        HI_U32    bfield_first          : 1   ; // [16]
        HI_U32    Reserved_1900         : 1   ; // [17]
        HI_U32    ifir_mode             : 2   ; // [19..18]
        HI_U32    Reserved_1899         : 8   ; // [27..20]
        HI_U32    mute_en               : 1   ; // [28]
        HI_U32    Reserved_1898         : 2   ; // [30..29]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCTRL;

// Define the union U_VADUPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1903         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADUPD;

// Define the union U_VADCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_caddr           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VADCADDR;
// Define the union U_VADCCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_ccaddr          : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VADCCADDR;
// Define the union U_VADSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    surface_cstride       : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADSTRIDE;

// Define the union U_VADIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1906         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADIRESO;

// Define the union U_VADLKEY
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    luma_low              : 8   ; // [7..0]
        HI_U32    luma_high             : 8   ; // [15..8]
        HI_U32    luma_mask             : 8   ; // [23..16]
        HI_U32    Reserved_1907         : 7   ; // [30..24]
        HI_U32    luma_key_en           : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADLKEY;

// Define the union U_VADCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    Reserved_1909         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCBMPARA;

// Define the union U_VADDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1910         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADDFPOS;

// Define the union U_VADDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1912         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADDLPOS;

// Define the union U_VADVFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xfpos           : 12  ; // [11..0]
        HI_U32    video_yfpos           : 12  ; // [23..12]
        HI_U32    Reserved_1913         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADVFPOS;

// Define the union U_VADVLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    video_xlpos           : 12  ; // [11..0]
        HI_U32    video_ylpos           : 12  ; // [23..12]
        HI_U32    Reserved_1914         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADVLPOS;

// Define the union U_VADBK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbk_cr                : 8   ; // [7..0]
        HI_U32    vbk_cb                : 8   ; // [15..8]
        HI_U32    vbk_y                 : 8   ; // [23..16]
        HI_U32    vbk_alpha             : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADBK;

// Define the union U_VADCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1915         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCIDC;

// Define the union U_VADCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_1917         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCODC;

// Define the union U_VADCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_1919         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_1918         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCP0;

// Define the union U_VADCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_1921         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_1920         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCP1;

// Define the union U_VADCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_1923         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_1922         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCP2;

// Define the union U_VADCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_1925         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_1924         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCP3;

// Define the union U_VADCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_1926         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADCSCP4;

// Define the union U_VADACM0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    acm0_en               : 1   ; // [28]
        HI_U32    acm1_en               : 1   ; // [29]
        HI_U32    acm2_en               : 1   ; // [30]
        HI_U32    acm3_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM0;

// Define the union U_VADACM1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    acm_test_en           : 1   ; // [20]
        HI_U32    Reserved_1928         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM1;

// Define the union U_VADACM2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1929         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM2;

// Define the union U_VADACM3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1930         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM3;

// Define the union U_VADACM4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1931         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM4;

// Define the union U_VADACM5
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1932         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM5;

// Define the union U_VADACM6
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_u_off           : 5   ; // [4..0]
        HI_U32    acm_b_u_off           : 5   ; // [9..5]
        HI_U32    acm_c_u_off           : 5   ; // [14..10]
        HI_U32    acm_d_u_off           : 5   ; // [19..15]
        HI_U32    acm_fir_blk           : 4   ; // [23..20]
        HI_U32    acm_sec_blk           : 4   ; // [27..24]
        HI_U32    Reserved_1933         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM6;

// Define the union U_VADACM7
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acm_a_v_off           : 5   ; // [4..0]
        HI_U32    acm_b_v_off           : 5   ; // [9..5]
        HI_U32    acm_c_v_off           : 5   ; // [14..10]
        HI_U32    acm_d_v_off           : 5   ; // [19..15]
        HI_U32    Reserved_1934         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACM7;

// Define the union U_VADHSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1937         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1936         : 3   ; // [22..20]
        HI_U32    hchfir_en             : 1   ; // [23]
        HI_U32    hlfir_en              : 1   ; // [24]
        HI_U32    Reserved_1935         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hchmsc_en             : 1   ; // [30]
        HI_U32    hlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADHSP;

// Define the union U_VADHLOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_loffset           : 17  ; // [16..0]
        HI_U32    Reserved_1938         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADHLOFFSET;

// Define the union U_VADHCOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 17  ; // [16..0]
        HI_U32    Reserved_1939         : 15  ; // [31..17]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADHCOFFSET;

// Define the union U_VADVSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1940         : 23  ; // [22..0]
        HI_U32    vchfir_en             : 1   ; // [23]
        HI_U32    vlfir_en              : 1   ; // [24]
        HI_U32    chroma_type           : 1   ; // [25]
        HI_U32    vsc_chroma_tap        : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vchmsc_en             : 1   ; // [30]
        HI_U32    vlmsc_en              : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADVSP;

// Define the union U_VADVSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1942         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADVSR;

// Define the union U_VADVOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vchroma_offset        : 16  ; // [15..0]
        HI_U32    vluma_offset          : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADVOFFSET;

// Define the union U_VADZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1943         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADZMEORESO;

// Define the union U_VADZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1944         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADZMEIRESO;

// Define the union U_VADZMEDBG
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    need_rand_range       : 8   ; // [7..0]
        HI_U32    rdy_rand_range        : 8   ; // [15..8]
        HI_U32    need_mode             : 1   ; // [16]
        HI_U32    rdy_mode              : 1   ; // [17]
        HI_U32    Reserved_1945         : 14  ; // [31..18]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADZMEDBG;

// Define the union U_VADMOSAIC
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 Reserved_1946           : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_VADMOSAIC;
// Define the union U_VADACCTHD1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_low               : 10  ; // [9..0]
        HI_U32    thd_high              : 10  ; // [19..10]
        HI_U32    thd_med_low           : 10  ; // [29..20]
        HI_U32    acc_mode              : 1   ; // [30]
        HI_U32    acc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCTHD1;

// Define the union U_VADACCTHD2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    thd_med_high          : 10  ; // [9..0]
        HI_U32    acc_multiple          : 8   ; // [17..10]
        HI_U32    acc_rst               : 1   ; // [18]
        HI_U32    Reserved_1948         : 13  ; // [31..19]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCTHD2;

// Define the union U_VADACCLOWN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1949         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCLOWN;

// Define the union U_VADACCMEDN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1951         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCMEDN;

// Define the union U_VADACCHIGHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1953         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCHIGHN;

// Define the union U_VADACCMLN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1955         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCMLN;

// Define the union U_VADACCMHN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    table_data1n          : 10  ; // [9..0]
        HI_U32    table_data2n          : 10  ; // [19..10]
        HI_U32    table_data3n          : 10  ; // [29..20]
        HI_U32    Reserved_1957         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCMHN;

// Define the union U_VADACC3LOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_low              : 21  ; // [20..0]
        HI_U32    Reserved_1959         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACC3LOW;

// Define the union U_VADACC3MED
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_med              : 21  ; // [20..0]
        HI_U32    Reserved_1961         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACC3MED;

// Define the union U_VADACC3HIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt3_high             : 21  ; // [20..0]
        HI_U32    Reserved_1962         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACC3HIGH;

// Define the union U_VADACC8MLOW
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_low          : 21  ; // [20..0]
        HI_U32    Reserved_1963         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACC8MLOW;

// Define the union U_VADACC8MHIGH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cnt8_med_high         : 21  ; // [20..0]
        HI_U32    Reserved_1964         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACC8MHIGH;

// Define the union U_VADACCTOTAL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    acc_pix_total         : 21  ; // [20..0]
        HI_U32    Reserved_1965         : 11  ; // [31..21]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADACCTOTAL;

// Define the union U_VADIFIRCOEF01
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef0                 : 10  ; // [9..0]
        HI_U32    Reserved_1967         : 6   ; // [15..10]
        HI_U32    coef1                 : 10  ; // [25..16]
        HI_U32    Reserved_1966         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADIFIRCOEF01;

// Define the union U_VADIFIRCOEF23
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef2                 : 10  ; // [9..0]
        HI_U32    Reserved_1970         : 6   ; // [15..10]
        HI_U32    coef3                 : 10  ; // [25..16]
        HI_U32    Reserved_1969         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADIFIRCOEF23;

// Define the union U_VADIFIRCOEF45
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef4                 : 10  ; // [9..0]
        HI_U32    Reserved_1972         : 6   ; // [15..10]
        HI_U32    coef5                 : 10  ; // [25..16]
        HI_U32    Reserved_1971         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADIFIRCOEF45;

// Define the union U_VADIFIRCOEF67
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    coef6                 : 10  ; // [9..0]
        HI_U32    Reserved_1974         : 6   ; // [15..10]
        HI_U32    coef7                 : 10  ; // [25..16]
        HI_U32    Reserved_1973         : 6   ; // [31..26]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_VADIFIRCOEF67;

// Define the union U_G0CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_1976         : 14  ; // [23..10]
        HI_U32    dcmp_Inter            : 1   ; // [24]
        HI_U32    dcmp_mode             : 1   ; // [25]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_1975         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CTRL;

// Define the union U_G0UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_1978         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0UPD;

// Define the union U_G0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0ADDR;
// Define the union U_G0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_1979         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0STRIDE;

// Define the union U_G0CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_1981         : 1   ; // [9]
        HI_U32    vedge_p               : 1   ; // [10]
        HI_U32    hedge_p               : 1   ; // [11]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    premult_en            : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_1980         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CBMPARA;

// Define the union U_G0CKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CKEYMAX;

// Define the union U_G0CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CKEYMIN;

// Define the union U_G0CMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_1982         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CMASK;

// Define the union U_G0IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1983         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0IRESO;

// Define the union U_G0ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1984         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0ORESO;

// Define the union U_G0SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_1985         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0SFPOS;

// Define the union U_G0DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_1986         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0DFPOS;

// Define the union U_G0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_1987         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0DLPOS;

// Define the union U_G0HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_1990         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_1989         : 3   ; // [22..20]
        HI_U32    hafir_en              : 1   ; // [23]
        HI_U32    hfir_en               : 1   ; // [24]
        HI_U32    Reserved_1988         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hamid_en              : 1   ; // [30]
        HI_U32    hsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0HSP;

// Define the union U_G0HOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 16  ; // [15..0]
        HI_U32    hor_loffset           : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0HOFFSET;

// Define the union U_G0VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_1994         : 23  ; // [22..0]
        HI_U32    vafir_en              : 1   ; // [23]
        HI_U32    vfir_en               : 1   ; // [24]
        HI_U32    Reserved_1993         : 1   ; // [25]
        HI_U32    Reserved_1992         : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vamid_en              : 1   ; // [30]
        HI_U32    vsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0VSP;

// Define the union U_G0VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_1995         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0VSR;

// Define the union U_G0VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbtm_offset           : 16  ; // [15..0]
        HI_U32    vtp_offset            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0VOFFSET;

// Define the union U_G0ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_1996         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0ZMEORESO;

// Define the union U_G0ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_1997         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0ZMEIRESO;

// Define the union U_G0CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc2               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc0               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_1998         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCIDC;

// Define the union U_G0CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc2               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc0               : 9   ; // [26..18]
        HI_U32    Reserved_2000         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCODC;

// Define the union U_G0CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2002         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2001         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCP0;

// Define the union U_G0CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2004         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2003         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCP1;

// Define the union U_G0CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2006         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2005         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCP2;

// Define the union U_G0CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2008         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2007         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCP3;

// Define the union U_G0CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2009         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0CSCP4;

// Define the union U_G0P0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P0ADDR;
// Define the union U_G0P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2011         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P0STRIDE;

// Define the union U_G0P0DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2012         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P0DFPOS;

// Define the union U_G0P0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2013         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P0DLPOS;

// Define the union U_G0P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2014         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P0RESO;

// Define the union U_G0P1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P1ADDR;
// Define the union U_G0P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2015         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P1STRIDE;

// Define the union U_G0P1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2016         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P1DFPOS;

// Define the union U_G0P1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2017         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P1DLPOS;

// Define the union U_G0P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2018         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P1RESO;

// Define the union U_G0P2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P2ADDR;
// Define the union U_G0P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2019         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P2STRIDE;

// Define the union U_G0P2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2020         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P2DFPOS;

// Define the union U_G0P2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2021         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P2DLPOS;

// Define the union U_G0P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2022         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P2RESO;

// Define the union U_G0P3ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P3ADDR;
// Define the union U_G0P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2023         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P3STRIDE;

// Define the union U_G0P3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2024         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P3DFPOS;

// Define the union U_G0P3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2025         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P3DLPOS;

// Define the union U_G0P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2026         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P3RESO;

// Define the union U_G0P4ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P4ADDR;
// Define the union U_G0P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2027         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P4STRIDE;

// Define the union U_G0P4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2028         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P4DFPOS;

// Define the union U_G0P4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2029         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P4DLPOS;

// Define the union U_G0P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2030         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P4RESO;

// Define the union U_G0P5ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P5ADDR;
// Define the union U_G0P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2031         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P5STRIDE;

// Define the union U_G0P5DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2032         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P5DFPOS;

// Define the union U_G0P5DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2033         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P5DLPOS;

// Define the union U_G0P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2034         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P5RESO;

// Define the union U_G0P6ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P6ADDR;
// Define the union U_G0P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2035         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P6STRIDE;

// Define the union U_G0P6DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2036         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P6DFPOS;

// Define the union U_G0P6DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2037         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P6DLPOS;

// Define the union U_G0P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2038         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P6RESO;

// Define the union U_G0P7ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0P7ADDR;
// Define the union U_G0P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2039         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P7STRIDE;

// Define the union U_G0P7DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2040         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P7DFPOS;

// Define the union U_G0P7DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2041         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P7DLPOS;

// Define the union U_G0P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2042         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0P7RESO;

// Define the union U_G08SLICEEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    Reserved_2043         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G08SLICEEN;

// Define the union U_G0DCMPMODE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2045         : 4   ; // [3..0]
        HI_U32    line_len_idx          : 2   ; // [5..4]
        HI_U32    line_type             : 2   ; // [7..6]
        HI_U32    Reserved_2044         : 23  ; // [30..8]
        HI_U32    dcmp_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0DCMPMODE;

// Define the union U_G0DCMPBANKWIDTH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_bankwidth        : 12  ; // [11..0]
        HI_U32    Reserved_2047         : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0DCMPBANKWIDTH;

// Define the union U_G0DCMPSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_stride           : 16  ; // [15..0]
        HI_U32    Reserved_2048         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G0DCMPSTRIDE;

// Define the union U_G0DCMPAADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_a             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0DCMPAADDR;
// Define the union U_G0DCMPRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_r             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0DCMPRADDR;
// Define the union U_G0DCMPGADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_g             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0DCMPGADDR;
// Define the union U_G0DCMPBADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_b             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G0DCMPBADDR;
// Define the union U_G1CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_2050         : 14  ; // [23..10]
        HI_U32    dcmp_inter            : 1   ; // [24]
        HI_U32    dcmp_mode             : 1   ; // [25]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_2049         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CTRL;

// Define the union U_G1UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_2052         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1UPD;

// Define the union U_G1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1ADDR;
// Define the union U_G1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2053         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1STRIDE;

// Define the union U_G1CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_2055         : 1   ; // [9]
        HI_U32    vedge_p               : 1   ; // [10]
        HI_U32    hedge_p               : 1   ; // [11]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    premult_en            : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_2054         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CBMPARA;

// Define the union U_G1CKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CKEYMAX;

// Define the union U_G1CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CKEYMIN;

// Define the union U_G1CMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_2056         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CMASK;

// Define the union U_G1IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2057         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1IRESO;

// Define the union U_G1ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2058         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1ORESO;

// Define the union U_G1SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_2059         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1SFPOS;

// Define the union U_G1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_2060         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1DFPOS;

// Define the union U_G1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_2061         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1DLPOS;

// Define the union U_G1HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_2064         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_2063         : 3   ; // [22..20]
        HI_U32    hafir_en              : 1   ; // [23]
        HI_U32    hfir_en               : 1   ; // [24]
        HI_U32    Reserved_2062         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hamid_en              : 1   ; // [30]
        HI_U32    hsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1HSP;

// Define the union U_G1HOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 16  ; // [15..0]
        HI_U32    hor_loffset           : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1HOFFSET;

// Define the union U_G1VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2068         : 23  ; // [22..0]
        HI_U32    vafir_en              : 1   ; // [23]
        HI_U32    vfir_en               : 1   ; // [24]
        HI_U32    Reserved_2067         : 1   ; // [25]
        HI_U32    Reserved_2066         : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vamid_en              : 1   ; // [30]
        HI_U32    vsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1VSP;

// Define the union U_G1VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_2069         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1VSR;

// Define the union U_G1VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbtm_offset           : 16  ; // [15..0]
        HI_U32    vtp_offset            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1VOFFSET;

// Define the union U_G1ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2070         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1ZMEORESO;

// Define the union U_G1ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2071         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1ZMEIRESO;

// Define the union U_G1CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2072         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCIDC;

// Define the union U_G1CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2074         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCODC;

// Define the union U_G1CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2076         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2075         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCP0;

// Define the union U_G1CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2078         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2077         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCP1;

// Define the union U_G1CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2080         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2079         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCP2;

// Define the union U_G1CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2082         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2081         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCP3;

// Define the union U_G1CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2083         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1CSCP4;

// Define the union U_G1P0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P0ADDR;
// Define the union U_G1P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2085         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P0STRIDE;

// Define the union U_G1P0DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2086         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P0DFPOS;

// Define the union U_G1P0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2087         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P0DLPOS;

// Define the union U_G1P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2088         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P0RESO;

// Define the union U_G1P1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P1ADDR;
// Define the union U_G1P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2089         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P1STRIDE;

// Define the union U_G1P1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2090         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P1DFPOS;

// Define the union U_G1P1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2091         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P1DLPOS;

// Define the union U_G1P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2092         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P1RESO;

// Define the union U_G1P2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P2ADDR;
// Define the union U_G1P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2093         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P2STRIDE;

// Define the union U_G1P2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2094         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P2DFPOS;

// Define the union U_G1P2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2095         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P2DLPOS;

// Define the union U_G1P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2096         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P2RESO;

// Define the union U_G1P3ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P3ADDR;
// Define the union U_G1P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2097         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P3STRIDE;

// Define the union U_G1P3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2098         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P3DFPOS;

// Define the union U_G1P3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2099         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P3DLPOS;

// Define the union U_G1P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2100         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P3RESO;

// Define the union U_G1P4ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P4ADDR;
// Define the union U_G1P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2101         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P4STRIDE;

// Define the union U_G1P4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2102         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P4DFPOS;

// Define the union U_G1P4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2103         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P4DLPOS;

// Define the union U_G1P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2104         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P4RESO;

// Define the union U_G1P5ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P5ADDR;
// Define the union U_G1P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2105         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P5STRIDE;

// Define the union U_G1P5DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2106         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P5DFPOS;

// Define the union U_G1P5DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2107         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P5DLPOS;

// Define the union U_G1P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2108         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P5RESO;

// Define the union U_G1P6ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P6ADDR;
// Define the union U_G1P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2109         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P6STRIDE;

// Define the union U_G1P6DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2110         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P6DFPOS;

// Define the union U_G1P6DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2111         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P6DLPOS;

// Define the union U_G1P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2112         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P6RESO;

// Define the union U_G1P7ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1P7ADDR;
// Define the union U_G1P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2113         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P7STRIDE;

// Define the union U_G1P7DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2114         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P7DFPOS;

// Define the union U_G1P7DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2115         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P7DLPOS;

// Define the union U_G1P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2116         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1P7RESO;

// Define the union U_G18SLICEEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    Reserved_2117         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G18SLICEEN;

// Define the union U_G1DCMPMODE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2119         : 4   ; // [3..0]
        HI_U32    line_len_idx          : 2   ; // [5..4]
        HI_U32    line_type             : 2   ; // [7..6]
        HI_U32    Reserved_2118         : 23  ; // [30..8]
        HI_U32    dcmp_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1DCMPMODE;

// Define the union U_G1DCMPBANKWIDTH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_bankwidth        : 12  ; // [11..0]
        HI_U32    Reserved_2121         : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1DCMPBANKWIDTH;

// Define the union U_G1DCMPSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_stride           : 16  ; // [15..0]
        HI_U32    Reserved_2122         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G1DCMPSTRIDE;

// Define the union U_G1DCMPAADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_a             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1DCMPAADDR;
// Define the union U_G1DCMPRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_r             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1DCMPRADDR;
// Define the union U_G1DCMPGADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_g             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1DCMPGADDR;
// Define the union U_G1DCMPBADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_b             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G1DCMPBADDR;
// Define the union U_G2CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_2124         : 14  ; // [23..10]
        HI_U32    dcmp_inter            : 1   ; // [24]
        HI_U32    dcmp_mode             : 1   ; // [25]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_2123         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CTRL;

// Define the union U_G2UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_2126         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2UPD;

// Define the union U_G2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2ADDR;
// Define the union U_G2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2127         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2STRIDE;

// Define the union U_G2CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_2129         : 1   ; // [9]
        HI_U32    vedge_p               : 1   ; // [10]
        HI_U32    hedge_p               : 1   ; // [11]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    premult_en            : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_2128         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CBMPARA;

// Define the union U_G2CKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CKEYMAX;

// Define the union U_G2CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CKEYMIN;

// Define the union U_G2CMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_2130         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CMASK;

// Define the union U_G2IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2131         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2IRESO;

// Define the union U_G2ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2132         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2ORESO;

// Define the union U_G2SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_2133         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2SFPOS;

// Define the union U_G2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_2134         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2DFPOS;

// Define the union U_G2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_2135         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2DLPOS;

// Define the union U_G2HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_2138         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_2137         : 3   ; // [22..20]
        HI_U32    hafir_en              : 1   ; // [23]
        HI_U32    hfir_en               : 1   ; // [24]
        HI_U32    Reserved_2136         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hamid_en              : 1   ; // [30]
        HI_U32    hsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2HSP;

// Define the union U_G2HOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 16  ; // [15..0]
        HI_U32    hor_loffset           : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2HOFFSET;

// Define the union U_G2VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2142         : 23  ; // [22..0]
        HI_U32    vafir_en              : 1   ; // [23]
        HI_U32    vfir_en               : 1   ; // [24]
        HI_U32    Reserved_2141         : 1   ; // [25]
        HI_U32    Reserved_2140         : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vamid_en              : 1   ; // [30]
        HI_U32    vsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2VSP;

// Define the union U_G2VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_2143         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2VSR;

// Define the union U_G2VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbtm_offset           : 16  ; // [15..0]
        HI_U32    vtp_offset            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2VOFFSET;

// Define the union U_G2ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2144         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2ZMEORESO;

// Define the union U_G2ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2145         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2ZMEIRESO;

// Define the union U_G2CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2146         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCIDC;

// Define the union U_G2CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2148         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCODC;

// Define the union U_G2CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2150         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2149         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCP0;

// Define the union U_G2CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2152         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2151         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCP1;

// Define the union U_G2CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2154         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2153         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCP2;

// Define the union U_G2CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2156         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2155         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCP3;

// Define the union U_G2CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2157         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2CSCP4;

// Define the union U_G2P0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P0ADDR;
// Define the union U_G2P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2159         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P0STRIDE;

// Define the union U_G2P0DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2160         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P0DFPOS;

// Define the union U_G2P0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2161         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P0DLPOS;

// Define the union U_G2P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2162         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P0RESO;

// Define the union U_G2P1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P1ADDR;
// Define the union U_G2P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2163         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P1STRIDE;

// Define the union U_G2P1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2164         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P1DFPOS;

// Define the union U_G2P1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2165         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P1DLPOS;

// Define the union U_G2P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2166         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P1RESO;

// Define the union U_G2P2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P2ADDR;
// Define the union U_G2P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2167         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P2STRIDE;

// Define the union U_G2P2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2168         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P2DFPOS;

// Define the union U_G2P2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2169         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P2DLPOS;

// Define the union U_G2P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2170         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P2RESO;

// Define the union U_G2P3ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P3ADDR;
// Define the union U_G2P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2171         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P3STRIDE;

// Define the union U_G2P3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2172         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P3DFPOS;

// Define the union U_G2P3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2173         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P3DLPOS;

// Define the union U_G2P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2174         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P3RESO;

// Define the union U_G2P4ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P4ADDR;
// Define the union U_G2P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2175         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P4STRIDE;

// Define the union U_G2P4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2176         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P4DFPOS;

// Define the union U_G2P4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2177         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P4DLPOS;

// Define the union U_G2P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2178         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P4RESO;

// Define the union U_G2P5ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P5ADDR;
// Define the union U_G2P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2179         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P5STRIDE;

// Define the union U_G2P5DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2180         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P5DFPOS;

// Define the union U_G2P5DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2181         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P5DLPOS;

// Define the union U_G2P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2182         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P5RESO;

// Define the union U_G2P6ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P6ADDR;
// Define the union U_G2P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2183         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P6STRIDE;

// Define the union U_G2P6DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2184         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P6DFPOS;

// Define the union U_G2P6DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2185         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P6DLPOS;

// Define the union U_G2P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2186         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P6RESO;

// Define the union U_G2P7ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2P7ADDR;
// Define the union U_G2P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2187         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P7STRIDE;

// Define the union U_G2P7DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2188         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P7DFPOS;

// Define the union U_G2P7DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2189         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P7DLPOS;

// Define the union U_G2P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2190         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2P7RESO;

// Define the union U_G28SLICEEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    Reserved_2191         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G28SLICEEN;

// Define the union U_G2DCMPMODE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2193         : 4   ; // [3..0]
        HI_U32    line_len_idx          : 2   ; // [5..4]
        HI_U32    line_type             : 2   ; // [7..6]
        HI_U32    Reserved_2192         : 23  ; // [30..8]
        HI_U32    dcmp_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2DCMPMODE;

// Define the union U_G2DCMPBANKWIDTH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_bankwidth        : 12  ; // [11..0]
        HI_U32    Reserved_2195         : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2DCMPBANKWIDTH;

// Define the union U_G2DCMPSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_stride           : 16  ; // [15..0]
        HI_U32    Reserved_2196         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G2DCMPSTRIDE;

// Define the union U_G2DCMPAADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_a             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2DCMPAADDR;
// Define the union U_G2DCMPRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_r             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2DCMPRADDR;
// Define the union U_G2DCMPGADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_g             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2DCMPGADDR;
// Define the union U_G2DCMPBADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_b             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G2DCMPBADDR;
// Define the union U_G3CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_2198         : 14  ; // [23..10]
        HI_U32    dcmp_inter            : 1   ; // [24]
        HI_U32    dcmp_mode             : 1   ; // [25]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_2197         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CTRL;

// Define the union U_G3UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_2200         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3UPD;

// Define the union U_G3ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3ADDR;
// Define the union U_G3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2201         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3STRIDE;

// Define the union U_G3CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_2203         : 1   ; // [9]
        HI_U32    vedge_p               : 1   ; // [10]
        HI_U32    hedge_p               : 1   ; // [11]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    premult_en            : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_2202         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CBMPARA;

// Define the union U_G3CKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CKEYMAX;

// Define the union U_G3CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CKEYMIN;

// Define the union U_G3CMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_2204         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CMASK;

// Define the union U_G3IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2205         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3IRESO;

// Define the union U_G3ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2206         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3ORESO;

// Define the union U_G3SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_2207         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3SFPOS;

// Define the union U_G3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_2208         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3DFPOS;

// Define the union U_G3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_2209         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3DLPOS;

// Define the union U_G3HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_2212         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_2211         : 3   ; // [22..20]
        HI_U32    hafir_en              : 1   ; // [23]
        HI_U32    hfir_en               : 1   ; // [24]
        HI_U32    Reserved_2210         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hamid_en              : 1   ; // [30]
        HI_U32    hsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3HSP;

// Define the union U_G3HOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 16  ; // [15..0]
        HI_U32    hor_loffset           : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3HOFFSET;

// Define the union U_G3VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2216         : 23  ; // [22..0]
        HI_U32    vafir_en              : 1   ; // [23]
        HI_U32    vfir_en               : 1   ; // [24]
        HI_U32    Reserved_2215         : 1   ; // [25]
        HI_U32    Reserved_2214         : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vamid_en              : 1   ; // [30]
        HI_U32    vsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3VSP;

// Define the union U_G3VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_2217         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3VSR;

// Define the union U_G3VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbtm_offset           : 16  ; // [15..0]
        HI_U32    vtp_offset            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3VOFFSET;

// Define the union U_G3ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2218         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3ZMEORESO;

// Define the union U_G3ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2219         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3ZMEIRESO;

// Define the union U_G3CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2220         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCIDC;

// Define the union U_G3CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2222         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCODC;

// Define the union U_G3CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2224         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2223         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCP0;

// Define the union U_G3CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2226         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2225         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCP1;

// Define the union U_G3CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2228         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2227         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCP2;

// Define the union U_G3CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2230         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2229         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCP3;

// Define the union U_G3CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2231         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3CSCP4;

// Define the union U_G3P0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P0ADDR;
// Define the union U_G3P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2233         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P0STRIDE;

// Define the union U_G3P0DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2234         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P0DFPOS;

// Define the union U_G3P0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2235         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P0DLPOS;

// Define the union U_G3P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2236         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P0RESO;

// Define the union U_G3P1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P1ADDR;
// Define the union U_G3P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2237         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P1STRIDE;

// Define the union U_G3P1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2238         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P1DFPOS;

// Define the union U_G3P1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2239         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P1DLPOS;

// Define the union U_G3P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2240         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P1RESO;

// Define the union U_G3P2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P2ADDR;
// Define the union U_G3P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2241         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P2STRIDE;

// Define the union U_G3P2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2242         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P2DFPOS;

// Define the union U_G3P2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2243         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P2DLPOS;

// Define the union U_G3P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2244         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P2RESO;

// Define the union U_G3P3ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P3ADDR;
// Define the union U_G3P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2245         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P3STRIDE;

// Define the union U_G3P3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2246         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P3DFPOS;

// Define the union U_G3P3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2247         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P3DLPOS;

// Define the union U_G3P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2248         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P3RESO;

// Define the union U_G3P4ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P4ADDR;
// Define the union U_G3P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2249         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P4STRIDE;

// Define the union U_G3P4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2250         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P4DFPOS;

// Define the union U_G3P4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2251         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P4DLPOS;

// Define the union U_G3P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2252         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P4RESO;

// Define the union U_G3P5ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P5ADDR;
// Define the union U_G3P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2253         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P5STRIDE;

// Define the union U_G3P5DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2254         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P5DFPOS;

// Define the union U_G3P5DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2255         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P5DLPOS;

// Define the union U_G3P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2256         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P5RESO;

// Define the union U_G3P6ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P6ADDR;
// Define the union U_G3P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2257         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P6STRIDE;

// Define the union U_G3P6DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2258         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P6DFPOS;

// Define the union U_G3P6DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2259         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P6DLPOS;

// Define the union U_G3P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2260         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P6RESO;

// Define the union U_G3P7ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3P7ADDR;
// Define the union U_G3P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2261         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P7STRIDE;

// Define the union U_G3P7DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2262         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P7DFPOS;

// Define the union U_G3P7DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2263         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P7DLPOS;

// Define the union U_G3P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2264         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3P7RESO;

// Define the union U_G38SLICEEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    Reserved_2265         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G38SLICEEN;

// Define the union U_G3DCMPMODE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2267         : 4   ; // [3..0]
        HI_U32    line_len_idx          : 2   ; // [5..4]
        HI_U32    line_type             : 2   ; // [7..6]
        HI_U32    Reserved_2266         : 23  ; // [30..8]
        HI_U32    dcmp_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3DCMPMODE;

// Define the union U_G3DCMPBANKWIDTH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_bankwidth        : 12  ; // [11..0]
        HI_U32    Reserved_2269         : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3DCMPBANKWIDTH;

// Define the union U_G3DCMPSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_stride           : 16  ; // [15..0]
        HI_U32    Reserved_2270         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G3DCMPSTRIDE;

// Define the union U_G3DCMPAADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_a             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3DCMPAADDR;
// Define the union U_G3DCMPRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_r             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3DCMPRADDR;
// Define the union U_G3DCMPGADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_g             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3DCMPGADDR;
// Define the union U_G3DCMPBADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_b             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G3DCMPBADDR;
// Define the union U_G4CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_2272         : 14  ; // [23..10]
        HI_U32    dcmp_inter            : 1   ; // [24]
        HI_U32    dcmp_mode             : 1   ; // [25]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_2271         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CTRL;

// Define the union U_G4UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_2274         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4UPD;

// Define the union U_G4ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4ADDR;
// Define the union U_G4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2275         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4STRIDE;

// Define the union U_G4CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_2277         : 1   ; // [9]
        HI_U32    vedge_p               : 1   ; // [10]
        HI_U32    hedge_p               : 1   ; // [11]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    premult_en            : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_2276         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CBMPARA;

// Define the union U_G4CKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CKEYMAX;

// Define the union U_G4CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CKEYMIN;

// Define the union U_G4CMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_2278         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CMASK;

// Define the union U_G4IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2279         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4IRESO;

// Define the union U_G4ORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2280         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4ORESO;

// Define the union U_G4SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_2281         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4SFPOS;

// Define the union U_G4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_2282         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4DFPOS;

// Define the union U_G4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_2283         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4DLPOS;

// Define the union U_G4HSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hratio                : 16  ; // [15..0]
        HI_U32    Reserved_2286         : 3   ; // [18..16]
        HI_U32    hfir_order            : 1   ; // [19]
        HI_U32    Reserved_2285         : 3   ; // [22..20]
        HI_U32    hafir_en              : 1   ; // [23]
        HI_U32    hfir_en               : 1   ; // [24]
        HI_U32    Reserved_2284         : 3   ; // [27..25]
        HI_U32    hchmid_en             : 1   ; // [28]
        HI_U32    hlmid_en              : 1   ; // [29]
        HI_U32    hamid_en              : 1   ; // [30]
        HI_U32    hsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4HSP;

// Define the union U_G4HOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hor_coffset           : 16  ; // [15..0]
        HI_U32    hor_loffset           : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4HOFFSET;

// Define the union U_G4VSP
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2290         : 23  ; // [22..0]
        HI_U32    vafir_en              : 1   ; // [23]
        HI_U32    vfir_en               : 1   ; // [24]
        HI_U32    Reserved_2289         : 1   ; // [25]
        HI_U32    Reserved_2288         : 1   ; // [26]
        HI_U32    vsc_luma_tap          : 1   ; // [27]
        HI_U32    vchmid_en             : 1   ; // [28]
        HI_U32    vlmid_en              : 1   ; // [29]
        HI_U32    vamid_en              : 1   ; // [30]
        HI_U32    vsc_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4VSP;

// Define the union U_G4VSR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vratio                : 16  ; // [15..0]
        HI_U32    Reserved_2291         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4VSR;

// Define the union U_G4VOFFSET
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vbtm_offset           : 16  ; // [15..0]
        HI_U32    vtp_offset            : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4VOFFSET;

// Define the union U_G4ZMEORESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ow                    : 12  ; // [11..0]
        HI_U32    oh                    : 12  ; // [23..12]
        HI_U32    Reserved_2292         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4ZMEORESO;

// Define the union U_G4ZMEIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2293         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4ZMEIRESO;

// Define the union U_G4CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2294         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCIDC;

// Define the union U_G4CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2296         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCODC;

// Define the union U_G4CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2298         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2297         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCP0;

// Define the union U_G4CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2300         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2299         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCP1;

// Define the union U_G4CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2302         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2301         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCP2;

// Define the union U_G4CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2304         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2303         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCP3;

// Define the union U_G4CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2305         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4CSCP4;

// Define the union U_G4P0ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P0ADDR;
// Define the union U_G4P0STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2307         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P0STRIDE;

// Define the union U_G4P0DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2308         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P0DFPOS;

// Define the union U_G4P0DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2309         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P0DLPOS;

// Define the union U_G4P0RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2310         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P0RESO;

// Define the union U_G4P1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P1ADDR;
// Define the union U_G4P1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2311         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P1STRIDE;

// Define the union U_G4P1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2312         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P1DFPOS;

// Define the union U_G4P1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2313         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P1DLPOS;

// Define the union U_G4P1RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2314         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P1RESO;

// Define the union U_G4P2ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P2ADDR;
// Define the union U_G4P2STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2315         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P2STRIDE;

// Define the union U_G4P2DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2316         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P2DFPOS;

// Define the union U_G4P2DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2317         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P2DLPOS;

// Define the union U_G4P2RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2318         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P2RESO;

// Define the union U_G4P3ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P3ADDR;
// Define the union U_G4P3STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2319         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P3STRIDE;

// Define the union U_G4P3DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2320         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P3DFPOS;

// Define the union U_G4P3DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2321         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P3DLPOS;

// Define the union U_G4P3RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2322         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P3RESO;

// Define the union U_G4P4ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P4ADDR;
// Define the union U_G4P4STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2323         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P4STRIDE;

// Define the union U_G4P4DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2324         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P4DFPOS;

// Define the union U_G4P4DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2325         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P4DLPOS;

// Define the union U_G4P4RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2326         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P4RESO;

// Define the union U_G4P5ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P5ADDR;
// Define the union U_G4P5STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2327         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P5STRIDE;

// Define the union U_G4P5DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2328         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P5DFPOS;

// Define the union U_G4P5DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2329         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P5DLPOS;

// Define the union U_G4P5RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2330         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P5RESO;

// Define the union U_G4P6ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P6ADDR;
// Define the union U_G4P6STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2331         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P6STRIDE;

// Define the union U_G4P6DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2332         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P6DFPOS;

// Define the union U_G4P6DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2333         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P6DLPOS;

// Define the union U_G4P6RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2334         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P6RESO;

// Define the union U_G4P7ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4P7ADDR;
// Define the union U_G4P7STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2335         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P7STRIDE;

// Define the union U_G4P7DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2336         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P7DFPOS;

// Define the union U_G4P7DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2337         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P7DLPOS;

// Define the union U_G4P7RESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    w                     : 12  ; // [11..0]
        HI_U32    h                     : 12  ; // [23..12]
        HI_U32    Reserved_2338         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4P7RESO;

// Define the union U_G48SLICEEN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    Reserved_2339         : 24  ; // [31..8]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G48SLICEEN;

// Define the union U_G4DCMPMODE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    Reserved_2341         : 4   ; // [3..0]
        HI_U32    line_len_idx          : 2   ; // [5..4]
        HI_U32    line_type             : 2   ; // [7..6]
        HI_U32    Reserved_2340         : 23  ; // [30..8]
        HI_U32    dcmp_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4DCMPMODE;

// Define the union U_G4DCMPBANKWIDTH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_bankwidth        : 12  ; // [11..0]
        HI_U32    Reserved_2343         : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4DCMPBANKWIDTH;

// Define the union U_G4DCMPSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    dcmp_stride           : 16  ; // [15..0]
        HI_U32    Reserved_2344         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_G4DCMPSTRIDE;

// Define the union U_G4DCMPAADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_a             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4DCMPAADDR;
// Define the union U_G4DCMPRADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_r             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4DCMPRADDR;
// Define the union U_G4DCMPGADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_g             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4DCMPGADDR;
// Define the union U_G4DCMPBADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 dcmp_addr_b             : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_G4DCMPBADDR;
// Define the union U_HCCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_2346         : 16  ; // [25..10]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_2345         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCTRL;

// Define the union U_HCUPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_2348         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCUPD;

// Define the union U_HCADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_HCADDR;
// Define the union U_HCSTRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2349         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCSTRIDE;

// Define the union U_HCCBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_2352         : 3   ; // [11..9]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    Reserved_2351         : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_2350         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCBMPARA;

// Define the union U_HCCKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCKEYMAX;

// Define the union U_HCCKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCKEYMIN;

// Define the union U_HCCMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_2353         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCMASK;

// Define the union U_HCIRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2354         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCIRESO;

// Define the union U_HCSFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_2355         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCSFPOS;

// Define the union U_HCDFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_2357         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCDFPOS;

// Define the union U_HCDLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_2358         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCDLPOS;

// Define the union U_HCCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2359         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCIDC;

// Define the union U_HCCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2361         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCODC;

// Define the union U_HCCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2363         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2362         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCP0;

// Define the union U_HCCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2365         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2364         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCP1;

// Define the union U_HCCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2367         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2366         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCP2;

// Define the union U_HCCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2369         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2368         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCP3;

// Define the union U_HCCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2370         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HCCSCP4;

// Define the union U_HC1CTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    ifmt                  : 8   ; // [7..0]
        HI_U32    bitext                : 2   ; // [9..8]
        HI_U32    Reserved_2372         : 16  ; // [25..10]
        HI_U32    read_mode             : 1   ; // [26]
        HI_U32    upd_mode              : 1   ; // [27]
        HI_U32    Reserved_2371         : 3   ; // [30..28]
        HI_U32    surface_en            : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CTRL;

// Define the union U_HC1UPD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    regup                 : 1   ; // [0]
        HI_U32    Reserved_2374         : 31  ; // [31..1]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1UPD;

// Define the union U_HC1ADDR
typedef union
{
    // Define the struct bits 
    struct
    {
        HI_U32 surface_addr            : 32  ; // [31..0]
    } bits;
 
    // Define an unsigned member
    HI_U32    u32;
 
} U_HC1ADDR;
// Define the union U_HC1STRIDE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    surface_stride        : 16  ; // [15..0]
        HI_U32    Reserved_2375         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1STRIDE;

// Define the union U_HC1CBMPARA
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    galpha                : 8   ; // [7..0]
        HI_U32    palpha_range          : 1   ; // [8]
        HI_U32    Reserved_2378         : 3   ; // [11..9]
        HI_U32    palpha_en             : 1   ; // [12]
        HI_U32    Reserved_2377         : 1   ; // [13]
        HI_U32    key_en                : 1   ; // [14]
        HI_U32    key_mode              : 1   ; // [15]
        HI_U32    Reserved_2376         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CBMPARA;

// Define the union U_HC1CKEYMAX
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_max              : 8   ; // [7..0]
        HI_U32    keyg_max              : 8   ; // [15..8]
        HI_U32    keyr_max              : 8   ; // [23..16]
        HI_U32    va0                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CKEYMAX;

// Define the union U_HC1CKEYMIN
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    keyb_min              : 8   ; // [7..0]
        HI_U32    keyg_min              : 8   ; // [15..8]
        HI_U32    keyr_min              : 8   ; // [23..16]
        HI_U32    va1                   : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CKEYMIN;

// Define the union U_HC1CMASK
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    kmsk_b                : 8   ; // [7..0]
        HI_U32    kmsk_g                : 8   ; // [15..8]
        HI_U32    kmsk_r                : 8   ; // [23..16]
        HI_U32    Reserved_2379         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CMASK;

// Define the union U_HC1IRESO
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    iw                    : 12  ; // [11..0]
        HI_U32    ih                    : 12  ; // [23..12]
        HI_U32    Reserved_2380         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1IRESO;

// Define the union U_HC1SFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    src_xfpos             : 7   ; // [6..0]
        HI_U32    Reserved_2381         : 25  ; // [31..7]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1SFPOS;

// Define the union U_HC1DFPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xfpos            : 12  ; // [11..0]
        HI_U32    disp_yfpos            : 12  ; // [23..12]
        HI_U32    Reserved_2383         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1DFPOS;

// Define the union U_HC1DLPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    disp_xlpos            : 12  ; // [11..0]
        HI_U32    disp_ylpos            : 12  ; // [23..12]
        HI_U32    Reserved_2384         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1DLPOS;

// Define the union U_HC1CSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2385         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCIDC;

// Define the union U_HC1CSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2387         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCODC;

// Define the union U_HC1CSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2389         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2388         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCP0;

// Define the union U_HC1CSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2391         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2390         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCP1;

// Define the union U_HC1CSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2393         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2392         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCP2;

// Define the union U_HC1CSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2395         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2394         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCP3;

// Define the union U_HC1CSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2396         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_HC1CSCP4;

// Define the union U_CBMBKG1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cbm_bkgcr             : 8   ; // [7..0]
        HI_U32    cbm_bkgcb             : 8   ; // [15..8]
        HI_U32    cbm_bkgy              : 8   ; // [23..16]
        HI_U32    Reserved_2397         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMBKG1;

// Define the union U_CBMBKG2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cbm_bkgcr             : 8   ; // [7..0]
        HI_U32    cbm_bkgcb             : 8   ; // [15..8]
        HI_U32    cbm_bkgy              : 8   ; // [23..16]
        HI_U32    Reserved_2399         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMBKG2;

// Define the union U_CBMBKG3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cbm_bkgcr             : 8   ; // [7..0]
        HI_U32    cbm_bkgcb             : 8   ; // [15..8]
        HI_U32    cbm_bkgy              : 8   ; // [23..16]
        HI_U32    Reserved_2400         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMBKG3;

// Define the union U_CBMBKG4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cbm_bkgcr             : 8   ; // [7..0]
        HI_U32    cbm_bkgcb             : 8   ; // [15..8]
        HI_U32    cbm_bkgy              : 8   ; // [23..16]
        HI_U32    Reserved_2401         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMBKG4;

// Define the union U_CBMATTR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    sur_attr0             : 4   ; // [3..0]
        HI_U32    sur_attr1             : 4   ; // [7..4]
        HI_U32    sur_attr2             : 4   ; // [11..8]
        HI_U32    sur_attr3             : 4   ; // [15..12]
        HI_U32    Reserved_2402         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMATTR;

// Define the union U_CBMMIX1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    mixer_prio0           : 4   ; // [3..0]
        HI_U32    mixer_prio1           : 4   ; // [7..4]
        HI_U32    mixer_prio2           : 4   ; // [11..8]
        HI_U32    mixer_prio3           : 4   ; // [15..12]
        HI_U32    mixer_prio4           : 4   ; // [19..16]
        HI_U32    mixer_prio5           : 4   ; // [23..20]
        HI_U32    Reserved_2403         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMMIX1;

// Define the union U_CBMMIX2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    mixer_prio0           : 4   ; // [3..0]
        HI_U32    mixer_prio1           : 4   ; // [7..4]
        HI_U32    mixer_prio2           : 4   ; // [11..8]
        HI_U32    mixer_prio3           : 4   ; // [15..12]
        HI_U32    mixer_prio4           : 4   ; // [19..16]
        HI_U32    mixer_prio5           : 4   ; // [23..20]
        HI_U32    Reserved_2404         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMMIX2;

// Define the union U_CBMMIX3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    mixer_prio0           : 4   ; // [3..0]
        HI_U32    mixer_prio1           : 4   ; // [7..4]
        HI_U32    mixer_prio2           : 4   ; // [11..8]
        HI_U32    mixer_prio3           : 4   ; // [15..12]
        HI_U32    mixer_prio4           : 4   ; // [19..16]
        HI_U32    Reserved_2405         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMMIX3;

// Define the union U_CBMMIX4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    mixer_prio0           : 4   ; // [3..0]
        HI_U32    mixer_prio1           : 4   ; // [7..4]
        HI_U32    mixer_prio2           : 4   ; // [11..8]
        HI_U32    mixer_prio3           : 4   ; // [15..12]
        HI_U32    mixer_prio4           : 4   ; // [19..16]
        HI_U32    Reserved_2406         : 12  ; // [31..20]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_CBMMIX4;

// Define the union U_DHDCTRL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    intfdm                : 4   ; // [3..0]
        HI_U32    intfb                 : 2   ; // [5..4]
        HI_U32    synm                  : 1   ; // [6]
        HI_U32    iop                   : 1   ; // [7]
        HI_U32    ivs                   : 1   ; // [8]
        HI_U32    ihs                   : 1   ; // [9]
        HI_U32    idv                   : 1   ; // [10]
        HI_U32    Reserved_2409         : 3   ; // [13..11]
        HI_U32    gmmen                 : 1   ; // [14]
        HI_U32    Reserved_2408         : 1   ; // [15]
        HI_U32    clipen                : 1   ; // [16]
        HI_U32    Reserved_2407         : 3   ; // [19..17]
        HI_U32    fpga_lmt_width        : 7   ; // [26..20]
        HI_U32    fpga_lmt_en           : 1   ; // [27]
        HI_U32    Reserved_vcp2vdp      : 1   ; // [28]
        HI_U32    multi32_md            : 1   ; // [29]
        HI_U32    slave_md              : 1   ; // [30]
        HI_U32    intf_en               : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCTRL;

// Define the union U_DHDVSYNC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vact                  : 12  ; // [11..0]
        HI_U32    vbb                   : 8   ; // [19..12]
        HI_U32    vfb                   : 8   ; // [27..20]
        HI_U32    Reserved_2411         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDVSYNC;

// Define the union U_DHDHSYNC1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hact                  : 16  ; // [15..0]
        HI_U32    hbb                   : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDHSYNC1;

// Define the union U_DHDHSYNC2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hfb                   : 16  ; // [15..0]
        HI_U32    hmid                  : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDHSYNC2;

// Define the union U_DHDVPLUS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    bvact                 : 12  ; // [11..0]
        HI_U32    bvbb                  : 8   ; // [19..12]
        HI_U32    bvfb                  : 8   ; // [27..20]
        HI_U32    Reserved_2412         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDVPLUS;

// Define the union U_DHDPWR
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    hpw                   : 16  ; // [15..0]
        HI_U32    vpw                   : 8   ; // [23..16]
        HI_U32    Reserved_2413         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDPWR;

// Define the union U_DHDVTTHD3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vtmgthd3              : 13  ; // [12..0]
        HI_U32    Reserved_2415         : 2   ; // [14..13]
        HI_U32    thd3_mode             : 1   ; // [15]
        HI_U32    vtmgthd4              : 13  ; // [28..16]
        HI_U32    Reserved_2414         : 2   ; // [30..29]
        HI_U32    thd4_mode             : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDVTTHD3;

// Define the union U_DHDVTTHD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vtmgthd1              : 13  ; // [12..0]
        HI_U32    Reserved_2417         : 2   ; // [14..13]
        HI_U32    thd1_mode             : 1   ; // [15]
        HI_U32    Reserved_2416         : 16  ; // [31..16]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDVTTHD;

// Define the union U_DHDCSCIDC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscidc0               : 9   ; // [8..0]
        HI_U32    cscidc1               : 9   ; // [17..9]
        HI_U32    cscidc2               : 9   ; // [26..18]
        HI_U32    csc_en                : 1   ; // [27]
        HI_U32    Reserved_2418         : 4   ; // [31..28]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCIDC;

// Define the union U_DHDCSCODC
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscodc0               : 9   ; // [8..0]
        HI_U32    cscodc1               : 9   ; // [17..9]
        HI_U32    cscodc2               : 9   ; // [26..18]
        HI_U32    Reserved_2419         : 5   ; // [31..27]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCODC;

// Define the union U_DHDCSCP0
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp00                : 13  ; // [12..0]
        HI_U32    Reserved_2421         : 3   ; // [15..13]
        HI_U32    cscp01                : 13  ; // [28..16]
        HI_U32    Reserved_2420         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCP0;

// Define the union U_DHDCSCP1
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp02                : 13  ; // [12..0]
        HI_U32    Reserved_2423         : 3   ; // [15..13]
        HI_U32    cscp10                : 13  ; // [28..16]
        HI_U32    Reserved_2422         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCP1;

// Define the union U_DHDCSCP2
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp11                : 13  ; // [12..0]
        HI_U32    Reserved_2425         : 3   ; // [15..13]
        HI_U32    cscp12                : 13  ; // [28..16]
        HI_U32    Reserved_2424         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCP2;

// Define the union U_DHDCSCP3
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp20                : 13  ; // [12..0]
        HI_U32    Reserved_2427         : 3   ; // [15..13]
        HI_U32    cscp21                : 13  ; // [28..16]
        HI_U32    Reserved_2426         : 3   ; // [31..29]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCP3;

// Define the union U_DHDCSCP4
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    cscp22                : 13  ; // [12..0]
        HI_U32    Reserved_2428         : 19  ; // [31..13]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCSCP4;

// Define the union U_DHDCLIPL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    clipcl0               : 10  ; // [9..0]
        HI_U32    clipcl1               : 10  ; // [19..10]
        HI_U32    clipcl2               : 10  ; // [29..20]
        HI_U32    dfir_en               : 1   ; // [30]
        HI_U32    clipen                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCLIPL;

// Define the union U_DHDCLIPH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    clipch0               : 10  ; // [9..0]
        HI_U32    clipch1               : 10  ; // [19..10]
        HI_U32    clipch2               : 10  ; // [29..20]
        HI_U32    Reserved_2430         : 2   ; // [31..30]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCLIPH;

// Define the union U_DHDCCDOIMGMOD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    img_mode              : 7   ; // [6..0]
        HI_U32    img_right             : 1   ; // [7]
        HI_U32    img_id                : 2   ; // [9..8]
        HI_U32    Reserved_2432         : 1   ; // [10]
        HI_U32    ccd_en                : 1   ; // [11]
        HI_U32    Reserved_2431         : 20  ; // [31..12]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDOIMGMOD;

// Define the union U_DHDCCDOPOSMSKH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p32_en                : 1   ; // [0]
        HI_U32    p33_en                : 1   ; // [1]
        HI_U32    p34_en                : 1   ; // [2]
        HI_U32    p35_en                : 1   ; // [3]
        HI_U32    p36_en                : 1   ; // [4]
        HI_U32    p37_en                : 1   ; // [5]
        HI_U32    p38_en                : 1   ; // [6]
        HI_U32    p39_en                : 1   ; // [7]
        HI_U32    p40_en                : 1   ; // [8]
        HI_U32    p41_en                : 1   ; // [9]
        HI_U32    p42_en                : 1   ; // [10]
        HI_U32    p43_en                : 1   ; // [11]
        HI_U32    p44_en                : 1   ; // [12]
        HI_U32    p45_en                : 1   ; // [13]
        HI_U32    p46_en                : 1   ; // [14]
        HI_U32    p47_en                : 1   ; // [15]
        HI_U32    p48_en                : 1   ; // [16]
        HI_U32    p49_en                : 1   ; // [17]
        HI_U32    p50_en                : 1   ; // [18]
        HI_U32    p51_en                : 1   ; // [19]
        HI_U32    p52_en                : 1   ; // [20]
        HI_U32    p53_en                : 1   ; // [21]
        HI_U32    p54_en                : 1   ; // [22]
        HI_U32    p55_en                : 1   ; // [23]
        HI_U32    p56_en                : 1   ; // [24]
        HI_U32    p57_en                : 1   ; // [25]
        HI_U32    p58_en                : 1   ; // [26]
        HI_U32    p59_en                : 1   ; // [27]
        HI_U32    p60_en                : 1   ; // [28]
        HI_U32    p61_en                : 1   ; // [29]
        HI_U32    p62_en                : 1   ; // [30]
        HI_U32    p63_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDOPOSMSKH;

// Define the union U_DHDCCDOPOSMSKL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    p8_en                 : 1   ; // [8]
        HI_U32    p9_en                 : 1   ; // [9]
        HI_U32    p10_en                : 1   ; // [10]
        HI_U32    p11_en                : 1   ; // [11]
        HI_U32    p12_en                : 1   ; // [12]
        HI_U32    p13_en                : 1   ; // [13]
        HI_U32    p14_en                : 1   ; // [14]
        HI_U32    p15_en                : 1   ; // [15]
        HI_U32    p16_en                : 1   ; // [16]
        HI_U32    p17_en                : 1   ; // [17]
        HI_U32    p18_en                : 1   ; // [18]
        HI_U32    p19_en                : 1   ; // [19]
        HI_U32    p20_en                : 1   ; // [20]
        HI_U32    p21_en                : 1   ; // [21]
        HI_U32    p22_en                : 1   ; // [22]
        HI_U32    p23_en                : 1   ; // [23]
        HI_U32    p24_en                : 1   ; // [24]
        HI_U32    p25_en                : 1   ; // [25]
        HI_U32    p26_en                : 1   ; // [26]
        HI_U32    p27_en                : 1   ; // [27]
        HI_U32    p28_en                : 1   ; // [28]
        HI_U32    p29_en                : 1   ; // [29]
        HI_U32    p30_en                : 1   ; // [30]
        HI_U32    p31_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDOPOSMSKL;

// Define the union U_DHDCCDIIMGMOD
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    img_mode              : 7   ; // [6..0]
        HI_U32    img_right             : 1   ; // [7]
        HI_U32    img_id                : 2   ; // [9..8]
        HI_U32    Reserved_2434         : 22  ; // [31..10]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDIIMGMOD;

// Define the union U_DHDCCDIPOSMSKH
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p32_en                : 1   ; // [0]
        HI_U32    p33_en                : 1   ; // [1]
        HI_U32    p34_en                : 1   ; // [2]
        HI_U32    p35_en                : 1   ; // [3]
        HI_U32    p36_en                : 1   ; // [4]
        HI_U32    p37_en                : 1   ; // [5]
        HI_U32    p38_en                : 1   ; // [6]
        HI_U32    p39_en                : 1   ; // [7]
        HI_U32    p40_en                : 1   ; // [8]
        HI_U32    p41_en                : 1   ; // [9]
        HI_U32    p42_en                : 1   ; // [10]
        HI_U32    p43_en                : 1   ; // [11]
        HI_U32    p44_en                : 1   ; // [12]
        HI_U32    p45_en                : 1   ; // [13]
        HI_U32    p46_en                : 1   ; // [14]
        HI_U32    p47_en                : 1   ; // [15]
        HI_U32    p48_en                : 1   ; // [16]
        HI_U32    p49_en                : 1   ; // [17]
        HI_U32    p50_en                : 1   ; // [18]
        HI_U32    p51_en                : 1   ; // [19]
        HI_U32    p52_en                : 1   ; // [20]
        HI_U32    p53_en                : 1   ; // [21]
        HI_U32    p54_en                : 1   ; // [22]
        HI_U32    p55_en                : 1   ; // [23]
        HI_U32    p56_en                : 1   ; // [24]
        HI_U32    p57_en                : 1   ; // [25]
        HI_U32    p58_en                : 1   ; // [26]
        HI_U32    p59_en                : 1   ; // [27]
        HI_U32    p60_en                : 1   ; // [28]
        HI_U32    p61_en                : 1   ; // [29]
        HI_U32    p62_en                : 1   ; // [30]
        HI_U32    p63_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDIPOSMSKH;

// Define the union U_DHDCCDIPOSMSKL
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    p0_en                 : 1   ; // [0]
        HI_U32    p1_en                 : 1   ; // [1]
        HI_U32    p2_en                 : 1   ; // [2]
        HI_U32    p3_en                 : 1   ; // [3]
        HI_U32    p4_en                 : 1   ; // [4]
        HI_U32    p5_en                 : 1   ; // [5]
        HI_U32    p6_en                 : 1   ; // [6]
        HI_U32    p7_en                 : 1   ; // [7]
        HI_U32    p8_en                 : 1   ; // [8]
        HI_U32    p9_en                 : 1   ; // [9]
        HI_U32    p10_en                : 1   ; // [10]
        HI_U32    p11_en                : 1   ; // [11]
        HI_U32    p12_en                : 1   ; // [12]
        HI_U32    p13_en                : 1   ; // [13]
        HI_U32    p14_en                : 1   ; // [14]
        HI_U32    p15_en                : 1   ; // [15]
        HI_U32    p16_en                : 1   ; // [16]
        HI_U32    p17_en                : 1   ; // [17]
        HI_U32    p18_en                : 1   ; // [18]
        HI_U32    p19_en                : 1   ; // [19]
        HI_U32    p20_en                : 1   ; // [20]
        HI_U32    p21_en                : 1   ; // [21]
        HI_U32    p22_en                : 1   ; // [22]
        HI_U32    p23_en                : 1   ; // [23]
        HI_U32    p24_en                : 1   ; // [24]
        HI_U32    p25_en                : 1   ; // [25]
        HI_U32    p26_en                : 1   ; // [26]
        HI_U32    p27_en                : 1   ; // [27]
        HI_U32    p28_en                : 1   ; // [28]
        HI_U32    p29_en                : 1   ; // [29]
        HI_U32    p30_en                : 1   ; // [30]
        HI_U32    p31_en                : 1   ; // [31]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDIPOSMSKL;

// Define the union U_DHDSTATE
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    vback_blank           : 1   ; // [0]
        HI_U32    vblank                : 1   ; // [1]
        HI_U32    bottom_field          : 1   ; // [2]
        HI_U32    Reserved_2436         : 29  ; // [31..3]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDSTATE;

// Define the union U_DHDCCDP0FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2438         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP0FPOS;

// Define the union U_DHDCCDP0LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2440         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP0LPOS;

// Define the union U_DHDCCDP1FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2441         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP1FPOS;

// Define the union U_DHDCCDP1LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2442         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP1LPOS;

// Define the union U_DHDCCDP2FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2443         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP2FPOS;

// Define the union U_DHDCCDP2LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2444         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP2LPOS;

// Define the union U_DHDCCDP3FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2445         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP3FPOS;

// Define the union U_DHDCCDP3LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2446         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP3LPOS;

// Define the union U_DHDCCDP4FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2447         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP4FPOS;

// Define the union U_DHDCCDP4LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2448         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP4LPOS;

// Define the union U_DHDCCDP5FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2449         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP5FPOS;

// Define the union U_DHDCCDP5LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2450         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP5LPOS;

// Define the union U_DHDCCDP6FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2451         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP6FPOS;

// Define the union U_DHDCCDP6LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2452         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP6LPOS;

// Define the union U_DHDCCDP7FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2453         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP7FPOS;

// Define the union U_DHDCCDP7LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2454         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP7LPOS;

// Define the union U_DHDCCDP8FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2455         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP8FPOS;

// Define the union U_DHDCCDP8LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2456         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP8LPOS;

// Define the union U_DHDCCDP9FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2457         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP9FPOS;

// Define the union U_DHDCCDP9LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2458         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP9LPOS;

// Define the union U_DHDCCDP10FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2459         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP10FPOS;

// Define the union U_DHDCCDP10LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2460         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP10LPOS;

// Define the union U_DHDCCDP11FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2461         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP11FPOS;

// Define the union U_DHDCCDP11LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2462         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP11LPOS;

// Define the union U_DHDCCDP12FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2463         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP12FPOS;

// Define the union U_DHDCCDP12LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2464         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP12LPOS;

// Define the union U_DHDCCDP13FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2465         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP13FPOS;

// Define the union U_DHDCCDP13LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2466         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP13LPOS;

// Define the union U_DHDCCDP14FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2467         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP14FPOS;

// Define the union U_DHDCCDP14LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2468         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP14LPOS;

// Define the union U_DHDCCDP15FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2469         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP15FPOS;

// Define the union U_DHDCCDP15LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2470         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP15LPOS;

// Define the union U_DHDCCDP16FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2471         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP16FPOS;

// Define the union U_DHDCCDP16LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2472         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP16LPOS;

// Define the union U_DHDCCDP17FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2473         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP17FPOS;

// Define the union U_DHDCCDP17LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2474         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP17LPOS;

// Define the union U_DHDCCDP18FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2475         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP18FPOS;

// Define the union U_DHDCCDP18LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2476         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP18LPOS;

// Define the union U_DHDCCDP19FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2477         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP19FPOS;

// Define the union U_DHDCCDP19LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2478         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP19LPOS;

// Define the union U_DHDCCDP20FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2479         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP20FPOS;

// Define the union U_DHDCCDP20LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2480         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP20LPOS;

// Define the union U_DHDCCDP21FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2481         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP21FPOS;

// Define the union U_DHDCCDP21LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2482         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP21LPOS;

// Define the union U_DHDCCDP22FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2483         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP22FPOS;

// Define the union U_DHDCCDP22LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2484         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP22LPOS;

// Define the union U_DHDCCDP23FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2485         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP23FPOS;

// Define the union U_DHDCCDP23LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2486         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP23LPOS;

// Define the union U_DHDCCDP24FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2487         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP24FPOS;

// Define the union U_DHDCCDP24LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2488         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP24LPOS;

// Define the union U_DHDCCDP25FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2489         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP25FPOS;

// Define the union U_DHDCCDP25LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2490         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP25LPOS;

// Define the union U_DHDCCDP26FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2491         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP26FPOS;

// Define the union U_DHDCCDP26LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2492         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP26LPOS;

// Define the union U_DHDCCDP27FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2493         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP27FPOS;

// Define the union U_DHDCCDP27LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2494         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP27LPOS;

// Define the union U_DHDCCDP28FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2495         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP28FPOS;

// Define the union U_DHDCCDP28LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2496         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP28LPOS;

// Define the union U_DHDCCDP29FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2497         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP29FPOS;

// Define the union U_DHDCCDP29LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2498         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP29LPOS;

// Define the union U_DHDCCDP30FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2499         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP30FPOS;

// Define the union U_DHDCCDP30LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2500         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP30LPOS;

// Define the union U_DHDCCDP31FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2501         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP31FPOS;

// Define the union U_DHDCCDP31LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2502         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP31LPOS;

// Define the union U_DHDCCDP32FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2503         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP32FPOS;

// Define the union U_DHDCCDP32LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2504         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP32LPOS;

// Define the union U_DHDCCDP33FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2505         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP33FPOS;

// Define the union U_DHDCCDP33LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2506         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP33LPOS;

// Define the union U_DHDCCDP34FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2507         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP34FPOS;

// Define the union U_DHDCCDP34LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2508         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP34LPOS;

// Define the union U_DHDCCDP35FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2509         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP35FPOS;

// Define the union U_DHDCCDP35LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2510         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP35LPOS;

// Define the union U_DHDCCDP36FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2511         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP36FPOS;

// Define the union U_DHDCCDP36LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2512         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP36LPOS;

// Define the union U_DHDCCDP37FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2513         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP37FPOS;

// Define the union U_DHDCCDP37LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2514         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP37LPOS;

// Define the union U_DHDCCDP38FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos                 : 12  ; // [11..0]
        HI_U32    yfpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2515         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP38FPOS;

// Define the union U_DHDCCDP38LPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xlpos                 : 12  ; // [11..0]
        HI_U32    ylpos                 : 12  ; // [23..12]
        HI_U32    Reserved_2516         : 8   ; // [31..24]
    } bits;

    // Define an unsigned member
    HI_U32    u32;

} U_DHDCCDP38LPOS;

// Define the union U_DHDCCDP39FPOS
typedef union
{
    // Define the struct bits
    struct
    {
        HI_U32    xfpos               