/*
 * ambhw/rtc.h
 *
 * History:
 *	2006/12/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2006-2007, Ambarella, Inc.
 */

#ifndef __AMBHW__RTC_H__
#define __AMBHW__RTC_H__

#include <ambhw/chip.h>
#include <ambhw/busaddr.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/

#if (CHIP_REV == A1)
#define RTC_SUPPORT_ONCHIP_INSTANCES		0 
#else
#define RTC_SUPPORT_ONCHIP_INSTANCES		1
#endif

#if (CHIP_REV == A5S) || (CHIP_REV == A7) || (CHIP_REV == A5L)
#define RTC_SUPPORT_EXTRA_WAKEUP_PINS		1
#define RTC_SUPPORT_30BITS_PASSED_SECONDS	1
#elif (CHIP_REV == I1) || (CHIP_REV == A7L)
#define RTC_SUPPORT_EXTRA_WAKEUP_PINS		1
#define RTC_SUPPORT_30BITS_PASSED_SECONDS	0
#else
#define RTC_SUPPORT_EXTRA_WAKEUP_PINS		0
#define RTC_SUPPORT_30BITS_PASSED_SECONDS	0
#endif

#if (CHIP_REV == I1) || (CHIP_REV == A7L)
#define RTC_SUPPORT_GPIO_PAD_PULL_CTRL		1
#define RTC_POWER_LOST_DETECT			1
#define RTC_SW_POWER_LOST_DETECT		0
#elif (CHIP_REV == A7)
#define RTC_SUPPORT_GPIO_PAD_PULL_CTRL		1
#define RTC_POWER_LOST_DETECT			0
#define RTC_SW_POWER_LOST_DETECT		1
#elif (CHIP_REV == A5L)
#define RTC_SUPPORT_GPIO_PAD_PULL_CTRL		0
#define RTC_POWER_LOST_DETECT			0
#define RTC_SW_POWER_LOST_DETECT		1
#else
#define RTC_SUPPORT_GPIO_PAD_PULL_CTRL		0
#define RTC_POWER_LOST_DETECT			0
#define RTC_SW_POWER_LOST_DETECT		0
#endif

#if (CHIP_REV == I1) || (CHIP_REV == A7L)
#define RTC_SEQ_LEVEL_CONFIGURABLE		1
#define RTC_WAKEUP_CTRL				1
#define RTC_LOW_BATTERY_DETECT			1
#else
#define RTC_SEQ_LEVEL_CONFIGURABLE		0
#define RTC_WAKEUP_CTRL				0
#define RTC_LOW_BATTERY_DETECT			0
#endif

#if (CHIP_REV == I1)
#define RTC_PWR_LOSS_DETECT_BIT			5
#define RTC_PWC_LOSS_MASK			0x20
#elif (CHIP_REV == A7L)
#define RTC_PWR_LOSS_DETECT_BIT			6
#define RTC_PWC_LOSS_MASK			0x40
#elif (CHIP_REV == A7) || (CHIP_REV == A5L)
#define RTC_PWR_LOSS_DETECT_BIT			30
#define RTC_PWC_LOSS_MASK			0x40000000
#else
#define RTC_PWR_LOSS_DETECT_BIT			1
#define RTC_PWC_LOSS_MASK			0x2
#endif

/****************************************************/
/* Controller registers definitions                 */
/****************************************************/
#if (RTC_SUPPORT_ONCHIP_INSTANCES == 1)

#define RTC_POS0_OFFSET			0x20
#define RTC_POS1_OFFSET			0x24
#define RTC_POS2_OFFSET			0x28
#define RTC_PWC_ALAT_OFFSET		0x2c
#define RTC_PWC_CURT_OFFSET		0x30
#define RTC_CURT_OFFSET			0x34
#define RTC_ALAT_OFFSET			0x38
#define RTC_STATUS_OFFSET		0x3c
#define RTC_RESET_OFFSET		0x40

#if (RTC_SUPPORT_EXTRA_WAKEUP_PINS == 1)
#define RTC_WO_OFFSET			0x7c
#endif

#if (RTC_SUPPORT_GPIO_PAD_PULL_CTRL == 1)
#define RTC_GPIO_PULL_EN_0_OFFSET	0x80
#define RTC_GPIO_PULL_EN_1_OFFSET	0x84
#define RTC_GPIO_PULL_EN_2_OFFSET	0x88
#define RTC_GPIO_PULL_EN_3_OFFSET	0x8c
#define RTC_GPIO_PULL_EN_4_OFFSET	0x90
#define RTC_GPIO_PULL_EN_5_OFFSET	0x54
#define RTC_GPIO_PULL_DIR_0_OFFSET	0x94
#define RTC_GPIO_PULL_DIR_1_OFFSET	0x98
#define RTC_GPIO_PULL_DIR_2_OFFSET	0x9c
#define RTC_GPIO_PULL_DIR_3_OFFSET	0xa0
#define RTC_GPIO_PULL_DIR_4_OFFSET	0xa4
#define RTC_GPIO_PULL_DIR_5_OFFSET	0x58

#if (CHIP_REV == I1)
#define RTC_RTC_CTL_OFFSET		0xff
#else
#define RTC_RTC_CTL_OFFSET		0xfc
#endif

#endif

#define RTC_PWC_DNALERT_OFFSET		0xa8
#define RTC_PWC_LBAT_OFFSET		0xac
#define RTC_PWC_REG_WKUPC_OFFSET	0xb0
#define RTC_PWC_REG_STA_OFFSET		0xb4
#define RTC_PWC_SET_STATUS_OFFSET	0xc0
#define RTC_PWC_CLR_REG_WKUPC_OFFSET	0xc4
#define RTC_PWC_WKENC_OFFSET		0xc8

#define RTC_POS3_OFFSET			0xd0

#define RTC_PWC_ENP1C_OFFSET		0xd4
#define RTC_PWC_ENP2C_OFFSET		0xd8
#define RTC_PWC_ENP3C_OFFSET		0xdc
#define RTC_PWC_ENP1_OFFSET		0xe0
#define RTC_PWC_ENP2_OFFSET		0xe4
#define RTC_PWC_ENP3_OFFSET		0xe8

#define RTC_PWC_DISP1C_OFFSET		0xec
#define RTC_PWC_DISP2C_OFFSET		0xf0
#define RTC_PWC_DISP3C_OFFSET		0xf4
#define RTC_PWC_DISP1_OFFSET		0xf8
#define RTC_PWC_DISP2_OFFSET		0xb8
#define RTC_PWC_DISP3_OFFSET		0xbc

/* Registers */

#define RTC_POS0_REG			RTC_REG(RTC_POS0_OFFSET)
#define RTC_POS1_REG			RTC_REG(RTC_POS1_OFFSET)
#define RTC_POS2_REG			RTC_REG(RTC_POS2_OFFSET)
#define RTC_POS3_REG			RTC_REG(RTC_POS3_OFFSET)
#define RTC_PWC_ALAT_REG		RTC_REG(RTC_PWC_ALAT_OFFSET)
#define RTC_PWC_CURT_REG		RTC_REG(RTC_PWC_CURT_OFFSET)
#define RTC_CURT_REG			RTC_REG(RTC_CURT_OFFSET)
#define RTC_ALAT_REG			RTC_REG(RTC_ALAT_OFFSET)
#define RTC_STATUS_REG			RTC_REG(RTC_STATUS_OFFSET)
#define RTC_RESET_REG			RTC_REG(RTC_RESET_OFFSET)

#if (RTC_SUPPORT_EXTRA_WAKEUP_PINS == 1)
#define RTC_WO_REG			RTC_REG(RTC_WO_OFFSET)
#endif
 
#if (RTC_SUPPORT_GPIO_PAD_PULL_CTRL == 1) 
#define RTC_GPIO_PULL_EN_0_REG		RTC_REG(RTC_GPIO_PULL_EN_0_OFFSET)
#define RTC_GPIO_PULL_EN_1_REG		RTC_REG(RTC_GPIO_PULL_EN_1_OFFSET)
#define RTC_GPIO_PULL_EN_2_REG		RTC_REG(RTC_GPIO_PULL_EN_2_OFFSET)
#define RTC_GPIO_PULL_EN_3_REG		RTC_REG(RTC_GPIO_PULL_EN_3_OFFSET)
#define RTC_GPIO_PULL_EN_4_REG		RTC_REG(RTC_GPIO_PULL_EN_4_OFFSET)
#define RTC_GPIO_PULL_EN_5_REG		RTC_REG(RTC_GPIO_PULL_EN_5_OFFSET)
#define RTC_GPIO_PULL_DIR_0_REG		RTC_REG(RTC_GPIO_PULL_DIR_0_OFFSET)
#define RTC_GPIO_PULL_DIR_1_REG		RTC_REG(RTC_GPIO_PULL_DIR_1_OFFSET)
#define RTC_GPIO_PULL_DIR_2_REG		RTC_REG(RTC_GPIO_PULL_DIR_2_OFFSET)
#define RTC_GPIO_PULL_DIR_3_REG		RTC_REG(RTC_GPIO_PULL_DIR_3_OFFSET)
#define RTC_GPIO_PULL_DIR_4_REG		RTC_REG(RTC_GPIO_PULL_DIR_4_OFFSET)
#define RTC_GPIO_PULL_DIR_5_REG		RTC_REG(RTC_GPIO_PULL_DIR_5_OFFSET)
#endif

#define RTC_RTC_CTL_REG			RTC_REG(RTC_RTC_CTL_OFFSET)

#define RTC_PWC_DNALERT_REG		RTC_REG(RTC_PWC_DNALERT_OFFSET)
#define RTC_PWC_LBAT_REG		RTC_REG(RTC_PWC_LBAT_OFFSET)
#define RTC_PWC_REG_WKUPC_REG		RTC_REG(RTC_PWC_REG_WKUPC_OFFSET)
#define RTC_PWC_REG_STA_REG		RTC_REG(RTC_PWC_REG_STA_OFFSET)
#define RTC_PWC_SET_STATUS_REG		RTC_REG(RTC_PWC_SET_STATUS_OFFSET)
#define RTC_PWC_CLR_REG_WKUPC_REG	RTC_REG(RTC_PWC_CLR_REG_WKUPC_OFFSET)
#define RTC_PWC_WKENC_REG		RTC_REG(RTC_PWC_WKENC_OFFSET)

/* Ties pseq* low / high */
#define RTC_PWC_ENP1C_REG		RTC_REG(RTC_PWC_ENP1C_OFFSET)
#define RTC_PWC_ENP2C_REG		RTC_REG(RTC_PWC_ENP2C_OFFSET)
#define RTC_PWC_ENP3C_REG		RTC_REG(RTC_PWC_ENP3C_OFFSET)
#define RTC_PWC_ENP1_REG		RTC_REG(RTC_PWC_ENP1_OFFSET)
#define RTC_PWC_ENP2_REG		RTC_REG(RTC_PWC_ENP2_OFFSET)
#define RTC_PWC_ENP3_REG		RTC_REG(RTC_PWC_ENP3_OFFSET)

#define RTC_PWC_DISP1C_REG		RTC_REG(RTC_PWC_DISP1C_OFFSET)
#define RTC_PWC_DISP2C_REG		RTC_REG(RTC_PWC_DISP2C_OFFSET)
#define RTC_PWC_DISP3C_REG		RTC_REG(RTC_PWC_DISP3C_OFFSET)
#define RTC_PWC_DISP1_REG		RTC_REG(RTC_PWC_DISP1_OFFSET)
#define RTC_PWC_DISP2_REG		RTC_REG(RTC_PWC_DISP2_OFFSET)
#define RTC_PWC_DISP3_REG		RTC_REG(RTC_PWC_DISP3_OFFSET)


/* RTC_STATUS_REG */
#define RTC_STATUS_WKUP			0x8
#define RTC_STATUS_ALA_WK		0x4
#define RTC_STATUS_PC_RST		0x2
#define RTC_STATUS_RTC_CLK		0x1

/* RTC_SEQ_NUM */
#define PWC_SEQ1			1
#define PWC_SEQ2			2
#define PWC_SEQ3			3
#define PWC_SEQ1C			4
#define PWC_SEQ2C			5
#define PWC_SEQ3C			6

/* RTC_WAKEUP_CTRL */
#define RTC_WAKEUP_CTRL_USB		1
#define RTC_WAKEUP_CTRL_SDCARD		2
#define RTC_WAKEUP_CTRL_ETHNET		4
#endif 

#endif

