//////////////////////////////////////////////////////////////////////////////
// ARM_ADDRESS_FILE.h generated by: addrfile2all.pl
// QCSR addrfile2all.pl 4.4
//////////////////////////////////////////////////////////////////////////////
// **** W A R N I N G ****  THIS FILE IS AUTO GENERATED!! PLEASE DO NOT EDIT!!
//////////////////////////////////////////////////////////////////////////////
// QUALCOMM Proprietary
// Copyright QUALCOMM Incorporated.  All rights reserved.
//
// All data and information contained in or disclosed by this document are
// confidential and proprietary information of QUALCOMM Incorporated, and
// all rights therein are expressly reserved. By accepting this material,
// the recipient agrees that this material and the information contained
// therein are held in confidence and in trust and will not be used,
// copied, reproduced in whole or in part, nor its contents revealed in
// any manner to others without the express written permission of QUALCOMM
// Incorporated.
//
// This technology was exported from the United States in accordance with
// the Export Administration Regulations. Diversion contrary to U.S. law
// prohibited.
//////////////////////////////////////////////////////////////////////////////
// RCS File        : -USE CVS LOG-
// Revision        : -USE CVS LOG-
// Last Check In   : -USE CVS LOG-
//////////////////////////////////////////////////////////////////////////////
// Description     : Constants related to Hardware Registers
//
// Byte Addresses are used for all BASES and ADDRESSES
//////////////////////////////////////////////////////////////////////////////
#ifndef ARM_ADDRESS_FILE_H

#define ARM_ADDRESS_FILE_H

enum QCSR_REG_TYPE {QCSR_REG_RO, QCSR_REG_WO, QCSR_REG_RW, QCSR_REG_COMMAND};

#define MAX_PIPES 		  8

#define BAM_OFFSET (32'h5000 + ((MAX_PIPES+2)*32'h1000))

#define USB_OTG_HS_TOP                                                                      (0x00080000)  // wlan USB base address 

#define USB_OTG_HS_ID                                                                    (BAM_OFFSET+0x00000000)
#define   USB_OTG_HS_ID___RWC                                                              QCSR_REG_RO
#define   USB_OTG_HS_ID___POR                                                              0x0042FA05
#define   USB_OTG_HS_ID__REVISON___M                                                       0x00FF0000
#define   USB_OTG_HS_ID__REVISON___S                                                       16
#define   USB_OTG_HS_ID__NID___M                                                           0x0000FF00
#define   USB_OTG_HS_ID__NID___S                                                           8
#define   USB_OTG_HS_ID__ID___M                                                            0x000000FF
#define   USB_OTG_HS_ID__ID___S                                                            0
#define   USB_OTG_HS_ID___M                                                                0x00FFFFFF
#define   USB_OTG_HS_ID___S                                                                0

#define USB_OTG_HS_HWGENERAL                                                             (BAM_OFFSET+0x00000004)
#define   USB_OTG_HS_HWGENERAL___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_HWGENERAL___POR                                                       0x000001C2
#define   USB_OTG_HS_HWGENERAL__SM___M                                                     0x00000200
#define   USB_OTG_HS_HWGENERAL__SM___S                                                     9
#define   USB_OTG_HS_HWGENERAL__PHYM___M                                                   0x000001C0
#define   USB_OTG_HS_HWGENERAL__PHYM___S                                                   6
#define   USB_OTG_HS_HWGENERAL__PHYW___M                                                   0x00000030
#define   USB_OTG_HS_HWGENERAL__PHYW___S                                                   4
#define   USB_OTG_HS_HWGENERAL__BWT___M                                                    0x00000008
#define   USB_OTG_HS_HWGENERAL__BWT___S                                                    3
#define   USB_OTG_HS_HWGENERAL__CLCK___M                                                   0x00000006
#define   USB_OTG_HS_HWGENERAL__CLCK___S                                                   1
#define   USB_OTG_HS_HWGENERAL__RT___M                                                     0x00000001
#define   USB_OTG_HS_HWGENERAL__RT___S                                                     0
#define   USB_OTG_HS_HWGENERAL___M                                                         0x000003FF
#define   USB_OTG_HS_HWGENERAL___S                                                         0

#define USB_OTG_HS_HWHOST                                                                (BAM_OFFSET+0x00000008)
#define   USB_OTG_HS_HWHOST___RWC                                                          QCSR_REG_RO
#define   USB_OTG_HS_HWHOST___POR                                                          0x10020001
#define   USB_OTG_HS_HWHOST__TTPER___M                                                     0xFF000000
#define   USB_OTG_HS_HWHOST__TTPER___S                                                     24
#define   USB_OTG_HS_HWHOST__TTASY___M                                                     0x00FF0000
#define   USB_OTG_HS_HWHOST__TTASY___S                                                     16
#define   USB_OTG_HS_HWHOST__NPORT___M                                                     0x0000000E
#define   USB_OTG_HS_HWHOST__NPORT___S                                                     1
#define   USB_OTG_HS_HWHOST__HC___M                                                        0x00000001
#define   USB_OTG_HS_HWHOST__HC___S                                                        0
#define   USB_OTG_HS_HWHOST___M                                                            0xFFFFFFFF
#define   USB_OTG_HS_HWHOST___S                                                            0

#define USB_OTG_HS_HWDEVICE                                                              (BAM_OFFSET+0x0000000C)
#define   USB_OTG_HS_HWDEVICE___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_HWDEVICE___POR                                                        0x00000021
#define   USB_OTG_HS_HWDEVICE__DEVEP___M                                                   0x0000003E
#define   USB_OTG_HS_HWDEVICE__DEVEP___S                                                   1
#define   USB_OTG_HS_HWDEVICE__DC___M                                                      0x00000001
#define   USB_OTG_HS_HWDEVICE__DC___S                                                      0
#define   USB_OTG_HS_HWDEVICE___M                                                          0x0000003F
#define   USB_OTG_HS_HWDEVICE___S                                                          0

#define USB_OTG_HS_HWTXBUF                                                               (BAM_OFFSET+0x00000010)
#define   USB_OTG_HS_HWTXBUF___RWC                                                         QCSR_REG_RO
#define   USB_OTG_HS_HWTXBUF___POR                                                         0x80070B08
#define   USB_OTG_HS_HWTXBUF__TXLCR___M                                                    0x80000000
#define   USB_OTG_HS_HWTXBUF__TXLCR___S                                                    31
#define   USB_OTG_HS_HWTXBUF__TXCHANADD___M                                                0x00FF0000
#define   USB_OTG_HS_HWTXBUF__TXCHANADD___S                                                16
#define   USB_OTG_HS_HWTXBUF__TXADD___M                                                    0x0000FF00
#define   USB_OTG_HS_HWTXBUF__TXADD___S                                                    8
#define   USB_OTG_HS_HWTXBUF__TXBURST___M                                                  0x000000FF
#define   USB_OTG_HS_HWTXBUF__TXBURST___S                                                  0
#define   USB_OTG_HS_HWTXBUF___M                                                           0xFFFFFFFF
#define   USB_OTG_HS_HWTXBUF___S                                                           0

#define USB_OTG_HS_HWRXBUF                                                               (BAM_OFFSET+0x00000014)
#define   USB_OTG_HS_HWRXBUF___RWC                                                         QCSR_REG_RO
#define   USB_OTG_HS_HWRXBUF___POR                                                         0x00000808
#define   USB_OTG_HS_HWRXBUF__RX_ADD___M                                                   0x0000FF00
#define   USB_OTG_HS_HWRXBUF__RX_ADD___S                                                   8
#define   USB_OTG_HS_HWRXBUF__RX_BURST___M                                                 0x000000FF
#define   USB_OTG_HS_HWRXBUF__RX_BURST___S                                                 0
#define   USB_OTG_HS_HWRXBUF___M                                                           0x0000FFFF
#define   USB_OTG_HS_HWRXBUF___S                                                           0

#define USB_OTG_HS_SCRATCH_RAMn(n)                                            (BAM_OFFSET+0x00000040+0x4*(n))
#define   USB_OTG_HS_SCRATCH_RAMn_nMIN                         0
#define   USB_OTG_HS_SCRATCH_RAMn_nMAX                         15
#define   USB_OTG_HS_SCRATCH_RAMn_ELEM                         16
#define   USB_OTG_HS_SCRATCH_RAMn___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAMn___POR                                                    0x00000000
#define   USB_OTG_HS_SCRATCH_RAMn__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAMn__SCRATCH_REGISTER___S                                    0
#define   USB_OTG_HS_SCRATCH_RAMn___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAMn___S                                                      0
#define USB_OTG_HS_SCRATCH_RAM0                                                          (BAM_OFFSET+0x00000040)
#define   USB_OTG_HS_SCRATCH_RAM0___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM0__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM0__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM1                                                          (BAM_OFFSET+0x00000044)
#define   USB_OTG_HS_SCRATCH_RAM1___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM1__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM1__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM2                                                          (BAM_OFFSET+0x00000048)
#define   USB_OTG_HS_SCRATCH_RAM2___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM2__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM2__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM3                                                          (BAM_OFFSET+0x0000004C)
#define   USB_OTG_HS_SCRATCH_RAM3___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM3__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM3__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM4                                                          (BAM_OFFSET+0x00000050)
#define   USB_OTG_HS_SCRATCH_RAM4___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM4__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM4__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM5                                                          (BAM_OFFSET+0x00000054)
#define   USB_OTG_HS_SCRATCH_RAM5___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM5__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM5__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM6                                                          (BAM_OFFSET+0x00000058)
#define   USB_OTG_HS_SCRATCH_RAM6___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM6__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM6__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM7                                                          (BAM_OFFSET+0x0000005C)
#define   USB_OTG_HS_SCRATCH_RAM7___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM7__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM7__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM8                                                          (BAM_OFFSET+0x00000060)
#define   USB_OTG_HS_SCRATCH_RAM8___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM8__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM8__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM9                                                          (BAM_OFFSET+0x00000064)
#define   USB_OTG_HS_SCRATCH_RAM9___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM9__SCRATCH_REGISTER___M                                    0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM9__SCRATCH_REGISTER___S                                    0
#define USB_OTG_HS_SCRATCH_RAM10                                                         (BAM_OFFSET+0x00000068)
#define   USB_OTG_HS_SCRATCH_RAM10___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM10__SCRATCH_REGISTER___M                                   0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM10__SCRATCH_REGISTER___S                                   0
#define USB_OTG_HS_SCRATCH_RAM11                                                         (BAM_OFFSET+0x0000006C)
#define   USB_OTG_HS_SCRATCH_RAM11___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM11__SCRATCH_REGISTER___M                                   0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM11__SCRATCH_REGISTER___S                                   0
#define USB_OTG_HS_SCRATCH_RAM12                                                         (BAM_OFFSET+0x00000070)
#define   USB_OTG_HS_SCRATCH_RAM12___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM12__SCRATCH_REGISTER___M                                   0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM12__SCRATCH_REGISTER___S                                   0
#define USB_OTG_HS_SCRATCH_RAM13                                                         (BAM_OFFSET+0x00000074)
#define   USB_OTG_HS_SCRATCH_RAM13___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM13__SCRATCH_REGISTER___M                                   0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM13__SCRATCH_REGISTER___S                                   0
#define USB_OTG_HS_SCRATCH_RAM14                                                         (BAM_OFFSET+0x00000078)
#define   USB_OTG_HS_SCRATCH_RAM14___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM14__SCRATCH_REGISTER___M                                   0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM14__SCRATCH_REGISTER___S                                   0
#define USB_OTG_HS_SCRATCH_RAM15                                                         (BAM_OFFSET+0x0000007C)
#define   USB_OTG_HS_SCRATCH_RAM15___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_SCRATCH_RAM15__SCRATCH_REGISTER___M                                   0xFFFFFFFF
#define   USB_OTG_HS_SCRATCH_RAM15__SCRATCH_REGISTER___S                                   0

#define USB_OTG_HS_GPTIMER0LD                                                            (BAM_OFFSET+0x00000080)
#define   USB_OTG_HS_GPTIMER0LD___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_GPTIMER0LD___POR                                                      0x00000000
#define   USB_OTG_HS_GPTIMER0LD__GPTLD___M                                                 0x00FFFFFF
#define   USB_OTG_HS_GPTIMER0LD__GPTLD___S                                                 0
#define   USB_OTG_HS_GPTIMER0LD___M                                                        0x00FFFFFF
#define   USB_OTG_HS_GPTIMER0LD___S                                                        0

#define USB_OTG_HS_GPTIMER0CTRL                                                          (BAM_OFFSET+0x00000084)
#define   USB_OTG_HS_GPTIMER0CTRL___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_GPTIMER0CTRL___POR                                                    0x00000000
#define   USB_OTG_HS_GPTIMER0CTRL__GTPRUN___M                                              0x80000000
#define   USB_OTG_HS_GPTIMER0CTRL__GTPRUN___S                                              31
#define   USB_OTG_HS_GPTIMER0CTRL__GPTRST___M                                              0x40000000
#define   USB_OTG_HS_GPTIMER0CTRL__GPTRST___S                                              30
#define   USB_OTG_HS_GPTIMER0CTRL__GPTMODE___M                                             0x01000000
#define   USB_OTG_HS_GPTIMER0CTRL__GPTMODE___S                                             24
#define   USB_OTG_HS_GPTIMER0CTRL__GPTCNT___M                                              0x00FFFFFF
#define   USB_OTG_HS_GPTIMER0CTRL__GPTCNT___S                                              0
#define   USB_OTG_HS_GPTIMER0CTRL___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_GPTIMER0CTRL___S                                                      0

#define USB_OTG_HS_GPTIMER1LD                                                            (BAM_OFFSET+0x00000088)
#define   USB_OTG_HS_GPTIMER1LD___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_GPTIMER1LD___POR                                                      0x00000000
#define   USB_OTG_HS_GPTIMER1LD__GPTLD___M                                                 0x00FFFFFF
#define   USB_OTG_HS_GPTIMER1LD__GPTLD___S                                                 0
#define   USB_OTG_HS_GPTIMER1LD___M                                                        0x00FFFFFF
#define   USB_OTG_HS_GPTIMER1LD___S                                                        0

#define USB_OTG_HS_GPTIMER1CTRL                                                          (BAM_OFFSET+0x0000008C)
#define   USB_OTG_HS_GPTIMER1CTRL___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_GPTIMER1CTRL___POR                                                    0x00000000
#define   USB_OTG_HS_GPTIMER1CTRL__GTPRUN___M                                              0x80000000
#define   USB_OTG_HS_GPTIMER1CTRL__GTPRUN___S                                              31
#define   USB_OTG_HS_GPTIMER1CTRL__GPTRST___M                                              0x40000000
#define   USB_OTG_HS_GPTIMER1CTRL__GPTRST___S                                              30
#define   USB_OTG_HS_GPTIMER1CTRL__GPTMODE___M                                             0x01000000
#define   USB_OTG_HS_GPTIMER1CTRL__GPTMODE___S                                             24
#define   USB_OTG_HS_GPTIMER1CTRL__GPTCNT___M                                              0x00FFFFFF
#define   USB_OTG_HS_GPTIMER1CTRL__GPTCNT___S                                              0
#define   USB_OTG_HS_GPTIMER1CTRL___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_GPTIMER1CTRL___S                                                      0

#define USB_OTG_HS_AHB_BURST                                                             (BAM_OFFSET+0x00000090)
#define   USB_OTG_HS_AHB_BURST___RWC                                                       QCSR_REG_RW
#define   USB_OTG_HS_AHB_BURST___POR                                                       0x00000000
#define   USB_OTG_HS_AHB_BURST__AHB_BURST___M                                              0x00000007
#define   USB_OTG_HS_AHB_BURST__AHB_BURST___S                                              0
#define   USB_OTG_HS_AHB_BURST___M                                                         0x00000007
#define   USB_OTG_HS_AHB_BURST___S                                                         0

#define USB_OTG_HS_XTOR_STS                                                              (BAM_OFFSET+0x00000094)
#define   USB_OTG_HS_XTOR_STS___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_XTOR_STS___POR                                                        0x00000000
#define   USB_OTG_HS_XTOR_STS__GRANT_STOLEN___M                                            0x00000002
#define   USB_OTG_HS_XTOR_STS__GRANT_STOLEN___S                                            1
#define   USB_OTG_HS_XTOR_STS___M                                                          0x00000002
#define   USB_OTG_HS_XTOR_STS___S                                                          1

#define USB_OTG_HS_AHB_MODE                                                              (BAM_OFFSET+0x00000098)
#define   USB_OTG_HS_AHB_MODE___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_AHB_MODE___POR                                                        0x00000001
#define   USB_OTG_HS_AHB_MODE__ASYNC_BRIDGES_BYPASS___M                                    0x80000000
#define   USB_OTG_HS_AHB_MODE__ASYNC_BRIDGES_BYPASS___S                                    31
#define   USB_OTG_HS_AHB_MODE__INCR_OVERRIDE___M                                           0x00000010
#define   USB_OTG_HS_AHB_MODE__INCR_OVERRIDE___S                                           4
#define   USB_OTG_HS_AHB_MODE__HPROT_MODE___M                                              0x0000000C
#define   USB_OTG_HS_AHB_MODE__HPROT_MODE___S                                              2
#define   USB_OTG_HS_AHB_MODE__GRANT_STOLEN_CLEAR___M                                      0x00000002
#define   USB_OTG_HS_AHB_MODE__GRANT_STOLEN_CLEAR___S                                      1
#define   USB_OTG_HS_AHB_MODE__XTOR_BYPASS___M                                             0x00000001
#define   USB_OTG_HS_AHB_MODE__XTOR_BYPASS___S                                             0
#define   USB_OTG_HS_AHB_MODE___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_AHB_MODE___S                                                          0

#define USB_OTG_HS_GEN_CONFIG                                                            (BAM_OFFSET+0x0000009C)
#define   USB_OTG_HS_GEN_CONFIG___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_GEN_CONFIG___POR                                                      0x00000830
#define   USB_OTG_HS_GEN_CONFIG__USB_OTG_HS_HW_QVERSION___M                                0xFFFF0000
#define   USB_OTG_HS_GEN_CONFIG__USB_OTG_HS_HW_QVERSION___S                                16
#define   USB_OTG_HS_GEN_CONFIG__SYS_CLK_SW_EN___M                                         0x00008000
#define   USB_OTG_HS_GEN_CONFIG__SYS_CLK_SW_EN___S                                         15
#define   USB_OTG_HS_GEN_CONFIG__TESTMUX_SEL_4___M                                         0x00004000
#define   USB_OTG_HS_GEN_CONFIG__TESTMUX_SEL_4___S                                         14
#define   USB_OTG_HS_GEN_CONFIG__USB_BAM_DISABLE___M                                       0x00002000
#define   USB_OTG_HS_GEN_CONFIG__USB_BAM_DISABLE___S                                       13
#define   USB_OTG_HS_GEN_CONFIG__DMA_HPROT_CTRL___M                                        0x00001000
#define   USB_OTG_HS_GEN_CONFIG__DMA_HPROT_CTRL___S                                        12
#define   USB_OTG_HS_GEN_CONFIG__ISO_FIX_EN___M                                            0x00000800
#define   USB_OTG_HS_GEN_CONFIG__ISO_FIX_EN___S                                            11
#define   USB_OTG_HS_GEN_CONFIG__DSC_PE_RST_EN___M                                         0x00000400
#define   USB_OTG_HS_GEN_CONFIG__DSC_PE_RST_EN___S                                         10
#define   USB_OTG_HS_GEN_CONFIG__HOST_SIM_TIMERS_EN_SUSP___M                               0x00000200
#define   USB_OTG_HS_GEN_CONFIG__HOST_SIM_TIMERS_EN_SUSP___S                               9
#define   USB_OTG_HS_GEN_CONFIG__HOST_SIM_TIMERS_EN_STD___M                                0x00000100
#define   USB_OTG_HS_GEN_CONFIG__HOST_SIM_TIMERS_EN_STD___S                                8
#define   USB_OTG_HS_GEN_CONFIG__PE_RX_BUF_PENDING_EN___M                                  0x00000080
#define   USB_OTG_HS_GEN_CONFIG__PE_RX_BUF_PENDING_EN___S                                  7
#define   USB_OTG_HS_GEN_CONFIG__STREAM_RX_BYPASS_ENABLE___M                               0x00000040
#define   USB_OTG_HS_GEN_CONFIG__STREAM_RX_BYPASS_ENABLE___S                               6
#define   USB_OTG_HS_GEN_CONFIG__ULPI_SERIAL_EN___M                                        0x00000020
#define   USB_OTG_HS_GEN_CONFIG__ULPI_SERIAL_EN___S                                        5
#define   USB_OTG_HS_GEN_CONFIG__PE_DP_TXFIFO_IDLE_FORCE___M                               0x00000010
#define   USB_OTG_HS_GEN_CONFIG__PE_DP_TXFIFO_IDLE_FORCE___S                               4
#define   USB_OTG_HS_GEN_CONFIG__TESTMUX_SEL_3_0___M                                       0x0000000F
#define   USB_OTG_HS_GEN_CONFIG__TESTMUX_SEL_3_0___S                                       0
#define   USB_OTG_HS_GEN_CONFIG___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_GEN_CONFIG___S                                                        0

#define USB_OTG_HS_GEN_CONFIG_2                                                          (BAM_OFFSET+0x000000A0)
#define   USB_OTG_HS_GEN_CONFIG_2___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_GEN_CONFIG_2___POR                                                    0x0000FF60
#define   USB_OTG_HS_GEN_CONFIG_2__SW_RESET_ALT_EN___M                                     0x00010000
#define   USB_OTG_HS_GEN_CONFIG_2__SW_RESET_ALT_EN___S                                     16
#define   USB_OTG_HS_GEN_CONFIG_2__DPSE_DMSE_HV_INTR_EN___M                                0x00008000
#define   USB_OTG_HS_GEN_CONFIG_2__DPSE_DMSE_HV_INTR_EN___S                                15
#define   USB_OTG_HS_GEN_CONFIG_2__USB_HW_SW_EVENTS_TOG_EN___M                             0x00004000
#define   USB_OTG_HS_GEN_CONFIG_2__USB_HW_SW_EVENTS_TOG_EN___S                             14
#define   USB_OTG_HS_GEN_CONFIG_2__SYS_CLK_HOST_DEV_GATE_EN___M                            0x00002000
#define   USB_OTG_HS_GEN_CONFIG_2__SYS_CLK_HOST_DEV_GATE_EN___S                            13
#define   USB_OTG_HS_GEN_CONFIG_2__LINESTATE_DIFF_WAKEUP_EN___M                            0x00001000
#define   USB_OTG_HS_GEN_CONFIG_2__LINESTATE_DIFF_WAKEUP_EN___S                            12
#define   USB_OTG_HS_GEN_CONFIG_2__ULPI_LPM_PEND_EN___M                                    0x00000800
#define   USB_OTG_HS_GEN_CONFIG_2__ULPI_LPM_PEND_EN___S                                    11
#define   USB_OTG_HS_GEN_CONFIG_2__RX_FULL_NAK_EN___M                                      0x00000400
#define   USB_OTG_HS_GEN_CONFIG_2__RX_FULL_NAK_EN___S                                      10
#define   USB_OTG_HS_GEN_CONFIG_2__ENDLESS_TD_EN___M                                       0x00000200
#define   USB_OTG_HS_GEN_CONFIG_2__ENDLESS_TD_EN___S                                       9
#define   USB_OTG_HS_GEN_CONFIG_2__SCRATCH_RAM_EN___M                                      0x00000100
#define   USB_OTG_HS_GEN_CONFIG_2__SCRATCH_RAM_EN___S                                      8
#define   USB_OTG_HS_GEN_CONFIG_2__SESS_VLD_CTRL_EN___M                                    0x00000080
#define   USB_OTG_HS_GEN_CONFIG_2__SESS_VLD_CTRL_EN___S                                    7
#define   USB_OTG_HS_GEN_CONFIG_2__CI_T_WTSUSRSTHS_EN___M                                  0x00000040
#define   USB_OTG_HS_GEN_CONFIG_2__CI_T_WTSUSRSTHS_EN___S                                  6
#define   USB_OTG_HS_GEN_CONFIG_2__CI_T_UCH_EN___M                                         0x00000020
#define   USB_OTG_HS_GEN_CONFIG_2__CI_T_UCH_EN___S                                         5
#define   USB_OTG_HS_GEN_CONFIG_2__DP_RESET___M                                            0x00000010
#define   USB_OTG_HS_GEN_CONFIG_2__DP_RESET___S                                            4
#define   USB_OTG_HS_GEN_CONFIG_2__ZLP_PRIME___M                                           0x00000008
#define   USB_OTG_HS_GEN_CONFIG_2__ZLP_PRIME___S                                           3
#define   USB_OTG_HS_GEN_CONFIG_2__NO_SOF_RX_FIFO_FULL___M                                 0x00000004
#define   USB_OTG_HS_GEN_CONFIG_2__NO_SOF_RX_FIFO_FULL___S                                 2
#define   USB_OTG_HS_GEN_CONFIG_2__WRONG_OPMODE_SUSP___M                                   0x00000002
#define   USB_OTG_HS_GEN_CONFIG_2__WRONG_OPMODE_SUSP___S                                   1
#define   USB_OTG_HS_GEN_CONFIG_2__RESUME_END_INTER___M                                    0x00000001
#define   USB_OTG_HS_GEN_CONFIG_2__RESUME_END_INTER___S                                    0
#define   USB_OTG_HS_GEN_CONFIG_2___M                                                      0x0001FFFF
#define   USB_OTG_HS_GEN_CONFIG_2___S                                                      0

#define USB_OTG_HS_CAPLENGTH                                                             (BAM_OFFSET+0x00000100)
#define   USB_OTG_HS_CAPLENGTH___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_CAPLENGTH___POR                                                       0x01000040
#define   USB_OTG_HS_CAPLENGTH__HCIVERSION___M                                             0xFFFF0000
#define   USB_OTG_HS_CAPLENGTH__HCIVERSION___S                                             16
#define   USB_OTG_HS_CAPLENGTH__CAPLENGTH___M                                              0x000000FF
#define   USB_OTG_HS_CAPLENGTH__CAPLENGTH___S                                              0
#define   USB_OTG_HS_CAPLENGTH___M                                                         0xFFFFFFFF
#define   USB_OTG_HS_CAPLENGTH___S                                                         0

#define USB_OTG_HS_HCSPARAMS                                                             (BAM_OFFSET+0x00000104)
#define   USB_OTG_HS_HCSPARAMS___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_HCSPARAMS___POR                                                       0x00010011
#define   USB_OTG_HS_HCSPARAMS__N_TT___M                                                   0x0F000000
#define   USB_OTG_HS_HCSPARAMS__N_TT___S                                                   24
#define   USB_OTG_HS_HCSPARAMS__N_PTT___M                                                  0x00F00000
#define   USB_OTG_HS_HCSPARAMS__N_PTT___S                                                  20
#define   USB_OTG_HS_HCSPARAMS__PI___M                                                     0x00010000
#define   USB_OTG_HS_HCSPARAMS__PI___S                                                     16
#define   USB_OTG_HS_HCSPARAMS__N_CC___M                                                   0x0000F000
#define   USB_OTG_HS_HCSPARAMS__N_CC___S                                                   12
#define   USB_OTG_HS_HCSPARAMS__N_PCC___M                                                  0x00000F00
#define   USB_OTG_HS_HCSPARAMS__N_PCC___S                                                  8
#define   USB_OTG_HS_HCSPARAMS__PPC___M                                                    0x00000010
#define   USB_OTG_HS_HCSPARAMS__PPC___S                                                    4
#define   USB_OTG_HS_HCSPARAMS__N_PORTS___M                                                0x0000000F
#define   USB_OTG_HS_HCSPARAMS__N_PORTS___S                                                0
#define   USB_OTG_HS_HCSPARAMS___M                                                         0x0FFFFFFF
#define   USB_OTG_HS_HCSPARAMS___S                                                         0

#define USB_OTG_HS_HCCPARAMS                                                             (BAM_OFFSET+0x00000108)
#define   USB_OTG_HS_HCCPARAMS___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_HCCPARAMS___POR                                                       0x00000006
#define   USB_OTG_HS_HCCPARAMS__EECP___M                                                   0x0000FF00
#define   USB_OTG_HS_HCCPARAMS__EECP___S                                                   8
#define   USB_OTG_HS_HCCPARAMS__IST___M                                                    0x000000F0
#define   USB_OTG_HS_HCCPARAMS__IST___S                                                    4
#define   USB_OTG_HS_HCCPARAMS__ASP___M                                                    0x00000004
#define   USB_OTG_HS_HCCPARAMS__ASP___S                                                    2
#define   USB_OTG_HS_HCCPARAMS__PFL___M                                                    0x00000002
#define   USB_OTG_HS_HCCPARAMS__PFL___S                                                    1
#define   USB_OTG_HS_HCCPARAMS__ADC___M                                                    0x00000001
#define   USB_OTG_HS_HCCPARAMS__ADC___S                                                    0
#define   USB_OTG_HS_HCCPARAMS___M                                                         0x0000FFFF
#define   USB_OTG_HS_HCCPARAMS___S                                                         0

#define USB_OTG_HS_DCIVERSION                                                            (BAM_OFFSET+0x00000120)
#define   USB_OTG_HS_DCIVERSION___RWC                                                      QCSR_REG_RO
#define   USB_OTG_HS_DCIVERSION___POR                                                      0x00000001
#define   USB_OTG_HS_DCIVERSION__DCIVERSION___M                                            0x0000FFFF
#define   USB_OTG_HS_DCIVERSION__DCIVERSION___S                                            0
#define   USB_OTG_HS_DCIVERSION___M                                                        0x0000FFFF
#define   USB_OTG_HS_DCIVERSION___S                                                        0

#define USB_OTG_HS_DCCPARAMS                                                             (BAM_OFFSET+0x00000124)
#define   USB_OTG_HS_DCCPARAMS___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_DCCPARAMS___POR                                                       0x00000190
#define   USB_OTG_HS_DCCPARAMS__HC___M                                                     0x00000100
#define   USB_OTG_HS_DCCPARAMS__HC___S                                                     8
#define   USB_OTG_HS_DCCPARAMS__DC___M                                                     0x00000080
#define   USB_OTG_HS_DCCPARAMS__DC___S                                                     7
#define   USB_OTG_HS_DCCPARAMS__DEN___M                                                    0x0000001F
#define   USB_OTG_HS_DCCPARAMS__DEN___S                                                    0
#define   USB_OTG_HS_DCCPARAMS___M                                                         0x000001FF
#define   USB_OTG_HS_DCCPARAMS___S                                                         0

#define USB_OTG_HS_USBCMD                                                                (BAM_OFFSET+0x00000140)
#define   USB_OTG_HS_USBCMD___RWC                                                          QCSR_REG_RW
#define   USB_OTG_HS_USBCMD___POR                                                          0x00080000
#define   USB_OTG_HS_USBCMD__RST_CTRL___M                                                  0x80000000
#define   USB_OTG_HS_USBCMD__RST_CTRL___S                                                  31
#define   USB_OTG_HS_USBCMD__ULPI_STP_CTRL___M                                             0x40000000
#define   USB_OTG_HS_USBCMD__ULPI_STP_CTRL___S                                             30
#define   USB_OTG_HS_USBCMD__ASYNC_INTR_CTRL___M                                           0x20000000
#define   USB_OTG_HS_USBCMD__ASYNC_INTR_CTRL___S                                           29
#define   USB_OTG_HS_USBCMD__SE0_GLITCH_FIX_CTRL___M                                       0x10000000
#define   USB_OTG_HS_USBCMD__SE0_GLITCH_FIX_CTRL___S                                       28
#define   USB_OTG_HS_USBCMD__FS_3_WIRE_2_WIRE_SELECT___M                                   0x08000000
#define   USB_OTG_HS_USBCMD__FS_3_WIRE_2_WIRE_SELECT___S                                   27
#define   USB_OTG_HS_USBCMD__ULPI_SER3_NOT6_SEL___M                                        0x04000000
#define   USB_OTG_HS_USBCMD__ULPI_SER3_NOT6_SEL___S                                        26
#define   USB_OTG_HS_USBCMD__SESS_VLD_CTRL___M                                             0x02000000
#define   USB_OTG_HS_USBCMD__SESS_VLD_CTRL___S                                             25
#define   USB_OTG_HS_USBCMD__ITC___M                                                       0x00FF0000
#define   USB_OTG_HS_USBCMD__ITC___S                                                       16
#define   USB_OTG_HS_USBCMD__FS2___M                                                       0x00008000
#define   USB_OTG_HS_USBCMD__FS2___S                                                       15
#define   USB_OTG_HS_USBCMD__ATDTW___M                                                     0x00004000
#define   USB_OTG_HS_USBCMD__ATDTW___S                                                     14
#define   USB_OTG_HS_USBCMD__SUTW___M                                                      0x00002000
#define   USB_OTG_HS_USBCMD__SUTW___S                                                      13
#define   USB_OTG_HS_USBCMD__ASPE___M                                                      0x00000800
#define   USB_OTG_HS_USBCMD__ASPE___S                                                      11
#define   USB_OTG_HS_USBCMD__ASP___M                                                       0x00000300
#define   USB_OTG_HS_USBCMD__ASP___S                                                       8
#define   USB_OTG_HS_USBCMD__LR___M                                                        0x00000080
#define   USB_OTG_HS_USBCMD__LR___S                                                        7
#define   USB_OTG_HS_USBCMD__IAA___M                                                       0x00000040
#define   USB_OTG_HS_USBCMD__IAA___S                                                       6
#define   USB_OTG_HS_USBCMD__ASE___M                                                       0x00000020
#define   USB_OTG_HS_USBCMD__ASE___S                                                       5
#define   USB_OTG_HS_USBCMD__PSE___M                                                       0x00000010
#define   USB_OTG_HS_USBCMD__PSE___S                                                       4
#define   USB_OTG_HS_USBCMD__FS___M                                                        0x0000000C
#define   USB_OTG_HS_USBCMD__FS___S                                                        2
#define   USB_OTG_HS_USBCMD__RST___M                                                       0x00000002
#define   USB_OTG_HS_USBCMD__RST___S                                                       1
#define   USB_OTG_HS_USBCMD__RS___M                                                        0x00000001
#define   USB_OTG_HS_USBCMD__RS___S                                                        0
#define   USB_OTG_HS_USBCMD___M                                                            0xFFFFFFFF
#define   USB_OTG_HS_USBCMD___S                                                            0

#define USB_OTG_HS_USBSTS                                                                (BAM_OFFSET+0x00000144)
#define   USB_OTG_HS_USBSTS___RWC                                                          QCSR_REG_RW
#define   USB_OTG_HS_USBSTS___POR                                                          0x00000000
#define   USB_OTG_HS_USBSTS__ULPI_INTR___M                                                 0x80000000
#define   USB_OTG_HS_USBSTS__ULPI_INTR___S                                                 31
#define   USB_OTG_HS_USBSTS__PHY_SESS_VLD_CHG___M                                          0x40000000
#define   USB_OTG_HS_USBSTS__PHY_SESS_VLD_CHG___S                                          30
#define   USB_OTG_HS_USBSTS__PHY_SESS_VLD___M                                              0x20000000
#define   USB_OTG_HS_USBSTS__PHY_SESS_VLD___S                                              29
#define   USB_OTG_HS_USBSTS__PHY_ALT_INT___M                                               0x10000000
#define   USB_OTG_HS_USBSTS__PHY_ALT_INT___S                                               28
#define   USB_OTG_HS_USBSTS__ASYNC_WAKEUP_INTR___M                                         0x08000000
#define   USB_OTG_HS_USBSTS__ASYNC_WAKEUP_INTR___S                                         27
#define   USB_OTG_HS_USBSTS__TI1___M                                                       0x02000000
#define   USB_OTG_HS_USBSTS__TI1___S                                                       25
#define   USB_OTG_HS_USBSTS__TI0___M                                                       0x01000000
#define   USB_OTG_HS_USBSTS__TI0___S                                                       24
#define   USB_OTG_HS_USBSTS__UPI___M                                                       0x00080000
#define   USB_OTG_HS_USBSTS__UPI___S                                                       19
#define   USB_OTG_HS_USBSTS__UAI___M                                                       0x00040000
#define   USB_OTG_HS_USBSTS__UAI___S                                                       18
#define   USB_OTG_HS_USBSTS__NAKI___M                                                      0x00010000
#define   USB_OTG_HS_USBSTS__NAKI___S                                                      16
#define   USB_OTG_HS_USBSTS__AS___M                                                        0x00008000
#define   USB_OTG_HS_USBSTS__AS___S                                                        15
#define   USB_OTG_HS_USBSTS__PS___M                                                        0x00004000
#define   USB_OTG_HS_USBSTS__PS___S                                                        14
#define   USB_OTG_HS_USBSTS__RCL___M                                                       0x00002000
#define   USB_OTG_HS_USBSTS__RCL___S                                                       13
#define   USB_OTG_HS_USBSTS__HCH___M                                                       0x00001000
#define   USB_OTG_HS_USBSTS__HCH___S                                                       12
#define   USB_OTG_HS_USBSTS__ULPII___M                                                     0x00000400
#define   USB_OTG_HS_USBSTS__ULPII___S                                                     10
#define   USB_OTG_HS_USBSTS__SLI___M                                                       0x00000100
#define   USB_OTG_HS_USBSTS__SLI___S                                                       8
#define   USB_OTG_HS_USBSTS__SRI___M                                                       0x00000080
#define   USB_OTG_HS_USBSTS__SRI___S                                                       7
#define   USB_OTG_HS_USBSTS__URI___M                                                       0x00000040
#define   USB_OTG_HS_USBSTS__URI___S                                                       6
#define   USB_OTG_HS_USBSTS__AAI___M                                                       0x00000020
#define   USB_OTG_HS_USBSTS__AAI___S                                                       5
#define   USB_OTG_HS_USBSTS__SEI___M                                                       0x00000010
#define   USB_OTG_HS_USBSTS__SEI___S                                                       4
#define   USB_OTG_HS_USBSTS__FRI___M                                                       0x00000008
#define   USB_OTG_HS_USBSTS__FRI___S                                                       3
#define   USB_OTG_HS_USBSTS__PCI___M                                                       0x00000004
#define   USB_OTG_HS_USBSTS__PCI___S                                                       2
#define   USB_OTG_HS_USBSTS__UEI___M                                                       0x00000002
#define   USB_OTG_HS_USBSTS__UEI___S                                                       1
#define   USB_OTG_HS_USBSTS__UI___M                                                        0x00000001
#define   USB_OTG_HS_USBSTS__UI___S                                                        0
#define   USB_OTG_HS_USBSTS___M                                                            0xFFFFFFFF
#define   USB_OTG_HS_USBSTS___S                                                            0

#define USB_OTG_HS_USBINTR                                                               (BAM_OFFSET+0x00000148)
#define   USB_OTG_HS_USBINTR___RWC                                                         QCSR_REG_RW
#define   USB_OTG_HS_USBINTR___POR                                                         0x00000000
#define   USB_OTG_HS_USBINTR__ULPI_INTR_EN___M                                             0x80000000
#define   USB_OTG_HS_USBINTR__ULPI_INTR_EN___S                                             31
#define   USB_OTG_HS_USBINTR__PHY_SESS_VLD_CHG_EN___M                                      0x40000000
#define   USB_OTG_HS_USBINTR__PHY_SESS_VLD_CHG_EN___S                                      30
#define   USB_OTG_HS_USBINTR__TIE1___M                                                     0x02000000
#define   USB_OTG_HS_USBINTR__TIE1___S                                                     25
#define   USB_OTG_HS_USBINTR__TIE0___M                                                     0x01000000
#define   USB_OTG_HS_USBINTR__TIE0___S                                                     24
#define   USB_OTG_HS_USBINTR__UPIE___M                                                     0x00080000
#define   USB_OTG_HS_USBINTR__UPIE___S                                                     19
#define   USB_OTG_HS_USBINTR__UAIE___M                                                     0x00040000
#define   USB_OTG_HS_USBINTR__UAIE___S                                                     18
#define   USB_OTG_HS_USBINTR__NAKE___M                                                     0x00010000
#define   USB_OTG_HS_USBINTR__NAKE___S                                                     16
#define   USB_OTG_HS_USBINTR__ULPIE___M                                                    0x00000400
#define   USB_OTG_HS_USBINTR__ULPIE___S                                                    10
#define   USB_OTG_HS_USBINTR__SLE___M                                                      0x00000100
#define   USB_OTG_HS_USBINTR__SLE___S                                                      8
#define   USB_OTG_HS_USBINTR__SRE___M                                                      0x00000080
#define   USB_OTG_HS_USBINTR__SRE___S                                                      7
#define   USB_OTG_HS_USBINTR__URE___M                                                      0x00000040
#define   USB_OTG_HS_USBINTR__URE___S                                                      6
#define   USB_OTG_HS_USBINTR__AAE___M                                                      0x00000020
#define   USB_OTG_HS_USBINTR__AAE___S                                                      5
#define   USB_OTG_HS_USBINTR__SEE___M                                                      0x00000010
#define   USB_OTG_HS_USBINTR__SEE___S                                                      4
#define   USB_OTG_HS_USBINTR__FRE___M                                                      0x00000008
#define   USB_OTG_HS_USBINTR__FRE___S                                                      3
#define   USB_OTG_HS_USBINTR__PCE___M                                                      0x00000004
#define   USB_OTG_HS_USBINTR__PCE___S                                                      2
#define   USB_OTG_HS_USBINTR__UEE___M                                                      0x00000002
#define   USB_OTG_HS_USBINTR__UEE___S                                                      1
#define   USB_OTG_HS_USBINTR__UE___M                                                       0x00000001
#define   USB_OTG_HS_USBINTR__UE___S                                                       0
#define   USB_OTG_HS_USBINTR___M                                                           0xFFFFFFFF
#define   USB_OTG_HS_USBINTR___S                                                           0

#define USB_OTG_HS_FRINDEX                                                               (BAM_OFFSET+0x0000014C)
#define   USB_OTG_HS_FRINDEX___RWC                                                         QCSR_REG_RW
#define   USB_OTG_HS_FRINDEX___POR                                                         0x00000000
#define   USB_OTG_HS_FRINDEX__FRINDEX___M                                                  0x00003FFF
#define   USB_OTG_HS_FRINDEX__FRINDEX___S                                                  0
#define   USB_OTG_HS_FRINDEX___M                                                           0x00003FFF
#define   USB_OTG_HS_FRINDEX___S                                                           0

#define USB_OTG_HS_PERIODICLISTBASE                                                      (BAM_OFFSET+0x00000154)
#define   USB_OTG_HS_PERIODICLISTBASE___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_PERIODICLISTBASE___POR                                                0x00000000
#define   USB_OTG_HS_PERIODICLISTBASE__PERBASE___M                                         0xFFFFF000
#define   USB_OTG_HS_PERIODICLISTBASE__PERBASE___S                                         12
#define   USB_OTG_HS_PERIODICLISTBASE___M                                                  0xFFFFF000
#define   USB_OTG_HS_PERIODICLISTBASE___S                                                  12

#define USB_OTG_HS_DEVICEADDR                                                            (BAM_OFFSET+0x00000154)
#define   USB_OTG_HS_DEVICEADDR___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_DEVICEADDR___POR                                                      0x00000000
#define   USB_OTG_HS_DEVICEADDR__USBADR___M                                                0xFE000000
#define   USB_OTG_HS_DEVICEADDR__USBADR___S                                                25
#define   USB_OTG_HS_DEVICEADDR__USBADRA___M                                               0x01000000
#define   USB_OTG_HS_DEVICEADDR__USBADRA___S                                               24
#define   USB_OTG_HS_DEVICEADDR___M                                                        0xFF000000
#define   USB_OTG_HS_DEVICEADDR___S                                                        24

#define USB_OTG_HS_ASYNCLISTADDR                                                         (BAM_OFFSET+0x00000158)
#define   USB_OTG_HS_ASYNCLISTADDR___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_ASYNCLISTADDR___POR                                                   0x00000000
#define   USB_OTG_HS_ASYNCLISTADDR__ASYBASE___M                                            0xFFFFFFE0
#define   USB_OTG_HS_ASYNCLISTADDR__ASYBASE___S                                            5
#define   USB_OTG_HS_ASYNCLISTADDR___M                                                     0xFFFFFFE0
#define   USB_OTG_HS_ASYNCLISTADDR___S                                                     5

#define USB_OTG_HS_ENDPOINTLISTADDR                                                      (BAM_OFFSET+0x00000158)
#define   USB_OTG_HS_ENDPOINTLISTADDR___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_ENDPOINTLISTADDR___POR                                                0x00000000
#define   USB_OTG_HS_ENDPOINTLISTADDR__EPBASE___M                                          0xFFFFF800
#define   USB_OTG_HS_ENDPOINTLISTADDR__EPBASE___S                                          11
#define   USB_OTG_HS_ENDPOINTLISTADDR___M                                                  0xFFFFF800
#define   USB_OTG_HS_ENDPOINTLISTADDR___S                                                  11

#define USB_OTG_HS_TTCTRL                                                                (BAM_OFFSET+0x0000015C)
#define   USB_OTG_HS_TTCTRL___RWC                                                          QCSR_REG_RW
#define   USB_OTG_HS_TTCTRL___POR                                                          0x00000000
#define   USB_OTG_HS_TTCTRL__TTHA___M                                                      0x7F000000
#define   USB_OTG_HS_TTCTRL__TTHA___S                                                      24
#define   USB_OTG_HS_TTCTRL___M                                                            0x7F000000
#define   USB_OTG_HS_TTCTRL___S                                                            24

#define USB_OTG_HS_BURSTSIZE                                                             (BAM_OFFSET+0x00000160)
#define   USB_OTG_HS_BURSTSIZE___RWC                                                       QCSR_REG_RW
#define   USB_OTG_HS_BURSTSIZE___POR                                                       0x00001010
#define   USB_OTG_HS_BURSTSIZE__TXPBURST___M                                               0x0000FF00
#define   USB_OTG_HS_BURSTSIZE__TXPBURST___S                                               8
#define   USB_OTG_HS_BURSTSIZE__RXPBURST___M                                               0x000000FF
#define   USB_OTG_HS_BURSTSIZE__RXPBURST___S                                               0
#define   USB_OTG_HS_BURSTSIZE___M                                                         0x0000FFFF
#define   USB_OTG_HS_BURSTSIZE___S                                                         0

#define USB_OTG_HS_TXFILLTUNING                                                          (BAM_OFFSET+0x00000164)
#define   USB_OTG_HS_TXFILLTUNING___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_TXFILLTUNING___POR                                                    0x00000000
#define   USB_OTG_HS_TXFILLTUNING__TXFIFOTHRES___M                                         0x003F0000
#define   USB_OTG_HS_TXFILLTUNING__TXFIFOTHRES___S                                         16
#define   USB_OTG_HS_TXFILLTUNING__TXSCHHEALTH___M                                         0x00001F00
#define   USB_OTG_HS_TXFILLTUNING__TXSCHHEALTH___S                                         8
#define   USB_OTG_HS_TXFILLTUNING__TXSCHOH___M                                             0x000000FF
#define   USB_OTG_HS_TXFILLTUNING__TXSCHOH___S                                             0
#define   USB_OTG_HS_TXFILLTUNING___M                                                      0x003FFFFF
#define   USB_OTG_HS_TXFILLTUNING___S                                                      0

#define USB_OTG_HS_ULPI_VIEWPORT                                                         (BAM_OFFSET+0x00000170)
#define   USB_OTG_HS_ULPI_VIEWPORT___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_ULPI_VIEWPORT___POR                                                   0x08000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIWU___M                                             0x80000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIWU___S                                             31
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIRUN___M                                            0x40000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIRUN___S                                            30
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIRW___M                                             0x20000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIRW___S                                             29
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIFORCE___M                                          0x10000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIFORCE___S                                          28
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPISS___M                                             0x08000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPISS___S                                             27
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIPORT___M                                           0x07000000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIPORT___S                                           24
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIADDR___M                                           0x00FF0000
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIADDR___S                                           16
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIDATRD___M                                          0x0000FF00
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIDATRD___S                                          8
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIDATWR___M                                          0x000000FF
#define   USB_OTG_HS_ULPI_VIEWPORT__ULPIDATWR___S                                          0
#define   USB_OTG_HS_ULPI_VIEWPORT___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_ULPI_VIEWPORT___S                                                     0

#define USB_OTG_HS_ENDPTNAK                                                              (BAM_OFFSET+0x00000178)
#define   USB_OTG_HS_ENDPTNAK___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_ENDPTNAK___POR                                                        0x00000000
#define   USB_OTG_HS_ENDPTNAK__EPTN___M                                                    0xFFFF0000
#define   USB_OTG_HS_ENDPTNAK__EPTN___S                                                    16
#define   USB_OTG_HS_ENDPTNAK__EPRN___M                                                    0x0000FFFF
#define   USB_OTG_HS_ENDPTNAK__EPRN___S                                                    0
#define   USB_OTG_HS_ENDPTNAK___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_ENDPTNAK___S                                                          0

#define USB_OTG_HS_ENDPTNAKEN                                                            (BAM_OFFSET+0x0000017C)
#define   USB_OTG_HS_ENDPTNAKEN___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTNAKEN___POR                                                      0x00000000
#define   USB_OTG_HS_ENDPTNAKEN__EPTNE___M                                                 0xFFFF0000
#define   USB_OTG_HS_ENDPTNAKEN__EPTNE___S                                                 16
#define   USB_OTG_HS_ENDPTNAKEN__EPRNE___M                                                 0x0000FFFF
#define   USB_OTG_HS_ENDPTNAKEN__EPRNE___S                                                 0
#define   USB_OTG_HS_ENDPTNAKEN___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_ENDPTNAKEN___S                                                        0

#define USB_OTG_HS_PORTSC                                                                (BAM_OFFSET+0x00000184)
#define   USB_OTG_HS_PORTSC___RWC                                                          QCSR_REG_RW
#define   USB_OTG_HS_PORTSC___POR                                                          0xCC000004
#define   USB_OTG_HS_PORTSC__PTS___M                                                       0xC0000000
#define   USB_OTG_HS_PORTSC__PTS___S                                                       30
#define   USB_OTG_HS_PORTSC__STS___M                                                       0x20000000
#define   USB_OTG_HS_PORTSC__STS___S                                                       29
#define   USB_OTG_HS_PORTSC__PTW___M                                                       0x10000000
#define   USB_OTG_HS_PORTSC__PTW___S                                                       28
#define   USB_OTG_HS_PORTSC__PSPD___M                                                      0x0C000000
#define   USB_OTG_HS_PORTSC__PSPD___S                                                      26
#define   USB_OTG_HS_PORTSC__SPRT___M                                                      0x02000000
#define   USB_OTG_HS_PORTSC__SPRT___S                                                      25
#define   USB_OTG_HS_PORTSC__PFSC___M                                                      0x01000000
#define   USB_OTG_HS_PORTSC__PFSC___S                                                      24
#define   USB_OTG_HS_PORTSC__PHCD___M                                                      0x00800000
#define   USB_OTG_HS_PORTSC__PHCD___S                                                      23
#define   USB_OTG_HS_PORTSC__WKOC___M                                                      0x00400000
#define   USB_OTG_HS_PORTSC__WKOC___S                                                      22
#define   USB_OTG_HS_PORTSC__WKDS___M                                                      0x00200000
#define   USB_OTG_HS_PORTSC__WKDS___S                                                      21
#define   USB_OTG_HS_PORTSC__WKCN___M                                                      0x00100000
#define   USB_OTG_HS_PORTSC__WKCN___S                                                      20
#define   USB_OTG_HS_PORTSC__PTC___M                                                       0x000F0000
#define   USB_OTG_HS_PORTSC__PTC___S                                                       16
#define   USB_OTG_HS_PORTSC__PIC___M                                                       0x0000C000
#define   USB_OTG_HS_PORTSC__PIC___S                                                       14
#define   USB_OTG_HS_PORTSC__PO___M                                                        0x00002000
#define   USB_OTG_HS_PORTSC__PO___S                                                        13
#define   USB_OTG_HS_PORTSC__PP___M                                                        0x00001000
#define   USB_OTG_HS_PORTSC__PP___S                                                        12
#define   USB_OTG_HS_PORTSC__LS___M                                                        0x00000C00
#define   USB_OTG_HS_PORTSC__LS___S                                                        10
#define   USB_OTG_HS_PORTSC__HSP___M                                                       0x00000200
#define   USB_OTG_HS_PORTSC__HSP___S                                                       9
#define   USB_OTG_HS_PORTSC__PR___M                                                        0x00000100
#define   USB_OTG_HS_PORTSC__PR___S                                                        8
#define   USB_OTG_HS_PORTSC__SUSP___M                                                      0x00000080
#define   USB_OTG_HS_PORTSC__SUSP___S                                                      7
#define   USB_OTG_HS_PORTSC__FPR___M                                                       0x00000040
#define   USB_OTG_HS_PORTSC__FPR___S                                                       6
#define   USB_OTG_HS_PORTSC__OCC___M                                                       0x00000020
#define   USB_OTG_HS_PORTSC__OCC___S                                                       5
#define   USB_OTG_HS_PORTSC__OCA___M                                                       0x00000010
#define   USB_OTG_HS_PORTSC__OCA___S                                                       4
#define   USB_OTG_HS_PORTSC__PEC___M                                                       0x00000008
#define   USB_OTG_HS_PORTSC__PEC___S                                                       3
#define   USB_OTG_HS_PORTSC__PE___M                                                        0x00000004
#define   USB_OTG_HS_PORTSC__PE___S                                                        2
#define   USB_OTG_HS_PORTSC__CSC___M                                                       0x00000002
#define   USB_OTG_HS_PORTSC__CSC___S                                                       1
#define   USB_OTG_HS_PORTSC__CCS___M                                                       0x00000001
#define   USB_OTG_HS_PORTSC__CCS___S                                                       0
#define   USB_OTG_HS_PORTSC___M                                                            0xFFFFFFFF
#define   USB_OTG_HS_PORTSC___S                                                            0

#define USB_OTG_HS_OTGSC                                                                 (BAM_OFFSET+0x000001A4)
#define   USB_OTG_HS_OTGSC___RWC                                                           QCSR_REG_RW
#define   USB_OTG_HS_OTGSC___POR                                                           0x00000E20
#define   USB_OTG_HS_OTGSC__DPIE___M                                                       0x40000000
#define   USB_OTG_HS_OTGSC__DPIE___S                                                       30
#define   USB_OTG_HS_OTGSC__FIELD_1MSE___M                                                 0x20000000
#define   USB_OTG_HS_OTGSC__FIELD_1MSE___S                                                 29
#define   USB_OTG_HS_OTGSC__BSEIE___M                                                      0x10000000
#define   USB_OTG_HS_OTGSC__BSEIE___S                                                      28
#define   USB_OTG_HS_OTGSC__BSVIE___M                                                      0x08000000
#define   USB_OTG_HS_OTGSC__BSVIE___S                                                      27
#define   USB_OTG_HS_OTGSC__ASVIE___M                                                      0x04000000
#define   USB_OTG_HS_OTGSC__ASVIE___S                                                      26
#define   USB_OTG_HS_OTGSC__AVVIE___M                                                      0x02000000
#define   USB_OTG_HS_OTGSC__AVVIE___S                                                      25
#define   USB_OTG_HS_OTGSC__IDIE___M                                                       0x01000000
#define   USB_OTG_HS_OTGSC__IDIE___S                                                       24
#define   USB_OTG_HS_OTGSC__DPIS___M                                                       0x00400000
#define   USB_OTG_HS_OTGSC__DPIS___S                                                       22
#define   USB_OTG_HS_OTGSC__FIELD_1MSS___M                                                 0x00200000
#define   USB_OTG_HS_OTGSC__FIELD_1MSS___S                                                 21
#define   USB_OTG_HS_OTGSC__BSEIS___M                                                      0x00100000
#define   USB_OTG_HS_OTGSC__BSEIS___S                                                      20
#define   USB_OTG_HS_OTGSC__BSVIS___M                                                      0x00080000
#define   USB_OTG_HS_OTGSC__BSVIS___S                                                      19
#define   USB_OTG_HS_OTGSC__ASVIS___M                                                      0x00040000
#define   USB_OTG_HS_OTGSC__ASVIS___S                                                      18
#define   USB_OTG_HS_OTGSC__AVVIS___M                                                      0x00020000
#define   USB_OTG_HS_OTGSC__AVVIS___S                                                      17
#define   USB_OTG_HS_OTGSC__IDIS___M                                                       0x00010000
#define   USB_OTG_HS_OTGSC__IDIS___S                                                       16
#define   USB_OTG_HS_OTGSC__DPS___M                                                        0x00004000
#define   USB_OTG_HS_OTGSC__DPS___S                                                        14
#define   USB_OTG_HS_OTGSC__FIELD_1MST___M                                                 0x00002000
#define   USB_OTG_HS_OTGSC__FIELD_1MST___S                                                 13
#define   USB_OTG_HS_OTGSC__BSE___M                                                        0x00001000
#define   USB_OTG_HS_OTGSC__BSE___S                                                        12
#define   USB_OTG_HS_OTGSC__BSV___M                                                        0x00000800
#define   USB_OTG_HS_OTGSC__BSV___S                                                        11
#define   USB_OTG_HS_OTGSC__ASV___M                                                        0x00000400
#define   USB_OTG_HS_OTGSC__ASV___S                                                        10
#define   USB_OTG_HS_OTGSC__AVV___M                                                        0x00000200
#define   USB_OTG_HS_OTGSC__AVV___S                                                        9
#define   USB_OTG_HS_OTGSC__ID___M                                                         0x00000100
#define   USB_OTG_HS_OTGSC__ID___S                                                         8
#define   USB_OTG_HS_OTGSC__HABA___M                                                       0x00000080
#define   USB_OTG_HS_OTGSC__HABA___S                                                       7
#define   USB_OTG_HS_OTGSC__HADP___M                                                       0x00000040
#define   USB_OTG_HS_OTGSC__HADP___S                                                       6
#define   USB_OTG_HS_OTGSC__IDPU___M                                                       0x00000020
#define   USB_OTG_HS_OTGSC__IDPU___S                                                       5
#define   USB_OTG_HS_OTGSC__DP___M                                                         0x00000010
#define   USB_OTG_HS_OTGSC__DP___S                                                         4
#define   USB_OTG_HS_OTGSC__OT___M                                                         0x00000008
#define   USB_OTG_HS_OTGSC__OT___S                                                         3
#define   USB_OTG_HS_OTGSC__HAAR___M                                                       0x00000004
#define   USB_OTG_HS_OTGSC__HAAR___S                                                       2
#define   USB_OTG_HS_OTGSC__VC___M                                                         0x00000002
#define   USB_OTG_HS_OTGSC__VC___S                                                         1
#define   USB_OTG_HS_OTGSC__VD___M                                                         0x00000001
#define   USB_OTG_HS_OTGSC__VD___S                                                         0
#define   USB_OTG_HS_OTGSC___M                                                             0x7FFFFFFF
#define   USB_OTG_HS_OTGSC___S                                                             0

#define USB_OTG_HS_USBMODE                                                               (BAM_OFFSET+0x000001A8)
#define   USB_OTG_HS_USBMODE___RWC                                                         QCSR_REG_RW
#define   USB_OTG_HS_USBMODE___POR                                                         0x00000000
#define   USB_OTG_HS_USBMODE__VBPS___M                                                     0x00000020
#define   USB_OTG_HS_USBMODE__VBPS___S                                                     5
#define   USB_OTG_HS_USBMODE__SDIS___M                                                     0x00000010
#define   USB_OTG_HS_USBMODE__SDIS___S                                                     4
#define   USB_OTG_HS_USBMODE__SLOM___M                                                     0x00000008
#define   USB_OTG_HS_USBMODE__SLOM___S                                                     3
#define   USB_OTG_HS_USBMODE__ES___M                                                       0x00000004
#define   USB_OTG_HS_USBMODE__ES___S                                                       2
#define   USB_OTG_HS_USBMODE__CM___M                                                       0x00000003
#define   USB_OTG_HS_USBMODE__CM___S                                                       0
#define   USB_OTG_HS_USBMODE___M                                                           0x0000003F
#define   USB_OTG_HS_USBMODE___S                                                           0

#define USB_OTG_HS_ENDPTSETUPSTAT                                                        (BAM_OFFSET+0x000001AC)
#define   USB_OTG_HS_ENDPTSETUPSTAT___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPTSETUPSTAT___POR                                                  0x00000000
#define   USB_OTG_HS_ENDPTSETUPSTAT__ENDPTSETUPSTAT___M                                    0x0000FFFF
#define   USB_OTG_HS_ENDPTSETUPSTAT__ENDPTSETUPSTAT___S                                    0
#define   USB_OTG_HS_ENDPTSETUPSTAT___M                                                    0x0000FFFF
#define   USB_OTG_HS_ENDPTSETUPSTAT___S                                                    0

#define USB_OTG_HS_ENDPTPRIME                                                            (BAM_OFFSET+0x000001B0)
#define   USB_OTG_HS_ENDPTPRIME___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTPRIME___POR                                                      0x00000000
#define   USB_OTG_HS_ENDPTPRIME__PETB___M                                                  0xFFFF0000
#define   USB_OTG_HS_ENDPTPRIME__PETB___S                                                  16
#define   USB_OTG_HS_ENDPTPRIME__PERB___M                                                  0x0000FFFF
#define   USB_OTG_HS_ENDPTPRIME__PERB___S                                                  0
#define   USB_OTG_HS_ENDPTPRIME___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_ENDPTPRIME___S                                                        0

#define USB_OTG_HS_ENDPTFLUSH                                                            (BAM_OFFSET+0x000001B4)
#define   USB_OTG_HS_ENDPTFLUSH___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTFLUSH___POR                                                      0x00000000
#define   USB_OTG_HS_ENDPTFLUSH__FETB___M                                                  0xFFFF0000
#define   USB_OTG_HS_ENDPTFLUSH__FETB___S                                                  16
#define   USB_OTG_HS_ENDPTFLUSH__FERB___M                                                  0x0000FFFF
#define   USB_OTG_HS_ENDPTFLUSH__FERB___S                                                  0
#define   USB_OTG_HS_ENDPTFLUSH___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_ENDPTFLUSH___S                                                        0

#define USB_OTG_HS_ENDPTSTAT                                                             (BAM_OFFSET+0x000001B8)
#define   USB_OTG_HS_ENDPTSTAT___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_ENDPTSTAT___POR                                                       0x00000000
#define   USB_OTG_HS_ENDPTSTAT__ETBR___M                                                   0xFFFF0000
#define   USB_OTG_HS_ENDPTSTAT__ETBR___S                                                   16
#define   USB_OTG_HS_ENDPTSTAT__ERBR___M                                                   0x0000FFFF
#define   USB_OTG_HS_ENDPTSTAT__ERBR___S                                                   0
#define   USB_OTG_HS_ENDPTSTAT___M                                                         0xFFFFFFFF
#define   USB_OTG_HS_ENDPTSTAT___S                                                         0

#define USB_OTG_HS_ENDPTCOMPLETE                                                         (BAM_OFFSET+0x000001BC)
#define   USB_OTG_HS_ENDPTCOMPLETE___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCOMPLETE___POR                                                   0x00000000
#define   USB_OTG_HS_ENDPTCOMPLETE__ETCE___M                                               0xFFFF0000
#define   USB_OTG_HS_ENDPTCOMPLETE__ETCE___S                                               16
#define   USB_OTG_HS_ENDPTCOMPLETE__ERCE___M                                               0x0000FFFF
#define   USB_OTG_HS_ENDPTCOMPLETE__ERCE___S                                               0
#define   USB_OTG_HS_ENDPTCOMPLETE___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_ENDPTCOMPLETE___S                                                     0

#define USB_OTG_HS_ENDPTCTRL0                                                            (BAM_OFFSET+0x000001C0)
#define   USB_OTG_HS_ENDPTCTRL0___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL0___POR                                                      0x00800080
#define   USB_OTG_HS_ENDPTCTRL0__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL0__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL0__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL0__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL0__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL0__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL0__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL0__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL0__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL0__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL0__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL0__RXS___S                                                   0
#define   USB_OTG_HS_ENDPTCTRL0___M                                                        0x00FFFFFF
#define   USB_OTG_HS_ENDPTCTRL0___S                                                        0

#define USB_OTG_HS_ENDPTCTRLn(n)                                              (BAM_OFFSET+0x000001C0+0x4*(n))
#define   USB_OTG_HS_ENDPTCTRLn_nMIN                           1
#define   USB_OTG_HS_ENDPTCTRLn_nMAX                           15
#define   USB_OTG_HS_ENDPTCTRLn_ELEM                           15
#define   USB_OTG_HS_ENDPTCTRLn___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRLn___POR                                                      0x00000000
#define   USB_OTG_HS_ENDPTCTRLn__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRLn__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRLn__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRLn__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRLn__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRLn__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRLn__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRLn__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRLn__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRLn__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRLn__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRLn__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRLn__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRLn__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRLn__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRLn__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRLn__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRLn__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRLn__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRLn__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRLn__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRLn__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRLn__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRLn__RXS___S                                                   0
#define   USB_OTG_HS_ENDPTCTRLn___M                                                        0x00FFFFFF
#define   USB_OTG_HS_ENDPTCTRLn___S                                                        0
#define USB_OTG_HS_ENDPTCTRL1                                                            (BAM_OFFSET+0x000001C4)
#define   USB_OTG_HS_ENDPTCTRL1___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL1__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL1__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL1__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL1__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL1__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL1__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL1__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL1__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL1__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL1__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL1__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL1__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL1__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL1__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL1__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL1__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL1__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL1__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL1__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL1__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL1__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL1__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL1__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL1__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL2                                                            (BAM_OFFSET+0x000001C8)
#define   USB_OTG_HS_ENDPTCTRL2___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL2__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL2__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL2__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL2__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL2__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL2__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL2__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL2__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL2__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL2__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL2__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL2__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL2__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL2__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL2__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL2__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL2__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL2__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL2__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL2__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL2__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL2__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL2__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL2__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL3                                                            (BAM_OFFSET+0x000001CC)
#define   USB_OTG_HS_ENDPTCTRL3___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL3__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL3__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL3__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL3__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL3__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL3__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL3__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL3__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL3__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL3__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL3__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL3__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL3__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL3__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL3__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL3__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL3__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL3__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL3__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL3__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL3__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL3__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL3__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL3__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL4                                                            (BAM_OFFSET+0x000001D0)
#define   USB_OTG_HS_ENDPTCTRL4___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL4__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL4__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL4__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL4__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL4__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL4__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL4__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL4__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL4__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL4__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL4__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL4__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL4__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL4__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL4__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL4__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL4__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL4__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL4__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL4__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL4__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL4__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL4__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL4__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL5                                                            (BAM_OFFSET+0x000001D4)
#define   USB_OTG_HS_ENDPTCTRL5___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL5__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL5__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL5__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL5__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL5__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL5__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL5__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL5__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL5__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL5__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL5__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL5__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL5__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL5__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL5__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL5__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL5__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL5__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL5__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL5__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL5__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL5__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL5__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL5__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL6                                                            (BAM_OFFSET+0x000001D8)
#define   USB_OTG_HS_ENDPTCTRL6___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL6__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL6__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL6__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL6__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL6__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL6__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL6__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL6__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL6__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL6__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL6__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL6__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL6__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL6__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL6__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL6__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL6__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL6__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL6__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL6__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL6__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL6__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL6__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL6__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL7                                                            (BAM_OFFSET+0x000001DC)
#define   USB_OTG_HS_ENDPTCTRL7___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL7__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL7__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL7__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL7__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL7__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL7__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL7__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL7__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL7__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL7__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL7__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL7__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL7__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL7__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL7__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL7__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL7__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL7__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL7__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL7__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL7__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL7__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL7__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL7__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL8                                                            (BAM_OFFSET+0x000001E0)
#define   USB_OTG_HS_ENDPTCTRL8___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL8__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL8__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL8__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL8__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL8__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL8__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL8__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL8__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL8__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL8__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL8__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL8__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL8__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL8__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL8__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL8__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL8__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL8__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL8__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL8__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL8__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL8__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL8__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL8__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL9                                                            (BAM_OFFSET+0x000001E4)
#define   USB_OTG_HS_ENDPTCTRL9___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL9__TXE___M                                                   0x00800000
#define   USB_OTG_HS_ENDPTCTRL9__TXE___S                                                   23
#define   USB_OTG_HS_ENDPTCTRL9__TXR___M                                                   0x00400000
#define   USB_OTG_HS_ENDPTCTRL9__TXR___S                                                   22
#define   USB_OTG_HS_ENDPTCTRL9__TXI___M                                                   0x00200000
#define   USB_OTG_HS_ENDPTCTRL9__TXI___S                                                   21
#define   USB_OTG_HS_ENDPTCTRL9__TXT___M                                                   0x000C0000
#define   USB_OTG_HS_ENDPTCTRL9__TXT___S                                                   18
#define   USB_OTG_HS_ENDPTCTRL9__TXD___M                                                   0x00020000
#define   USB_OTG_HS_ENDPTCTRL9__TXD___S                                                   17
#define   USB_OTG_HS_ENDPTCTRL9__TXS___M                                                   0x00010000
#define   USB_OTG_HS_ENDPTCTRL9__TXS___S                                                   16
#define   USB_OTG_HS_ENDPTCTRL9__RXE___M                                                   0x00000080
#define   USB_OTG_HS_ENDPTCTRL9__RXE___S                                                   7
#define   USB_OTG_HS_ENDPTCTRL9__RXR___M                                                   0x00000040
#define   USB_OTG_HS_ENDPTCTRL9__RXR___S                                                   6
#define   USB_OTG_HS_ENDPTCTRL9__RXI___M                                                   0x00000020
#define   USB_OTG_HS_ENDPTCTRL9__RXI___S                                                   5
#define   USB_OTG_HS_ENDPTCTRL9__RXT___M                                                   0x0000000C
#define   USB_OTG_HS_ENDPTCTRL9__RXT___S                                                   2
#define   USB_OTG_HS_ENDPTCTRL9__RXD___M                                                   0x00000002
#define   USB_OTG_HS_ENDPTCTRL9__RXD___S                                                   1
#define   USB_OTG_HS_ENDPTCTRL9__RXS___M                                                   0x00000001
#define   USB_OTG_HS_ENDPTCTRL9__RXS___S                                                   0
#define USB_OTG_HS_ENDPTCTRL10                                                           (BAM_OFFSET+0x000001E8)
#define   USB_OTG_HS_ENDPTCTRL10___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL10__TXE___M                                                  0x00800000
#define   USB_OTG_HS_ENDPTCTRL10__TXE___S                                                  23
#define   USB_OTG_HS_ENDPTCTRL10__TXR___M                                                  0x00400000
#define   USB_OTG_HS_ENDPTCTRL10__TXR___S                                                  22
#define   USB_OTG_HS_ENDPTCTRL10__TXI___M                                                  0x00200000
#define   USB_OTG_HS_ENDPTCTRL10__TXI___S                                                  21
#define   USB_OTG_HS_ENDPTCTRL10__TXT___M                                                  0x000C0000
#define   USB_OTG_HS_ENDPTCTRL10__TXT___S                                                  18
#define   USB_OTG_HS_ENDPTCTRL10__TXD___M                                                  0x00020000
#define   USB_OTG_HS_ENDPTCTRL10__TXD___S                                                  17
#define   USB_OTG_HS_ENDPTCTRL10__TXS___M                                                  0x00010000
#define   USB_OTG_HS_ENDPTCTRL10__TXS___S                                                  16
#define   USB_OTG_HS_ENDPTCTRL10__RXE___M                                                  0x00000080
#define   USB_OTG_HS_ENDPTCTRL10__RXE___S                                                  7
#define   USB_OTG_HS_ENDPTCTRL10__RXR___M                                                  0x00000040
#define   USB_OTG_HS_ENDPTCTRL10__RXR___S                                                  6
#define   USB_OTG_HS_ENDPTCTRL10__RXI___M                                                  0x00000020
#define   USB_OTG_HS_ENDPTCTRL10__RXI___S                                                  5
#define   USB_OTG_HS_ENDPTCTRL10__RXT___M                                                  0x0000000C
#define   USB_OTG_HS_ENDPTCTRL10__RXT___S                                                  2
#define   USB_OTG_HS_ENDPTCTRL10__RXD___M                                                  0x00000002
#define   USB_OTG_HS_ENDPTCTRL10__RXD___S                                                  1
#define   USB_OTG_HS_ENDPTCTRL10__RXS___M                                                  0x00000001
#define   USB_OTG_HS_ENDPTCTRL10__RXS___S                                                  0
#define USB_OTG_HS_ENDPTCTRL11                                                           (BAM_OFFSET+0x000001EC)
#define   USB_OTG_HS_ENDPTCTRL11___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL11__TXE___M                                                  0x00800000
#define   USB_OTG_HS_ENDPTCTRL11__TXE___S                                                  23
#define   USB_OTG_HS_ENDPTCTRL11__TXR___M                                                  0x00400000
#define   USB_OTG_HS_ENDPTCTRL11__TXR___S                                                  22
#define   USB_OTG_HS_ENDPTCTRL11__TXI___M                                                  0x00200000
#define   USB_OTG_HS_ENDPTCTRL11__TXI___S                                                  21
#define   USB_OTG_HS_ENDPTCTRL11__TXT___M                                                  0x000C0000
#define   USB_OTG_HS_ENDPTCTRL11__TXT___S                                                  18
#define   USB_OTG_HS_ENDPTCTRL11__TXD___M                                                  0x00020000
#define   USB_OTG_HS_ENDPTCTRL11__TXD___S                                                  17
#define   USB_OTG_HS_ENDPTCTRL11__TXS___M                                                  0x00010000
#define   USB_OTG_HS_ENDPTCTRL11__TXS___S                                                  16
#define   USB_OTG_HS_ENDPTCTRL11__RXE___M                                                  0x00000080
#define   USB_OTG_HS_ENDPTCTRL11__RXE___S                                                  7
#define   USB_OTG_HS_ENDPTCTRL11__RXR___M                                                  0x00000040
#define   USB_OTG_HS_ENDPTCTRL11__RXR___S                                                  6
#define   USB_OTG_HS_ENDPTCTRL11__RXI___M                                                  0x00000020
#define   USB_OTG_HS_ENDPTCTRL11__RXI___S                                                  5
#define   USB_OTG_HS_ENDPTCTRL11__RXT___M                                                  0x0000000C
#define   USB_OTG_HS_ENDPTCTRL11__RXT___S                                                  2
#define   USB_OTG_HS_ENDPTCTRL11__RXD___M                                                  0x00000002
#define   USB_OTG_HS_ENDPTCTRL11__RXD___S                                                  1
#define   USB_OTG_HS_ENDPTCTRL11__RXS___M                                                  0x00000001
#define   USB_OTG_HS_ENDPTCTRL11__RXS___S                                                  0
#define USB_OTG_HS_ENDPTCTRL12                                                           (BAM_OFFSET+0x000001F0)
#define   USB_OTG_HS_ENDPTCTRL12___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL12__TXE___M                                                  0x00800000
#define   USB_OTG_HS_ENDPTCTRL12__TXE___S                                                  23
#define   USB_OTG_HS_ENDPTCTRL12__TXR___M                                                  0x00400000
#define   USB_OTG_HS_ENDPTCTRL12__TXR___S                                                  22
#define   USB_OTG_HS_ENDPTCTRL12__TXI___M                                                  0x00200000
#define   USB_OTG_HS_ENDPTCTRL12__TXI___S                                                  21
#define   USB_OTG_HS_ENDPTCTRL12__TXT___M                                                  0x000C0000
#define   USB_OTG_HS_ENDPTCTRL12__TXT___S                                                  18
#define   USB_OTG_HS_ENDPTCTRL12__TXD___M                                                  0x00020000
#define   USB_OTG_HS_ENDPTCTRL12__TXD___S                                                  17
#define   USB_OTG_HS_ENDPTCTRL12__TXS___M                                                  0x00010000
#define   USB_OTG_HS_ENDPTCTRL12__TXS___S                                                  16
#define   USB_OTG_HS_ENDPTCTRL12__RXE___M                                                  0x00000080
#define   USB_OTG_HS_ENDPTCTRL12__RXE___S                                                  7
#define   USB_OTG_HS_ENDPTCTRL12__RXR___M                                                  0x00000040
#define   USB_OTG_HS_ENDPTCTRL12__RXR___S                                                  6
#define   USB_OTG_HS_ENDPTCTRL12__RXI___M                                                  0x00000020
#define   USB_OTG_HS_ENDPTCTRL12__RXI___S                                                  5
#define   USB_OTG_HS_ENDPTCTRL12__RXT___M                                                  0x0000000C
#define   USB_OTG_HS_ENDPTCTRL12__RXT___S                                                  2
#define   USB_OTG_HS_ENDPTCTRL12__RXD___M                                                  0x00000002
#define   USB_OTG_HS_ENDPTCTRL12__RXD___S                                                  1
#define   USB_OTG_HS_ENDPTCTRL12__RXS___M                                                  0x00000001
#define   USB_OTG_HS_ENDPTCTRL12__RXS___S                                                  0
#define USB_OTG_HS_ENDPTCTRL13                                                           (BAM_OFFSET+0x000001F4)
#define   USB_OTG_HS_ENDPTCTRL13___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL13__TXE___M                                                  0x00800000
#define   USB_OTG_HS_ENDPTCTRL13__TXE___S                                                  23
#define   USB_OTG_HS_ENDPTCTRL13__TXR___M                                                  0x00400000
#define   USB_OTG_HS_ENDPTCTRL13__TXR___S                                                  22
#define   USB_OTG_HS_ENDPTCTRL13__TXI___M                                                  0x00200000
#define   USB_OTG_HS_ENDPTCTRL13__TXI___S                                                  21
#define   USB_OTG_HS_ENDPTCTRL13__TXT___M                                                  0x000C0000
#define   USB_OTG_HS_ENDPTCTRL13__TXT___S                                                  18
#define   USB_OTG_HS_ENDPTCTRL13__TXD___M                                                  0x00020000
#define   USB_OTG_HS_ENDPTCTRL13__TXD___S                                                  17
#define   USB_OTG_HS_ENDPTCTRL13__TXS___M                                                  0x00010000
#define   USB_OTG_HS_ENDPTCTRL13__TXS___S                                                  16
#define   USB_OTG_HS_ENDPTCTRL13__RXE___M                                                  0x00000080
#define   USB_OTG_HS_ENDPTCTRL13__RXE___S                                                  7
#define   USB_OTG_HS_ENDPTCTRL13__RXR___M                                                  0x00000040
#define   USB_OTG_HS_ENDPTCTRL13__RXR___S                                                  6
#define   USB_OTG_HS_ENDPTCTRL13__RXI___M                                                  0x00000020
#define   USB_OTG_HS_ENDPTCTRL13__RXI___S                                                  5
#define   USB_OTG_HS_ENDPTCTRL13__RXT___M                                                  0x0000000C
#define   USB_OTG_HS_ENDPTCTRL13__RXT___S                                                  2
#define   USB_OTG_HS_ENDPTCTRL13__RXD___M                                                  0x00000002
#define   USB_OTG_HS_ENDPTCTRL13__RXD___S                                                  1
#define   USB_OTG_HS_ENDPTCTRL13__RXS___M                                                  0x00000001
#define   USB_OTG_HS_ENDPTCTRL13__RXS___S                                                  0
#define USB_OTG_HS_ENDPTCTRL14                                                           (BAM_OFFSET+0x000001F8)
#define   USB_OTG_HS_ENDPTCTRL14___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL14__TXE___M                                                  0x00800000
#define   USB_OTG_HS_ENDPTCTRL14__TXE___S                                                  23
#define   USB_OTG_HS_ENDPTCTRL14__TXR___M                                                  0x00400000
#define   USB_OTG_HS_ENDPTCTRL14__TXR___S                                                  22
#define   USB_OTG_HS_ENDPTCTRL14__TXI___M                                                  0x00200000
#define   USB_OTG_HS_ENDPTCTRL14__TXI___S                                                  21
#define   USB_OTG_HS_ENDPTCTRL14__TXT___M                                                  0x000C0000
#define   USB_OTG_HS_ENDPTCTRL14__TXT___S                                                  18
#define   USB_OTG_HS_ENDPTCTRL14__TXD___M                                                  0x00020000
#define   USB_OTG_HS_ENDPTCTRL14__TXD___S                                                  17
#define   USB_OTG_HS_ENDPTCTRL14__TXS___M                                                  0x00010000
#define   USB_OTG_HS_ENDPTCTRL14__TXS___S                                                  16
#define   USB_OTG_HS_ENDPTCTRL14__RXE___M                                                  0x00000080
#define   USB_OTG_HS_ENDPTCTRL14__RXE___S                                                  7
#define   USB_OTG_HS_ENDPTCTRL14__RXR___M                                                  0x00000040
#define   USB_OTG_HS_ENDPTCTRL14__RXR___S                                                  6
#define   USB_OTG_HS_ENDPTCTRL14__RXI___M                                                  0x00000020
#define   USB_OTG_HS_ENDPTCTRL14__RXI___S                                                  5
#define   USB_OTG_HS_ENDPTCTRL14__RXT___M                                                  0x0000000C
#define   USB_OTG_HS_ENDPTCTRL14__RXT___S                                                  2
#define   USB_OTG_HS_ENDPTCTRL14__RXD___M                                                  0x00000002
#define   USB_OTG_HS_ENDPTCTRL14__RXD___S                                                  1
#define   USB_OTG_HS_ENDPTCTRL14__RXS___M                                                  0x00000001
#define   USB_OTG_HS_ENDPTCTRL14__RXS___S                                                  0
#define USB_OTG_HS_ENDPTCTRL15                                                           (BAM_OFFSET+0x000001FC)
#define   USB_OTG_HS_ENDPTCTRL15___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_ENDPTCTRL15__TXE___M                                                  0x00800000
#define   USB_OTG_HS_ENDPTCTRL15__TXE___S                                                  23
#define   USB_OTG_HS_ENDPTCTRL15__TXR___M                                                  0x00400000
#define   USB_OTG_HS_ENDPTCTRL15__TXR___S                                                  22
#define   USB_OTG_HS_ENDPTCTRL15__TXI___M                                                  0x00200000
#define   USB_OTG_HS_ENDPTCTRL15__TXI___S                                                  21
#define   USB_OTG_HS_ENDPTCTRL15__TXT___M                                                  0x000C0000
#define   USB_OTG_HS_ENDPTCTRL15__TXT___S                                                  18
#define   USB_OTG_HS_ENDPTCTRL15__TXD___M                                                  0x00020000
#define   USB_OTG_HS_ENDPTCTRL15__TXD___S                                                  17
#define   USB_OTG_HS_ENDPTCTRL15__TXS___M                                                  0x00010000
#define   USB_OTG_HS_ENDPTCTRL15__TXS___S                                                  16
#define   USB_OTG_HS_ENDPTCTRL15__RXE___M                                                  0x00000080
#define   USB_OTG_HS_ENDPTCTRL15__RXE___S                                                  7
#define   USB_OTG_HS_ENDPTCTRL15__RXR___M                                                  0x00000040
#define   USB_OTG_HS_ENDPTCTRL15__RXR___S                                                  6
#define   USB_OTG_HS_ENDPTCTRL15__RXI___M                                                  0x00000020
#define   USB_OTG_HS_ENDPTCTRL15__RXI___S                                                  5
#define   USB_OTG_HS_ENDPTCTRL15__RXT___M                                                  0x0000000C
#define   USB_OTG_HS_ENDPTCTRL15__RXT___S                                                  2
#define   USB_OTG_HS_ENDPTCTRL15__RXD___M                                                  0x00000002
#define   USB_OTG_HS_ENDPTCTRL15__RXD___S                                                  1
#define   USB_OTG_HS_ENDPTCTRL15__RXS___M                                                  0x00000001
#define   USB_OTG_HS_ENDPTCTRL15__RXS___S                                                  0

#define USB_OTG_HS_ENDPT_PIPE_IDn(n)                                          (BAM_OFFSET+0x000001FC+0x4*(n))
#define   USB_OTG_HS_ENDPT_PIPE_IDn_nMIN                       1
#define   USB_OTG_HS_ENDPT_PIPE_IDn_nMAX                       15
#define   USB_OTG_HS_ENDPT_PIPE_IDn_ELEM                       15
#define   USB_OTG_HS_ENDPT_PIPE_IDn___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_IDn___POR                                                  0x001F001F
#define   USB_OTG_HS_ENDPT_PIPE_IDn__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_IDn__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_IDn__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_IDn__RX_PIPE_ID___S                                        0
#define   USB_OTG_HS_ENDPT_PIPE_IDn___M                                                    0x001FFFFF
#define   USB_OTG_HS_ENDPT_PIPE_IDn___S                                                    0
#define USB_OTG_HS_ENDPT_PIPE_ID1                                                        (BAM_OFFSET+0x00000200)
#define   USB_OTG_HS_ENDPT_PIPE_ID1___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID1__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID1__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID1__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID1__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID2                                                        (BAM_OFFSET+0x00000204)
#define   USB_OTG_HS_ENDPT_PIPE_ID2___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID2__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID2__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID2__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID2__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID3                                                        (BAM_OFFSET+0x00000208)
#define   USB_OTG_HS_ENDPT_PIPE_ID3___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID3__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID3__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID3__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID3__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID4                                                        (BAM_OFFSET+0x0000020C)
#define   USB_OTG_HS_ENDPT_PIPE_ID4___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID4__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID4__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID4__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID4__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID5                                                        (BAM_OFFSET+0x00000210)
#define   USB_OTG_HS_ENDPT_PIPE_ID5___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID5__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID5__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID5__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID5__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID6                                                        (BAM_OFFSET+0x00000214)
#define   USB_OTG_HS_ENDPT_PIPE_ID6___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID6__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID6__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID6__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID6__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID7                                                        (BAM_OFFSET+0x00000218)
#define   USB_OTG_HS_ENDPT_PIPE_ID7___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID7__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID7__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID7__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID7__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID8                                                        (BAM_OFFSET+0x0000021C)
#define   USB_OTG_HS_ENDPT_PIPE_ID8___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID8__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID8__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID8__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID8__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID9                                                        (BAM_OFFSET+0x00000220)
#define   USB_OTG_HS_ENDPT_PIPE_ID9___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID9__TX_PIPE_ID___M                                        0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID9__TX_PIPE_ID___S                                        16
#define   USB_OTG_HS_ENDPT_PIPE_ID9__RX_PIPE_ID___M                                        0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID9__RX_PIPE_ID___S                                        0
#define USB_OTG_HS_ENDPT_PIPE_ID10                                                       (BAM_OFFSET+0x00000224)
#define   USB_OTG_HS_ENDPT_PIPE_ID10___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID10__TX_PIPE_ID___M                                       0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID10__TX_PIPE_ID___S                                       16
#define   USB_OTG_HS_ENDPT_PIPE_ID10__RX_PIPE_ID___M                                       0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID10__RX_PIPE_ID___S                                       0
#define USB_OTG_HS_ENDPT_PIPE_ID11                                                       (BAM_OFFSET+0x00000228)
#define   USB_OTG_HS_ENDPT_PIPE_ID11___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID11__TX_PIPE_ID___M                                       0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID11__TX_PIPE_ID___S                                       16
#define   USB_OTG_HS_ENDPT_PIPE_ID11__RX_PIPE_ID___M                                       0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID11__RX_PIPE_ID___S                                       0
#define USB_OTG_HS_ENDPT_PIPE_ID12                                                       (BAM_OFFSET+0x0000022C)
#define   USB_OTG_HS_ENDPT_PIPE_ID12___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID12__TX_PIPE_ID___M                                       0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID12__TX_PIPE_ID___S                                       16
#define   USB_OTG_HS_ENDPT_PIPE_ID12__RX_PIPE_ID___M                                       0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID12__RX_PIPE_ID___S                                       0
#define USB_OTG_HS_ENDPT_PIPE_ID13                                                       (BAM_OFFSET+0x00000230)
#define   USB_OTG_HS_ENDPT_PIPE_ID13___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID13__TX_PIPE_ID___M                                       0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID13__TX_PIPE_ID___S                                       16
#define   USB_OTG_HS_ENDPT_PIPE_ID13__RX_PIPE_ID___M                                       0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID13__RX_PIPE_ID___S                                       0
#define USB_OTG_HS_ENDPT_PIPE_ID14                                                       (BAM_OFFSET+0x00000234)
#define   USB_OTG_HS_ENDPT_PIPE_ID14___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID14__TX_PIPE_ID___M                                       0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID14__TX_PIPE_ID___S                                       16
#define   USB_OTG_HS_ENDPT_PIPE_ID14__RX_PIPE_ID___M                                       0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID14__RX_PIPE_ID___S                                       0
#define USB_OTG_HS_ENDPT_PIPE_ID15                                                       (BAM_OFFSET+0x00000238)
#define   USB_OTG_HS_ENDPT_PIPE_ID15___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_ENDPT_PIPE_ID15__TX_PIPE_ID___M                                       0x001F0000
#define   USB_OTG_HS_ENDPT_PIPE_ID15__TX_PIPE_ID___S                                       16
#define   USB_OTG_HS_ENDPT_PIPE_ID15__RX_PIPE_ID___M                                       0x0000001F
#define   USB_OTG_HS_ENDPT_PIPE_ID15__RX_PIPE_ID___S                                       0

#define USB_OTG_HS_PHY_CTRL                                                              (BAM_OFFSET+0x00000240)
#define   USB_OTG_HS_PHY_CTRL___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_PHY_CTRL___POR                                                        0x000C3C3A
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_CLAMP_MPM_DPSE_DMSE_EN_N___M                       0x00200000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_CLAMP_MPM_DPSE_DMSE_EN_N___S                       21
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DMSE_INTEN___M                                     0x00100000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DMSE_INTEN___S                                     20
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DMSEHV_CLAMP_EN___M                                0x00080000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DMSEHV_CLAMP_EN___S                                19
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_ULPI_CLK_EN___M                                    0x00040000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_ULPI_CLK_EN___S                                    18
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_REFCLKOUT_EN___M                                   0x00020000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_REFCLKOUT_EN___S                                   17
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_USE_CLKCORE___M                                    0x00008000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_USE_CLKCORE___S                                    15
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DPSE_INTEN___M                                     0x00004000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DPSE_INTEN___S                                     14
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DPSEHV_CLAMP_EN___M                                0x00002000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_DPSEHV_CLAMP_EN___S                                13
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_IDHV_CLAMP_EN___M                                  0x00001000
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_IDHV_CLAMP_EN___S                                  12
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_OTGSESSVLDHV_CLAMP_EN___M                          0x00000800
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_OTGSESSVLDHV_CLAMP_EN___S                          11
#define   USB_OTG_HS_PHY_CTRL__PHY_MPM_HV_CLAMP_EN___M                                     0x00000400
#define   USB_OTG_HS_PHY_CTRL__PHY_MPM_HV_CLAMP_EN___S                                     10
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_OTGSESSVLDHV_INTEN___M                             0x00000200
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_OTGSESSVLDHV_INTEN___S                             9
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_IDHV_INTEN___M                                     0x00000100
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_IDHV_INTEN___S                                     8
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_ULPI_POR___M                                       0x00000080
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_ULPI_POR___S                                       7
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_FSEL___M                                           0x00000070
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_FSEL___S                                           4
#define   USB_OTG_HS_PHY_CTRL__HOST_PORTCTRL_FORCE_SUSEN___M                               0x00000008
#define   USB_OTG_HS_PHY_CTRL__HOST_PORTCTRL_FORCE_SUSEN___S                               3
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_SIDDQ___M                                          0x00000004
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_SIDDQ___S                                          2
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_RETEN___M                                          0x00000002
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_RETEN___S                                          1
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_POR___M                                            0x00000001
#define   USB_OTG_HS_PHY_CTRL__USB2_PHY_POR___S                                            0
#define   USB_OTG_HS_PHY_CTRL___M                                                          0x003FFFFF
#define   USB_OTG_HS_PHY_CTRL___S                                                          0

#define USB_OTG_HS_GENERIC1                                                              (BAM_OFFSET+0x00000244)
#define   USB_OTG_HS_GENERIC1___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_GENERIC1___POR                                                        0x00000000
#define   USB_OTG_HS_GENERIC1__USB_HS_TX_DEPTH___M                                         0xFFFF0000
#define   USB_OTG_HS_GENERIC1__USB_HS_TX_DEPTH___S                                         16
#define   USB_OTG_HS_GENERIC1__USB_HS_RX_DEPTH___M                                         0x0000FFFF
#define   USB_OTG_HS_GENERIC1__USB_HS_RX_DEPTH___S                                         0
#define   USB_OTG_HS_GENERIC1___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_GENERIC1___S                                                          0

#define USB_OTG_HS_GENERIC2                                                              (BAM_OFFSET+0x00000248)
#define   USB_OTG_HS_GENERIC2___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_GENERIC2___POR                                                        0x00000000
#define   USB_OTG_HS_GENERIC2__USE_EXT_HSIC___M                                            0x00040000
#define   USB_OTG_HS_GENERIC2__USE_EXT_HSIC___S                                            18
#define   USB_OTG_HS_GENERIC2__USE_SECURITY___M                                            0x00020000
#define   USB_OTG_HS_GENERIC2__USE_SECURITY___S                                            17
#define   USB_OTG_HS_GENERIC2__USE_FS_SIE___M                                              0x00010000
#define   USB_OTG_HS_GENERIC2__USE_FS_SIE___S                                              16
#define   USB_OTG_HS_GENERIC2__USE_SPS_AHB2AHB___M                                         0x00008000
#define   USB_OTG_HS_GENERIC2__USE_SPS_AHB2AHB___S                                         15
#define   USB_OTG_HS_GENERIC2__LPM_SUPPORT___M                                             0x00004000
#define   USB_OTG_HS_GENERIC2__LPM_SUPPORT___S                                             14
#define   USB_OTG_HS_GENERIC2__USB_HS_DEV_EP___M                                           0x00003E00
#define   USB_OTG_HS_GENERIC2__USB_HS_DEV_EP___S                                           9
#define   USB_OTG_HS_GENERIC2__MAX_PIPES___M                                               0x000001F8
#define   USB_OTG_HS_GENERIC2__MAX_PIPES___S                                               3
#define   USB_OTG_HS_GENERIC2__USE_SPS___M                                                 0x00000004
#define   USB_OTG_HS_GENERIC2__USE_SPS___S                                                 2
#define   USB_OTG_HS_GENERIC2__USE_HSIC___M                                                0x00000002
#define   USB_OTG_HS_GENERIC2__USE_HSIC___S                                                1
#define   USB_OTG_HS_GENERIC2__UTMI_PHY_SW_IF_EN___M                                       0x00000001
#define   USB_OTG_HS_GENERIC2__UTMI_PHY_SW_IF_EN___S                                       0
#define   USB_OTG_HS_GENERIC2___M                                                          0x0007FFFF
#define   USB_OTG_HS_GENERIC2___S                                                          0

#define USB_OTG_HS_L1_EP_CTRL                                                            (BAM_OFFSET+0x00000250)
#define   USB_OTG_HS_L1_EP_CTRL___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_L1_EP_CTRL___POR                                                      0x0000FFFF
#define   USB_OTG_HS_L1_EP_CTRL__TX_EP_PRIME_L1_EXIT___M                                   0xFFFF0000
#define   USB_OTG_HS_L1_EP_CTRL__TX_EP_PRIME_L1_EXIT___S                                   16
#define   USB_OTG_HS_L1_EP_CTRL__TX_EP_PRIME_L1_EN___M                                     0x0000FFFF
#define   USB_OTG_HS_L1_EP_CTRL__TX_EP_PRIME_L1_EN___S                                     0
#define   USB_OTG_HS_L1_EP_CTRL___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_L1_EP_CTRL___S                                                        0

#define USB_OTG_HS_L1_CONFIG                                                             (BAM_OFFSET+0x00000254)
#define   USB_OTG_HS_L1_CONFIG___RWC                                                       QCSR_REG_RW
#define   USB_OTG_HS_L1_CONFIG___POR                                                       0x00000000
#define   USB_OTG_HS_L1_CONFIG__PLL_PWR_DWN_EN___M                                         0x00000800
#define   USB_OTG_HS_L1_CONFIG__PLL_PWR_DWN_EN___S                                         11
#define   USB_OTG_HS_L1_CONFIG__PHY_LPM_EN___M                                             0x00000400
#define   USB_OTG_HS_L1_CONFIG__PHY_LPM_EN___S                                             10
#define   USB_OTG_HS_L1_CONFIG__GATE_AHB_CLK_EN___M                                        0x00000200
#define   USB_OTG_HS_L1_CONFIG__GATE_AHB_CLK_EN___S                                        9
#define   USB_OTG_HS_L1_CONFIG__GATE_FS_XCVR_CLK_EN___M                                    0x00000100
#define   USB_OTG_HS_L1_CONFIG__GATE_FS_XCVR_CLK_EN___S                                    8
#define   USB_OTG_HS_L1_CONFIG__GATE_SYS_CLK_EN___M                                        0x00000080
#define   USB_OTG_HS_L1_CONFIG__GATE_SYS_CLK_EN___S                                        7
#define   USB_OTG_HS_L1_CONFIG__GATE_XCVR_CLK_EN___M                                       0x00000040
#define   USB_OTG_HS_L1_CONFIG__GATE_XCVR_CLK_EN___S                                       6
#define   USB_OTG_HS_L1_CONFIG__L1_REMOTE_WAKEUP_EN___M                                    0x00000020
#define   USB_OTG_HS_L1_CONFIG__L1_REMOTE_WAKEUP_EN___S                                    5
#define   USB_OTG_HS_L1_CONFIG__LPM_EN___M                                                 0x00000010
#define   USB_OTG_HS_L1_CONFIG__LPM_EN___S                                                 4
#define   USB_OTG_HS_L1_CONFIG__PLL_TURNOFF_MIN_HIRD___M                                   0x0000000F
#define   USB_OTG_HS_L1_CONFIG__PLL_TURNOFF_MIN_HIRD___S                                   0
#define   USB_OTG_HS_L1_CONFIG___M                                                         0x00000FFF
#define   USB_OTG_HS_L1_CONFIG___S                                                         0

#define USB_OTG_HS_LPM_DEBUG_1                                                           (BAM_OFFSET+0x00000258)
#define   USB_OTG_HS_LPM_DEBUG_1___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_LPM_DEBUG_1___POR                                                     0x00000000
#define   USB_OTG_HS_LPM_DEBUG_1__DEBUG_L1_LONG_ENT_CNT___M                                0xFFFF0000
#define   USB_OTG_HS_LPM_DEBUG_1__DEBUG_L1_LONG_ENT_CNT___S                                16
#define   USB_OTG_HS_LPM_DEBUG_1__DEBUG_L1_SHORT_ENT_CNT___M                               0x0000FFFF
#define   USB_OTG_HS_LPM_DEBUG_1__DEBUG_L1_SHORT_ENT_CNT___S                               0
#define   USB_OTG_HS_LPM_DEBUG_1___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_LPM_DEBUG_1___S                                                       0

#define USB_OTG_HS_LPM_DEBUG_2                                                           (BAM_OFFSET+0x0000025C)
#define   USB_OTG_HS_LPM_DEBUG_2___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_LPM_DEBUG_2___POR                                                     0x00000000
#define   USB_OTG_HS_LPM_DEBUG_2__L1_RMT_WKUP_TIME___M                                     0x00001E00
#define   USB_OTG_HS_LPM_DEBUG_2__L1_RMT_WKUP_TIME___S                                     9
#define   USB_OTG_HS_LPM_DEBUG_2__L1_FPR___M                                               0x00000100
#define   USB_OTG_HS_LPM_DEBUG_2__L1_FPR___S                                               8
#define   USB_OTG_HS_LPM_DEBUG_2__HSIC_CLK_PLL_BYPASSNL___M                                0x00000080
#define   USB_OTG_HS_LPM_DEBUG_2__HSIC_CLK_PLL_BYPASSNL___S                                7
#define   USB_OTG_HS_LPM_DEBUG_2__HSIC_CLK_PLL_RESET___M                                   0x00000040
#define   USB_OTG_HS_LPM_DEBUG_2__HSIC_CLK_PLL_RESET___S                                   6
#define   USB_OTG_HS_LPM_DEBUG_2__HSIC_CLK_GATE___M                                        0x00000020
#define   USB_OTG_HS_LPM_DEBUG_2__HSIC_CLK_GATE___S                                        5
#define   USB_OTG_HS_LPM_DEBUG_2__FS_XCVR_CLK_GATE___M                                     0x00000010
#define   USB_OTG_HS_LPM_DEBUG_2__FS_XCVR_CLK_GATE___S                                     4
#define   USB_OTG_HS_LPM_DEBUG_2__SYS_CLK_GATE___M                                         0x00000008
#define   USB_OTG_HS_LPM_DEBUG_2__SYS_CLK_GATE___S                                         3
#define   USB_OTG_HS_LPM_DEBUG_2__AHB_CLK_GATE___M                                         0x00000004
#define   USB_OTG_HS_LPM_DEBUG_2__AHB_CLK_GATE___S                                         2
#define   USB_OTG_HS_LPM_DEBUG_2__L1_STATE___M                                             0x00000002
#define   USB_OTG_HS_LPM_DEBUG_2__L1_STATE___S                                             1
#define   USB_OTG_HS_LPM_DEBUG_2__DEBUG_L1_EN___M                                          0x00000001
#define   USB_OTG_HS_LPM_DEBUG_2__DEBUG_L1_EN___S                                          0
#define   USB_OTG_HS_LPM_DEBUG_2___M                                                       0x00001FFF
#define   USB_OTG_HS_LPM_DEBUG_2___S                                                       0

#define USB_OTG_HS_LPM_ATTRIBUTES                                                        (BAM_OFFSET+0x00000260)
#define   USB_OTG_HS_LPM_ATTRIBUTES___RWC                                                  QCSR_REG_RO
#define   USB_OTG_HS_LPM_ATTRIBUTES___POR                                                  0x00000000
#define   USB_OTG_HS_LPM_ATTRIBUTES__BREMOTEWAKE___M                                       0x00000010
#define   USB_OTG_HS_LPM_ATTRIBUTES__BREMOTEWAKE___S                                       4
#define   USB_OTG_HS_LPM_ATTRIBUTES__HIRD___M                                              0x0000000F
#define   USB_OTG_HS_LPM_ATTRIBUTES__HIRD___S                                              0
#define   USB_OTG_HS_LPM_ATTRIBUTES___M                                                    0x0000001F
#define   USB_OTG_HS_LPM_ATTRIBUTES___S                                                    0

#define USB_OTG_HS_HW_VER                                                                (BAM_OFFSET+0x00000270)
#define   USB_OTG_HS_HW_VER___RWC                                                          QCSR_REG_RO
#define   USB_OTG_HS_HW_VER___POR                                                          0x00000000
#define   USB_OTG_HS_HW_VER__MAJOR___M                                                     0xF0000000
#define   USB_OTG_HS_HW_VER__MAJOR___S                                                     28
#define   USB_OTG_HS_HW_VER__MINOR___M                                                     0x0FFF0000
#define   USB_OTG_HS_HW_VER__MINOR___S                                                     16
#define   USB_OTG_HS_HW_VER__STEP___M                                                      0x0000FFFF
#define   USB_OTG_HS_HW_VER__STEP___S                                                      0
#define   USB_OTG_HS_HW_VER___M                                                            0xFFFFFFFF
#define   USB_OTG_HS_HW_VER___S                                                            0

#define USB_OTG_HS_TEST_BUS                                                              (BAM_OFFSET+0x00000274)
#define   USB_OTG_HS_TEST_BUS___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_TEST_BUS___POR                                                        0x00000000
#define   USB_OTG_HS_TEST_BUS__USB2_TEST_BUS___M                                           0xFFFFFFFF
#define   USB_OTG_HS_TEST_BUS__USB2_TEST_BUS___S                                           0
#define   USB_OTG_HS_TEST_BUS___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_TEST_BUS___S                                                          0

#define USB_OTG_HS_PHY_SEC_CTRL                                                          (BAM_OFFSET+0x00000278)
#define   USB_OTG_HS_PHY_SEC_CTRL___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_PHY_SEC_CTRL___POR                                                    0x000C3C32
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_CLAMP_MPM_DPSE_DMSE_EN_N_2___M                 0x00200000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_CLAMP_MPM_DPSE_DMSE_EN_N_2___S                 21
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DMSE_INTEN_2___M                               0x00100000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DMSE_INTEN_2___S                               20
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DMSEHV_CLAMP_EN_2___M                          0x00080000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DMSEHV_CLAMP_EN_2___S                          19
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_ULPI_CLK_EN_2___M                              0x00040000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_ULPI_CLK_EN_2___S                              18
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_HS2_DIG_CLAMP_N_2___M                          0x00010000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_HS2_DIG_CLAMP_N_2___S                          16
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_USE_CLKCORE_2___M                              0x00008000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_USE_CLKCORE_2___S                              15
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DPSE_INTEN_2___M                               0x00004000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DPSE_INTEN_2___S                               14
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DPSEHV_CLAMP_EN_2___M                          0x00002000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_DPSEHV_CLAMP_EN_2___S                          13
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_IDHV_CLAMP_EN_2___M                            0x00001000
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_IDHV_CLAMP_EN_2___S                            12
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_OTGSESSVLDHV_CLAMP_EN_2___M                    0x00000800
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_OTGSESSVLDHV_CLAMP_EN_2___S                    11
#define   USB_OTG_HS_PHY_SEC_CTRL__PHY_MPM_HV_CLAMP_EN_2___M                               0x00000400
#define   USB_OTG_HS_PHY_SEC_CTRL__PHY_MPM_HV_CLAMP_EN_2___S                               10
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_OTGSESSVLDHV_INTEN_2___M                       0x00000200
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_OTGSESSVLDHV_INTEN_2___S                       9
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_IDHV_INTEN_2___M                               0x00000100
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_IDHV_INTEN_2___S                               8
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_ULPI_POR_2___M                                 0x00000080
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_ULPI_POR_2___S                                 7
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_FSEL_2___M                                     0x00000070
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_FSEL_2___S                                     4
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_SIDDQ_2___M                                    0x00000004
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_SIDDQ_2___S                                    2
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_RETEN_2___M                                    0x00000002
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_RETEN_2___S                                    1
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_POR_2___M                                      0x00000001
#define   USB_OTG_HS_PHY_SEC_CTRL__USB2_PHY_POR_2___S                                      0
#define   USB_OTG_HS_PHY_SEC_CTRL___M                                                      0x003FFFFF
#define   USB_OTG_HS_PHY_SEC_CTRL___S                                                      0

#define USB_OTG_HS_USE_EXT_HSIC                                                          (BAM_OFFSET+0x0000027C)
#define   USB_OTG_HS_USE_EXT_HSIC___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_USE_EXT_HSIC___POR                                                    0x00000000
#define   USB_OTG_HS_USE_EXT_HSIC__USB2_INT_EXT_PHY_SEL___M                                0x00000002
#define   USB_OTG_HS_USE_EXT_HSIC__USB2_INT_EXT_PHY_SEL___S                                1
#define   USB_OTG_HS_USE_EXT_HSIC__USB2_HSIC_OR_USB2_PHY_SEL___M                           0x00000001
#define   USB_OTG_HS_USE_EXT_HSIC__USB2_HSIC_OR_USB2_PHY_SEL___S                           0
#define   USB_OTG_HS_USE_EXT_HSIC___M                                                      0x00000003
#define   USB_OTG_HS_USE_EXT_HSIC___S                                                      0

#define USB_OTG_HS_BAM_CTRL                                                              (0x00004000)
#define   USB_OTG_HS_BAM_CTRL___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_BAM_CTRL___POR                                                        0x00020000
#define   USB_OTG_HS_BAM_CTRL__CACHE_MISS_ERR_RESP_EN___M                                  0x00080000
#define   USB_OTG_HS_BAM_CTRL__CACHE_MISS_ERR_RESP_EN___S                                  19
#define   USB_OTG_HS_BAM_CTRL__LOCAL_CLK_GATING___M                                        0x00060000
#define   USB_OTG_HS_BAM_CTRL__LOCAL_CLK_GATING___S                                        17
#define   USB_OTG_HS_BAM_CTRL__IBC_DISABLE___M                                             0x00010000
#define   USB_OTG_HS_BAM_CTRL__IBC_DISABLE___S                                             16
#define   USB_OTG_HS_BAM_CTRL__BAM_CACHED_DESC_STORE___M                                   0x00008000
#define   USB_OTG_HS_BAM_CTRL__BAM_CACHED_DESC_STORE___S                                   15
#define   USB_OTG_HS_BAM_CTRL__BAM_DESC_CACHE_SEL___M                                      0x00006000
#define   USB_OTG_HS_BAM_CTRL__BAM_DESC_CACHE_SEL___S                                      13
#define   USB_OTG_HS_BAM_CTRL__BAM_TESTBUS_SEL___M                                         0x00000FE0
#define   USB_OTG_HS_BAM_CTRL__BAM_TESTBUS_SEL___S                                         5
#define   USB_OTG_HS_BAM_CTRL__BAM_EN_ACCUM___M                                            0x00000010
#define   USB_OTG_HS_BAM_CTRL__BAM_EN_ACCUM___S                                            4
#define   USB_OTG_HS_BAM_CTRL__BAM_EN___M                                                  0x00000002
#define   USB_OTG_HS_BAM_CTRL__BAM_EN___S                                                  1
#define   USB_OTG_HS_BAM_CTRL__BAM_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_CTRL__BAM_SW_RST___S                                              0
#define   USB_OTG_HS_BAM_CTRL___M                                                          0x000FFFFF
#define   USB_OTG_HS_BAM_CTRL___S                                                          0

#define USB_OTG_HS_BAM_REVISION                                                          (0x00004004)
#define   USB_OTG_HS_BAM_REVISION___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_REVISION__INACTIV_TMR_BASE___M                                    0xFF000000
#define   USB_OTG_HS_BAM_REVISION__INACTIV_TMR_BASE___S                                    24
#define   USB_OTG_HS_BAM_REVISION__CMD_DESC_EN___M                                         0x00800000
#define   USB_OTG_HS_BAM_REVISION__CMD_DESC_EN___S                                         23
#define   USB_OTG_HS_BAM_REVISION__DESC_CACHE_DEPTH___M                                    0x00600000
#define   USB_OTG_HS_BAM_REVISION__DESC_CACHE_DEPTH___S                                    21
#define   USB_OTG_HS_BAM_REVISION__NUM_INACTIV_TMRS___M                                    0x00100000
#define   USB_OTG_HS_BAM_REVISION__NUM_INACTIV_TMRS___S                                    20
#define   USB_OTG_HS_BAM_REVISION__INACTIV_TMRS_EXST___M                                   0x00080000
#define   USB_OTG_HS_BAM_REVISION__INACTIV_TMRS_EXST___S                                   19
#define   USB_OTG_HS_BAM_REVISION__HIGH_FREQUENCY_BAM___M                                  0x00040000
#define   USB_OTG_HS_BAM_REVISION__HIGH_FREQUENCY_BAM___S                                  18
#define   USB_OTG_HS_BAM_REVISION__BAM_HAS_NO_BYPASS___M                                   0x00020000
#define   USB_OTG_HS_BAM_REVISION__BAM_HAS_NO_BYPASS___S                                   17
#define   USB_OTG_HS_BAM_REVISION__SECURED___M                                             0x00010000
#define   USB_OTG_HS_BAM_REVISION__SECURED___S                                             16
#define   USB_OTG_HS_BAM_REVISION__USE_VMIDMT___M                                          0x00008000
#define   USB_OTG_HS_BAM_REVISION__USE_VMIDMT___S                                          15
#define   USB_OTG_HS_BAM_REVISION__AXI_ACTIVE___M                                          0x00004000
#define   USB_OTG_HS_BAM_REVISION__AXI_ACTIVE___S                                          14
#define   USB_OTG_HS_BAM_REVISION__CE_BUFFER_SIZE___M                                      0x00002000
#define   USB_OTG_HS_BAM_REVISION__CE_BUFFER_SIZE___S                                      13
#define   USB_OTG_HS_BAM_REVISION__NUM_EES___M                                             0x00000F00
#define   USB_OTG_HS_BAM_REVISION__NUM_EES___S                                             8
#define   USB_OTG_HS_BAM_REVISION__REVISION___M                                            0x000000FF
#define   USB_OTG_HS_BAM_REVISION__REVISION___S                                            0
#define   USB_OTG_HS_BAM_REVISION___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_BAM_REVISION___S                                                      0

#define USB_OTG_HS_BAM_SW_VERSION                                                        (0x00004080)
#define   USB_OTG_HS_BAM_SW_VERSION___RWC                                                  QCSR_REG_RO
#define   USB_OTG_HS_BAM_SW_VERSION__MAJOR___M                                             0xF0000000
#define   USB_OTG_HS_BAM_SW_VERSION__MAJOR___S                                             28
#define   USB_OTG_HS_BAM_SW_VERSION__MINOR___M                                             0x0FFF0000
#define   USB_OTG_HS_BAM_SW_VERSION__MINOR___S                                             16
#define   USB_OTG_HS_BAM_SW_VERSION__STEP___M                                              0x0000FFFF
#define   USB_OTG_HS_BAM_SW_VERSION__STEP___S                                              0
#define   USB_OTG_HS_BAM_SW_VERSION___M                                                    0xFFFFFFFF
#define   USB_OTG_HS_BAM_SW_VERSION___S                                                    0

#define USB_OTG_HS_BAM_NUM_PIPES                                                         (0x0000403C)
#define   USB_OTG_HS_BAM_NUM_PIPES___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_NUM_PIPES__BAM_NON_PIPE_GRP___M                                   0xFF000000
#define   USB_OTG_HS_BAM_NUM_PIPES__BAM_NON_PIPE_GRP___S                                   24
#define   USB_OTG_HS_BAM_NUM_PIPES__PERIPH_NON_PIPE_GRP___M                                0x00FF0000
#define   USB_OTG_HS_BAM_NUM_PIPES__PERIPH_NON_PIPE_GRP___S                                16
#define   USB_OTG_HS_BAM_NUM_PIPES__BAM_NUM_PIPES___M                                      0x000000FF
#define   USB_OTG_HS_BAM_NUM_PIPES__BAM_NUM_PIPES___S                                      0
#define   USB_OTG_HS_BAM_NUM_PIPES___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_BAM_NUM_PIPES___S                                                     0

#define USB_OTG_HS_BAM_TIMER                                                             (0x00004040)
#define   USB_OTG_HS_BAM_TIMER___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_TIMER___POR                                                       0x00000000
#define   USB_OTG_HS_BAM_TIMER__TIMER___M                                                  0x0000FFFF
#define   USB_OTG_HS_BAM_TIMER__TIMER___S                                                  0
#define   USB_OTG_HS_BAM_TIMER___M                                                         0x0000FFFF
#define   USB_OTG_HS_BAM_TIMER___S                                                         0

#define USB_OTG_HS_BAM_TIMER_CTRL                                                        (0x00004044)
#define   USB_OTG_HS_BAM_TIMER_CTRL___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_TIMER_CTRL___POR                                                  0x00000000
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_RST___M                                         0x80000000
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_RST___S                                         31
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_RUN___M                                         0x40000000
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_RUN___S                                         30
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_MODE___M                                        0x20000000
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_MODE___S                                        29
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_TRSHLD___M                                      0x0000FFFF
#define   USB_OTG_HS_BAM_TIMER_CTRL__TIMER_TRSHLD___S                                      0
#define   USB_OTG_HS_BAM_TIMER_CTRL___M                                                    0xFFFFFFFF
#define   USB_OTG_HS_BAM_TIMER_CTRL___S                                                    0

#define USB_OTG_HS_BAM_DESC_CNT_TRSHLD                                                   (0x00004008)
#define   USB_OTG_HS_BAM_DESC_CNT_TRSHLD___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_DESC_CNT_TRSHLD___POR                                             0x00000000
#define   USB_OTG_HS_BAM_DESC_CNT_TRSHLD__CNT_TRSHLD___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_DESC_CNT_TRSHLD__CNT_TRSHLD___S                                   0
#define   USB_OTG_HS_BAM_DESC_CNT_TRSHLD___M                                               0x0000FFFF
#define   USB_OTG_HS_BAM_DESC_CNT_TRSHLD___S                                               0

#define USB_OTG_HS_BAM_IRQ_SRCS                                                          (0x0000400C)
#define   USB_OTG_HS_BAM_IRQ_SRCS___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS___POR                                                    0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS__BAM_IRQ___M                                             0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS__BAM_IRQ___S                                             31
#define   USB_OTG_HS_BAM_IRQ_SRCS__P_IRQ___M                                               0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS__P_IRQ___S                                               0
#define   USB_OTG_HS_BAM_IRQ_SRCS___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS___S                                                      0

#define USB_OTG_HS_BAM_IRQ_SRCS_MSK                                                      (0x00004010)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK___POR                                                0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__BAM_IRQ_MSK___M                                     0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__BAM_IRQ_MSK___S                                     31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__BAM_IRQ_MSK__DISABLE_BAM_INTERRUPT                  0x0
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__BAM_IRQ_MSK__ENABLE_BAM_INTERRUPT                   0x1
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__P_IRQ_MSK___M                                       0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__P_IRQ_MSK___S                                       0
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__P_IRQ_MSK__DISABLE_PIPE_INTERRUPT                   0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK__P_IRQ_MSK__ENABLE_PIPE_INTERRUPT                    0x00000001
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK___M                                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK___S                                                  0

#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED                                                 (0x00004030)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED___RWC                                           QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED___POR                                           0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED__BAM_IRQ_UNMASKED___M                           0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED__BAM_IRQ_UNMASKED___S                           31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED__P_IRQ_UNMASKED___M                             0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED__P_IRQ_UNMASKED___S                             0
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED___M                                             0xFFFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED___S                                             0

#define USB_OTG_HS_BAM_IRQ_STTS                                                          (0x00004014)
#define   USB_OTG_HS_BAM_IRQ_STTS___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_STTS___POR                                                    0x00000000
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_TIMER_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_TIMER_IRQ___S                                       4
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_EMPTY_IRQ___M                                       0x00000008
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_EMPTY_IRQ___S                                       3
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_ERROR_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_ERROR_IRQ___S                                       2
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_HRESP_ERR_IRQ___M                                   0x00000002
#define   USB_OTG_HS_BAM_IRQ_STTS__BAM_HRESP_ERR_IRQ___S                                   1
#define   USB_OTG_HS_BAM_IRQ_STTS___M                                                      0x0000001E
#define   USB_OTG_HS_BAM_IRQ_STTS___S                                                      1

#define USB_OTG_HS_BAM_IRQ_CLR                                                           (0x00004018)
#define   USB_OTG_HS_BAM_IRQ_CLR___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_IRQ_CLR___POR                                                     0x00000000
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_TIMER_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_TIMER_CLR___S                                        4
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_EMPTY_CLR___M                                        0x00000008
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_EMPTY_CLR___S                                        3
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_ERROR_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_ERROR_CLR___S                                        2
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_HRESP_ERR_CLR___M                                    0x00000002
#define   USB_OTG_HS_BAM_IRQ_CLR__BAM_HRESP_ERR_CLR___S                                    1
#define   USB_OTG_HS_BAM_IRQ_CLR___M                                                       0x0000001E
#define   USB_OTG_HS_BAM_IRQ_CLR___S                                                       1

#define USB_OTG_HS_BAM_IRQ_EN                                                            (0x0000401C)
#define   USB_OTG_HS_BAM_IRQ_EN___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_EN___POR                                                      0x00000000
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_TIMER_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_TIMER_EN___S                                          4
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_EMPTY_EN___M                                          0x00000008
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_EMPTY_EN___S                                          3
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_ERROR_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_ERROR_EN___S                                          2
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_HRESP_ERR_EN___M                                      0x00000002
#define   USB_OTG_HS_BAM_IRQ_EN__BAM_HRESP_ERR_EN___S                                      1
#define   USB_OTG_HS_BAM_IRQ_EN___M                                                        0x0000001E
#define   USB_OTG_HS_BAM_IRQ_EN___S                                                        1

#define USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS                                              (0x00004024)
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS___RWC                                        QCSR_REG_RO
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS___POR                                        0x00000000
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HVMID___M                           0x007C0000
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HVMID___S                           18
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_DIRECT_MODE___M                     0x00020000
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_DIRECT_MODE___S                     17
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HCID___M                            0x0001F000
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HCID___S                            12
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HPROT___M                           0x00000F00
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HPROT___S                           8
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HBURST___M                          0x000000E0
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HBURST___S                          5
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HSIZE___M                           0x00000018
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HSIZE___S                           3
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HWRITE___M                          0x00000004
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HWRITE___S                          2
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HTRANS___M                          0x00000003
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS__BAM_ERR_HTRANS___S                          0
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS___M                                          0x007FFFFF
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_CTRLS___S                                          0

#define USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR                                               (0x00004028)
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR___RWC                                         QCSR_REG_RO
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR___POR                                         0x00000000
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR__BAM_ERR_ADDR___M                             0xFFFFFFFF
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR__BAM_ERR_ADDR___S                             0
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR___M                                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_ADDR___S                                           0

#define USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA                                               (0x0000402C)
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA___RWC                                         QCSR_REG_RO
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA___POR                                         0x00000000
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA__BAM_ERR_DATA___M                             0xFFFFFFFF
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA__BAM_ERR_DATA___S                             0
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA___M                                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_AHB_MASTER_ERR_DATA___S                                           0

#define USB_OTG_HS_BAM_TRUST_REG                                                         (0x00004070)
#define   USB_OTG_HS_BAM_TRUST_REG___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_TRUST_REG___POR                                                   0x00000000
#define   USB_OTG_HS_BAM_TRUST_REG__LOCK_EE_CTRL___M                                       0x00002000
#define   USB_OTG_HS_BAM_TRUST_REG__LOCK_EE_CTRL___S                                       13
#define   USB_OTG_HS_BAM_TRUST_REG__BAM_VMID___M                                           0x00001F00
#define   USB_OTG_HS_BAM_TRUST_REG__BAM_VMID___S                                           8
#define   USB_OTG_HS_BAM_TRUST_REG__BAM_RST_BLOCK___M                                      0x00000080
#define   USB_OTG_HS_BAM_TRUST_REG__BAM_RST_BLOCK___S                                      7
#define   USB_OTG_HS_BAM_TRUST_REG__BAM_EE___M                                             0x00000007
#define   USB_OTG_HS_BAM_TRUST_REG__BAM_EE___S                                             0
#define   USB_OTG_HS_BAM_TRUST_REG___M                                                     0x00003FFF
#define   USB_OTG_HS_BAM_TRUST_REG___S                                                     0

#define USB_OTG_HS_BAM_TEST_BUS_SEL                                                      (0x00004074)
#define   USB_OTG_HS_BAM_TEST_BUS_SEL___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_TEST_BUS_SEL___POR                                                0x00000000
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__SW_EVENTS_ZERO___M                                  0x00200000
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__SW_EVENTS_ZERO___S                                  21
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__SW_EVENTS_SEL___M                                   0x00180000
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__SW_EVENTS_SEL___S                                   19
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_DATA_ERASE___M                                  0x00040000
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_DATA_ERASE___S                                  18
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_DATA_FLUSH___M                                  0x00020000
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_DATA_FLUSH___S                                  17
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_CLK_ALWAYS_ON___M                               0x00010000
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_CLK_ALWAYS_ON___S                               16
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_TESTBUS_SEL___M                                 0x0000007F
#define   USB_OTG_HS_BAM_TEST_BUS_SEL__BAM_TESTBUS_SEL___S                                 0
#define   USB_OTG_HS_BAM_TEST_BUS_SEL___M                                                  0x003FFFFF
#define   USB_OTG_HS_BAM_TEST_BUS_SEL___S                                                  0

#define USB_OTG_HS_BAM_TEST_BUS_REG                                                      (0x00004078)
#define   USB_OTG_HS_BAM_TEST_BUS_REG___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_TEST_BUS_REG___POR                                                0x00000000
#define   USB_OTG_HS_BAM_TEST_BUS_REG__BAM_TESTBUS_REG___M                                 0xFFFFFFFF
#define   USB_OTG_HS_BAM_TEST_BUS_REG__BAM_TESTBUS_REG___S                                 0
#define   USB_OTG_HS_BAM_TEST_BUS_REG___M                                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_TEST_BUS_REG___S                                                  0

#define USB_OTG_HS_BAM_CNFG_BITS                                                         (0x0000407C)
#define   USB_OTG_HS_BAM_CNFG_BITS___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_CNFG_BITS___POR                                                   0x00000000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ZLT_W_CD_SUPPORT___M                               0x10000000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ZLT_W_CD_SUPPORT___S                               28
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_CD_ENABLE___M                                      0x08000000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_CD_ENABLE___S                                      27
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_AU_ACCUMED___M                                     0x04000000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_AU_ACCUMED___S                                     26
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PSM_P_HD_DATA___M                                  0x02000000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PSM_P_HD_DATA___S                                  25
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_REG_P_EN___M                                       0x01000000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_REG_P_EN___S                                       24
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_DSC_AVL_P_RST___M                               0x00800000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_DSC_AVL_P_RST___S                               23
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_RETR_SVPNT___M                                  0x00400000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_RETR_SVPNT___S                                  22
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_CSW_ACK_IDL___M                                 0x00200000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_CSW_ACK_IDL___S                                 21
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_BLK_CSW___M                                     0x00100000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_BLK_CSW___S                                     20
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_P_RES___M                                       0x00080000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_WB_P_RES___S                                       19
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_SI_P_RES___M                                       0x00040000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_SI_P_RES___S                                       18
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_AU_P_RES___M                                       0x00020000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_AU_P_RES___S                                       17
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PSM_P_RES___M                                      0x00010000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PSM_P_RES___S                                      16
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PSM_CSW_REQ___M                                    0x00008000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PSM_CSW_REQ___S                                    15
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_SB_CLK_REQ___M                                     0x00004000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_SB_CLK_REQ___S                                     14
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_IBC_DISABLE___M                                    0x00002000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_IBC_DISABLE___S                                    13
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_NO_EXT_P_RST___M                                   0x00001000
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_NO_EXT_P_RST___S                                   12
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_FULL_PIPE___M                                      0x00000800
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_FULL_PIPE___S                                      11
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ADML_SYNC_BRIDGE___M                               0x00000008
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ADML_SYNC_BRIDGE___S                               3
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PIPE_CNFG___M                                      0x00000004
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_PIPE_CNFG___S                                      2
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ADML_DEEP_CONS_FIFO___M                            0x00000002
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ADML_DEEP_CONS_FIFO___S                            1
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ADML_INCR4_EN_N___M                                0x00000001
#define   USB_OTG_HS_BAM_CNFG_BITS__BAM_ADML_INCR4_EN_N___S                                0
#define   USB_OTG_HS_BAM_CNFG_BITS___M                                                     0x1FFFFFFF
#define   USB_OTG_HS_BAM_CNFG_BITS___S                                                     0

#define USB_OTG_HS_BAM_IRQ_SRCS_EEn(n)                                        (0x00004800+0x80*(n))
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn_nMIN                     0
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn_nMAX                     7
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn_ELEM                     8
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn___POR                                                0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn__P_IRQ___S                                           0
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn___M                                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EEn___S                                                  0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE0                                                      (0x00004800)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE0___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE0__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE0__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE0__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE0__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE1                                                      (0x00004880)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE1___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE1__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE1__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE1__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE1__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE2                                                      (0x00004900)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE2___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE2__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE2__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE2__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE2__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE3                                                      (0x00004980)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE3___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE3__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE3__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE3__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE3__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE4                                                      (0x00004A00)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE4___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE4__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE4__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE4__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE4__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE5                                                      (0x00004A80)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE5___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE5__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE5__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE5__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE5__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE6                                                      (0x00004B00)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE6___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE6__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE6__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE6__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE6__P_IRQ___S                                           0
#define USB_OTG_HS_BAM_IRQ_SRCS_EE7                                                      (0x00004B80)
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE7___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE7__BAM_IRQ___M                                         0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE7__BAM_IRQ___S                                         31
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE7__P_IRQ___M                                           0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_EE7__P_IRQ___S                                           0

#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn(n)                                    (0x00004804+0x80*(n))
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn_nMIN                 0
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn_nMAX                 7
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn_ELEM                 8
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn___POR                                            0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__BAM_IRQ_MSK__DISABLE_BAM_INTERRUPT              0x0
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__BAM_IRQ_MSK__ENABLE_BAM_INTERRUPT               0x1
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__P_IRQ_MSK___S                                   0
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__P_IRQ_MSK__DISABLE_PIPE_INTERRUPT               0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn__P_IRQ_MSK__ENABLE_PIPE_INTERRUPT                0x00000001
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn___M                                              0xFFFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EEn___S                                              0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE0                                                  (0x00004804)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE0___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE0__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE0__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE0__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE0__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE1                                                  (0x00004884)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE1___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE1__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE1__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE1__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE1__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE2                                                  (0x00004904)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE2___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE2__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE2__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE2__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE2__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE3                                                  (0x00004984)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE3___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE3__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE3__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE3__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE3__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE4                                                  (0x00004A04)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE4___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE4__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE4__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE4__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE4__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE5                                                  (0x00004A84)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE5___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE5__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE5__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE5__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE5__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE6                                                  (0x00004B04)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE6___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE6__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE6__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE6__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE6__P_IRQ_MSK___S                                   0
#define USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE7                                                  (0x00004B84)
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE7___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE7__BAM_IRQ_MSK___M                                 0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE7__BAM_IRQ_MSK___S                                 31
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE7__P_IRQ_MSK___M                                   0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_MSK_EE7__P_IRQ_MSK___S                                   0

#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn(n)                               (0x00004808+0x80*(n))
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn_nMIN            0
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn_nMAX            7
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn_ELEM            8
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn___POR                                       0x00000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn__P_IRQ_UNMASKED___S                         0
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn___M                                         0xFFFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EEn___S                                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE0                                             (0x00004808)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE0___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE0__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE0__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE0__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE0__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE1                                             (0x00004888)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE1___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE1__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE1__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE1__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE1__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE2                                             (0x00004908)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE2___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE2__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE2__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE2__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE2__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE3                                             (0x00004988)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE3___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE3__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE3__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE3__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE3__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE4                                             (0x00004A08)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE4___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE4__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE4__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE4__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE4__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE5                                             (0x00004A88)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE5___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE5__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE5__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE5__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE5__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE6                                             (0x00004B08)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE6___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE6__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE6__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE6__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE6__P_IRQ_UNMASKED___S                         0
#define USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE7                                             (0x00004B88)
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE7___RWC                                       QCSR_REG_RO
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE7__BAM_IRQ_UNMASKED___M                       0x80000000
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE7__BAM_IRQ_UNMASKED___S                       31
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE7__P_IRQ_UNMASKED___M                         0x7FFFFFFF
#define   USB_OTG_HS_BAM_IRQ_SRCS_UNMASKED_EE7__P_IRQ_UNMASKED___S                         0

#define USB_OTG_HS_BAM_P_CTRLn(n)                                             (0x00005000+0x1000*(n))
#define   USB_OTG_HS_BAM_P_CTRLn_nMIN                          0
#define   USB_OTG_HS_BAM_P_CTRLn_nMAX                          15
#define   USB_OTG_HS_BAM_P_CTRLn_ELEM                          16
#define   USB_OTG_HS_BAM_P_CTRLn___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRLn___POR                                                     0x00000000
#define   USB_OTG_HS_BAM_P_CTRLn__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRLn__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRLn__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRLn__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRLn__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRLn__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRLn__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRLn__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRLn__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRLn__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRLn__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRLn__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRLn__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRLn__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRLn__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRLn__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRLn__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRLn__P_EN___S                                                 1
#define   USB_OTG_HS_BAM_P_CTRLn___M                                                       0x001FFFFE
#define   USB_OTG_HS_BAM_P_CTRLn___S                                                       1
#define USB_OTG_HS_BAM_P_CTRL0                                                           (0x00005000)
#define   USB_OTG_HS_BAM_P_CTRL0___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL0__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL0__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL0__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL0__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL0__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL0__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL0__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL0__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL0__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL0__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL0__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL0__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL0__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL0__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL0__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL0__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL0__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL0__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL1                                                           (0x00006000)
#define   USB_OTG_HS_BAM_P_CTRL1___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL1__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL1__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL1__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL1__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL1__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL1__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL1__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL1__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL1__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL1__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL1__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL1__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL1__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL1__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL1__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL1__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL1__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL1__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL2                                                           (0x00007000)
#define   USB_OTG_HS_BAM_P_CTRL2___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL2__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL2__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL2__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL2__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL2__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL2__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL2__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL2__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL2__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL2__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL2__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL2__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL2__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL2__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL2__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL2__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL2__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL2__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL3                                                           (0x00008000)
#define   USB_OTG_HS_BAM_P_CTRL3___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL3__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL3__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL3__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL3__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL3__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL3__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL3__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL3__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL3__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL3__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL3__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL3__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL3__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL3__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL3__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL3__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL3__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL3__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL4                                                           (0x00009000)
#define   USB_OTG_HS_BAM_P_CTRL4___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL4__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL4__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL4__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL4__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL4__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL4__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL4__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL4__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL4__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL4__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL4__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL4__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL4__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL4__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL4__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL4__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL4__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL4__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL5                                                           (0x0000A000)
#define   USB_OTG_HS_BAM_P_CTRL5___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL5__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL5__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL5__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL5__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL5__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL5__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL5__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL5__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL5__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL5__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL5__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL5__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL5__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL5__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL5__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL5__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL5__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL5__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL6                                                           (0x0000B000)
#define   USB_OTG_HS_BAM_P_CTRL6___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL6__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL6__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL6__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL6__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL6__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL6__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL6__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL6__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL6__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL6__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL6__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL6__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL6__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL6__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL6__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL6__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL6__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL6__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL7                                                           (0x0000C000)
#define   USB_OTG_HS_BAM_P_CTRL7___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL7__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL7__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL7__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL7__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL7__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL7__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL7__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL7__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL7__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL7__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL7__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL7__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL7__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL7__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL7__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL7__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL7__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL7__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL8                                                           (0x0000D000)
#define   USB_OTG_HS_BAM_P_CTRL8___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL8__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL8__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL8__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL8__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL8__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL8__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL8__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL8__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL8__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL8__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL8__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL8__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL8__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL8__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL8__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL8__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL8__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL8__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL9                                                           (0x0000E000)
#define   USB_OTG_HS_BAM_P_CTRL9___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL9__P_LOCK_GROUP___M                                         0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL9__P_LOCK_GROUP___S                                         16
#define   USB_OTG_HS_BAM_P_CTRL9__P_WRITE_NWD___M                                          0x00000800
#define   USB_OTG_HS_BAM_P_CTRL9__P_WRITE_NWD___S                                          11
#define   USB_OTG_HS_BAM_P_CTRL9__P_PREFETCH_LIMIT___M                                     0x00000600
#define   USB_OTG_HS_BAM_P_CTRL9__P_PREFETCH_LIMIT___S                                     9
#define   USB_OTG_HS_BAM_P_CTRL9__P_AUTO_EOB_SEL___M                                       0x00000180
#define   USB_OTG_HS_BAM_P_CTRL9__P_AUTO_EOB_SEL___S                                       7
#define   USB_OTG_HS_BAM_P_CTRL9__P_AUTO_EOB___M                                           0x00000040
#define   USB_OTG_HS_BAM_P_CTRL9__P_AUTO_EOB___S                                           6
#define   USB_OTG_HS_BAM_P_CTRL9__P_SYS_MODE___M                                           0x00000020
#define   USB_OTG_HS_BAM_P_CTRL9__P_SYS_MODE___S                                           5
#define   USB_OTG_HS_BAM_P_CTRL9__P_SYS_STRM___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_CTRL9__P_SYS_STRM___S                                           4
#define   USB_OTG_HS_BAM_P_CTRL9__P_DIRECTION___M                                          0x00000008
#define   USB_OTG_HS_BAM_P_CTRL9__P_DIRECTION___S                                          3
#define   USB_OTG_HS_BAM_P_CTRL9__P_EN___M                                                 0x00000002
#define   USB_OTG_HS_BAM_P_CTRL9__P_EN___S                                                 1
#define USB_OTG_HS_BAM_P_CTRL10                                                          (0x0000F000)
#define   USB_OTG_HS_BAM_P_CTRL10___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL10__P_LOCK_GROUP___M                                        0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL10__P_LOCK_GROUP___S                                        16
#define   USB_OTG_HS_BAM_P_CTRL10__P_WRITE_NWD___M                                         0x00000800
#define   USB_OTG_HS_BAM_P_CTRL10__P_WRITE_NWD___S                                         11
#define   USB_OTG_HS_BAM_P_CTRL10__P_PREFETCH_LIMIT___M                                    0x00000600
#define   USB_OTG_HS_BAM_P_CTRL10__P_PREFETCH_LIMIT___S                                    9
#define   USB_OTG_HS_BAM_P_CTRL10__P_AUTO_EOB_SEL___M                                      0x00000180
#define   USB_OTG_HS_BAM_P_CTRL10__P_AUTO_EOB_SEL___S                                      7
#define   USB_OTG_HS_BAM_P_CTRL10__P_AUTO_EOB___M                                          0x00000040
#define   USB_OTG_HS_BAM_P_CTRL10__P_AUTO_EOB___S                                          6
#define   USB_OTG_HS_BAM_P_CTRL10__P_SYS_MODE___M                                          0x00000020
#define   USB_OTG_HS_BAM_P_CTRL10__P_SYS_MODE___S                                          5
#define   USB_OTG_HS_BAM_P_CTRL10__P_SYS_STRM___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_CTRL10__P_SYS_STRM___S                                          4
#define   USB_OTG_HS_BAM_P_CTRL10__P_DIRECTION___M                                         0x00000008
#define   USB_OTG_HS_BAM_P_CTRL10__P_DIRECTION___S                                         3
#define   USB_OTG_HS_BAM_P_CTRL10__P_EN___M                                                0x00000002
#define   USB_OTG_HS_BAM_P_CTRL10__P_EN___S                                                1
#define USB_OTG_HS_BAM_P_CTRL11                                                          (0x00010000)
#define   USB_OTG_HS_BAM_P_CTRL11___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL11__P_LOCK_GROUP___M                                        0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL11__P_LOCK_GROUP___S                                        16
#define   USB_OTG_HS_BAM_P_CTRL11__P_WRITE_NWD___M                                         0x00000800
#define   USB_OTG_HS_BAM_P_CTRL11__P_WRITE_NWD___S                                         11
#define   USB_OTG_HS_BAM_P_CTRL11__P_PREFETCH_LIMIT___M                                    0x00000600
#define   USB_OTG_HS_BAM_P_CTRL11__P_PREFETCH_LIMIT___S                                    9
#define   USB_OTG_HS_BAM_P_CTRL11__P_AUTO_EOB_SEL___M                                      0x00000180
#define   USB_OTG_HS_BAM_P_CTRL11__P_AUTO_EOB_SEL___S                                      7
#define   USB_OTG_HS_BAM_P_CTRL11__P_AUTO_EOB___M                                          0x00000040
#define   USB_OTG_HS_BAM_P_CTRL11__P_AUTO_EOB___S                                          6
#define   USB_OTG_HS_BAM_P_CTRL11__P_SYS_MODE___M                                          0x00000020
#define   USB_OTG_HS_BAM_P_CTRL11__P_SYS_MODE___S                                          5
#define   USB_OTG_HS_BAM_P_CTRL11__P_SYS_STRM___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_CTRL11__P_SYS_STRM___S                                          4
#define   USB_OTG_HS_BAM_P_CTRL11__P_DIRECTION___M                                         0x00000008
#define   USB_OTG_HS_BAM_P_CTRL11__P_DIRECTION___S                                         3
#define   USB_OTG_HS_BAM_P_CTRL11__P_EN___M                                                0x00000002
#define   USB_OTG_HS_BAM_P_CTRL11__P_EN___S                                                1
#define USB_OTG_HS_BAM_P_CTRL12                                                          (0x00011000)
#define   USB_OTG_HS_BAM_P_CTRL12___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL12__P_LOCK_GROUP___M                                        0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL12__P_LOCK_GROUP___S                                        16
#define   USB_OTG_HS_BAM_P_CTRL12__P_WRITE_NWD___M                                         0x00000800
#define   USB_OTG_HS_BAM_P_CTRL12__P_WRITE_NWD___S                                         11
#define   USB_OTG_HS_BAM_P_CTRL12__P_PREFETCH_LIMIT___M                                    0x00000600
#define   USB_OTG_HS_BAM_P_CTRL12__P_PREFETCH_LIMIT___S                                    9
#define   USB_OTG_HS_BAM_P_CTRL12__P_AUTO_EOB_SEL___M                                      0x00000180
#define   USB_OTG_HS_BAM_P_CTRL12__P_AUTO_EOB_SEL___S                                      7
#define   USB_OTG_HS_BAM_P_CTRL12__P_AUTO_EOB___M                                          0x00000040
#define   USB_OTG_HS_BAM_P_CTRL12__P_AUTO_EOB___S                                          6
#define   USB_OTG_HS_BAM_P_CTRL12__P_SYS_MODE___M                                          0x00000020
#define   USB_OTG_HS_BAM_P_CTRL12__P_SYS_MODE___S                                          5
#define   USB_OTG_HS_BAM_P_CTRL12__P_SYS_STRM___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_CTRL12__P_SYS_STRM___S                                          4
#define   USB_OTG_HS_BAM_P_CTRL12__P_DIRECTION___M                                         0x00000008
#define   USB_OTG_HS_BAM_P_CTRL12__P_DIRECTION___S                                         3
#define   USB_OTG_HS_BAM_P_CTRL12__P_EN___M                                                0x00000002
#define   USB_OTG_HS_BAM_P_CTRL12__P_EN___S                                                1
#define USB_OTG_HS_BAM_P_CTRL13                                                          (0x00012000)
#define   USB_OTG_HS_BAM_P_CTRL13___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL13__P_LOCK_GROUP___M                                        0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL13__P_LOCK_GROUP___S                                        16
#define   USB_OTG_HS_BAM_P_CTRL13__P_WRITE_NWD___M                                         0x00000800
#define   USB_OTG_HS_BAM_P_CTRL13__P_WRITE_NWD___S                                         11
#define   USB_OTG_HS_BAM_P_CTRL13__P_PREFETCH_LIMIT___M                                    0x00000600
#define   USB_OTG_HS_BAM_P_CTRL13__P_PREFETCH_LIMIT___S                                    9
#define   USB_OTG_HS_BAM_P_CTRL13__P_AUTO_EOB_SEL___M                                      0x00000180
#define   USB_OTG_HS_BAM_P_CTRL13__P_AUTO_EOB_SEL___S                                      7
#define   USB_OTG_HS_BAM_P_CTRL13__P_AUTO_EOB___M                                          0x00000040
#define   USB_OTG_HS_BAM_P_CTRL13__P_AUTO_EOB___S                                          6
#define   USB_OTG_HS_BAM_P_CTRL13__P_SYS_MODE___M                                          0x00000020
#define   USB_OTG_HS_BAM_P_CTRL13__P_SYS_MODE___S                                          5
#define   USB_OTG_HS_BAM_P_CTRL13__P_SYS_STRM___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_CTRL13__P_SYS_STRM___S                                          4
#define   USB_OTG_HS_BAM_P_CTRL13__P_DIRECTION___M                                         0x00000008
#define   USB_OTG_HS_BAM_P_CTRL13__P_DIRECTION___S                                         3
#define   USB_OTG_HS_BAM_P_CTRL13__P_EN___M                                                0x00000002
#define   USB_OTG_HS_BAM_P_CTRL13__P_EN___S                                                1
#define USB_OTG_HS_BAM_P_CTRL14                                                          (0x00013000)
#define   USB_OTG_HS_BAM_P_CTRL14___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL14__P_LOCK_GROUP___M                                        0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL14__P_LOCK_GROUP___S                                        16
#define   USB_OTG_HS_BAM_P_CTRL14__P_WRITE_NWD___M                                         0x00000800
#define   USB_OTG_HS_BAM_P_CTRL14__P_WRITE_NWD___S                                         11
#define   USB_OTG_HS_BAM_P_CTRL14__P_PREFETCH_LIMIT___M                                    0x00000600
#define   USB_OTG_HS_BAM_P_CTRL14__P_PREFETCH_LIMIT___S                                    9
#define   USB_OTG_HS_BAM_P_CTRL14__P_AUTO_EOB_SEL___M                                      0x00000180
#define   USB_OTG_HS_BAM_P_CTRL14__P_AUTO_EOB_SEL___S                                      7
#define   USB_OTG_HS_BAM_P_CTRL14__P_AUTO_EOB___M                                          0x00000040
#define   USB_OTG_HS_BAM_P_CTRL14__P_AUTO_EOB___S                                          6
#define   USB_OTG_HS_BAM_P_CTRL14__P_SYS_MODE___M                                          0x00000020
#define   USB_OTG_HS_BAM_P_CTRL14__P_SYS_MODE___S                                          5
#define   USB_OTG_HS_BAM_P_CTRL14__P_SYS_STRM___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_CTRL14__P_SYS_STRM___S                                          4
#define   USB_OTG_HS_BAM_P_CTRL14__P_DIRECTION___M                                         0x00000008
#define   USB_OTG_HS_BAM_P_CTRL14__P_DIRECTION___S                                         3
#define   USB_OTG_HS_BAM_P_CTRL14__P_EN___M                                                0x00000002
#define   USB_OTG_HS_BAM_P_CTRL14__P_EN___S                                                1
#define USB_OTG_HS_BAM_P_CTRL15                                                          (0x00014000)
#define   USB_OTG_HS_BAM_P_CTRL15___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_CTRL15__P_LOCK_GROUP___M                                        0x001F0000
#define   USB_OTG_HS_BAM_P_CTRL15__P_LOCK_GROUP___S                                        16
#define   USB_OTG_HS_BAM_P_CTRL15__P_WRITE_NWD___M                                         0x00000800
#define   USB_OTG_HS_BAM_P_CTRL15__P_WRITE_NWD___S                                         11
#define   USB_OTG_HS_BAM_P_CTRL15__P_PREFETCH_LIMIT___M                                    0x00000600
#define   USB_OTG_HS_BAM_P_CTRL15__P_PREFETCH_LIMIT___S                                    9
#define   USB_OTG_HS_BAM_P_CTRL15__P_AUTO_EOB_SEL___M                                      0x00000180
#define   USB_OTG_HS_BAM_P_CTRL15__P_AUTO_EOB_SEL___S                                      7
#define   USB_OTG_HS_BAM_P_CTRL15__P_AUTO_EOB___M                                          0x00000040
#define   USB_OTG_HS_BAM_P_CTRL15__P_AUTO_EOB___S                                          6
#define   USB_OTG_HS_BAM_P_CTRL15__P_SYS_MODE___M                                          0x00000020
#define   USB_OTG_HS_BAM_P_CTRL15__P_SYS_MODE___S                                          5
#define   USB_OTG_HS_BAM_P_CTRL15__P_SYS_STRM___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_CTRL15__P_SYS_STRM___S                                          4
#define   USB_OTG_HS_BAM_P_CTRL15__P_DIRECTION___M                                         0x00000008
#define   USB_OTG_HS_BAM_P_CTRL15__P_DIRECTION___S                                         3
#define   USB_OTG_HS_BAM_P_CTRL15__P_EN___M                                                0x00000002
#define   USB_OTG_HS_BAM_P_CTRL15__P_EN___S                                                1

#define USB_OTG_HS_BAM_P_RSTn(n)                                              (0x00005004+0x1000*(n))
#define   USB_OTG_HS_BAM_P_RSTn_nMIN                           0
#define   USB_OTG_HS_BAM_P_RSTn_nMAX                           15
#define   USB_OTG_HS_BAM_P_RSTn_ELEM                           16
#define   USB_OTG_HS_BAM_P_RSTn___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RSTn___POR                                                      0x00000000
#define   USB_OTG_HS_BAM_P_RSTn__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RSTn__P_SW_RST___S                                              0
#define   USB_OTG_HS_BAM_P_RSTn___M                                                        0x00000001
#define   USB_OTG_HS_BAM_P_RSTn___S                                                        0
#define USB_OTG_HS_BAM_P_RST0                                                            (0x00005004)
#define   USB_OTG_HS_BAM_P_RST0___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST0__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST0__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST1                                                            (0x00006004)
#define   USB_OTG_HS_BAM_P_RST1___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST1__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST1__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST2                                                            (0x00007004)
#define   USB_OTG_HS_BAM_P_RST2___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST2__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST2__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST3                                                            (0x00008004)
#define   USB_OTG_HS_BAM_P_RST3___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST3__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST3__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST4                                                            (0x00009004)
#define   USB_OTG_HS_BAM_P_RST4___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST4__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST4__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST5                                                            (0x0000A004)
#define   USB_OTG_HS_BAM_P_RST5___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST5__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST5__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST6                                                            (0x0000B004)
#define   USB_OTG_HS_BAM_P_RST6___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST6__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST6__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST7                                                            (0x0000C004)
#define   USB_OTG_HS_BAM_P_RST7___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST7__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST7__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST8                                                            (0x0000D004)
#define   USB_OTG_HS_BAM_P_RST8___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST8__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST8__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST9                                                            (0x0000E004)
#define   USB_OTG_HS_BAM_P_RST9___RWC                                                      QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST9__P_SW_RST___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_RST9__P_SW_RST___S                                              0
#define USB_OTG_HS_BAM_P_RST10                                                           (0x0000F004)
#define   USB_OTG_HS_BAM_P_RST10___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST10__P_SW_RST___M                                             0x00000001
#define   USB_OTG_HS_BAM_P_RST10__P_SW_RST___S                                             0
#define USB_OTG_HS_BAM_P_RST11                                                           (0x00010004)
#define   USB_OTG_HS_BAM_P_RST11___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST11__P_SW_RST___M                                             0x00000001
#define   USB_OTG_HS_BAM_P_RST11__P_SW_RST___S                                             0
#define USB_OTG_HS_BAM_P_RST12                                                           (0x00011004)
#define   USB_OTG_HS_BAM_P_RST12___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST12__P_SW_RST___M                                             0x00000001
#define   USB_OTG_HS_BAM_P_RST12__P_SW_RST___S                                             0
#define USB_OTG_HS_BAM_P_RST13                                                           (0x00012004)
#define   USB_OTG_HS_BAM_P_RST13___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST13__P_SW_RST___M                                             0x00000001
#define   USB_OTG_HS_BAM_P_RST13__P_SW_RST___S                                             0
#define USB_OTG_HS_BAM_P_RST14                                                           (0x00013004)
#define   USB_OTG_HS_BAM_P_RST14___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST14__P_SW_RST___M                                             0x00000001
#define   USB_OTG_HS_BAM_P_RST14__P_SW_RST___S                                             0
#define USB_OTG_HS_BAM_P_RST15                                                           (0x00014004)
#define   USB_OTG_HS_BAM_P_RST15___RWC                                                     QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_RST15__P_SW_RST___M                                             0x00000001
#define   USB_OTG_HS_BAM_P_RST15__P_SW_RST___S                                             0

#define USB_OTG_HS_BAM_P_HALTn(n)                                             (0x00005008+0x1000*(n))
#define   USB_OTG_HS_BAM_P_HALTn_nMIN                          0
#define   USB_OTG_HS_BAM_P_HALTn_nMAX                          15
#define   USB_OTG_HS_BAM_P_HALTn_ELEM                          16
#define   USB_OTG_HS_BAM_P_HALTn___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALTn___POR                                                     0x00000000
#define   USB_OTG_HS_BAM_P_HALTn__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALTn__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALTn__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALTn__P_HALT___S                                               0
#define   USB_OTG_HS_BAM_P_HALTn___M                                                       0x00000003
#define   USB_OTG_HS_BAM_P_HALTn___S                                                       0
#define USB_OTG_HS_BAM_P_HALT0                                                           (0x00005008)
#define   USB_OTG_HS_BAM_P_HALT0___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT0__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT0__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT0__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT0__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT1                                                           (0x00006008)
#define   USB_OTG_HS_BAM_P_HALT1___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT1__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT1__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT1__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT1__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT2                                                           (0x00007008)
#define   USB_OTG_HS_BAM_P_HALT2___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT2__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT2__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT2__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT2__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT3                                                           (0x00008008)
#define   USB_OTG_HS_BAM_P_HALT3___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT3__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT3__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT3__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT3__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT4                                                           (0x00009008)
#define   USB_OTG_HS_BAM_P_HALT4___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT4__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT4__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT4__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT4__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT5                                                           (0x0000A008)
#define   USB_OTG_HS_BAM_P_HALT5___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT5__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT5__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT5__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT5__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT6                                                           (0x0000B008)
#define   USB_OTG_HS_BAM_P_HALT6___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT6__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT6__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT6__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT6__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT7                                                           (0x0000C008)
#define   USB_OTG_HS_BAM_P_HALT7___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT7__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT7__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT7__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT7__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT8                                                           (0x0000D008)
#define   USB_OTG_HS_BAM_P_HALT8___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT8__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT8__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT8__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT8__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT9                                                           (0x0000E008)
#define   USB_OTG_HS_BAM_P_HALT9___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT9__P_PROD_HALTED___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_HALT9__P_PROD_HALTED___S                                        1
#define   USB_OTG_HS_BAM_P_HALT9__P_HALT___M                                               0x00000001
#define   USB_OTG_HS_BAM_P_HALT9__P_HALT___S                                               0
#define USB_OTG_HS_BAM_P_HALT10                                                          (0x0000F008)
#define   USB_OTG_HS_BAM_P_HALT10___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT10__P_PROD_HALTED___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_HALT10__P_PROD_HALTED___S                                       1
#define   USB_OTG_HS_BAM_P_HALT10__P_HALT___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_HALT10__P_HALT___S                                              0
#define USB_OTG_HS_BAM_P_HALT11                                                          (0x00010008)
#define   USB_OTG_HS_BAM_P_HALT11___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT11__P_PROD_HALTED___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_HALT11__P_PROD_HALTED___S                                       1
#define   USB_OTG_HS_BAM_P_HALT11__P_HALT___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_HALT11__P_HALT___S                                              0
#define USB_OTG_HS_BAM_P_HALT12                                                          (0x00011008)
#define   USB_OTG_HS_BAM_P_HALT12___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT12__P_PROD_HALTED___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_HALT12__P_PROD_HALTED___S                                       1
#define   USB_OTG_HS_BAM_P_HALT12__P_HALT___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_HALT12__P_HALT___S                                              0
#define USB_OTG_HS_BAM_P_HALT13                                                          (0x00012008)
#define   USB_OTG_HS_BAM_P_HALT13___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT13__P_PROD_HALTED___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_HALT13__P_PROD_HALTED___S                                       1
#define   USB_OTG_HS_BAM_P_HALT13__P_HALT___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_HALT13__P_HALT___S                                              0
#define USB_OTG_HS_BAM_P_HALT14                                                          (0x00013008)
#define   USB_OTG_HS_BAM_P_HALT14___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT14__P_PROD_HALTED___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_HALT14__P_PROD_HALTED___S                                       1
#define   USB_OTG_HS_BAM_P_HALT14__P_HALT___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_HALT14__P_HALT___S                                              0
#define USB_OTG_HS_BAM_P_HALT15                                                          (0x00014008)
#define   USB_OTG_HS_BAM_P_HALT15___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_HALT15__P_PROD_HALTED___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_HALT15__P_PROD_HALTED___S                                       1
#define   USB_OTG_HS_BAM_P_HALT15__P_HALT___M                                              0x00000001
#define   USB_OTG_HS_BAM_P_HALT15__P_HALT___S                                              0

#define USB_OTG_HS_BAM_P_TRUST_REGn(n)                                        (0x00005030+0x1000*(n))
#define   USB_OTG_HS_BAM_P_TRUST_REGn_nMIN                     0
#define   USB_OTG_HS_BAM_P_TRUST_REGn_nMAX                     15
#define   USB_OTG_HS_BAM_P_TRUST_REGn_ELEM                     16
#define   USB_OTG_HS_BAM_P_TRUST_REGn___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REGn___POR                                                0x00000000
#define   USB_OTG_HS_BAM_P_TRUST_REGn__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REGn__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REGn__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REGn__BAM_P_EE___S                                        0
#define   USB_OTG_HS_BAM_P_TRUST_REGn___M                                                  0x00001FFF
#define   USB_OTG_HS_BAM_P_TRUST_REGn___S                                                  0
#define USB_OTG_HS_BAM_P_TRUST_REG0                                                      (0x00005030)
#define   USB_OTG_HS_BAM_P_TRUST_REG0___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG0__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG0__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG0__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG0__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG1                                                      (0x00006030)
#define   USB_OTG_HS_BAM_P_TRUST_REG1___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG1__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG1__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG1__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG1__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG2                                                      (0x00007030)
#define   USB_OTG_HS_BAM_P_TRUST_REG2___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG2__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG2__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG2__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG2__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG3                                                      (0x00008030)
#define   USB_OTG_HS_BAM_P_TRUST_REG3___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG3__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG3__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG3__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG3__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG4                                                      (0x00009030)
#define   USB_OTG_HS_BAM_P_TRUST_REG4___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG4__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG4__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG4__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG4__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG5                                                      (0x0000A030)
#define   USB_OTG_HS_BAM_P_TRUST_REG5___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG5__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG5__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG5__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG5__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG6                                                      (0x0000B030)
#define   USB_OTG_HS_BAM_P_TRUST_REG6___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG6__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG6__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG6__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG6__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG7                                                      (0x0000C030)
#define   USB_OTG_HS_BAM_P_TRUST_REG7___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG7__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG7__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG7__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG7__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG8                                                      (0x0000D030)
#define   USB_OTG_HS_BAM_P_TRUST_REG8___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG8__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG8__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG8__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG8__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG9                                                      (0x0000E030)
#define   USB_OTG_HS_BAM_P_TRUST_REG9___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG9__BAM_P_VMID___M                                      0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG9__BAM_P_VMID___S                                      8
#define   USB_OTG_HS_BAM_P_TRUST_REG9__BAM_P_EE___M                                        0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG9__BAM_P_EE___S                                        0
#define USB_OTG_HS_BAM_P_TRUST_REG10                                                     (0x0000F030)
#define   USB_OTG_HS_BAM_P_TRUST_REG10___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG10__BAM_P_VMID___M                                     0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG10__BAM_P_VMID___S                                     8
#define   USB_OTG_HS_BAM_P_TRUST_REG10__BAM_P_EE___M                                       0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG10__BAM_P_EE___S                                       0
#define USB_OTG_HS_BAM_P_TRUST_REG11                                                     (0x00010030)
#define   USB_OTG_HS_BAM_P_TRUST_REG11___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG11__BAM_P_VMID___M                                     0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG11__BAM_P_VMID___S                                     8
#define   USB_OTG_HS_BAM_P_TRUST_REG11__BAM_P_EE___M                                       0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG11__BAM_P_EE___S                                       0
#define USB_OTG_HS_BAM_P_TRUST_REG12                                                     (0x00011030)
#define   USB_OTG_HS_BAM_P_TRUST_REG12___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG12__BAM_P_VMID___M                                     0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG12__BAM_P_VMID___S                                     8
#define   USB_OTG_HS_BAM_P_TRUST_REG12__BAM_P_EE___M                                       0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG12__BAM_P_EE___S                                       0
#define USB_OTG_HS_BAM_P_TRUST_REG13                                                     (0x00012030)
#define   USB_OTG_HS_BAM_P_TRUST_REG13___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG13__BAM_P_VMID___M                                     0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG13__BAM_P_VMID___S                                     8
#define   USB_OTG_HS_BAM_P_TRUST_REG13__BAM_P_EE___M                                       0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG13__BAM_P_EE___S                                       0
#define USB_OTG_HS_BAM_P_TRUST_REG14                                                     (0x00013030)
#define   USB_OTG_HS_BAM_P_TRUST_REG14___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG14__BAM_P_VMID___M                                     0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG14__BAM_P_VMID___S                                     8
#define   USB_OTG_HS_BAM_P_TRUST_REG14__BAM_P_EE___M                                       0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG14__BAM_P_EE___S                                       0
#define USB_OTG_HS_BAM_P_TRUST_REG15                                                     (0x00014030)
#define   USB_OTG_HS_BAM_P_TRUST_REG15___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TRUST_REG15__BAM_P_VMID___M                                     0x00001F00
#define   USB_OTG_HS_BAM_P_TRUST_REG15__BAM_P_VMID___S                                     8
#define   USB_OTG_HS_BAM_P_TRUST_REG15__BAM_P_EE___M                                       0x00000007
#define   USB_OTG_HS_BAM_P_TRUST_REG15__BAM_P_EE___S                                       0

#define USB_OTG_HS_BAM_P_IRQ_STTSn(n)                                         (0x00005010+0x1000*(n))
#define   USB_OTG_HS_BAM_P_IRQ_STTSn_nMIN                      0
#define   USB_OTG_HS_BAM_P_IRQ_STTSn_nMAX                      15
#define   USB_OTG_HS_BAM_P_IRQ_STTSn_ELEM                      16
#define   USB_OTG_HS_BAM_P_IRQ_STTSn___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTSn___POR                                                 0x00000000
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTSn__P_PRCSD_DESC_IRQ___S                                 0
#define   USB_OTG_HS_BAM_P_IRQ_STTSn___M                                                   0x0000003F
#define   USB_OTG_HS_BAM_P_IRQ_STTSn___S                                                   0
#define USB_OTG_HS_BAM_P_IRQ_STTS0                                                       (0x00005010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS0___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS0__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS1                                                       (0x00006010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS1___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS1__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS2                                                       (0x00007010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS2___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS2__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS3                                                       (0x00008010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS3___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS3__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS4                                                       (0x00009010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS4___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS4__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS5                                                       (0x0000A010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS5___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS5__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS6                                                       (0x0000B010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS6___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS6__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS7                                                       (0x0000C010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS7___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS7__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS8                                                       (0x0000D010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS8___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS8__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS9                                                       (0x0000E010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS9___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_TRNSFR_END_IRQ___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_TRNSFR_END_IRQ___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_ERR_IRQ___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_ERR_IRQ___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_OUT_OF_DESC_IRQ___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_OUT_OF_DESC_IRQ___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_WAKE_IRQ___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_WAKE_IRQ___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_TIMER_IRQ___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_TIMER_IRQ___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_PRCSD_DESC_IRQ___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS9__P_PRCSD_DESC_IRQ___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_STTS10                                                      (0x0000F010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS10___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_TRNSFR_END_IRQ___M                                0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_TRNSFR_END_IRQ___S                                5
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_ERR_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_ERR_IRQ___S                                       4
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_OUT_OF_DESC_IRQ___M                               0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_OUT_OF_DESC_IRQ___S                               3
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_WAKE_IRQ___M                                      0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_WAKE_IRQ___S                                      2
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_TIMER_IRQ___M                                     0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_TIMER_IRQ___S                                     1
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_PRCSD_DESC_IRQ___M                                0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS10__P_PRCSD_DESC_IRQ___S                                0
#define USB_OTG_HS_BAM_P_IRQ_STTS11                                                      (0x00010010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS11___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_TRNSFR_END_IRQ___M                                0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_TRNSFR_END_IRQ___S                                5
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_ERR_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_ERR_IRQ___S                                       4
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_OUT_OF_DESC_IRQ___M                               0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_OUT_OF_DESC_IRQ___S                               3
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_WAKE_IRQ___M                                      0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_WAKE_IRQ___S                                      2
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_TIMER_IRQ___M                                     0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_TIMER_IRQ___S                                     1
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_PRCSD_DESC_IRQ___M                                0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS11__P_PRCSD_DESC_IRQ___S                                0
#define USB_OTG_HS_BAM_P_IRQ_STTS12                                                      (0x00011010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS12___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_TRNSFR_END_IRQ___M                                0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_TRNSFR_END_IRQ___S                                5
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_ERR_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_ERR_IRQ___S                                       4
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_OUT_OF_DESC_IRQ___M                               0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_OUT_OF_DESC_IRQ___S                               3
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_WAKE_IRQ___M                                      0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_WAKE_IRQ___S                                      2
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_TIMER_IRQ___M                                     0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_TIMER_IRQ___S                                     1
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_PRCSD_DESC_IRQ___M                                0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS12__P_PRCSD_DESC_IRQ___S                                0
#define USB_OTG_HS_BAM_P_IRQ_STTS13                                                      (0x00012010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS13___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_TRNSFR_END_IRQ___M                                0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_TRNSFR_END_IRQ___S                                5
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_ERR_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_ERR_IRQ___S                                       4
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_OUT_OF_DESC_IRQ___M                               0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_OUT_OF_DESC_IRQ___S                               3
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_WAKE_IRQ___M                                      0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_WAKE_IRQ___S                                      2
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_TIMER_IRQ___M                                     0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_TIMER_IRQ___S                                     1
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_PRCSD_DESC_IRQ___M                                0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS13__P_PRCSD_DESC_IRQ___S                                0
#define USB_OTG_HS_BAM_P_IRQ_STTS14                                                      (0x00013010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS14___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_TRNSFR_END_IRQ___M                                0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_TRNSFR_END_IRQ___S                                5
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_ERR_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_ERR_IRQ___S                                       4
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_OUT_OF_DESC_IRQ___M                               0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_OUT_OF_DESC_IRQ___S                               3
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_WAKE_IRQ___M                                      0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_WAKE_IRQ___S                                      2
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_TIMER_IRQ___M                                     0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_TIMER_IRQ___S                                     1
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_PRCSD_DESC_IRQ___M                                0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS14__P_PRCSD_DESC_IRQ___S                                0
#define USB_OTG_HS_BAM_P_IRQ_STTS15                                                      (0x00014010)
#define   USB_OTG_HS_BAM_P_IRQ_STTS15___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_TRNSFR_END_IRQ___M                                0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_TRNSFR_END_IRQ___S                                5
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_ERR_IRQ___M                                       0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_ERR_IRQ___S                                       4
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_OUT_OF_DESC_IRQ___M                               0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_OUT_OF_DESC_IRQ___S                               3
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_WAKE_IRQ___M                                      0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_WAKE_IRQ___S                                      2
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_TIMER_IRQ___M                                     0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_TIMER_IRQ___S                                     1
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_PRCSD_DESC_IRQ___M                                0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_STTS15__P_PRCSD_DESC_IRQ___S                                0

#define USB_OTG_HS_BAM_P_IRQ_CLRn(n)                                          (0x00005014+0x1000*(n))
#define   USB_OTG_HS_BAM_P_IRQ_CLRn_nMIN                       0
#define   USB_OTG_HS_BAM_P_IRQ_CLRn_nMAX                       15
#define   USB_OTG_HS_BAM_P_IRQ_CLRn_ELEM                       16
#define   USB_OTG_HS_BAM_P_IRQ_CLRn___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLRn___POR                                                  0x00000000
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLRn__P_PRCSD_DESC_CLR___S                                  0
#define   USB_OTG_HS_BAM_P_IRQ_CLRn___M                                                    0x0000003F
#define   USB_OTG_HS_BAM_P_IRQ_CLRn___S                                                    0
#define USB_OTG_HS_BAM_P_IRQ_CLR0                                                        (0x00005014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR0___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR0__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR1                                                        (0x00006014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR1___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR1__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR2                                                        (0x00007014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR2___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR2__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR3                                                        (0x00008014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR3___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR3__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR4                                                        (0x00009014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR4___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR4__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR5                                                        (0x0000A014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR5___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR5__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR6                                                        (0x0000B014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR6___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR6__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR7                                                        (0x0000C014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR7___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR7__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR8                                                        (0x0000D014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR8___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR8__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR9                                                        (0x0000E014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR9___RWC                                                  QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_TRNSFR_END_CLR___M                                  0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_TRNSFR_END_CLR___S                                  5
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_ERR_CLR___M                                         0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_ERR_CLR___S                                         4
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_OUT_OF_DESC_CLR___M                                 0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_OUT_OF_DESC_CLR___S                                 3
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_WAKE_CLR___M                                        0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_WAKE_CLR___S                                        2
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_TIMER_CLR___M                                       0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_TIMER_CLR___S                                       1
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_PRCSD_DESC_CLR___M                                  0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR9__P_PRCSD_DESC_CLR___S                                  0
#define USB_OTG_HS_BAM_P_IRQ_CLR10                                                       (0x0000F014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR10___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_TRNSFR_END_CLR___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_TRNSFR_END_CLR___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_ERR_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_ERR_CLR___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_OUT_OF_DESC_CLR___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_OUT_OF_DESC_CLR___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_WAKE_CLR___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_WAKE_CLR___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_TIMER_CLR___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_TIMER_CLR___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_PRCSD_DESC_CLR___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR10__P_PRCSD_DESC_CLR___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_CLR11                                                       (0x00010014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR11___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_TRNSFR_END_CLR___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_TRNSFR_END_CLR___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_ERR_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_ERR_CLR___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_OUT_OF_DESC_CLR___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_OUT_OF_DESC_CLR___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_WAKE_CLR___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_WAKE_CLR___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_TIMER_CLR___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_TIMER_CLR___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_PRCSD_DESC_CLR___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR11__P_PRCSD_DESC_CLR___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_CLR12                                                       (0x00011014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR12___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_TRNSFR_END_CLR___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_TRNSFR_END_CLR___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_ERR_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_ERR_CLR___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_OUT_OF_DESC_CLR___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_OUT_OF_DESC_CLR___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_WAKE_CLR___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_WAKE_CLR___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_TIMER_CLR___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_TIMER_CLR___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_PRCSD_DESC_CLR___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR12__P_PRCSD_DESC_CLR___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_CLR13                                                       (0x00012014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR13___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_TRNSFR_END_CLR___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_TRNSFR_END_CLR___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_ERR_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_ERR_CLR___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_OUT_OF_DESC_CLR___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_OUT_OF_DESC_CLR___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_WAKE_CLR___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_WAKE_CLR___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_TIMER_CLR___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_TIMER_CLR___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_PRCSD_DESC_CLR___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR13__P_PRCSD_DESC_CLR___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_CLR14                                                       (0x00013014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR14___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_TRNSFR_END_CLR___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_TRNSFR_END_CLR___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_ERR_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_ERR_CLR___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_OUT_OF_DESC_CLR___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_OUT_OF_DESC_CLR___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_WAKE_CLR___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_WAKE_CLR___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_TIMER_CLR___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_TIMER_CLR___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_PRCSD_DESC_CLR___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR14__P_PRCSD_DESC_CLR___S                                 0
#define USB_OTG_HS_BAM_P_IRQ_CLR15                                                       (0x00014014)
#define   USB_OTG_HS_BAM_P_IRQ_CLR15___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_TRNSFR_END_CLR___M                                 0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_TRNSFR_END_CLR___S                                 5
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_ERR_CLR___M                                        0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_ERR_CLR___S                                        4
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_OUT_OF_DESC_CLR___M                                0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_OUT_OF_DESC_CLR___S                                3
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_WAKE_CLR___M                                       0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_WAKE_CLR___S                                       2
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_TIMER_CLR___M                                      0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_TIMER_CLR___S                                      1
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_PRCSD_DESC_CLR___M                                 0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_CLR15__P_PRCSD_DESC_CLR___S                                 0

#define USB_OTG_HS_BAM_P_IRQ_ENn(n)                                           (0x00005018+0x1000*(n))
#define   USB_OTG_HS_BAM_P_IRQ_ENn_nMIN                        0
#define   USB_OTG_HS_BAM_P_IRQ_ENn_nMAX                        15
#define   USB_OTG_HS_BAM_P_IRQ_ENn_ELEM                        16
#define   USB_OTG_HS_BAM_P_IRQ_ENn___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_ENn___POR                                                   0x00000000
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_ENn__P_PRCSD_DESC_EN___S                                    0
#define   USB_OTG_HS_BAM_P_IRQ_ENn___M                                                     0x0000003F
#define   USB_OTG_HS_BAM_P_IRQ_ENn___S                                                     0
#define USB_OTG_HS_BAM_P_IRQ_EN0                                                         (0x00005018)
#define   USB_OTG_HS_BAM_P_IRQ_EN0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN0__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN1                                                         (0x00006018)
#define   USB_OTG_HS_BAM_P_IRQ_EN1___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN1__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN2                                                         (0x00007018)
#define   USB_OTG_HS_BAM_P_IRQ_EN2___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN2__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN3                                                         (0x00008018)
#define   USB_OTG_HS_BAM_P_IRQ_EN3___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN3__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN4                                                         (0x00009018)
#define   USB_OTG_HS_BAM_P_IRQ_EN4___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN4__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN5                                                         (0x0000A018)
#define   USB_OTG_HS_BAM_P_IRQ_EN5___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN5__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN6                                                         (0x0000B018)
#define   USB_OTG_HS_BAM_P_IRQ_EN6___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN6__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN7                                                         (0x0000C018)
#define   USB_OTG_HS_BAM_P_IRQ_EN7___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN7__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN8                                                         (0x0000D018)
#define   USB_OTG_HS_BAM_P_IRQ_EN8___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN8__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN9                                                         (0x0000E018)
#define   USB_OTG_HS_BAM_P_IRQ_EN9___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_TRNSFR_END_EN___M                                    0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_TRNSFR_END_EN___S                                    5
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_ERR_EN___M                                           0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_ERR_EN___S                                           4
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_OUT_OF_DESC_EN___M                                   0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_OUT_OF_DESC_EN___S                                   3
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_WAKE_EN___M                                          0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_WAKE_EN___S                                          2
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_TIMER_EN___M                                         0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_TIMER_EN___S                                         1
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_PRCSD_DESC_EN___M                                    0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN9__P_PRCSD_DESC_EN___S                                    0
#define USB_OTG_HS_BAM_P_IRQ_EN10                                                        (0x0000F018)
#define   USB_OTG_HS_BAM_P_IRQ_EN10___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_TRNSFR_END_EN___M                                   0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_TRNSFR_END_EN___S                                   5
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_ERR_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_ERR_EN___S                                          4
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_OUT_OF_DESC_EN___M                                  0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_OUT_OF_DESC_EN___S                                  3
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_WAKE_EN___M                                         0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_WAKE_EN___S                                         2
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_TIMER_EN___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_TIMER_EN___S                                        1
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_PRCSD_DESC_EN___M                                   0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN10__P_PRCSD_DESC_EN___S                                   0
#define USB_OTG_HS_BAM_P_IRQ_EN11                                                        (0x00010018)
#define   USB_OTG_HS_BAM_P_IRQ_EN11___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_TRNSFR_END_EN___M                                   0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_TRNSFR_END_EN___S                                   5
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_ERR_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_ERR_EN___S                                          4
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_OUT_OF_DESC_EN___M                                  0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_OUT_OF_DESC_EN___S                                  3
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_WAKE_EN___M                                         0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_WAKE_EN___S                                         2
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_TIMER_EN___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_TIMER_EN___S                                        1
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_PRCSD_DESC_EN___M                                   0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN11__P_PRCSD_DESC_EN___S                                   0
#define USB_OTG_HS_BAM_P_IRQ_EN12                                                        (0x00011018)
#define   USB_OTG_HS_BAM_P_IRQ_EN12___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_TRNSFR_END_EN___M                                   0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_TRNSFR_END_EN___S                                   5
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_ERR_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_ERR_EN___S                                          4
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_OUT_OF_DESC_EN___M                                  0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_OUT_OF_DESC_EN___S                                  3
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_WAKE_EN___M                                         0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_WAKE_EN___S                                         2
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_TIMER_EN___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_TIMER_EN___S                                        1
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_PRCSD_DESC_EN___M                                   0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN12__P_PRCSD_DESC_EN___S                                   0
#define USB_OTG_HS_BAM_P_IRQ_EN13                                                        (0x00012018)
#define   USB_OTG_HS_BAM_P_IRQ_EN13___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_TRNSFR_END_EN___M                                   0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_TRNSFR_END_EN___S                                   5
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_ERR_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_ERR_EN___S                                          4
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_OUT_OF_DESC_EN___M                                  0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_OUT_OF_DESC_EN___S                                  3
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_WAKE_EN___M                                         0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_WAKE_EN___S                                         2
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_TIMER_EN___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_TIMER_EN___S                                        1
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_PRCSD_DESC_EN___M                                   0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN13__P_PRCSD_DESC_EN___S                                   0
#define USB_OTG_HS_BAM_P_IRQ_EN14                                                        (0x00013018)
#define   USB_OTG_HS_BAM_P_IRQ_EN14___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_TRNSFR_END_EN___M                                   0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_TRNSFR_END_EN___S                                   5
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_ERR_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_ERR_EN___S                                          4
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_OUT_OF_DESC_EN___M                                  0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_OUT_OF_DESC_EN___S                                  3
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_WAKE_EN___M                                         0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_WAKE_EN___S                                         2
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_TIMER_EN___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_TIMER_EN___S                                        1
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_PRCSD_DESC_EN___M                                   0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN14__P_PRCSD_DESC_EN___S                                   0
#define USB_OTG_HS_BAM_P_IRQ_EN15                                                        (0x00014018)
#define   USB_OTG_HS_BAM_P_IRQ_EN15___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_TRNSFR_END_EN___M                                   0x00000020
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_TRNSFR_END_EN___S                                   5
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_ERR_EN___M                                          0x00000010
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_ERR_EN___S                                          4
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_OUT_OF_DESC_EN___M                                  0x00000008
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_OUT_OF_DESC_EN___S                                  3
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_WAKE_EN___M                                         0x00000004
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_WAKE_EN___S                                         2
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_TIMER_EN___M                                        0x00000002
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_TIMER_EN___S                                        1
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_PRCSD_DESC_EN___M                                   0x00000001
#define   USB_OTG_HS_BAM_P_IRQ_EN15__P_PRCSD_DESC_EN___S                                   0

#define USB_OTG_HS_BAM_P_TIMERn(n)                                            (0x0000501C+0x1000*(n))
#define   USB_OTG_HS_BAM_P_TIMERn_nMIN                         0
#define   USB_OTG_HS_BAM_P_TIMERn_nMAX                         15
#define   USB_OTG_HS_BAM_P_TIMERn_ELEM                         16
#define   USB_OTG_HS_BAM_P_TIMERn___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMERn___POR                                                    0x00000000
#define   USB_OTG_HS_BAM_P_TIMERn__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMERn__P_TIMER___S                                             0
#define   USB_OTG_HS_BAM_P_TIMERn___M                                                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMERn___S                                                      0
#define USB_OTG_HS_BAM_P_TIMER0                                                          (0x0000501C)
#define   USB_OTG_HS_BAM_P_TIMER0___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER0__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER0__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER1                                                          (0x0000601C)
#define   USB_OTG_HS_BAM_P_TIMER1___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER1__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER1__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER2                                                          (0x0000701C)
#define   USB_OTG_HS_BAM_P_TIMER2___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER2__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER2__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER3                                                          (0x0000801C)
#define   USB_OTG_HS_BAM_P_TIMER3___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER3__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER3__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER4                                                          (0x0000901C)
#define   USB_OTG_HS_BAM_P_TIMER4___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER4__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER4__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER5                                                          (0x0000A01C)
#define   USB_OTG_HS_BAM_P_TIMER5___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER5__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER5__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER6                                                          (0x0000B01C)
#define   USB_OTG_HS_BAM_P_TIMER6___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER6__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER6__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER7                                                          (0x0000C01C)
#define   USB_OTG_HS_BAM_P_TIMER7___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER7__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER7__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER8                                                          (0x0000D01C)
#define   USB_OTG_HS_BAM_P_TIMER8___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER8__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER8__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER9                                                          (0x0000E01C)
#define   USB_OTG_HS_BAM_P_TIMER9___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER9__P_TIMER___M                                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER9__P_TIMER___S                                             0
#define USB_OTG_HS_BAM_P_TIMER10                                                         (0x0000F01C)
#define   USB_OTG_HS_BAM_P_TIMER10___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER10__P_TIMER___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER10__P_TIMER___S                                            0
#define USB_OTG_HS_BAM_P_TIMER11                                                         (0x0001001C)
#define   USB_OTG_HS_BAM_P_TIMER11___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER11__P_TIMER___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER11__P_TIMER___S                                            0
#define USB_OTG_HS_BAM_P_TIMER12                                                         (0x0001101C)
#define   USB_OTG_HS_BAM_P_TIMER12___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER12__P_TIMER___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER12__P_TIMER___S                                            0
#define USB_OTG_HS_BAM_P_TIMER13                                                         (0x0001201C)
#define   USB_OTG_HS_BAM_P_TIMER13___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER13__P_TIMER___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER13__P_TIMER___S                                            0
#define USB_OTG_HS_BAM_P_TIMER14                                                         (0x0001301C)
#define   USB_OTG_HS_BAM_P_TIMER14___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER14__P_TIMER___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER14__P_TIMER___S                                            0
#define USB_OTG_HS_BAM_P_TIMER15                                                         (0x0001401C)
#define   USB_OTG_HS_BAM_P_TIMER15___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_TIMER15__P_TIMER___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER15__P_TIMER___S                                            0

#define USB_OTG_HS_BAM_P_TIMER_CTRLn(n)                                       (0x00005020+0x1000*(n))
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn_nMIN                    0
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn_nMAX                    15
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn_ELEM                    16
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn___POR                                               0x00000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn__P_TIMER_TRSHLD___S                                 0
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn___M                                                 0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRLn___S                                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL0                                                     (0x00005020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL0__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL1                                                     (0x00006020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL1__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL2                                                     (0x00007020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL2__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL3                                                     (0x00008020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL3__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL4                                                     (0x00009020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL4__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL5                                                     (0x0000A020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL5__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL6                                                     (0x0000B020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL6__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL7                                                     (0x0000C020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL7__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL8                                                     (0x0000D020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL8__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL9                                                     (0x0000E020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_RST___M                                    0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_RST___S                                    31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_RUN___M                                    0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_RUN___S                                    30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_MODE___M                                   0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_MODE___S                                   29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL9__P_TIMER_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_TIMER_CTRL10                                                    (0x0000F020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_RST___M                                   0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_RST___S                                   31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_RUN___M                                   0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_RUN___S                                   30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_MODE___M                                  0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_MODE___S                                  29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_TRSHLD___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL10__P_TIMER_TRSHLD___S                                0
#define USB_OTG_HS_BAM_P_TIMER_CTRL11                                                    (0x00010020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_RST___M                                   0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_RST___S                                   31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_RUN___M                                   0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_RUN___S                                   30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_MODE___M                                  0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_MODE___S                                  29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_TRSHLD___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL11__P_TIMER_TRSHLD___S                                0
#define USB_OTG_HS_BAM_P_TIMER_CTRL12                                                    (0x00011020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_RST___M                                   0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_RST___S                                   31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_RUN___M                                   0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_RUN___S                                   30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_MODE___M                                  0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_MODE___S                                  29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_TRSHLD___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL12__P_TIMER_TRSHLD___S                                0
#define USB_OTG_HS_BAM_P_TIMER_CTRL13                                                    (0x00012020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_RST___M                                   0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_RST___S                                   31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_RUN___M                                   0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_RUN___S                                   30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_MODE___M                                  0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_MODE___S                                  29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_TRSHLD___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL13__P_TIMER_TRSHLD___S                                0
#define USB_OTG_HS_BAM_P_TIMER_CTRL14                                                    (0x00013020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_RST___M                                   0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_RST___S                                   31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_RUN___M                                   0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_RUN___S                                   30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_MODE___M                                  0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_MODE___S                                  29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_TRSHLD___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL14__P_TIMER_TRSHLD___S                                0
#define USB_OTG_HS_BAM_P_TIMER_CTRL15                                                    (0x00014020)
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_RST___M                                   0x80000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_RST___S                                   31
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_RUN___M                                   0x40000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_RUN___S                                   30
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_MODE___M                                  0x20000000
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_MODE___S                                  29
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_TRSHLD___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_TIMER_CTRL15__P_TIMER_TRSHLD___S                                0

#define USB_OTG_HS_BAM_P_PRDCR_SDBNDn(n)                                      (0x00005024+0x1000*(n))
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn_nMIN                   0
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn_nMAX                   15
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn_ELEM                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn___POR                                              0x00000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn__BAM_P_BYTES_FREE___S                              0
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn___M                                                0x01FFFFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBNDn___S                                                0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND0                                                    (0x00005024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND0__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND1                                                    (0x00006024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND1__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND2                                                    (0x00007024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND2__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND3                                                    (0x00008024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND3__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND4                                                    (0x00009024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND4__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND5                                                    (0x0000A024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND5__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND6                                                    (0x0000B024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND6__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND7                                                    (0x0000C024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND7__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND8                                                    (0x0000D024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND8__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND9                                                    (0x0000E024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_BYTES_FREE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND9__BAM_P_BYTES_FREE___S                              0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND10                                                   (0x0000F024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_BYTES_FREE___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND10__BAM_P_BYTES_FREE___S                             0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND11                                                   (0x00010024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_BYTES_FREE___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND11__BAM_P_BYTES_FREE___S                             0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND12                                                   (0x00011024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_BYTES_FREE___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND12__BAM_P_BYTES_FREE___S                             0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND13                                                   (0x00012024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_BYTES_FREE___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND13__BAM_P_BYTES_FREE___S                             0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND14                                                   (0x00013024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_BYTES_FREE___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND14__BAM_P_BYTES_FREE___S                             0
#define USB_OTG_HS_BAM_P_PRDCR_SDBND15                                                   (0x00014024)
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_BYTES_FREE___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PRDCR_SDBND15__BAM_P_BYTES_FREE___S                             0

#define USB_OTG_HS_BAM_P_CNSMR_SDBNDn(n)                                      (0x00005028+0x1000*(n))
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn_nMIN                   0
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn_nMAX                   15
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn_ELEM                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn___POR                                              0x00000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn__BAM_P_BYTES_AVAIL___S                             0
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn___M                                                0x01FFFFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBNDn___S                                                0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND0                                                    (0x00005028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND0__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND1                                                    (0x00006028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND1__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND2                                                    (0x00007028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND2__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND3                                                    (0x00008028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND3__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND4                                                    (0x00009028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND4__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND5                                                    (0x0000A028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND5__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND6                                                    (0x0000B028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND6__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND7                                                    (0x0000C028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND7__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND8                                                    (0x0000D028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND8__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND9                                                    (0x0000E028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9___RWC                                              QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_SB_UPDATED___M                              0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_SB_UPDATED___S                              24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_WAIT_4_ACK___M                              0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_WAIT_4_ACK___S                              23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_ACK_TOGGLE___M                              0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_ACK_TOGGLE___S                              22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_ACK_TOGGLE_R___M                            0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_ACK_TOGGLE_R___S                            21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_TOGGLE___M                                  0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_TOGGLE___S                                  20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_CTRL___M                                    0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_CTRL___S                                    16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_BYTES_AVAIL___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND9__BAM_P_BYTES_AVAIL___S                             0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND10                                                   (0x0000F028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_WAIT_4_ACK___M                             0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_WAIT_4_ACK___S                             23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_ACK_TOGGLE___M                             0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_ACK_TOGGLE___S                             22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_ACK_TOGGLE_R___M                           0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_ACK_TOGGLE_R___S                           21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_BYTES_AVAIL___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND10__BAM_P_BYTES_AVAIL___S                            0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND11                                                   (0x00010028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_WAIT_4_ACK___M                             0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_WAIT_4_ACK___S                             23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_ACK_TOGGLE___M                             0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_ACK_TOGGLE___S                             22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_ACK_TOGGLE_R___M                           0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_ACK_TOGGLE_R___S                           21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_BYTES_AVAIL___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND11__BAM_P_BYTES_AVAIL___S                            0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND12                                                   (0x00011028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_WAIT_4_ACK___M                             0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_WAIT_4_ACK___S                             23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_ACK_TOGGLE___M                             0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_ACK_TOGGLE___S                             22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_ACK_TOGGLE_R___M                           0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_ACK_TOGGLE_R___S                           21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_BYTES_AVAIL___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND12__BAM_P_BYTES_AVAIL___S                            0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND13                                                   (0x00012028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_WAIT_4_ACK___M                             0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_WAIT_4_ACK___S                             23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_ACK_TOGGLE___M                             0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_ACK_TOGGLE___S                             22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_ACK_TOGGLE_R___M                           0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_ACK_TOGGLE_R___S                           21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_BYTES_AVAIL___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND13__BAM_P_BYTES_AVAIL___S                            0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND14                                                   (0x00013028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_WAIT_4_ACK___M                             0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_WAIT_4_ACK___S                             23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_ACK_TOGGLE___M                             0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_ACK_TOGGLE___S                             22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_ACK_TOGGLE_R___M                           0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_ACK_TOGGLE_R___S                           21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_BYTES_AVAIL___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND14__BAM_P_BYTES_AVAIL___S                            0
#define USB_OTG_HS_BAM_P_CNSMR_SDBND15                                                   (0x00014028)
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15___RWC                                             QCSR_REG_RO
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_SB_UPDATED___M                             0x01000000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_SB_UPDATED___S                             24
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_WAIT_4_ACK___M                             0x00800000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_WAIT_4_ACK___S                             23
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_ACK_TOGGLE___M                             0x00400000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_ACK_TOGGLE___S                             22
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_ACK_TOGGLE_R___M                           0x00200000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_ACK_TOGGLE_R___S                           21
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_TOGGLE___M                                 0x00100000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_TOGGLE___S                                 20
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_CTRL___M                                   0x000F0000
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_CTRL___S                                   16
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_BYTES_AVAIL___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_CNSMR_SDBND15__BAM_P_BYTES_AVAIL___S                            0

#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn(n)                                   (0x0000582C+0x1000*(n))
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn_nMIN                0
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn_nMAX                15
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn_ELEM                16
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn___POR                                           0x00000000
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn__P_EVNT_DEST_ADDR___S                           0
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn___M                                             0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDRn___S                                             0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR0                                                 (0x0000582C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR0___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR0__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR0__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR1                                                 (0x0000682C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR1___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR1__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR1__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR2                                                 (0x0000782C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR2___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR2__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR2__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR3                                                 (0x0000882C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR3___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR3__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR3__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR4                                                 (0x0000982C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR4___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR4__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR4__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR5                                                 (0x0000A82C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR5___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR5__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR5__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR6                                                 (0x0000B82C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR6___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR6__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR6__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR7                                                 (0x0000C82C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR7___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR7__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR7__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR8                                                 (0x0000D82C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR8___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR8__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR8__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR9                                                 (0x0000E82C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR9___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR9__P_EVNT_DEST_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR9__P_EVNT_DEST_ADDR___S                           0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR10                                                (0x0000F82C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR10___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR10__P_EVNT_DEST_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR10__P_EVNT_DEST_ADDR___S                          0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR11                                                (0x0001082C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR11___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR11__P_EVNT_DEST_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR11__P_EVNT_DEST_ADDR___S                          0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR12                                                (0x0001182C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR12___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR12__P_EVNT_DEST_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR12__P_EVNT_DEST_ADDR___S                          0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR13                                                (0x0001282C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR13___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR13__P_EVNT_DEST_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR13__P_EVNT_DEST_ADDR___S                          0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR14                                                (0x0001382C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR14___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR14__P_EVNT_DEST_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR14__P_EVNT_DEST_ADDR___S                          0
#define USB_OTG_HS_BAM_P_EVNT_DEST_ADDR15                                                (0x0001482C)
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR15___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR15__P_EVNT_DEST_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_DEST_ADDR15__P_EVNT_DEST_ADDR___S                          0

#define USB_OTG_HS_BAM_P_EVNT_REGn(n)                                         (0x00005818+0x1000*(n))
#define   USB_OTG_HS_BAM_P_EVNT_REGn_nMIN                      0
#define   USB_OTG_HS_BAM_P_EVNT_REGn_nMAX                      15
#define   USB_OTG_HS_BAM_P_EVNT_REGn_ELEM                      16
#define   USB_OTG_HS_BAM_P_EVNT_REGn___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REGn___POR                                                 0x00000000
#define   USB_OTG_HS_BAM_P_EVNT_REGn__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REGn__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REGn__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REGn__P_DESC_FIFO_PEER_OFST___S                            0
#define   USB_OTG_HS_BAM_P_EVNT_REGn___M                                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_EVNT_REGn___S                                                   0
#define USB_OTG_HS_BAM_P_EVNT_REG0                                                       (0x00005818)
#define   USB_OTG_HS_BAM_P_EVNT_REG0___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG0__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG0__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG0__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG0__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG1                                                       (0x00006818)
#define   USB_OTG_HS_BAM_P_EVNT_REG1___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG1__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG1__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG1__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG1__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG2                                                       (0x00007818)
#define   USB_OTG_HS_BAM_P_EVNT_REG2___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG2__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG2__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG2__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG2__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG3                                                       (0x00008818)
#define   USB_OTG_HS_BAM_P_EVNT_REG3___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG3__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG3__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG3__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG3__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG4                                                       (0x00009818)
#define   USB_OTG_HS_BAM_P_EVNT_REG4___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG4__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG4__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG4__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG4__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG5                                                       (0x0000A818)
#define   USB_OTG_HS_BAM_P_EVNT_REG5___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG5__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG5__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG5__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG5__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG6                                                       (0x0000B818)
#define   USB_OTG_HS_BAM_P_EVNT_REG6___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG6__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG6__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG6__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG6__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG7                                                       (0x0000C818)
#define   USB_OTG_HS_BAM_P_EVNT_REG7___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG7__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG7__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG7__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG7__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG8                                                       (0x0000D818)
#define   USB_OTG_HS_BAM_P_EVNT_REG8___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG8__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG8__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG8__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG8__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG9                                                       (0x0000E818)
#define   USB_OTG_HS_BAM_P_EVNT_REG9___RWC                                                 QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG9__P_BYTES_CONSUMED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG9__P_BYTES_CONSUMED___S                                 16
#define   USB_OTG_HS_BAM_P_EVNT_REG9__P_DESC_FIFO_PEER_OFST___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG9__P_DESC_FIFO_PEER_OFST___S                            0
#define USB_OTG_HS_BAM_P_EVNT_REG10                                                      (0x0000F818)
#define   USB_OTG_HS_BAM_P_EVNT_REG10___RWC                                                QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG10__P_BYTES_CONSUMED___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG10__P_BYTES_CONSUMED___S                                16
#define   USB_OTG_HS_BAM_P_EVNT_REG10__P_DESC_FIFO_PEER_OFST___M                           0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG10__P_DESC_FIFO_PEER_OFST___S                           0
#define USB_OTG_HS_BAM_P_EVNT_REG11                                                      (0x00010818)
#define   USB_OTG_HS_BAM_P_EVNT_REG11___RWC                                                QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG11__P_BYTES_CONSUMED___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG11__P_BYTES_CONSUMED___S                                16
#define   USB_OTG_HS_BAM_P_EVNT_REG11__P_DESC_FIFO_PEER_OFST___M                           0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG11__P_DESC_FIFO_PEER_OFST___S                           0
#define USB_OTG_HS_BAM_P_EVNT_REG12                                                      (0x00011818)
#define   USB_OTG_HS_BAM_P_EVNT_REG12___RWC                                                QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG12__P_BYTES_CONSUMED___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG12__P_BYTES_CONSUMED___S                                16
#define   USB_OTG_HS_BAM_P_EVNT_REG12__P_DESC_FIFO_PEER_OFST___M                           0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG12__P_DESC_FIFO_PEER_OFST___S                           0
#define USB_OTG_HS_BAM_P_EVNT_REG13                                                      (0x00012818)
#define   USB_OTG_HS_BAM_P_EVNT_REG13___RWC                                                QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG13__P_BYTES_CONSUMED___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG13__P_BYTES_CONSUMED___S                                16
#define   USB_OTG_HS_BAM_P_EVNT_REG13__P_DESC_FIFO_PEER_OFST___M                           0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG13__P_DESC_FIFO_PEER_OFST___S                           0
#define USB_OTG_HS_BAM_P_EVNT_REG14                                                      (0x00013818)
#define   USB_OTG_HS_BAM_P_EVNT_REG14___RWC                                                QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG14__P_BYTES_CONSUMED___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG14__P_BYTES_CONSUMED___S                                16
#define   USB_OTG_HS_BAM_P_EVNT_REG14__P_DESC_FIFO_PEER_OFST___M                           0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG14__P_DESC_FIFO_PEER_OFST___S                           0
#define USB_OTG_HS_BAM_P_EVNT_REG15                                                      (0x00014818)
#define   USB_OTG_HS_BAM_P_EVNT_REG15___RWC                                                QCSR_REG_WO
#define   USB_OTG_HS_BAM_P_EVNT_REG15__P_BYTES_CONSUMED___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_EVNT_REG15__P_BYTES_CONSUMED___S                                16
#define   USB_OTG_HS_BAM_P_EVNT_REG15__P_DESC_FIFO_PEER_OFST___M                           0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_REG15__P_DESC_FIFO_PEER_OFST___S                           0

#define USB_OTG_HS_BAM_P_SW_OFSTSn(n)                                         (0x00005800+0x1000*(n))
#define   USB_OTG_HS_BAM_P_SW_OFSTSn_nMIN                      0
#define   USB_OTG_HS_BAM_P_SW_OFSTSn_nMAX                      15
#define   USB_OTG_HS_BAM_P_SW_OFSTSn_ELEM                      16
#define   USB_OTG_HS_BAM_P_SW_OFSTSn___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTSn___POR                                                 0x00000000
#define   USB_OTG_HS_BAM_P_SW_OFSTSn__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTSn__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTSn__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTSn__SW_DESC_OFST___S                                     0
#define   USB_OTG_HS_BAM_P_SW_OFSTSn___M                                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTSn___S                                                   0
#define USB_OTG_HS_BAM_P_SW_OFSTS0                                                       (0x00005800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS0___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS0__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS0__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS0__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS0__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS1                                                       (0x00006800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS1___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS1__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS1__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS1__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS1__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS2                                                       (0x00007800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS2___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS2__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS2__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS2__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS2__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS3                                                       (0x00008800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS3___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS3__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS3__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS3__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS3__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS4                                                       (0x00009800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS4___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS4__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS4__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS4__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS4__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS5                                                       (0x0000A800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS5___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS5__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS5__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS5__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS5__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS6                                                       (0x0000B800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS6___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS6__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS6__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS6__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS6__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS7                                                       (0x0000C800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS7___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS7__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS7__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS7__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS7__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS8                                                       (0x0000D800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS8___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS8__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS8__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS8__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS8__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS9                                                       (0x0000E800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS9___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS9__SW_OFST_IN_DESC___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS9__SW_OFST_IN_DESC___S                                  16
#define   USB_OTG_HS_BAM_P_SW_OFSTS9__SW_DESC_OFST___M                                     0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS9__SW_DESC_OFST___S                                     0
#define USB_OTG_HS_BAM_P_SW_OFSTS10                                                      (0x0000F800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS10___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS10__SW_OFST_IN_DESC___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS10__SW_OFST_IN_DESC___S                                 16
#define   USB_OTG_HS_BAM_P_SW_OFSTS10__SW_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS10__SW_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SW_OFSTS11                                                      (0x00010800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS11___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS11__SW_OFST_IN_DESC___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS11__SW_OFST_IN_DESC___S                                 16
#define   USB_OTG_HS_BAM_P_SW_OFSTS11__SW_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS11__SW_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SW_OFSTS12                                                      (0x00011800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS12___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS12__SW_OFST_IN_DESC___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS12__SW_OFST_IN_DESC___S                                 16
#define   USB_OTG_HS_BAM_P_SW_OFSTS12__SW_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS12__SW_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SW_OFSTS13                                                      (0x00012800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS13___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS13__SW_OFST_IN_DESC___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS13__SW_OFST_IN_DESC___S                                 16
#define   USB_OTG_HS_BAM_P_SW_OFSTS13__SW_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS13__SW_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SW_OFSTS14                                                      (0x00013800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS14___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS14__SW_OFST_IN_DESC___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS14__SW_OFST_IN_DESC___S                                 16
#define   USB_OTG_HS_BAM_P_SW_OFSTS14__SW_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS14__SW_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SW_OFSTS15                                                      (0x00014800)
#define   USB_OTG_HS_BAM_P_SW_OFSTS15___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SW_OFSTS15__SW_OFST_IN_DESC___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_SW_OFSTS15__SW_OFST_IN_DESC___S                                 16
#define   USB_OTG_HS_BAM_P_SW_OFSTS15__SW_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SW_OFSTS15__SW_DESC_OFST___S                                    0

#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn(n)                                   (0x00005824+0x1000*(n))
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn_nMIN                0
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn_nMAX                15
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn_ELEM                16
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn___POR                                           0x00000000
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn__P_DATA_FIFO_ADDR___S                           0
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn___M                                             0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDRn___S                                             0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR0                                                 (0x00005824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR0___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR0__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR0__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR1                                                 (0x00006824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR1___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR1__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR1__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR2                                                 (0x00007824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR2___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR2__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR2__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR3                                                 (0x00008824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR3___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR3__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR3__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR4                                                 (0x00009824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR4___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR4__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR4__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR5                                                 (0x0000A824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR5___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR5__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR5__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR6                                                 (0x0000B824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR6___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR6__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR6__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR7                                                 (0x0000C824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR7___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR7__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR7__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR8                                                 (0x0000D824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR8___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR8__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR8__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR9                                                 (0x0000E824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR9___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR9__P_DATA_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR9__P_DATA_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR10                                                (0x0000F824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR10___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR10__P_DATA_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR10__P_DATA_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR11                                                (0x00010824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR11___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR11__P_DATA_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR11__P_DATA_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR12                                                (0x00011824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR12___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR12__P_DATA_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR12__P_DATA_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR13                                                (0x00012824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR13___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR13__P_DATA_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR13__P_DATA_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR14                                                (0x00013824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR14___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR14__P_DATA_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR14__P_DATA_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DATA_FIFO_ADDR15                                                (0x00014824)
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR15___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR15__P_DATA_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DATA_FIFO_ADDR15__P_DATA_FIFO_ADDR___S                          0

#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn(n)                                   (0x0000581C+0x1000*(n))
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn_nMIN                0
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn_nMAX                15
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn_ELEM                16
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn___POR                                           0x00000000
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn__P_DESC_FIFO_ADDR___S                           0
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn___M                                             0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDRn___S                                             0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR0                                                 (0x0000581C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR0___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR0__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR0__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR1                                                 (0x0000681C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR1___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR1__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR1__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR2                                                 (0x0000781C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR2___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR2__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR2__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR3                                                 (0x0000881C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR3___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR3__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR3__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR4                                                 (0x0000981C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR4___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR4__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR4__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR5                                                 (0x0000A81C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR5___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR5__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR5__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR6                                                 (0x0000B81C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR6___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR6__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR6__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR7                                                 (0x0000C81C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR7___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR7__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR7__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR8                                                 (0x0000D81C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR8___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR8__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR8__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR9                                                 (0x0000E81C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR9___RWC                                           QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR9__P_DESC_FIFO_ADDR___M                           0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR9__P_DESC_FIFO_ADDR___S                           0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR10                                                (0x0000F81C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR10___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR10__P_DESC_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR10__P_DESC_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR11                                                (0x0001081C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR11___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR11__P_DESC_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR11__P_DESC_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR12                                                (0x0001181C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR12___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR12__P_DESC_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR12__P_DESC_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR13                                                (0x0001281C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR13___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR13__P_DESC_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR13__P_DESC_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR14                                                (0x0001381C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR14___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR14__P_DESC_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR14__P_DESC_FIFO_ADDR___S                          0
#define USB_OTG_HS_BAM_P_DESC_FIFO_ADDR15                                                (0x0001481C)
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR15___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR15__P_DESC_FIFO_ADDR___M                          0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DESC_FIFO_ADDR15__P_DESC_FIFO_ADDR___S                          0

#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn(n)                                  (0x00005828+0x1000*(n))
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn_nMIN               0
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn_nMAX               15
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn_ELEM               16
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn___POR                                          0x00000000
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn__P_TRSHLD___S                                  0
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn___M                                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLDn___S                                            0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD0                                                (0x00005828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD0___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD0__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD0__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD1                                                (0x00006828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD1___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD1__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD1__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD2                                                (0x00007828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD2___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD2__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD2__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD3                                                (0x00008828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD3___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD3__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD3__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD4                                                (0x00009828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD4___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD4__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD4__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD5                                                (0x0000A828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD5___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD5__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD5__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD6                                                (0x0000B828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD6___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD6__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD6__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD7                                                (0x0000C828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD7___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD7__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD7__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD8                                                (0x0000D828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD8___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD8__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD8__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD9                                                (0x0000E828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD9___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD9__P_TRSHLD___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD9__P_TRSHLD___S                                  0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD10                                               (0x0000F828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD10___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD10__P_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD10__P_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD11                                               (0x00010828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD11___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD11__P_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD11__P_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD12                                               (0x00011828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD12___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD12__P_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD12__P_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD13                                               (0x00012828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD13___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD13__P_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD13__P_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD14                                               (0x00013828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD14___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD14__P_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD14__P_TRSHLD___S                                 0
#define USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD15                                               (0x00014828)
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD15___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD15__P_TRSHLD___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_EVNT_GEN_TRSHLD15__P_TRSHLD___S                                 0

#define USB_OTG_HS_BAM_P_FIFO_SIZESn(n)                                       (0x00005820+0x1000*(n))
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn_nMIN                    0
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn_nMAX                    15
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn_ELEM                    16
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn___POR                                               0x00000000
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn__P_DESC_FIFO_SIZE___S                               0
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn___M                                                 0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZESn___S                                                 0
#define USB_OTG_HS_BAM_P_FIFO_SIZES0                                                     (0x00005820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES0___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES0__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES0__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES0__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES0__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES1                                                     (0x00006820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES1___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES1__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES1__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES1__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES1__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES2                                                     (0x00007820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES2___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES2__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES2__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES2__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES2__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES3                                                     (0x00008820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES3___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES3__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES3__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES3__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES3__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES4                                                     (0x00009820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES4___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES4__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES4__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES4__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES4__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES5                                                     (0x0000A820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES5___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES5__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES5__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES5__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES5__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES6                                                     (0x0000B820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES6___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES6__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES6__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES6__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES6__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES7                                                     (0x0000C820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES7___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES7__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES7__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES7__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES7__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES8                                                     (0x0000D820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES8___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES8__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES8__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES8__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES8__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES9                                                     (0x0000E820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES9___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES9__P_DATA_FIFO_SIZE___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES9__P_DATA_FIFO_SIZE___S                               16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES9__P_DESC_FIFO_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES9__P_DESC_FIFO_SIZE___S                               0
#define USB_OTG_HS_BAM_P_FIFO_SIZES10                                                    (0x0000F820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES10___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES10__P_DATA_FIFO_SIZE___M                              0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES10__P_DATA_FIFO_SIZE___S                              16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES10__P_DESC_FIFO_SIZE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES10__P_DESC_FIFO_SIZE___S                              0
#define USB_OTG_HS_BAM_P_FIFO_SIZES11                                                    (0x00010820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES11___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES11__P_DATA_FIFO_SIZE___M                              0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES11__P_DATA_FIFO_SIZE___S                              16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES11__P_DESC_FIFO_SIZE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES11__P_DESC_FIFO_SIZE___S                              0
#define USB_OTG_HS_BAM_P_FIFO_SIZES12                                                    (0x00011820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES12___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES12__P_DATA_FIFO_SIZE___M                              0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES12__P_DATA_FIFO_SIZE___S                              16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES12__P_DESC_FIFO_SIZE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES12__P_DESC_FIFO_SIZE___S                              0
#define USB_OTG_HS_BAM_P_FIFO_SIZES13                                                    (0x00012820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES13___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES13__P_DATA_FIFO_SIZE___M                              0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES13__P_DATA_FIFO_SIZE___S                              16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES13__P_DESC_FIFO_SIZE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES13__P_DESC_FIFO_SIZE___S                              0
#define USB_OTG_HS_BAM_P_FIFO_SIZES14                                                    (0x00013820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES14___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES14__P_DATA_FIFO_SIZE___M                              0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES14__P_DATA_FIFO_SIZE___S                              16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES14__P_DESC_FIFO_SIZE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES14__P_DESC_FIFO_SIZE___S                              0
#define USB_OTG_HS_BAM_P_FIFO_SIZES15                                                    (0x00014820)
#define   USB_OTG_HS_BAM_P_FIFO_SIZES15___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_FIFO_SIZES15__P_DATA_FIFO_SIZE___M                              0xFFFF0000
#define   USB_OTG_HS_BAM_P_FIFO_SIZES15__P_DATA_FIFO_SIZE___S                              16
#define   USB_OTG_HS_BAM_P_FIFO_SIZES15__P_DESC_FIFO_SIZE___M                              0x0000FFFF
#define   USB_OTG_HS_BAM_P_FIFO_SIZES15__P_DESC_FIFO_SIZE___S                              0

#define USB_OTG_HS_BAM_P_RETR_CNTXT_n(n)                                      (0x00005834+0x1000*(n))
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n_nMIN                   0
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n_nMAX                   15
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n_ELEM                   16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n___POR                                              0x00000000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n__RETR_OFST_IN_DESC___S                             0
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n___M                                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_n___S                                                0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_0                                                    (0x00005834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_0___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_0__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_0__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_0__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_0__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_1                                                    (0x00006834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_1___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_1__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_1__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_1__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_1__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_2                                                    (0x00007834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_2___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_2__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_2__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_2__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_2__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_3                                                    (0x00008834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_3___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_3__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_3__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_3__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_3__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_4                                                    (0x00009834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_4___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_4__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_4__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_4__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_4__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_5                                                    (0x0000A834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_5___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_5__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_5__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_5__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_5__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_6                                                    (0x0000B834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_6___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_6__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_6__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_6__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_6__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_7                                                    (0x0000C834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_7___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_7__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_7__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_7__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_7__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_8                                                    (0x0000D834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_8___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_8__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_8__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_8__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_8__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_9                                                    (0x0000E834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_9___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_9__RETR_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_9__RETR_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_9__RETR_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_9__RETR_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_10                                                   (0x0000F834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_10___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_10__RETR_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_10__RETR_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_10__RETR_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_10__RETR_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_11                                                   (0x00010834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_11___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_11__RETR_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_11__RETR_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_11__RETR_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_11__RETR_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_12                                                   (0x00011834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_12___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_12__RETR_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_12__RETR_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_12__RETR_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_12__RETR_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_13                                                   (0x00012834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_13___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_13__RETR_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_13__RETR_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_13__RETR_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_13__RETR_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_14                                                   (0x00013834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_14___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_14__RETR_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_14__RETR_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_14__RETR_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_14__RETR_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_RETR_CNTXT_15                                                   (0x00014834)
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_15___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_15__RETR_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_15__RETR_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_15__RETR_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_RETR_CNTXT_15__RETR_OFST_IN_DESC___S                            0

#define USB_OTG_HS_BAM_P_SI_CNTXT_n(n)                                        (0x00005838+0x1000*(n))
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n_nMIN                     0
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n_nMAX                     15
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n_ELEM                     16
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n___POR                                                0x00000000
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n__SI_DESC_OFST___S                                    0
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n___M                                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_n___S                                                  0
#define USB_OTG_HS_BAM_P_SI_CNTXT_0                                                      (0x00005838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_0___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_0__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_0__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_1                                                      (0x00006838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_1___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_1__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_1__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_2                                                      (0x00007838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_2___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_2__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_2__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_3                                                      (0x00008838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_3___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_3__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_3__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_4                                                      (0x00009838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_4___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_4__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_4__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_5                                                      (0x0000A838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_5___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_5__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_5__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_6                                                      (0x0000B838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_6___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_6__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_6__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_7                                                      (0x0000C838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_7___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_7__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_7__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_8                                                      (0x0000D838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_8___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_8__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_8__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_9                                                      (0x0000E838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_9___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_9__SI_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_9__SI_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_SI_CNTXT_10                                                     (0x0000F838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_10___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_10__SI_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_10__SI_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_SI_CNTXT_11                                                     (0x00010838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_11___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_11__SI_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_11__SI_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_SI_CNTXT_12                                                     (0x00011838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_12___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_12__SI_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_12__SI_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_SI_CNTXT_13                                                     (0x00012838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_13___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_13__SI_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_13__SI_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_SI_CNTXT_14                                                     (0x00013838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_14___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_14__SI_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_14__SI_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_SI_CNTXT_15                                                     (0x00014838)
#define   USB_OTG_HS_BAM_P_SI_CNTXT_15___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_SI_CNTXT_15__SI_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_SI_CNTXT_15__SI_DESC_OFST___S                                   0

#define USB_OTG_HS_BAM_P_DF_CNTXT_n(n)                                        (0x00005830+0x1000*(n))
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n_nMIN                     0
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n_nMAX                     15
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n_ELEM                     16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n___POR                                                0x00000000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n__DF_DESC_OFST___S                                    0
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n___M                                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_n___S                                                  0
#define USB_OTG_HS_BAM_P_DF_CNTXT_0                                                      (0x00005830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_0___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_0__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_0__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_0__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_0__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_1                                                      (0x00006830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_1___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_1__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_1__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_1__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_1__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_2                                                      (0x00007830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_2___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_2__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_2__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_2__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_2__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_3                                                      (0x00008830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_3___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_3__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_3__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_3__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_3__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_4                                                      (0x00009830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_4___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_4__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_4__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_4__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_4__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_5                                                      (0x0000A830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_5___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_5__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_5__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_5__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_5__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_6                                                      (0x0000B830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_6___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_6__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_6__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_6__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_6__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_7                                                      (0x0000C830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_7___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_7__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_7__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_7__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_7__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_8                                                      (0x0000D830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_8___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_8__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_8__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_8__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_8__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_9                                                      (0x0000E830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_9___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_9__WB_ACCUMULATED___M                                  0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_9__WB_ACCUMULATED___S                                  16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_9__DF_DESC_OFST___M                                    0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_9__DF_DESC_OFST___S                                    0
#define USB_OTG_HS_BAM_P_DF_CNTXT_10                                                     (0x0000F830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_10___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_10__WB_ACCUMULATED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_10__WB_ACCUMULATED___S                                 16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_10__DF_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_10__DF_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_DF_CNTXT_11                                                     (0x00010830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_11___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_11__WB_ACCUMULATED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_11__WB_ACCUMULATED___S                                 16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_11__DF_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_11__DF_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_DF_CNTXT_12                                                     (0x00011830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_12___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_12__WB_ACCUMULATED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_12__WB_ACCUMULATED___S                                 16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_12__DF_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_12__DF_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_DF_CNTXT_13                                                     (0x00012830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_13___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_13__WB_ACCUMULATED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_13__WB_ACCUMULATED___S                                 16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_13__DF_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_13__DF_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_DF_CNTXT_14                                                     (0x00013830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_14___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_14__WB_ACCUMULATED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_14__WB_ACCUMULATED___S                                 16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_14__DF_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_14__DF_DESC_OFST___S                                   0
#define USB_OTG_HS_BAM_P_DF_CNTXT_15                                                     (0x00014830)
#define   USB_OTG_HS_BAM_P_DF_CNTXT_15___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_DF_CNTXT_15__WB_ACCUMULATED___M                                 0xFFFF0000
#define   USB_OTG_HS_BAM_P_DF_CNTXT_15__WB_ACCUMULATED___S                                 16
#define   USB_OTG_HS_BAM_P_DF_CNTXT_15__DF_DESC_OFST___M                                   0x0000FFFF
#define   USB_OTG_HS_BAM_P_DF_CNTXT_15__DF_DESC_OFST___S                                   0

#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n(n)                                  (0x00005804+0x1000*(n))
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n_nMIN               0
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n_nMAX               15
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n_ELEM               16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n___POR                                          0x00000000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n__AU_ACKED___S                                  0
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n___M                                            0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_n___S                                            0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_0                                                (0x00005804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_0___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_0__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_0__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_0__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_0__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_1                                                (0x00006804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_1___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_1__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_1__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_1__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_1__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_2                                                (0x00007804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_2___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_2__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_2__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_2__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_2__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_3                                                (0x00008804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_3___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_3__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_3__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_3__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_3__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_4                                                (0x00009804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_4___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_4__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_4__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_4__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_4__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_5                                                (0x0000A804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_5___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_5__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_5__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_5__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_5__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_6                                                (0x0000B804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_6___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_6__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_6__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_6__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_6__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_7                                                (0x0000C804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_7___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_7__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_7__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_7__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_7__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_8                                                (0x0000D804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_8___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_8__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_8__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_8__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_8__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_9                                                (0x0000E804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_9___RWC                                          QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_9__AU_PSM_ACCUMED___M                            0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_9__AU_PSM_ACCUMED___S                            16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_9__AU_ACKED___M                                  0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_9__AU_ACKED___S                                  0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_10                                               (0x0000F804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_10___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_10__AU_PSM_ACCUMED___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_10__AU_PSM_ACCUMED___S                           16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_10__AU_ACKED___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_10__AU_ACKED___S                                 0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_11                                               (0x00010804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_11___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_11__AU_PSM_ACCUMED___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_11__AU_PSM_ACCUMED___S                           16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_11__AU_ACKED___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_11__AU_ACKED___S                                 0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_12                                               (0x00011804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_12___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_12__AU_PSM_ACCUMED___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_12__AU_PSM_ACCUMED___S                           16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_12__AU_ACKED___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_12__AU_ACKED___S                                 0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_13                                               (0x00012804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_13___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_13__AU_PSM_ACCUMED___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_13__AU_PSM_ACCUMED___S                           16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_13__AU_ACKED___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_13__AU_ACKED___S                                 0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_14                                               (0x00013804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_14___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_14__AU_PSM_ACCUMED___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_14__AU_PSM_ACCUMED___S                           16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_14__AU_ACKED___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_14__AU_ACKED___S                                 0
#define USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_15                                               (0x00014804)
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_15___RWC                                         QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_15__AU_PSM_ACCUMED___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_15__AU_PSM_ACCUMED___S                           16
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_15__AU_ACKED___M                                 0x0000FFFF
#define   USB_OTG_HS_BAM_P_AU_PSM_CNTXT_1_15__AU_ACKED___S                                 0

#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_n(n)                                     (0x00005808+0x1000*(n))
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n_nMIN                  0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n_nMAX                  15
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n_ELEM                  16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n___POR                                             0x00000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n__PSM_DESC_SIZE___S                                0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n___M                                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_n___S                                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_0                                                   (0x00005808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_0__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_1                                                   (0x00006808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_1__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_2                                                   (0x00007808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_2__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_3                                                   (0x00008808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_3__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_4                                                   (0x00009808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_4__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_5                                                   (0x0000A808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_5__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_6                                                   (0x0000B808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_6__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_7                                                   (0x0000C808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_7__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_8                                                   (0x0000D808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_8__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_9                                                   (0x0000E808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_VALID___M                               0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_VALID___S                               31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_IRQ___M                                 0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_IRQ___S                                 30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_IRQ_DONE___M                            0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_IRQ_DONE___S                            29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_GENERAL_BITS___M                             0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_GENERAL_BITS___S                             25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_CONS_STATE___M                               0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_CONS_STATE___S                               22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_PROD_SYS_STATE___M                           0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_PROD_SYS_STATE___S                           19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_PROD_B2B_STATE___M                           0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_PROD_B2B_STATE___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_SIZE___M                                0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_9__PSM_DESC_SIZE___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_10                                                  (0x0000F808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_VALID___M                              0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_VALID___S                              31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_IRQ___M                                0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_IRQ___S                                30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_IRQ_DONE___M                           0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_IRQ_DONE___S                           29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_GENERAL_BITS___M                            0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_GENERAL_BITS___S                            25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_CONS_STATE___M                              0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_CONS_STATE___S                              22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_PROD_SYS_STATE___M                          0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_PROD_SYS_STATE___S                          19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_PROD_B2B_STATE___M                          0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_PROD_B2B_STATE___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_10__PSM_DESC_SIZE___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_11                                                  (0x00010808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_VALID___M                              0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_VALID___S                              31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_IRQ___M                                0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_IRQ___S                                30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_IRQ_DONE___M                           0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_IRQ_DONE___S                           29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_GENERAL_BITS___M                            0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_GENERAL_BITS___S                            25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_CONS_STATE___M                              0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_CONS_STATE___S                              22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_PROD_SYS_STATE___M                          0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_PROD_SYS_STATE___S                          19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_PROD_B2B_STATE___M                          0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_PROD_B2B_STATE___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_11__PSM_DESC_SIZE___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_12                                                  (0x00011808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_VALID___M                              0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_VALID___S                              31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_IRQ___M                                0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_IRQ___S                                30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_IRQ_DONE___M                           0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_IRQ_DONE___S                           29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_GENERAL_BITS___M                            0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_GENERAL_BITS___S                            25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_CONS_STATE___M                              0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_CONS_STATE___S                              22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_PROD_SYS_STATE___M                          0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_PROD_SYS_STATE___S                          19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_PROD_B2B_STATE___M                          0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_PROD_B2B_STATE___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_12__PSM_DESC_SIZE___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_13                                                  (0x00012808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_VALID___M                              0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_VALID___S                              31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_IRQ___M                                0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_IRQ___S                                30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_IRQ_DONE___M                           0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_IRQ_DONE___S                           29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_GENERAL_BITS___M                            0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_GENERAL_BITS___S                            25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_CONS_STATE___M                              0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_CONS_STATE___S                              22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_PROD_SYS_STATE___M                          0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_PROD_SYS_STATE___S                          19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_PROD_B2B_STATE___M                          0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_PROD_B2B_STATE___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_13__PSM_DESC_SIZE___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_14                                                  (0x00013808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_VALID___M                              0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_VALID___S                              31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_IRQ___M                                0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_IRQ___S                                30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_IRQ_DONE___M                           0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_IRQ_DONE___S                           29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_GENERAL_BITS___M                            0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_GENERAL_BITS___S                            25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_CONS_STATE___M                              0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_CONS_STATE___S                              22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_PROD_SYS_STATE___M                          0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_PROD_SYS_STATE___S                          19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_PROD_B2B_STATE___M                          0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_PROD_B2B_STATE___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_14__PSM_DESC_SIZE___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_2_15                                                  (0x00014808)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_VALID___M                              0x80000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_VALID___S                              31
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_IRQ___M                                0x40000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_IRQ___S                                30
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_IRQ_DONE___M                           0x20000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_IRQ_DONE___S                           29
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_GENERAL_BITS___M                            0x1E000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_GENERAL_BITS___S                            25
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_CONS_STATE___M                              0x01C00000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_CONS_STATE___S                              22
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_PROD_SYS_STATE___M                          0x00380000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_PROD_SYS_STATE___S                          19
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_PROD_B2B_STATE___M                          0x00070000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_PROD_B2B_STATE___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_SIZE___M                               0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_2_15__PSM_DESC_SIZE___S                               0

#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_n(n)                                     (0x0000580C+0x1000*(n))
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n_nMIN                  0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n_nMAX                  15
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n_ELEM                  16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n___POR                                             0x00000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n__PSM_DESC_ADDR___S                                0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n___M                                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_n___S                                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_0                                                   (0x0000580C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_0___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_0__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_0__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_1                                                   (0x0000680C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_1___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_1__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_1__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_2                                                   (0x0000780C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_2___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_2__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_2__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_3                                                   (0x0000880C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_3___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_3__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_3__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_4                                                   (0x0000980C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_4___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_4__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_4__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_5                                                   (0x0000A80C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_5___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_5__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_5__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_6                                                   (0x0000B80C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_6___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_6__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_6__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_7                                                   (0x0000C80C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_7___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_7__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_7__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_8                                                   (0x0000D80C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_8___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_8__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_8__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_9                                                   (0x0000E80C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_9___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_9__PSM_DESC_ADDR___M                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_9__PSM_DESC_ADDR___S                                0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_10                                                  (0x0000F80C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_10___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_10__PSM_DESC_ADDR___M                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_10__PSM_DESC_ADDR___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_11                                                  (0x0001080C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_11___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_11__PSM_DESC_ADDR___M                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_11__PSM_DESC_ADDR___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_12                                                  (0x0001180C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_12___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_12__PSM_DESC_ADDR___M                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_12__PSM_DESC_ADDR___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_13                                                  (0x0001280C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_13___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_13__PSM_DESC_ADDR___M                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_13__PSM_DESC_ADDR___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_14                                                  (0x0001380C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_14___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_14__PSM_DESC_ADDR___M                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_14__PSM_DESC_ADDR___S                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_3_15                                                  (0x0001480C)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_15___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_15__PSM_DESC_ADDR___M                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_3_15__PSM_DESC_ADDR___S                               0

#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_n(n)                                     (0x00005810+0x1000*(n))
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n_nMIN                  0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n_nMAX                  15
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n_ELEM                  16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n___POR                                             0x00000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n__PSM_SAVED_ACCUMED_SIZE___S                       0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n___M                                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_n___S                                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_0                                                   (0x00005810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_0___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_0__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_0__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_0__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_0__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_1                                                   (0x00006810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_1___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_1__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_1__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_1__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_1__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_2                                                   (0x00007810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_2___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_2__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_2__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_2__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_2__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_3                                                   (0x00008810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_3___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_3__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_3__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_3__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_3__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_4                                                   (0x00009810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_4___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_4__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_4__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_4__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_4__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_5                                                   (0x0000A810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_5___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_5__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_5__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_5__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_5__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_6                                                   (0x0000B810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_6___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_6__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_6__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_6__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_6__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_7                                                   (0x0000C810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_7___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_7__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_7__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_7__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_7__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_8                                                   (0x0000D810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_8___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_8__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_8__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_8__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_8__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_9                                                   (0x0000E810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_9___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_9__PSM_DESC_OFST___M                                0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_9__PSM_DESC_OFST___S                                16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_9__PSM_SAVED_ACCUMED_SIZE___M                       0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_9__PSM_SAVED_ACCUMED_SIZE___S                       0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_10                                                  (0x0000F810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_10___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_10__PSM_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_10__PSM_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_10__PSM_SAVED_ACCUMED_SIZE___M                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_10__PSM_SAVED_ACCUMED_SIZE___S                      0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_11                                                  (0x00010810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_11___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_11__PSM_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_11__PSM_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_11__PSM_SAVED_ACCUMED_SIZE___M                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_11__PSM_SAVED_ACCUMED_SIZE___S                      0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_12                                                  (0x00011810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_12___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_12__PSM_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_12__PSM_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_12__PSM_SAVED_ACCUMED_SIZE___M                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_12__PSM_SAVED_ACCUMED_SIZE___S                      0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_13                                                  (0x00012810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_13___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_13__PSM_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_13__PSM_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_13__PSM_SAVED_ACCUMED_SIZE___M                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_13__PSM_SAVED_ACCUMED_SIZE___S                      0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_14                                                  (0x00013810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_14___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_14__PSM_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_14__PSM_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_14__PSM_SAVED_ACCUMED_SIZE___M                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_14__PSM_SAVED_ACCUMED_SIZE___S                      0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_4_15                                                  (0x00014810)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_15___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_15__PSM_DESC_OFST___M                               0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_15__PSM_DESC_OFST___S                               16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_15__PSM_SAVED_ACCUMED_SIZE___M                      0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_4_15__PSM_SAVED_ACCUMED_SIZE___S                      0

#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_n(n)                                     (0x00005814+0x1000*(n))
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n_nMIN                  0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n_nMAX                  15
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n_ELEM                  16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n___POR                                             0x00000000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n__PSM_OFST_IN_DESC___S                             0
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n___M                                               0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_n___S                                               0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_0                                                   (0x00005814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_0___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_0__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_0__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_0__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_0__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_1                                                   (0x00006814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_1___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_1__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_1__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_1__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_1__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_2                                                   (0x00007814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_2___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_2__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_2__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_2__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_2__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_3                                                   (0x00008814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_3___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_3__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_3__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_3__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_3__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_4                                                   (0x00009814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_4___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_4__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_4__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_4__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_4__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_5                                                   (0x0000A814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_5___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_5__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_5__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_5__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_5__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_6                                                   (0x0000B814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_6___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_6__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_6__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_6__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_6__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_7                                                   (0x0000C814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_7___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_7__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_7__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_7__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_7__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_8                                                   (0x0000D814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_8___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_8__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_8__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_8__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_8__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_9                                                   (0x0000E814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_9___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_9__PSM_BLOCK_BYTE_CNT___M                           0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_9__PSM_BLOCK_BYTE_CNT___S                           16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_9__PSM_OFST_IN_DESC___M                             0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_9__PSM_OFST_IN_DESC___S                             0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_10                                                  (0x0000F814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_10___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_10__PSM_BLOCK_BYTE_CNT___M                          0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_10__PSM_BLOCK_BYTE_CNT___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_10__PSM_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_10__PSM_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_11                                                  (0x00010814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_11___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_11__PSM_BLOCK_BYTE_CNT___M                          0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_11__PSM_BLOCK_BYTE_CNT___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_11__PSM_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_11__PSM_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_12                                                  (0x00011814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_12___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_12__PSM_BLOCK_BYTE_CNT___M                          0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_12__PSM_BLOCK_BYTE_CNT___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_12__PSM_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_12__PSM_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_13                                                  (0x00012814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_13___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_13__PSM_BLOCK_BYTE_CNT___M                          0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_13__PSM_BLOCK_BYTE_CNT___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_13__PSM_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_13__PSM_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_14                                                  (0x00013814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_14___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_14__PSM_BLOCK_BYTE_CNT___M                          0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_14__PSM_BLOCK_BYTE_CNT___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_14__PSM_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_14__PSM_OFST_IN_DESC___S                            0
#define USB_OTG_HS_BAM_P_PSM_CNTXT_5_15                                                  (0x00014814)
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_15___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_15__PSM_BLOCK_BYTE_CNT___M                          0xFFFF0000
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_15__PSM_BLOCK_BYTE_CNT___S                          16
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_15__PSM_OFST_IN_DESC___M                            0x0000FFFF
#define   USB_OTG_HS_BAM_P_PSM_CNTXT_5_15__PSM_OFST_IN_DESC___S                            0

#define USB_OTG_HS_BAM_P_RESERVED_2_n(n)                                      (0x0000583C+0x1000*(n))
#define   USB_OTG_HS_BAM_P_RESERVED_2_n_nMIN                   0
#define   USB_OTG_HS_BAM_P_RESERVED_2_n_nMAX                   15
#define   USB_OTG_HS_BAM_P_RESERVED_2_n_ELEM                   16
#define   USB_OTG_HS_BAM_P_RESERVED_2_n___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_n___POR                                              0x00000000
#define   USB_OTG_HS_BAM_P_RESERVED_2_n__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_n__BAM_P_RES_2___S                                   0
#define   USB_OTG_HS_BAM_P_RESERVED_2_n___M                                                0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_n___S                                                0
#define USB_OTG_HS_BAM_P_RESERVED_2_0                                                    (0x0000583C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_0___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_0__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_0__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_1                                                    (0x0000683C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_1___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_1__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_1__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_2                                                    (0x0000783C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_2___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_2__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_2__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_3                                                    (0x0000883C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_3___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_3__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_3__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_4                                                    (0x0000983C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_4___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_4__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_4__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_5                                                    (0x0000A83C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_5___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_5__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_5__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_6                                                    (0x0000B83C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_6___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_6__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_6__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_7                                                    (0x0000C83C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_7___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_7__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_7__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_8                                                    (0x0000D83C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_8___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_8__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_8__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_9                                                    (0x0000E83C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_9___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_9__BAM_P_RES_2___M                                   0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_9__BAM_P_RES_2___S                                   0
#define USB_OTG_HS_BAM_P_RESERVED_2_10                                                   (0x0000F83C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_10___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_10__BAM_P_RES_2___M                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_10__BAM_P_RES_2___S                                  0
#define USB_OTG_HS_BAM_P_RESERVED_2_11                                                   (0x0001083C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_11___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_11__BAM_P_RES_2___M                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_11__BAM_P_RES_2___S                                  0
#define USB_OTG_HS_BAM_P_RESERVED_2_12                                                   (0x0001183C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_12___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_12__BAM_P_RES_2___M                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_12__BAM_P_RES_2___S                                  0
#define USB_OTG_HS_BAM_P_RESERVED_2_13                                                   (0x0001283C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_13___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_13__BAM_P_RES_2___M                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_13__BAM_P_RES_2___S                                  0
#define USB_OTG_HS_BAM_P_RESERVED_2_14                                                   (0x0001383C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_14___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_14__BAM_P_RES_2___M                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_14__BAM_P_RES_2___S                                  0
#define USB_OTG_HS_BAM_P_RESERVED_2_15                                                   (0x0001483C)
#define   USB_OTG_HS_BAM_P_RESERVED_2_15___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_BAM_P_RESERVED_2_15__BAM_P_RES_2___M                                  0xFFFFFFFF
#define   USB_OTG_HS_BAM_P_RESERVED_2_15__BAM_P_RES_2___S                                  0

#define USB_OTG_HS_XPU_SCR                                                               (0x00002000)
#define   USB_OTG_HS_XPU_SCR___RWC                                                         QCSR_REG_RW
#define   USB_OTG_HS_XPU_SCR___POR                                                         0x00000106
#define   USB_OTG_HS_XPU_SCR__DYNAMIC_CLK_EN___M                                           0x00000100
#define   USB_OTG_HS_XPU_SCR__DYNAMIC_CLK_EN___S                                           8
#define   USB_OTG_HS_XPU_SCR__NSRGCLEE___M                                                 0x00000040
#define   USB_OTG_HS_XPU_SCR__NSRGCLEE___S                                                 6
#define   USB_OTG_HS_XPU_SCR__NSCFGE___M                                                   0x00000020
#define   USB_OTG_HS_XPU_SCR__NSCFGE___S                                                   5
#define   USB_OTG_HS_XPU_SCR__SDCDEE___M                                                   0x00000010
#define   USB_OTG_HS_XPU_SCR__SDCDEE___S                                                   4
#define   USB_OTG_HS_XPU_SCR__SEIE___M                                                     0x00000008
#define   USB_OTG_HS_XPU_SCR__SEIE___S                                                     3
#define   USB_OTG_HS_XPU_SCR__SCLERE___M                                                   0x00000004
#define   USB_OTG_HS_XPU_SCR__SCLERE___S                                                   2
#define   USB_OTG_HS_XPU_SCR__SCFGERE___M                                                  0x00000002
#define   USB_OTG_HS_XPU_SCR__SCFGERE___S                                                  1
#define   USB_OTG_HS_XPU_SCR__XPUNSE___M                                                   0x00000001
#define   USB_OTG_HS_XPU_SCR__XPUNSE___S                                                   0
#define   USB_OTG_HS_XPU_SCR___M                                                           0x000001FF
#define   USB_OTG_HS_XPU_SCR___S                                                           0

#define USB_OTG_HS_XPU_SWDR                                                              (0x00002004)
#define   USB_OTG_HS_XPU_SWDR___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_XPU_SWDR___POR                                                        0x00000000
#define   USB_OTG_HS_XPU_SWDR__SCFGWD___M                                                  0x00000001
#define   USB_OTG_HS_XPU_SWDR__SCFGWD___S                                                  0
#define   USB_OTG_HS_XPU_SWDR___M                                                          0x00000001
#define   USB_OTG_HS_XPU_SWDR___S                                                          0

#define USB_OTG_HS_XPU_SEAR0                                                             (0x00002040)
#define   USB_OTG_HS_XPU_SEAR0___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_XPU_SEAR0___POR                                                       0x00000000
#define   USB_OTG_HS_XPU_SEAR0__PA___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_XPU_SEAR0__PA___S                                                     0
#define   USB_OTG_HS_XPU_SEAR0___M                                                         0xFFFFFFFF
#define   USB_OTG_HS_XPU_SEAR0___S                                                         0

#define USB_OTG_HS_XPU_SESR                                                              (0x00002048)
#define   USB_OTG_HS_XPU_SESR___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_XPU_SESR___POR                                                        0x00000000
#define   USB_OTG_HS_XPU_SESR__MULTI___M                                                   0x80000000
#define   USB_OTG_HS_XPU_SESR__MULTI___S                                                   31
#define   USB_OTG_HS_XPU_SESR__CLIENT___M                                                  0x00000002
#define   USB_OTG_HS_XPU_SESR__CLIENT___S                                                  1
#define   USB_OTG_HS_XPU_SESR__CFG___M                                                     0x00000001
#define   USB_OTG_HS_XPU_SESR__CFG___S                                                     0
#define   USB_OTG_HS_XPU_SESR___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_XPU_SESR___S                                                          0

#define USB_OTG_HS_XPU_SESRRESTORE                                                       (0x0000204C)
#define   USB_OTG_HS_XPU_SESRRESTORE___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_XPU_SESRRESTORE___POR                                                 0x00000000
#define   USB_OTG_HS_XPU_SESRRESTORE__MULTI___M                                            0x80000000
#define   USB_OTG_HS_XPU_SESRRESTORE__MULTI___S                                            31
#define   USB_OTG_HS_XPU_SESRRESTORE__CLIENT___M                                           0x00000002
#define   USB_OTG_HS_XPU_SESRRESTORE__CLIENT___S                                           1
#define   USB_OTG_HS_XPU_SESRRESTORE__CFG___M                                              0x00000001
#define   USB_OTG_HS_XPU_SESRRESTORE__CFG___S                                              0
#define   USB_OTG_HS_XPU_SESRRESTORE___M                                                   0xFFFFFFFF
#define   USB_OTG_HS_XPU_SESRRESTORE___S                                                   0

#define USB_OTG_HS_XPU_SESYNR0                                                           (0x00002050)
#define   USB_OTG_HS_XPU_SESYNR0___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_XPU_SESYNR0___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_SESYNR0__ATID___M                                                 0xFF000000
#define   USB_OTG_HS_XPU_SESYNR0__ATID___S                                                 24
#define   USB_OTG_HS_XPU_SESYNR0__AVMID___M                                                0x00FF0000
#define   USB_OTG_HS_XPU_SESYNR0__AVMID___S                                                16
#define   USB_OTG_HS_XPU_SESYNR0__ABID___M                                                 0x0000E000
#define   USB_OTG_HS_XPU_SESYNR0__ABID___S                                                 13
#define   USB_OTG_HS_XPU_SESYNR0__APID___M                                                 0x00001F00
#define   USB_OTG_HS_XPU_SESYNR0__APID___S                                                 8
#define   USB_OTG_HS_XPU_SESYNR0__AMID___M                                                 0x000000FF
#define   USB_OTG_HS_XPU_SESYNR0__AMID___S                                                 0
#define   USB_OTG_HS_XPU_SESYNR0___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_XPU_SESYNR0___S                                                       0

#define USB_OTG_HS_XPU_SESYNR1                                                           (0x00002054)
#define   USB_OTG_HS_XPU_SESYNR1___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_XPU_SESYNR1___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_SESYNR1__DCD___M                                                  0x80000000
#define   USB_OTG_HS_XPU_SESYNR1__DCD___S                                                  31
#define   USB_OTG_HS_XPU_SESYNR1__AC___M                                                   0x40000000
#define   USB_OTG_HS_XPU_SESYNR1__AC___S                                                   30
#define   USB_OTG_HS_XPU_SESYNR1__BURSTLEN___M                                             0x20000000
#define   USB_OTG_HS_XPU_SESYNR1__BURSTLEN___S                                             29
#define   USB_OTG_HS_XPU_SESYNR1__ARDALLOCATE___M                                          0x10000000
#define   USB_OTG_HS_XPU_SESYNR1__ARDALLOCATE___S                                          28
#define   USB_OTG_HS_XPU_SESYNR1__ABURST___M                                               0x08000000
#define   USB_OTG_HS_XPU_SESYNR1__ABURST___S                                               27
#define   USB_OTG_HS_XPU_SESYNR1__AEXCLUSIVE___M                                           0x04000000
#define   USB_OTG_HS_XPU_SESYNR1__AEXCLUSIVE___S                                           26
#define   USB_OTG_HS_XPU_SESYNR1__AWRITE___M                                               0x02000000
#define   USB_OTG_HS_XPU_SESYNR1__AWRITE___S                                               25
#define   USB_OTG_HS_XPU_SESYNR1__AFULL___M                                                0x01000000
#define   USB_OTG_HS_XPU_SESYNR1__AFULL___S                                                24
#define   USB_OTG_HS_XPU_SESYNR1__ARDBEADNDXEN___M                                         0x00800000
#define   USB_OTG_HS_XPU_SESYNR1__ARDBEADNDXEN___S                                         23
#define   USB_OTG_HS_XPU_SESYNR1__AOOO___M                                                 0x00400000
#define   USB_OTG_HS_XPU_SESYNR1__AOOO___S                                                 22
#define   USB_OTG_HS_XPU_SESYNR1__APREQPRIORITY___M                                        0x00380000
#define   USB_OTG_HS_XPU_SESYNR1__APREQPRIORITY___S                                        19
#define   USB_OTG_HS_XPU_SESYNR1__ASIZE___M                                                0x00070000
#define   USB_OTG_HS_XPU_SESYNR1__ASIZE___S                                                16
#define   USB_OTG_HS_XPU_SESYNR1__AMSSSELFAUTH___M                                         0x00008000
#define   USB_OTG_HS_XPU_SESYNR1__AMSSSELFAUTH___S                                         15
#define   USB_OTG_HS_XPU_SESYNR1__ALEN___M                                                 0x00007F00
#define   USB_OTG_HS_XPU_SESYNR1__ALEN___S                                                 8
#define   USB_OTG_HS_XPU_SESYNR1__AINST___M                                                0x00000080
#define   USB_OTG_HS_XPU_SESYNR1__AINST___S                                                7
#define   USB_OTG_HS_XPU_SESYNR1__APROTNS___M                                              0x00000040
#define   USB_OTG_HS_XPU_SESYNR1__APROTNS___S                                              6
#define   USB_OTG_HS_XPU_SESYNR1__APRIV___M                                                0x00000020
#define   USB_OTG_HS_XPU_SESYNR1__APRIV___S                                                5
#define   USB_OTG_HS_XPU_SESYNR1__AINNERSHARED___M                                         0x00000010
#define   USB_OTG_HS_XPU_SESYNR1__AINNERSHARED___S                                         4
#define   USB_OTG_HS_XPU_SESYNR1__ASHARED___M                                              0x00000008
#define   USB_OTG_HS_XPU_SESYNR1__ASHARED___S                                              3
#define   USB_OTG_HS_XPU_SESYNR1__AMEMTYPE___M                                             0x00000007
#define   USB_OTG_HS_XPU_SESYNR1__AMEMTYPE___S                                             0
#define   USB_OTG_HS_XPU_SESYNR1___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_XPU_SESYNR1___S                                                       0

#define USB_OTG_HS_XPU_SESYNR2                                                           (0x00002058)
#define   USB_OTG_HS_XPU_SESYNR2___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_XPU_SESYNR2___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_SESYNR2__MODEM_PRT_HIT___M                                        0x00000004
#define   USB_OTG_HS_XPU_SESYNR2__MODEM_PRT_HIT___S                                        2
#define   USB_OTG_HS_XPU_SESYNR2__SECURE_PRT_HIT___M                                       0x00000002
#define   USB_OTG_HS_XPU_SESYNR2__SECURE_PRT_HIT___S                                       1
#define   USB_OTG_HS_XPU_SESYNR2__NONSECURE_PRT_HIT___M                                    0x00000001
#define   USB_OTG_HS_XPU_SESYNR2__NONSECURE_PRT_HIT___S                                    0
#define   USB_OTG_HS_XPU_SESYNR2___M                                                       0x00000007
#define   USB_OTG_HS_XPU_SESYNR2___S                                                       0

#define USB_OTG_HS_XPU_MCR                                                               (0x00002100)
#define   USB_OTG_HS_XPU_MCR___RWC                                                         QCSR_REG_RW
#define   USB_OTG_HS_XPU_MCR___POR                                                         0x00000106
#define   USB_OTG_HS_XPU_MCR__DYNAMIC_CLK_EN___M                                           0x00000100
#define   USB_OTG_HS_XPU_MCR__DYNAMIC_CLK_EN___S                                           8
#define   USB_OTG_HS_XPU_MCR__DCDEE___M                                                    0x00000010
#define   USB_OTG_HS_XPU_MCR__DCDEE___S                                                    4
#define   USB_OTG_HS_XPU_MCR__EIE___M                                                      0x00000008
#define   USB_OTG_HS_XPU_MCR__EIE___S                                                      3
#define   USB_OTG_HS_XPU_MCR__CLERE___M                                                    0x00000004
#define   USB_OTG_HS_XPU_MCR__CLERE___S                                                    2
#define   USB_OTG_HS_XPU_MCR__CFGERE___M                                                   0x00000002
#define   USB_OTG_HS_XPU_MCR__CFGERE___S                                                   1
#define   USB_OTG_HS_XPU_MCR__XPUMSAE___M                                                  0x00000001
#define   USB_OTG_HS_XPU_MCR__XPUMSAE___S                                                  0
#define   USB_OTG_HS_XPU_MCR___M                                                           0x000001FF
#define   USB_OTG_HS_XPU_MCR___S                                                           0

#define USB_OTG_HS_XPU_MEAR0                                                             (0x00002140)
#define   USB_OTG_HS_XPU_MEAR0___RWC                                                       QCSR_REG_RO
#define   USB_OTG_HS_XPU_MEAR0___POR                                                       0x00000000
#define   USB_OTG_HS_XPU_MEAR0__PA___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_XPU_MEAR0__PA___S                                                     0
#define   USB_OTG_HS_XPU_MEAR0___M                                                         0xFFFFFFFF
#define   USB_OTG_HS_XPU_MEAR0___S                                                         0

#define USB_OTG_HS_XPU_MESR                                                              (0x00002148)
#define   USB_OTG_HS_XPU_MESR___RWC                                                        QCSR_REG_RW
#define   USB_OTG_HS_XPU_MESR___POR                                                        0x00000000
#define   USB_OTG_HS_XPU_MESR__MULTI___M                                                   0x80000000
#define   USB_OTG_HS_XPU_MESR__MULTI___S                                                   31
#define   USB_OTG_HS_XPU_MESR__CLIENT___M                                                  0x00000002
#define   USB_OTG_HS_XPU_MESR__CLIENT___S                                                  1
#define   USB_OTG_HS_XPU_MESR__CFG___M                                                     0x00000001
#define   USB_OTG_HS_XPU_MESR__CFG___S                                                     0
#define   USB_OTG_HS_XPU_MESR___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_XPU_MESR___S                                                          0

#define USB_OTG_HS_XPU_MESRRESTORE                                                       (0x0000214C)
#define   USB_OTG_HS_XPU_MESRRESTORE___RWC                                                 QCSR_REG_RW
#define   USB_OTG_HS_XPU_MESRRESTORE___POR                                                 0x00000000
#define   USB_OTG_HS_XPU_MESRRESTORE__MULTI___M                                            0x80000000
#define   USB_OTG_HS_XPU_MESRRESTORE__MULTI___S                                            31
#define   USB_OTG_HS_XPU_MESRRESTORE__CLIENT___M                                           0x00000002
#define   USB_OTG_HS_XPU_MESRRESTORE__CLIENT___S                                           1
#define   USB_OTG_HS_XPU_MESRRESTORE__CFG___M                                              0x00000001
#define   USB_OTG_HS_XPU_MESRRESTORE__CFG___S                                              0
#define   USB_OTG_HS_XPU_MESRRESTORE___M                                                   0xFFFFFFFF
#define   USB_OTG_HS_XPU_MESRRESTORE___S                                                   0

#define USB_OTG_HS_XPU_MESYNR0                                                           (0x00002150)
#define   USB_OTG_HS_XPU_MESYNR0___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_XPU_MESYNR0___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_MESYNR0__ATID___M                                                 0xFF000000
#define   USB_OTG_HS_XPU_MESYNR0__ATID___S                                                 24
#define   USB_OTG_HS_XPU_MESYNR0__AVMID___M                                                0x00FF0000
#define   USB_OTG_HS_XPU_MESYNR0__AVMID___S                                                16
#define   USB_OTG_HS_XPU_MESYNR0__ABID___M                                                 0x0000E000
#define   USB_OTG_HS_XPU_MESYNR0__ABID___S                                                 13
#define   USB_OTG_HS_XPU_MESYNR0__APID___M                                                 0x00001F00
#define   USB_OTG_HS_XPU_MESYNR0__APID___S                                                 8
#define   USB_OTG_HS_XPU_MESYNR0__AMID___M                                                 0x000000FF
#define   USB_OTG_HS_XPU_MESYNR0__AMID___S                                                 0
#define   USB_OTG_HS_XPU_MESYNR0___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_XPU_MESYNR0___S                                                       0

#define USB_OTG_HS_XPU_MESYNR1                                                           (0x00002154)
#define   USB_OTG_HS_XPU_MESYNR1___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_XPU_MESYNR1___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_MESYNR1__DCD___M                                                  0x80000000
#define   USB_OTG_HS_XPU_MESYNR1__DCD___S                                                  31
#define   USB_OTG_HS_XPU_MESYNR1__AC___M                                                   0x40000000
#define   USB_OTG_HS_XPU_MESYNR1__AC___S                                                   30
#define   USB_OTG_HS_XPU_MESYNR1__BURSTLEN___M                                             0x20000000
#define   USB_OTG_HS_XPU_MESYNR1__BURSTLEN___S                                             29
#define   USB_OTG_HS_XPU_MESYNR1__ARDALLOCATE___M                                          0x10000000
#define   USB_OTG_HS_XPU_MESYNR1__ARDALLOCATE___S                                          28
#define   USB_OTG_HS_XPU_MESYNR1__ABURST___M                                               0x08000000
#define   USB_OTG_HS_XPU_MESYNR1__ABURST___S                                               27
#define   USB_OTG_HS_XPU_MESYNR1__AEXCLUSIVE___M                                           0x04000000
#define   USB_OTG_HS_XPU_MESYNR1__AEXCLUSIVE___S                                           26
#define   USB_OTG_HS_XPU_MESYNR1__AWRITE___M                                               0x02000000
#define   USB_OTG_HS_XPU_MESYNR1__AWRITE___S                                               25
#define   USB_OTG_HS_XPU_MESYNR1__AFULL___M                                                0x01000000
#define   USB_OTG_HS_XPU_MESYNR1__AFULL___S                                                24
#define   USB_OTG_HS_XPU_MESYNR1__ARDBEADNDXEN___M                                         0x00800000
#define   USB_OTG_HS_XPU_MESYNR1__ARDBEADNDXEN___S                                         23
#define   USB_OTG_HS_XPU_MESYNR1__AOOO___M                                                 0x00400000
#define   USB_OTG_HS_XPU_MESYNR1__AOOO___S                                                 22
#define   USB_OTG_HS_XPU_MESYNR1__APREQPRIORITY___M                                        0x00380000
#define   USB_OTG_HS_XPU_MESYNR1__APREQPRIORITY___S                                        19
#define   USB_OTG_HS_XPU_MESYNR1__ASIZE___M                                                0x00070000
#define   USB_OTG_HS_XPU_MESYNR1__ASIZE___S                                                16
#define   USB_OTG_HS_XPU_MESYNR1__AMSSSELFAUTH___M                                         0x00008000
#define   USB_OTG_HS_XPU_MESYNR1__AMSSSELFAUTH___S                                         15
#define   USB_OTG_HS_XPU_MESYNR1__ALEN___M                                                 0x00007F00
#define   USB_OTG_HS_XPU_MESYNR1__ALEN___S                                                 8
#define   USB_OTG_HS_XPU_MESYNR1__AINST___M                                                0x00000080
#define   USB_OTG_HS_XPU_MESYNR1__AINST___S                                                7
#define   USB_OTG_HS_XPU_MESYNR1__APROTNS___M                                              0x00000040
#define   USB_OTG_HS_XPU_MESYNR1__APROTNS___S                                              6
#define   USB_OTG_HS_XPU_MESYNR1__APRIV___M                                                0x00000020
#define   USB_OTG_HS_XPU_MESYNR1__APRIV___S                                                5
#define   USB_OTG_HS_XPU_MESYNR1__AINNERSHARED___M                                         0x00000010
#define   USB_OTG_HS_XPU_MESYNR1__AINNERSHARED___S                                         4
#define   USB_OTG_HS_XPU_MESYNR1__ASHARED___M                                              0x00000008
#define   USB_OTG_HS_XPU_MESYNR1__ASHARED___S                                              3
#define   USB_OTG_HS_XPU_MESYNR1__AMEMTYPE___M                                             0x00000007
#define   USB_OTG_HS_XPU_MESYNR1__AMEMTYPE___S                                             0
#define   USB_OTG_HS_XPU_MESYNR1___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_XPU_MESYNR1___S                                                       0

#define USB_OTG_HS_XPU_MESYNR2                                                           (0x00002158)
#define   USB_OTG_HS_XPU_MESYNR2___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_XPU_MESYNR2___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_MESYNR2__MODEM_PRT_HIT___M                                        0x00000004
#define   USB_OTG_HS_XPU_MESYNR2__MODEM_PRT_HIT___S                                        2
#define   USB_OTG_HS_XPU_MESYNR2__SECURE_PRT_HIT___M                                       0x00000002
#define   USB_OTG_HS_XPU_MESYNR2__SECURE_PRT_HIT___S                                       1
#define   USB_OTG_HS_XPU_MESYNR2__NONSECURE_PRT_HIT___M                                    0x00000001
#define   USB_OTG_HS_XPU_MESYNR2__NONSECURE_PRT_HIT___S                                    0
#define   USB_OTG_HS_XPU_MESYNR2___M                                                       0x00000007
#define   USB_OTG_HS_XPU_MESYNR2___S                                                       0

#define USB_OTG_HS_XPU_CR                                                                (0x00002080)
#define   USB_OTG_HS_XPU_CR___RWC                                                          QCSR_REG_RW
#define   USB_OTG_HS_XPU_CR___POR                                                          0x00000106
#define   USB_OTG_HS_XPU_CR__DYNAMIC_CLK_EN___M                                            0x00000100
#define   USB_OTG_HS_XPU_CR__DYNAMIC_CLK_EN___S                                            8
#define   USB_OTG_HS_XPU_CR__DCDEE___M                                                     0x00000010
#define   USB_OTG_HS_XPU_CR__DCDEE___S                                                     4
#define   USB_OTG_HS_XPU_CR__EIE___M                                                       0x00000008
#define   USB_OTG_HS_XPU_CR__EIE___S                                                       3
#define   USB_OTG_HS_XPU_CR__CLERE___M                                                     0x00000004
#define   USB_OTG_HS_XPU_CR__CLERE___S                                                     2
#define   USB_OTG_HS_XPU_CR__CFGERE___M                                                    0x00000002
#define   USB_OTG_HS_XPU_CR__CFGERE___S                                                    1
#define   USB_OTG_HS_XPU_CR__XPUVMIDE___M                                                  0x00000001
#define   USB_OTG_HS_XPU_CR__XPUVMIDE___S                                                  0
#define   USB_OTG_HS_XPU_CR___M                                                            0x000001FF
#define   USB_OTG_HS_XPU_CR___S                                                            0

#define USB_OTG_HS_XPU_RPU_ACRn(n)                                            (0x000020A0+0x4*(n))
#define   USB_OTG_HS_XPU_RPU_ACRn_nMIN                         0
#define   USB_OTG_HS_XPU_RPU_ACRn_nMAX                         0
#define   USB_OTG_HS_XPU_RPU_ACRn_ELEM                         1
#define   USB_OTG_HS_XPU_RPU_ACRn___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RPU_ACRn___POR                                                    0xFFFFFFFF
#define   USB_OTG_HS_XPU_RPU_ACRn__RWE___M                                                 0xFFFFFFFF
#define   USB_OTG_HS_XPU_RPU_ACRn__RWE___S                                                 0
#define   USB_OTG_HS_XPU_RPU_ACRn___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_XPU_RPU_ACRn___S                                                      0
#define USB_OTG_HS_XPU_RPU_ACR0                                                          (0x000020A0)
#define   USB_OTG_HS_XPU_RPU_ACR0___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RPU_ACR0__RWE___M                                                 0xFFFFFFFF
#define   USB_OTG_HS_XPU_RPU_ACR0__RWE___S                                                 0

#define USB_OTG_HS_XPU_EAR0                                                              (0x000020C0)
#define   USB_OTG_HS_XPU_EAR0___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_XPU_EAR0___POR                                                        0x00000000
#define   USB_OTG_HS_XPU_EAR0__PA___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_XPU_EAR0__PA___S                                                      0
#define   USB_OTG_HS_XPU_EAR0___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_XPU_EAR0___S                                                          0

#define USB_OTG_HS_XPU_ESR                                                               (0x000020C8)
#define   USB_OTG_HS_XPU_ESR___RWC                                                         QCSR_REG_RW
#define   USB_OTG_HS_XPU_ESR___POR                                                         0x00000000
#define   USB_OTG_HS_XPU_ESR__MULTI___M                                                    0x80000000
#define   USB_OTG_HS_XPU_ESR__MULTI___S                                                    31
#define   USB_OTG_HS_XPU_ESR__CLIENT___M                                                   0x00000002
#define   USB_OTG_HS_XPU_ESR__CLIENT___S                                                   1
#define   USB_OTG_HS_XPU_ESR__CFG___M                                                      0x00000001
#define   USB_OTG_HS_XPU_ESR__CFG___S                                                      0
#define   USB_OTG_HS_XPU_ESR___M                                                           0xFFFFFFFF
#define   USB_OTG_HS_XPU_ESR___S                                                           0

#define USB_OTG_HS_XPU_ESRRESTORE                                                        (0x000020CC)
#define   USB_OTG_HS_XPU_ESRRESTORE___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_ESRRESTORE___POR                                                  0x00000000
#define   USB_OTG_HS_XPU_ESRRESTORE__MULTI___M                                             0x80000000
#define   USB_OTG_HS_XPU_ESRRESTORE__MULTI___S                                             31
#define   USB_OTG_HS_XPU_ESRRESTORE__CLIENT___M                                            0x00000002
#define   USB_OTG_HS_XPU_ESRRESTORE__CLIENT___S                                            1
#define   USB_OTG_HS_XPU_ESRRESTORE__CFG___M                                               0x00000001
#define   USB_OTG_HS_XPU_ESRRESTORE__CFG___S                                               0
#define   USB_OTG_HS_XPU_ESRRESTORE___M                                                    0xFFFFFFFF
#define   USB_OTG_HS_XPU_ESRRESTORE___S                                                    0

#define USB_OTG_HS_XPU_ESYNR0                                                            (0x000020D0)
#define   USB_OTG_HS_XPU_ESYNR0___RWC                                                      QCSR_REG_RO
#define   USB_OTG_HS_XPU_ESYNR0___POR                                                      0x00000000
#define   USB_OTG_HS_XPU_ESYNR0__ATID___M                                                  0xFF000000
#define   USB_OTG_HS_XPU_ESYNR0__ATID___S                                                  24
#define   USB_OTG_HS_XPU_ESYNR0__AVMID___M                                                 0x00FF0000
#define   USB_OTG_HS_XPU_ESYNR0__AVMID___S                                                 16
#define   USB_OTG_HS_XPU_ESYNR0__ABID___M                                                  0x0000E000
#define   USB_OTG_HS_XPU_ESYNR0__ABID___S                                                  13
#define   USB_OTG_HS_XPU_ESYNR0__APID___M                                                  0x00001F00
#define   USB_OTG_HS_XPU_ESYNR0__APID___S                                                  8
#define   USB_OTG_HS_XPU_ESYNR0__AMID___M                                                  0x000000FF
#define   USB_OTG_HS_XPU_ESYNR0__AMID___S                                                  0
#define   USB_OTG_HS_XPU_ESYNR0___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_XPU_ESYNR0___S                                                        0

#define USB_OTG_HS_XPU_ESYNR1                                                            (0x000020D4)
#define   USB_OTG_HS_XPU_ESYNR1___RWC                                                      QCSR_REG_RO
#define   USB_OTG_HS_XPU_ESYNR1___POR                                                      0x00000000
#define   USB_OTG_HS_XPU_ESYNR1__DCD___M                                                   0x80000000
#define   USB_OTG_HS_XPU_ESYNR1__DCD___S                                                   31
#define   USB_OTG_HS_XPU_ESYNR1__AC___M                                                    0x40000000
#define   USB_OTG_HS_XPU_ESYNR1__AC___S                                                    30
#define   USB_OTG_HS_XPU_ESYNR1__BURSTLEN___M                                              0x20000000
#define   USB_OTG_HS_XPU_ESYNR1__BURSTLEN___S                                              29
#define   USB_OTG_HS_XPU_ESYNR1__ARDALLOCATE___M                                           0x10000000
#define   USB_OTG_HS_XPU_ESYNR1__ARDALLOCATE___S                                           28
#define   USB_OTG_HS_XPU_ESYNR1__ABURST___M                                                0x08000000
#define   USB_OTG_HS_XPU_ESYNR1__ABURST___S                                                27
#define   USB_OTG_HS_XPU_ESYNR1__AEXCLUSIVE___M                                            0x04000000
#define   USB_OTG_HS_XPU_ESYNR1__AEXCLUSIVE___S                                            26
#define   USB_OTG_HS_XPU_ESYNR1__AWRITE___M                                                0x02000000
#define   USB_OTG_HS_XPU_ESYNR1__AWRITE___S                                                25
#define   USB_OTG_HS_XPU_ESYNR1__AFULL___M                                                 0x01000000
#define   USB_OTG_HS_XPU_ESYNR1__AFULL___S                                                 24
#define   USB_OTG_HS_XPU_ESYNR1__ARDBEADNDXEN___M                                          0x00800000
#define   USB_OTG_HS_XPU_ESYNR1__ARDBEADNDXEN___S                                          23
#define   USB_OTG_HS_XPU_ESYNR1__AOOO___M                                                  0x00400000
#define   USB_OTG_HS_XPU_ESYNR1__AOOO___S                                                  22
#define   USB_OTG_HS_XPU_ESYNR1__APREQPRIORITY___M                                         0x00380000
#define   USB_OTG_HS_XPU_ESYNR1__APREQPRIORITY___S                                         19
#define   USB_OTG_HS_XPU_ESYNR1__ASIZE___M                                                 0x00070000
#define   USB_OTG_HS_XPU_ESYNR1__ASIZE___S                                                 16
#define   USB_OTG_HS_XPU_ESYNR1__AMSSSELFAUTH___M                                          0x00008000
#define   USB_OTG_HS_XPU_ESYNR1__AMSSSELFAUTH___S                                          15
#define   USB_OTG_HS_XPU_ESYNR1__ALEN___M                                                  0x00007F00
#define   USB_OTG_HS_XPU_ESYNR1__ALEN___S                                                  8
#define   USB_OTG_HS_XPU_ESYNR1__AINST___M                                                 0x00000080
#define   USB_OTG_HS_XPU_ESYNR1__AINST___S                                                 7
#define   USB_OTG_HS_XPU_ESYNR1__APROTNS___M                                               0x00000040
#define   USB_OTG_HS_XPU_ESYNR1__APROTNS___S                                               6
#define   USB_OTG_HS_XPU_ESYNR1__APRIV___M                                                 0x00000020
#define   USB_OTG_HS_XPU_ESYNR1__APRIV___S                                                 5
#define   USB_OTG_HS_XPU_ESYNR1__AINNERSHARED___M                                          0x00000010
#define   USB_OTG_HS_XPU_ESYNR1__AINNERSHARED___S                                          4
#define   USB_OTG_HS_XPU_ESYNR1__ASHARED___M                                               0x00000008
#define   USB_OTG_HS_XPU_ESYNR1__ASHARED___S                                               3
#define   USB_OTG_HS_XPU_ESYNR1__AMEMTYPE___M                                              0x00000007
#define   USB_OTG_HS_XPU_ESYNR1__AMEMTYPE___S                                              0
#define   USB_OTG_HS_XPU_ESYNR1___M                                                        0xFFFFFFFF
#define   USB_OTG_HS_XPU_ESYNR1___S                                                        0

#define USB_OTG_HS_XPU_ESYNR2                                                            (0x000020D8)
#define   USB_OTG_HS_XPU_ESYNR2___RWC                                                      QCSR_REG_RO
#define   USB_OTG_HS_XPU_ESYNR2___POR                                                      0x00000000
#define   USB_OTG_HS_XPU_ESYNR2__MODEM_PRT_HIT___M                                         0x00000004
#define   USB_OTG_HS_XPU_ESYNR2__MODEM_PRT_HIT___S                                         2
#define   USB_OTG_HS_XPU_ESYNR2__SECURE_PRT_HIT___M                                        0x00000002
#define   USB_OTG_HS_XPU_ESYNR2__SECURE_PRT_HIT___S                                        1
#define   USB_OTG_HS_XPU_ESYNR2__NONSECURE_PRT_HIT___M                                     0x00000001
#define   USB_OTG_HS_XPU_ESYNR2__NONSECURE_PRT_HIT___S                                     0
#define   USB_OTG_HS_XPU_ESYNR2___M                                                        0x00000007
#define   USB_OTG_HS_XPU_ESYNR2___S                                                        0

#define USB_OTG_HS_XPU_IDR0                                                              (0x00002074)
#define   USB_OTG_HS_XPU_IDR0___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_XPU_IDR0___POR                                                        0x00001414
#define   USB_OTG_HS_XPU_IDR0__CLIENTREQ_HALT_ACK_HW_EN___M                                0x80000000
#define   USB_OTG_HS_XPU_IDR0__CLIENTREQ_HALT_ACK_HW_EN___S                                31
#define   USB_OTG_HS_XPU_IDR0__SAVERESTORE_HW_EN___M                                       0x40000000
#define   USB_OTG_HS_XPU_IDR0__SAVERESTORE_HW_EN___S                                       30
#define   USB_OTG_HS_XPU_IDR0__BLED___M                                                    0x00008000
#define   USB_OTG_HS_XPU_IDR0__BLED___S                                                    15
#define   USB_OTG_HS_XPU_IDR0__XPUT___M                                                    0x00003000
#define   USB_OTG_HS_XPU_IDR0__XPUT___S                                                    12
#define   USB_OTG_HS_XPU_IDR0__PT___M                                                      0x00000800
#define   USB_OTG_HS_XPU_IDR0__PT___S                                                      11
#define   USB_OTG_HS_XPU_IDR0__MV___M                                                      0x00000400
#define   USB_OTG_HS_XPU_IDR0__MV___S                                                      10
#define   USB_OTG_HS_XPU_IDR0__NRG___M                                                     0x000003FF
#define   USB_OTG_HS_XPU_IDR0__NRG___S                                                     0
#define   USB_OTG_HS_XPU_IDR0___M                                                          0xFFFFFFFF
#define   USB_OTG_HS_XPU_IDR0___S                                                          0

#define USB_OTG_HS_XPU_IDR1                                                              (0x00002078)
#define   USB_OTG_HS_XPU_IDR1___RWC                                                        QCSR_REG_RO
#define   USB_OTG_HS_XPU_IDR1___POR                                                        0x1F0B0A1F
#define   USB_OTG_HS_XPU_IDR1__AMT_HW_ENABLE___M                                           0x40000000
#define   USB_OTG_HS_XPU_IDR1__AMT_HW_ENABLE___S                                           30
#define   USB_OTG_HS_XPU_IDR1__CLIENT_ADDR_WIDTH___M                                       0x3F000000
#define   USB_OTG_HS_XPU_IDR1__CLIENT_ADDR_WIDTH___S                                       24
#define   USB_OTG_HS_XPU_IDR1__CONFIG_ADDR_WIDTH___M                                       0x003F0000
#define   USB_OTG_HS_XPU_IDR1__CONFIG_ADDR_WIDTH___S                                       16
#define   USB_OTG_HS_XPU_IDR1__QRIB_EN___M                                                 0x00008000
#define   USB_OTG_HS_XPU_IDR1__QRIB_EN___S                                                 15
#define   USB_OTG_HS_XPU_IDR1__ASYNC_MODE___M                                              0x00004000
#define   USB_OTG_HS_XPU_IDR1__ASYNC_MODE___S                                              14
#define   USB_OTG_HS_XPU_IDR1__CONFIG_TYPE___M                                             0x00002000
#define   USB_OTG_HS_XPU_IDR1__CONFIG_TYPE___S                                             13
#define   USB_OTG_HS_XPU_IDR1__CLIENT_PIPELINE_ENABLED___M                                 0x00001000
#define   USB_OTG_HS_XPU_IDR1__CLIENT_PIPELINE_ENABLED___S                                 12
#define   USB_OTG_HS_XPU_IDR1__MSA_CHECK_HW_ENABLE___M                                     0x00000800
#define   USB_OTG_HS_XPU_IDR1__MSA_CHECK_HW_ENABLE___S                                     11
#define   USB_OTG_HS_XPU_IDR1__XPU_SYND_REG_ABSENT___M                                     0x00000400
#define   USB_OTG_HS_XPU_IDR1__XPU_SYND_REG_ABSENT___S                                     10
#define   USB_OTG_HS_XPU_IDR1__TZXPU___M                                                   0x00000200
#define   USB_OTG_HS_XPU_IDR1__TZXPU___S                                                   9
#define   USB_OTG_HS_XPU_IDR1__NVMID___M                                                   0x000000FF
#define   USB_OTG_HS_XPU_IDR1__NVMID___S                                                   0
#define   USB_OTG_HS_XPU_IDR1___M                                                          0x7FFFFFFF
#define   USB_OTG_HS_XPU_IDR1___S                                                          0

#define USB_OTG_HS_XPU_REV                                                               (0x0000207C)
#define   USB_OTG_HS_XPU_REV___RWC                                                         QCSR_REG_RO
#define   USB_OTG_HS_XPU_REV___POR                                                         0x20000000
#define   USB_OTG_HS_XPU_REV__MAJOR___M                                                    0xF0000000
#define   USB_OTG_HS_XPU_REV__MAJOR___S                                                    28
#define   USB_OTG_HS_XPU_REV__MINOR___M                                                    0x0FFF0000
#define   USB_OTG_HS_XPU_REV__MINOR___S                                                    16
#define   USB_OTG_HS_XPU_REV__STEP___M                                                     0x0000FFFF
#define   USB_OTG_HS_XPU_REV__STEP___S                                                     0
#define   USB_OTG_HS_XPU_REV___M                                                           0xFFFFFFFF
#define   USB_OTG_HS_XPU_REV___S                                                           0

#define USB_OTG_HS_XPU_RGn_RACRm(n,m)                                         (0x00002200+0x80*(n)+0x4*(m))
#define   USB_OTG_HS_XPU_RGn_RACRm_nMIN                        0
#define   USB_OTG_HS_XPU_RGn_RACRm_nMAX                        20
#define   USB_OTG_HS_XPU_RGn_RACRm_mMIN                        0
#define   USB_OTG_HS_XPU_RGn_RACRm_mMAX                        0
#define   USB_OTG_HS_XPU_RGn_RACRm_ELEM                        21
#define   USB_OTG_HS_XPU_RGn_RACRm___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RGn_RACRm___POR                                                   0x00000000
#define   USB_OTG_HS_XPU_RGn_RACRm__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RGn_RACRm__RWE___S                                                0
#define   USB_OTG_HS_XPU_RGn_RACRm___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_XPU_RGn_RACRm___S                                                     0
#define USB_OTG_HS_XPU_RG0_RACR0                                                         (0x00002200)
#define   USB_OTG_HS_XPU_RG0_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG0_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG0_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG1_RACR0                                                         (0x00002280)
#define   USB_OTG_HS_XPU_RG1_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG1_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG1_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG2_RACR0                                                         (0x00002300)
#define   USB_OTG_HS_XPU_RG2_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG2_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG2_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG3_RACR0                                                         (0x00002380)
#define   USB_OTG_HS_XPU_RG3_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG3_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG3_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG4_RACR0                                                         (0x00002400)
#define   USB_OTG_HS_XPU_RG4_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG4_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG4_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG5_RACR0                                                         (0x00002480)
#define   USB_OTG_HS_XPU_RG5_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG5_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG5_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG6_RACR0                                                         (0x00002500)
#define   USB_OTG_HS_XPU_RG6_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG6_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG6_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG7_RACR0                                                         (0x00002580)
#define   USB_OTG_HS_XPU_RG7_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG7_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG7_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG8_RACR0                                                         (0x00002600)
#define   USB_OTG_HS_XPU_RG8_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG8_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG8_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG9_RACR0                                                         (0x00002680)
#define   USB_OTG_HS_XPU_RG9_RACR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG9_RACR0__RWE___M                                                0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG9_RACR0__RWE___S                                                0
#define USB_OTG_HS_XPU_RG10_RACR0                                                        (0x00002700)
#define   USB_OTG_HS_XPU_RG10_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG10_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG10_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG11_RACR0                                                        (0x00002780)
#define   USB_OTG_HS_XPU_RG11_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG11_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG11_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG12_RACR0                                                        (0x00002800)
#define   USB_OTG_HS_XPU_RG12_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG12_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG12_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG13_RACR0                                                        (0x00002880)
#define   USB_OTG_HS_XPU_RG13_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG13_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG13_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG14_RACR0                                                        (0x00002900)
#define   USB_OTG_HS_XPU_RG14_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG14_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG14_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG15_RACR0                                                        (0x00002980)
#define   USB_OTG_HS_XPU_RG15_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG15_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG15_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG16_RACR0                                                        (0x00002A00)
#define   USB_OTG_HS_XPU_RG16_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG16_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG16_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG17_RACR0                                                        (0x00002A80)
#define   USB_OTG_HS_XPU_RG17_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG17_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG17_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG18_RACR0                                                        (0x00002B00)
#define   USB_OTG_HS_XPU_RG18_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG18_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG18_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG19_RACR0                                                        (0x00002B80)
#define   USB_OTG_HS_XPU_RG19_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG19_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG19_RACR0__RWE___S                                               0
#define USB_OTG_HS_XPU_RG20_RACR0                                                        (0x00002C00)
#define   USB_OTG_HS_XPU_RG20_RACR0___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG20_RACR0__RWE___M                                               0xFFFFFFFF
#define   USB_OTG_HS_XPU_RG20_RACR0__RWE___S                                               0

#define USB_OTG_HS_XPU_RGn_SCR(n)                                             (0x00002250+0x80*(n))
#define   USB_OTG_HS_XPU_RGn_SCR_nMIN                          0
#define   USB_OTG_HS_XPU_RGn_SCR_nMAX                          20
#define   USB_OTG_HS_XPU_RGn_SCR_ELEM                          21
#define   USB_OTG_HS_XPU_RGn_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RGn_SCR___POR                                                     0x00000001
#define   USB_OTG_HS_XPU_RGn_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RGn_SCR__NS___S                                                   0
#define   USB_OTG_HS_XPU_RGn_SCR___M                                                       0x00000001
#define   USB_OTG_HS_XPU_RGn_SCR___S                                                       0
#define USB_OTG_HS_XPU_RG0_SCR                                                           (0x00002250)
#define   USB_OTG_HS_XPU_RG0_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG0_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG0_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG1_SCR                                                           (0x000022D0)
#define   USB_OTG_HS_XPU_RG1_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG1_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG1_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG2_SCR                                                           (0x00002350)
#define   USB_OTG_HS_XPU_RG2_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG2_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG2_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG3_SCR                                                           (0x000023D0)
#define   USB_OTG_HS_XPU_RG3_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG3_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG3_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG4_SCR                                                           (0x00002450)
#define   USB_OTG_HS_XPU_RG4_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG4_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG4_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG5_SCR                                                           (0x000024D0)
#define   USB_OTG_HS_XPU_RG5_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG5_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG5_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG6_SCR                                                           (0x00002550)
#define   USB_OTG_HS_XPU_RG6_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG6_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG6_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG7_SCR                                                           (0x000025D0)
#define   USB_OTG_HS_XPU_RG7_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG7_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG7_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG8_SCR                                                           (0x00002650)
#define   USB_OTG_HS_XPU_RG8_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG8_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG8_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG9_SCR                                                           (0x000026D0)
#define   USB_OTG_HS_XPU_RG9_SCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG9_SCR__NS___M                                                   0x00000001
#define   USB_OTG_HS_XPU_RG9_SCR__NS___S                                                   0
#define USB_OTG_HS_XPU_RG10_SCR                                                          (0x00002750)
#define   USB_OTG_HS_XPU_RG10_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG10_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG10_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG11_SCR                                                          (0x000027D0)
#define   USB_OTG_HS_XPU_RG11_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG11_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG11_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG12_SCR                                                          (0x00002850)
#define   USB_OTG_HS_XPU_RG12_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG12_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG12_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG13_SCR                                                          (0x000028D0)
#define   USB_OTG_HS_XPU_RG13_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG13_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG13_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG14_SCR                                                          (0x00002950)
#define   USB_OTG_HS_XPU_RG14_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG14_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG14_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG15_SCR                                                          (0x000029D0)
#define   USB_OTG_HS_XPU_RG15_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG15_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG15_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG16_SCR                                                          (0x00002A50)
#define   USB_OTG_HS_XPU_RG16_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG16_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG16_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG17_SCR                                                          (0x00002AD0)
#define   USB_OTG_HS_XPU_RG17_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG17_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG17_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG18_SCR                                                          (0x00002B50)
#define   USB_OTG_HS_XPU_RG18_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG18_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG18_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG19_SCR                                                          (0x00002BD0)
#define   USB_OTG_HS_XPU_RG19_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG19_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG19_SCR__NS___S                                                  0
#define USB_OTG_HS_XPU_RG20_SCR                                                          (0x00002C50)
#define   USB_OTG_HS_XPU_RG20_SCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG20_SCR__NS___M                                                  0x00000001
#define   USB_OTG_HS_XPU_RG20_SCR__NS___S                                                  0

#define USB_OTG_HS_XPU_RGn_MCR(n)                                             (0x00002254+0x80*(n))
#define   USB_OTG_HS_XPU_RGn_MCR_nMIN                          0
#define   USB_OTG_HS_XPU_RGn_MCR_nMAX                          20
#define   USB_OTG_HS_XPU_RGn_MCR_ELEM                          21
#define   USB_OTG_HS_XPU_RGn_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RGn_MCR___POR                                                     0x00000000
#define   USB_OTG_HS_XPU_RGn_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RGn_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RGn_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RGn_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RGn_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RGn_MCR__MSAE___S                                                 0
#define   USB_OTG_HS_XPU_RGn_MCR___M                                                       0x00000007
#define   USB_OTG_HS_XPU_RGn_MCR___S                                                       0
#define USB_OTG_HS_XPU_RG0_MCR                                                           (0x00002254)
#define   USB_OTG_HS_XPU_RG0_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG0_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG0_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG0_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG0_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG0_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG0_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG1_MCR                                                           (0x000022D4)
#define   USB_OTG_HS_XPU_RG1_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG1_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG1_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG1_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG1_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG1_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG1_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG2_MCR                                                           (0x00002354)
#define   USB_OTG_HS_XPU_RG2_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG2_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG2_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG2_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG2_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG2_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG2_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG3_MCR                                                           (0x000023D4)
#define   USB_OTG_HS_XPU_RG3_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG3_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG3_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG3_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG3_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG3_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG3_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG4_MCR                                                           (0x00002454)
#define   USB_OTG_HS_XPU_RG4_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG4_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG4_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG4_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG4_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG4_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG4_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG5_MCR                                                           (0x000024D4)
#define   USB_OTG_HS_XPU_RG5_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG5_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG5_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG5_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG5_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG5_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG5_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG6_MCR                                                           (0x00002554)
#define   USB_OTG_HS_XPU_RG6_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG6_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG6_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG6_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG6_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG6_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG6_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG7_MCR                                                           (0x000025D4)
#define   USB_OTG_HS_XPU_RG7_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG7_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG7_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG7_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG7_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG7_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG7_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG8_MCR                                                           (0x00002654)
#define   USB_OTG_HS_XPU_RG8_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG8_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG8_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG8_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG8_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG8_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG8_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG9_MCR                                                           (0x000026D4)
#define   USB_OTG_HS_XPU_RG9_MCR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG9_MCR__VMIDCLE___M                                              0x00000004
#define   USB_OTG_HS_XPU_RG9_MCR__VMIDCLE___S                                              2
#define   USB_OTG_HS_XPU_RG9_MCR__SCLE___M                                                 0x00000002
#define   USB_OTG_HS_XPU_RG9_MCR__SCLE___S                                                 1
#define   USB_OTG_HS_XPU_RG9_MCR__MSAE___M                                                 0x00000001
#define   USB_OTG_HS_XPU_RG9_MCR__MSAE___S                                                 0
#define USB_OTG_HS_XPU_RG10_MCR                                                          (0x00002754)
#define   USB_OTG_HS_XPU_RG10_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG10_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG10_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG10_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG10_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG10_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG10_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG11_MCR                                                          (0x000027D4)
#define   USB_OTG_HS_XPU_RG11_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG11_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG11_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG11_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG11_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG11_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG11_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG12_MCR                                                          (0x00002854)
#define   USB_OTG_HS_XPU_RG12_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG12_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG12_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG12_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG12_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG12_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG12_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG13_MCR                                                          (0x000028D4)
#define   USB_OTG_HS_XPU_RG13_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG13_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG13_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG13_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG13_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG13_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG13_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG14_MCR                                                          (0x00002954)
#define   USB_OTG_HS_XPU_RG14_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG14_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG14_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG14_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG14_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG14_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG14_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG15_MCR                                                          (0x000029D4)
#define   USB_OTG_HS_XPU_RG15_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG15_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG15_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG15_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG15_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG15_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG15_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG16_MCR                                                          (0x00002A54)
#define   USB_OTG_HS_XPU_RG16_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG16_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG16_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG16_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG16_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG16_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG16_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG17_MCR                                                          (0x00002AD4)
#define   USB_OTG_HS_XPU_RG17_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG17_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG17_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG17_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG17_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG17_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG17_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG18_MCR                                                          (0x00002B54)
#define   USB_OTG_HS_XPU_RG18_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG18_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG18_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG18_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG18_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG18_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG18_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG19_MCR                                                          (0x00002BD4)
#define   USB_OTG_HS_XPU_RG19_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG19_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG19_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG19_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG19_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG19_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG19_MCR__MSAE___S                                                0
#define USB_OTG_HS_XPU_RG20_MCR                                                          (0x00002C54)
#define   USB_OTG_HS_XPU_RG20_MCR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_XPU_RG20_MCR__VMIDCLE___M                                             0x00000004
#define   USB_OTG_HS_XPU_RG20_MCR__VMIDCLE___S                                             2
#define   USB_OTG_HS_XPU_RG20_MCR__SCLE___M                                                0x00000002
#define   USB_OTG_HS_XPU_RG20_MCR__SCLE___S                                                1
#define   USB_OTG_HS_XPU_RG20_MCR__MSAE___M                                                0x00000001
#define   USB_OTG_HS_XPU_RG20_MCR__MSAE___S                                                0

#define USB_OTG_HS_VMIDMT_SCR0                                                           (0x00000000)
#define   USB_OTG_HS_VMIDMT_SCR0___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SCR0___POR                                                     0x00000111
#define   USB_OTG_HS_VMIDMT_SCR0__NSCFG___M                                                0x30000000
#define   USB_OTG_HS_VMIDMT_SCR0__NSCFG___S                                                28
#define   USB_OTG_HS_VMIDMT_SCR0__WACFG___M                                                0x0C000000
#define   USB_OTG_HS_VMIDMT_SCR0__WACFG___S                                                26
#define   USB_OTG_HS_VMIDMT_SCR0__RACFG___M                                                0x03000000
#define   USB_OTG_HS_VMIDMT_SCR0__RACFG___S                                                24
#define   USB_OTG_HS_VMIDMT_SCR0__SHCFG___M                                                0x00C00000
#define   USB_OTG_HS_VMIDMT_SCR0__SHCFG___S                                                22
#define   USB_OTG_HS_VMIDMT_SCR0__SMCFCFG___M                                              0x00200000
#define   USB_OTG_HS_VMIDMT_SCR0__SMCFCFG___S                                              21
#define   USB_OTG_HS_VMIDMT_SCR0__MTCFG___M                                                0x00100000
#define   USB_OTG_HS_VMIDMT_SCR0__MTCFG___S                                                20
#define   USB_OTG_HS_VMIDMT_SCR0__MEMATTR___M                                              0x00070000
#define   USB_OTG_HS_VMIDMT_SCR0__MEMATTR___S                                              16
#define   USB_OTG_HS_VMIDMT_SCR0__USFCFG___M                                               0x00000400
#define   USB_OTG_HS_VMIDMT_SCR0__USFCFG___S                                               10
#define   USB_OTG_HS_VMIDMT_SCR0__GSE___M                                                  0x00000200
#define   USB_OTG_HS_VMIDMT_SCR0__GSE___S                                                  9
#define   USB_OTG_HS_VMIDMT_SCR0__STALLD___M                                               0x00000100
#define   USB_OTG_HS_VMIDMT_SCR0__STALLD___S                                               8
#define   USB_OTG_HS_VMIDMT_SCR0__TRANSIENTCFG___M                                         0x000000C0
#define   USB_OTG_HS_VMIDMT_SCR0__TRANSIENTCFG___S                                         6
#define   USB_OTG_HS_VMIDMT_SCR0__GCFGFIE___M                                              0x00000020
#define   USB_OTG_HS_VMIDMT_SCR0__GCFGFIE___S                                              5
#define   USB_OTG_HS_VMIDMT_SCR0__GCFGERE___M                                              0x00000010
#define   USB_OTG_HS_VMIDMT_SCR0__GCFGERE___S                                              4
#define   USB_OTG_HS_VMIDMT_SCR0__GFIE___M                                                 0x00000004
#define   USB_OTG_HS_VMIDMT_SCR0__GFIE___S                                                 2
#define   USB_OTG_HS_VMIDMT_SCR0__CLIENTPD___M                                             0x00000001
#define   USB_OTG_HS_VMIDMT_SCR0__CLIENTPD___S                                             0
#define   USB_OTG_HS_VMIDMT_SCR0___M                                                       0x3FFFFFFF
#define   USB_OTG_HS_VMIDMT_SCR0___S                                                       0

#define USB_OTG_HS_VMIDMT_SCR1                                                           (0x00000004)
#define   USB_OTG_HS_VMIDMT_SCR1___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SCR1___POR                                                     0x00001F00
#define   USB_OTG_HS_VMIDMT_SCR1__GASRAE___M                                               0x01000000
#define   USB_OTG_HS_VMIDMT_SCR1__GASRAE___S                                               24
#define   USB_OTG_HS_VMIDMT_SCR1__NSNUMSMRGO___M                                           0x00001F00
#define   USB_OTG_HS_VMIDMT_SCR1__NSNUMSMRGO___S                                           8
#define   USB_OTG_HS_VMIDMT_SCR1___M                                                       0x01FFFF00
#define   USB_OTG_HS_VMIDMT_SCR1___S                                                       8

#define USB_OTG_HS_VMIDMT_SCR2                                                           (0x00000008)
#define   USB_OTG_HS_VMIDMT_SCR2___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SCR2___POR                                                     0x00000000
#define   USB_OTG_HS_VMIDMT_SCR2__BPVMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_SCR2__BPVMID___S                                               0
#define   USB_OTG_HS_VMIDMT_SCR2___M                                                       0x0000001F
#define   USB_OTG_HS_VMIDMT_SCR2___S                                                       0

#define USB_OTG_HS_VMIDMT_SACR                                                           (0x00000010)
#define   USB_OTG_HS_VMIDMT_SACR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SACR___POR                                                     0x00000000
#define   USB_OTG_HS_VMIDMT_SACR__BPRCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_SACR__BPRCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_SACR__BPRCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_SACR__BPRCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_SACR__BPRCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_SACR__BPRCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_SACR__BPREQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_SACR__BPREQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_SACR__BPREQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_SACR__BPREQPRIORITY___S                                        0
#define   USB_OTG_HS_VMIDMT_SACR___M                                                       0x7FFFFFFF
#define   USB_OTG_HS_VMIDMT_SACR___S                                                       0

#define USB_OTG_HS_VMIDMT_SIDR0                                                          (0x00000020)
#define   USB_OTG_HS_VMIDMT_SIDR0___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SIDR0___POR                                                    0x88000A11
#define   USB_OTG_HS_VMIDMT_SIDR0__SES___M                                                 0x80000000
#define   USB_OTG_HS_VMIDMT_SIDR0__SES___S                                                 31
#define   USB_OTG_HS_VMIDMT_SIDR0__SMS___M                                                 0x08000000
#define   USB_OTG_HS_VMIDMT_SIDR0__SMS___S                                                 27
#define   USB_OTG_HS_VMIDMT_SIDR0__NUMSIDB___M                                             0x00001E00
#define   USB_OTG_HS_VMIDMT_SIDR0__NUMSIDB___S                                             9
#define   USB_OTG_HS_VMIDMT_SIDR0__NUMSMRG___M                                             0x000000FF
#define   USB_OTG_HS_VMIDMT_SIDR0__NUMSMRG___S                                             0
#define   USB_OTG_HS_VMIDMT_SIDR0___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SIDR0___S                                                      0

#define USB_OTG_HS_VMIDMT_SIDR1                                                          (0x00000024)
#define   USB_OTG_HS_VMIDMT_SIDR1___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SIDR1___POR                                                    0x00009500
#define   USB_OTG_HS_VMIDMT_SIDR1__SMCD___M                                                0x00008000
#define   USB_OTG_HS_VMIDMT_SIDR1__SMCD___S                                                15
#define   USB_OTG_HS_VMIDMT_SIDR1__SSDTP___M                                               0x00001000
#define   USB_OTG_HS_VMIDMT_SIDR1__SSDTP___S                                               12
#define   USB_OTG_HS_VMIDMT_SIDR1__NUMSSDNDX___M                                           0x00000F00
#define   USB_OTG_HS_VMIDMT_SIDR1__NUMSSDNDX___S                                           8
#define   USB_OTG_HS_VMIDMT_SIDR1___M                                                      0x0000FF00
#define   USB_OTG_HS_VMIDMT_SIDR1___S                                                      8

#define USB_OTG_HS_VMIDMT_SIDR2                                                          (0x00000028)
#define   USB_OTG_HS_VMIDMT_SIDR2___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SIDR2___POR                                                    0x00000000
#define   USB_OTG_HS_VMIDMT_SIDR2__OAS___M                                                 0x000000F0
#define   USB_OTG_HS_VMIDMT_SIDR2__OAS___S                                                 4
#define   USB_OTG_HS_VMIDMT_SIDR2__IAS___M                                                 0x0000000F
#define   USB_OTG_HS_VMIDMT_SIDR2__IAS___S                                                 0
#define   USB_OTG_HS_VMIDMT_SIDR2___M                                                      0x000000FF
#define   USB_OTG_HS_VMIDMT_SIDR2___S                                                      0

#define USB_OTG_HS_VMIDMT_SIDR4                                                          (0x00000030)
#define   USB_OTG_HS_VMIDMT_SIDR4___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SIDR4___POR                                                    0x10000000
#define   USB_OTG_HS_VMIDMT_SIDR4__MAJOR___M                                               0xF0000000
#define   USB_OTG_HS_VMIDMT_SIDR4__MAJOR___S                                               28
#define   USB_OTG_HS_VMIDMT_SIDR4__MINOR___M                                               0x0FFF0000
#define   USB_OTG_HS_VMIDMT_SIDR4__MINOR___S                                               16
#define   USB_OTG_HS_VMIDMT_SIDR4__STEP___M                                                0x0000FFFF
#define   USB_OTG_HS_VMIDMT_SIDR4__STEP___S                                                0
#define   USB_OTG_HS_VMIDMT_SIDR4___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SIDR4___S                                                      0

#define USB_OTG_HS_VMIDMT_SIDR5                                                          (0x00000034)
#define   USB_OTG_HS_VMIDMT_SIDR5___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SIDR5___POR                                                    0x0011021F
#define   USB_OTG_HS_VMIDMT_SIDR5__NUMMSDRB___M                                            0x00FF0000
#define   USB_OTG_HS_VMIDMT_SIDR5__NUMMSDRB___S                                            16
#define   USB_OTG_HS_VMIDMT_SIDR5__MSAE___M                                                0x00000200
#define   USB_OTG_HS_VMIDMT_SIDR5__MSAE___S                                                9
#define   USB_OTG_HS_VMIDMT_SIDR5__QRIBE___M                                               0x00000100
#define   USB_OTG_HS_VMIDMT_SIDR5__QRIBE___S                                               8
#define   USB_OTG_HS_VMIDMT_SIDR5__NVMID___M                                               0x000000FF
#define   USB_OTG_HS_VMIDMT_SIDR5__NVMID___S                                               0
#define   USB_OTG_HS_VMIDMT_SIDR5___M                                                      0x00FFFFFF
#define   USB_OTG_HS_VMIDMT_SIDR5___S                                                      0

#define USB_OTG_HS_VMIDMT_SIDR7                                                          (0x0000003C)
#define   USB_OTG_HS_VMIDMT_SIDR7___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SIDR7___POR                                                    0x00000010
#define   USB_OTG_HS_VMIDMT_SIDR7__MAJOR___M                                               0x000000F0
#define   USB_OTG_HS_VMIDMT_SIDR7__MAJOR___S                                               4
#define   USB_OTG_HS_VMIDMT_SIDR7__MINOR___M                                               0x0000000F
#define   USB_OTG_HS_VMIDMT_SIDR7__MINOR___S                                               0
#define   USB_OTG_HS_VMIDMT_SIDR7___M                                                      0x000000FF
#define   USB_OTG_HS_VMIDMT_SIDR7___S                                                      0

#define USB_OTG_HS_VMIDMT_SGFAR0                                                         (0x00000040)
#define   USB_OTG_HS_VMIDMT_SGFAR0___RWC                                                   QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SGFAR0___POR                                                   0x00000000
#define   USB_OTG_HS_VMIDMT_SGFAR0__SGFEA0___M                                             0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SGFAR0__SGFEA0___S                                             0
#define   USB_OTG_HS_VMIDMT_SGFAR0___M                                                     0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SGFAR0___S                                                     0

#define USB_OTG_HS_VMIDMT_SGFSR                                                          (0x00000048)
#define   USB_OTG_HS_VMIDMT_SGFSR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SGFSR___POR                                                    0x00000000
#define   USB_OTG_HS_VMIDMT_SGFSR__MULTI_CLIENT___M                                        0x80000000
#define   USB_OTG_HS_VMIDMT_SGFSR__MULTI_CLIENT___S                                        31
#define   USB_OTG_HS_VMIDMT_SGFSR__MULTI_CFG___M                                           0x40000000
#define   USB_OTG_HS_VMIDMT_SGFSR__MULTI_CFG___S                                           30
#define   USB_OTG_HS_VMIDMT_SGFSR__CAF___M                                                 0x00000020
#define   USB_OTG_HS_VMIDMT_SGFSR__CAF___S                                                 5
#define   USB_OTG_HS_VMIDMT_SGFSR__SMCF___M                                                0x00000004
#define   USB_OTG_HS_VMIDMT_SGFSR__SMCF___S                                                2
#define   USB_OTG_HS_VMIDMT_SGFSR__USF___M                                                 0x00000002
#define   USB_OTG_HS_VMIDMT_SGFSR__USF___S                                                 1
#define   USB_OTG_HS_VMIDMT_SGFSR___M                                                      0xFFFFFFFE
#define   USB_OTG_HS_VMIDMT_SGFSR___S                                                      1

#define USB_OTG_HS_VMIDMT_SGFSRRESTORE                                                   (0x0000004C)
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE___RWC                                             QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE___POR                                             0x00000000
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__MULTI_CLIENT___M                                 0x80000000
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__MULTI_CLIENT___S                                 31
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__MULTI_CFG___M                                    0x40000000
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__MULTI_CFG___S                                    30
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__CAF___M                                          0x00000020
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__CAF___S                                          5
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__SMCF___M                                         0x00000004
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__SMCF___S                                         2
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__USF___M                                          0x00000002
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE__USF___S                                          1
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE___M                                               0xFFFFFFFE
#define   USB_OTG_HS_VMIDMT_SGFSRRESTORE___S                                               1

#define USB_OTG_HS_VMIDMT_SGFSYNDR0                                                      (0x00000050)
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0___POR                                                0x00000000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__MSSSELFAUTH___M                                     0x00000100
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__MSSSELFAUTH___S                                     8
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__NSATTR___M                                          0x00000020
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__NSATTR___S                                          5
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__NSSTATE___M                                         0x00000010
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__NSSTATE___S                                         4
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__WNR___M                                             0x00000002
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0__WNR___S                                             1
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0___M                                                  0x000001FE
#define   USB_OTG_HS_VMIDMT_SGFSYNDR0___S                                                  1

#define USB_OTG_HS_VMIDMT_SGFSYNDR1                                                      (0x00000054)
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1___POR                                                0x00000000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1__MSDINDEX___M                                        0x1F000000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1__MSDINDEX___S                                        24
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1__SSDINDEX___M                                        0x001F0000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1__SSDINDEX___S                                        16
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1__STREAMINDEX___M                                     0x0000001F
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1__STREAMINDEX___S                                     0
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1___M                                                  0x1FFFFFFF
#define   USB_OTG_HS_VMIDMT_SGFSYNDR1___S                                                  0

#define USB_OTG_HS_VMIDMT_SGFSYNDR2                                                      (0x00000058)
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2___RWC                                                QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2___POR                                                0x00000000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__ATID___M                                            0x3F000000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__ATID___S                                            24
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__AVMID___M                                           0x001F0000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__AVMID___S                                           16
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__ABID___M                                            0x0000E000
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__ABID___S                                            13
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__APID___M                                            0x00001F00
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__APID___S                                            8
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__AMID___M                                            0x000000FF
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2__AMID___S                                            0
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2___M                                                  0x3FFFFFFF
#define   USB_OTG_HS_VMIDMT_SGFSYNDR2___S                                                  0

#define USB_OTG_HS_VMIDMT_VMIDMTSCR0                                                     (0x00000090)
#define   USB_OTG_HS_VMIDMT_VMIDMTSCR0___RWC                                               QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_VMIDMTSCR0___POR                                               0x00000001
#define   USB_OTG_HS_VMIDMT_VMIDMTSCR0__CLKONOFFE___M                                      0x00000001
#define   USB_OTG_HS_VMIDMT_VMIDMTSCR0__CLKONOFFE___S                                      0
#define   USB_OTG_HS_VMIDMT_VMIDMTSCR0___M                                                 0x00000001
#define   USB_OTG_HS_VMIDMT_VMIDMTSCR0___S                                                 0

#define USB_OTG_HS_VMIDMT_CR0                                                            (0x00000000)
#define   USB_OTG_HS_VMIDMT_CR0___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_CR0___POR                                                      0x00000111
#define   USB_OTG_HS_VMIDMT_CR0__WACFG___M                                                 0x0C000000
#define   USB_OTG_HS_VMIDMT_CR0__WACFG___S                                                 26
#define   USB_OTG_HS_VMIDMT_CR0__RACFG___M                                                 0x03000000
#define   USB_OTG_HS_VMIDMT_CR0__RACFG___S                                                 24
#define   USB_OTG_HS_VMIDMT_CR0__SHCFG___M                                                 0x00C00000
#define   USB_OTG_HS_VMIDMT_CR0__SHCFG___S                                                 22
#define   USB_OTG_HS_VMIDMT_CR0__SMCFCFG___M                                               0x00200000
#define   USB_OTG_HS_VMIDMT_CR0__SMCFCFG___S                                               21
#define   USB_OTG_HS_VMIDMT_CR0__MTCFG___M                                                 0x00100000
#define   USB_OTG_HS_VMIDMT_CR0__MTCFG___S                                                 20
#define   USB_OTG_HS_VMIDMT_CR0__MEMATTR___M                                               0x00070000
#define   USB_OTG_HS_VMIDMT_CR0__MEMATTR___S                                               16
#define   USB_OTG_HS_VMIDMT_CR0__VMIDPNE___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_CR0__VMIDPNE___S                                               11
#define   USB_OTG_HS_VMIDMT_CR0__USFCFG___M                                                0x00000400
#define   USB_OTG_HS_VMIDMT_CR0__USFCFG___S                                                10
#define   USB_OTG_HS_VMIDMT_CR0__GSE___M                                                   0x00000200
#define   USB_OTG_HS_VMIDMT_CR0__GSE___S                                                   9
#define   USB_OTG_HS_VMIDMT_CR0__STALLD___M                                                0x00000100
#define   USB_OTG_HS_VMIDMT_CR0__STALLD___S                                                8
#define   USB_OTG_HS_VMIDMT_CR0__TRANSIENTCFG___M                                          0x000000C0
#define   USB_OTG_HS_VMIDMT_CR0__TRANSIENTCFG___S                                          6
#define   USB_OTG_HS_VMIDMT_CR0__GCFGFIE___M                                               0x00000020
#define   USB_OTG_HS_VMIDMT_CR0__GCFGFIE___S                                               5
#define   USB_OTG_HS_VMIDMT_CR0__GCFGERE___M                                               0x00000010
#define   USB_OTG_HS_VMIDMT_CR0__GCFGERE___S                                               4
#define   USB_OTG_HS_VMIDMT_CR0__GFIE___M                                                  0x00000004
#define   USB_OTG_HS_VMIDMT_CR0__GFIE___S                                                  2
#define   USB_OTG_HS_VMIDMT_CR0__CLIENTPD___M                                              0x00000001
#define   USB_OTG_HS_VMIDMT_CR0__CLIENTPD___S                                              0
#define   USB_OTG_HS_VMIDMT_CR0___M                                                        0x0FFFFFFF
#define   USB_OTG_HS_VMIDMT_CR0___S                                                        0

#define USB_OTG_HS_VMIDMT_CR2                                                            (0x00000008)
#define   USB_OTG_HS_VMIDMT_CR2___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_CR2___POR                                                      0x00000000
#define   USB_OTG_HS_VMIDMT_CR2__BPVMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_CR2__BPVMID___S                                                0
#define   USB_OTG_HS_VMIDMT_CR2___M                                                        0x0000001F
#define   USB_OTG_HS_VMIDMT_CR2___S                                                        0

#define USB_OTG_HS_VMIDMT_ACR                                                            (0x00000010)
#define   USB_OTG_HS_VMIDMT_ACR___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_ACR___POR                                                      0x00000000
#define   USB_OTG_HS_VMIDMT_ACR__BPRCNSH___M                                               0x40000000
#define   USB_OTG_HS_VMIDMT_ACR__BPRCNSH___S                                               30
#define   USB_OTG_HS_VMIDMT_ACR__BPRCISH___M                                               0x20000000
#define   USB_OTG_HS_VMIDMT_ACR__BPRCISH___S                                               29
#define   USB_OTG_HS_VMIDMT_ACR__BPRCOSH___M                                               0x10000000
#define   USB_OTG_HS_VMIDMT_ACR__BPRCOSH___S                                               28
#define   USB_OTG_HS_VMIDMT_ACR__BPREQPRIORITYCFG___M                                      0x00000010
#define   USB_OTG_HS_VMIDMT_ACR__BPREQPRIORITYCFG___S                                      4
#define   USB_OTG_HS_VMIDMT_ACR__BPREQPRIORITY___M                                         0x00000003
#define   USB_OTG_HS_VMIDMT_ACR__BPREQPRIORITY___S                                         0
#define   USB_OTG_HS_VMIDMT_ACR___M                                                        0x7FFFFFFF
#define   USB_OTG_HS_VMIDMT_ACR___S                                                        0

#define USB_OTG_HS_VMIDMT_IDR0                                                           (0x00000020)
#define   USB_OTG_HS_VMIDMT_IDR0___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_IDR0___POR                                                     0x08000A11
#define   USB_OTG_HS_VMIDMT_IDR0__SMS___M                                                  0x08000000
#define   USB_OTG_HS_VMIDMT_IDR0__SMS___S                                                  27
#define   USB_OTG_HS_VMIDMT_IDR0__NUMSIDB___M                                              0x00001E00
#define   USB_OTG_HS_VMIDMT_IDR0__NUMSIDB___S                                              9
#define   USB_OTG_HS_VMIDMT_IDR0__NUMSMRG___M                                              0x000000FF
#define   USB_OTG_HS_VMIDMT_IDR0__NUMSMRG___S                                              0
#define   USB_OTG_HS_VMIDMT_IDR0___M                                                       0x0FFFFFFF
#define   USB_OTG_HS_VMIDMT_IDR0___S                                                       0

#define USB_OTG_HS_VMIDMT_IDR1                                                           (0x00000024)
#define   USB_OTG_HS_VMIDMT_IDR1___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_IDR1___POR                                                     0x00008000
#define   USB_OTG_HS_VMIDMT_IDR1__SMCD___M                                                 0x00008000
#define   USB_OTG_HS_VMIDMT_IDR1__SMCD___S                                                 15
#define   USB_OTG_HS_VMIDMT_IDR1__SSDTP___M                                                0x00001000
#define   USB_OTG_HS_VMIDMT_IDR1__SSDTP___S                                                12
#define   USB_OTG_HS_VMIDMT_IDR1__NUMSSDNDX___M                                            0x00000F00
#define   USB_OTG_HS_VMIDMT_IDR1__NUMSSDNDX___S                                            8
#define   USB_OTG_HS_VMIDMT_IDR1___M                                                       0x0000FF00
#define   USB_OTG_HS_VMIDMT_IDR1___S                                                       8

#define USB_OTG_HS_VMIDMT_IDR2                                                           (0x00000028)
#define   USB_OTG_HS_VMIDMT_IDR2___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_IDR2___POR                                                     0x00000000
#define   USB_OTG_HS_VMIDMT_IDR2__OAS___M                                                  0x000000F0
#define   USB_OTG_HS_VMIDMT_IDR2__OAS___S                                                  4
#define   USB_OTG_HS_VMIDMT_IDR2__IAS___M                                                  0x0000000F
#define   USB_OTG_HS_VMIDMT_IDR2__IAS___S                                                  0
#define   USB_OTG_HS_VMIDMT_IDR2___M                                                       0x000000FF
#define   USB_OTG_HS_VMIDMT_IDR2___S                                                       0

#define USB_OTG_HS_VMIDMT_IDR4                                                           (0x00000030)
#define   USB_OTG_HS_VMIDMT_IDR4___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_IDR4___POR                                                     0x10000000
#define   USB_OTG_HS_VMIDMT_IDR4__MAJOR___M                                                0xF0000000
#define   USB_OTG_HS_VMIDMT_IDR4__MAJOR___S                                                28
#define   USB_OTG_HS_VMIDMT_IDR4__MINOR___M                                                0x0FFF0000
#define   USB_OTG_HS_VMIDMT_IDR4__MINOR___S                                                16
#define   USB_OTG_HS_VMIDMT_IDR4__STEP___M                                                 0x0000FFFF
#define   USB_OTG_HS_VMIDMT_IDR4__STEP___S                                                 0
#define   USB_OTG_HS_VMIDMT_IDR4___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_IDR4___S                                                       0

#define USB_OTG_HS_VMIDMT_IDR5                                                           (0x00000034)
#define   USB_OTG_HS_VMIDMT_IDR5___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_IDR5___POR                                                     0x0011021F
#define   USB_OTG_HS_VMIDMT_IDR5__NUMMSDRB___M                                             0x00FF0000
#define   USB_OTG_HS_VMIDMT_IDR5__NUMMSDRB___S                                             16
#define   USB_OTG_HS_VMIDMT_IDR5__MSAE___M                                                 0x00000200
#define   USB_OTG_HS_VMIDMT_IDR5__MSAE___S                                                 9
#define   USB_OTG_HS_VMIDMT_IDR5__QRIBE___M                                                0x00000100
#define   USB_OTG_HS_VMIDMT_IDR5__QRIBE___S                                                8
#define   USB_OTG_HS_VMIDMT_IDR5__NVMID___M                                                0x000000FF
#define   USB_OTG_HS_VMIDMT_IDR5__NVMID___S                                                0
#define   USB_OTG_HS_VMIDMT_IDR5___M                                                       0x00FFFFFF
#define   USB_OTG_HS_VMIDMT_IDR5___S                                                       0

#define USB_OTG_HS_VMIDMT_IDR7                                                           (0x0000003C)
#define   USB_OTG_HS_VMIDMT_IDR7___RWC                                                     QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_IDR7___POR                                                     0x00000010
#define   USB_OTG_HS_VMIDMT_IDR7__MAJOR___M                                                0x000000F0
#define   USB_OTG_HS_VMIDMT_IDR7__MAJOR___S                                                4
#define   USB_OTG_HS_VMIDMT_IDR7__MINOR___M                                                0x0000000F
#define   USB_OTG_HS_VMIDMT_IDR7__MINOR___S                                                0
#define   USB_OTG_HS_VMIDMT_IDR7___M                                                       0x000000FF
#define   USB_OTG_HS_VMIDMT_IDR7___S                                                       0

#define USB_OTG_HS_VMIDMT_GFAR0                                                          (0x00000040)
#define   USB_OTG_HS_VMIDMT_GFAR0___RWC                                                    QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_GFAR0___POR                                                    0x00000000
#define   USB_OTG_HS_VMIDMT_GFAR0__GFEA0___M                                               0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_GFAR0__GFEA0___S                                               0
#define   USB_OTG_HS_VMIDMT_GFAR0___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_GFAR0___S                                                      0

#define USB_OTG_HS_VMIDMT_GFSR                                                           (0x00000048)
#define   USB_OTG_HS_VMIDMT_GFSR___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_GFSR___POR                                                     0x00000000
#define   USB_OTG_HS_VMIDMT_GFSR__MULTI_CLIENT___M                                         0x80000000
#define   USB_OTG_HS_VMIDMT_GFSR__MULTI_CLIENT___S                                         31
#define   USB_OTG_HS_VMIDMT_GFSR__MULTI_CFG___M                                            0x40000000
#define   USB_OTG_HS_VMIDMT_GFSR__MULTI_CFG___S                                            30
#define   USB_OTG_HS_VMIDMT_GFSR__PF___M                                                   0x00000080
#define   USB_OTG_HS_VMIDMT_GFSR__PF___S                                                   7
#define   USB_OTG_HS_VMIDMT_GFSR__CAF___M                                                  0x00000020
#define   USB_OTG_HS_VMIDMT_GFSR__CAF___S                                                  5
#define   USB_OTG_HS_VMIDMT_GFSR__SMCF___M                                                 0x00000004
#define   USB_OTG_HS_VMIDMT_GFSR__SMCF___S                                                 2
#define   USB_OTG_HS_VMIDMT_GFSR__USF___M                                                  0x00000002
#define   USB_OTG_HS_VMIDMT_GFSR__USF___S                                                  1
#define   USB_OTG_HS_VMIDMT_GFSR___M                                                       0xFFFFFFFE
#define   USB_OTG_HS_VMIDMT_GFSR___S                                                       1

#define USB_OTG_HS_VMIDMT_GFSRRESTORE                                                    (0x0000004C)
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE___POR                                              0x00000000
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__MULTI_CLIENT___M                                  0x80000000
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__MULTI_CLIENT___S                                  31
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__MULTI_CFG___M                                     0x40000000
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__MULTI_CFG___S                                     30
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__PF___M                                            0x00000080
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__PF___S                                            7
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__CAF___M                                           0x00000020
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__CAF___S                                           5
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__SMCF___M                                          0x00000004
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__SMCF___S                                          2
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__USF___M                                           0x00000002
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE__USF___S                                           1
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE___M                                                0xFFFFFFFE
#define   USB_OTG_HS_VMIDMT_GFSRRESTORE___S                                                1

#define USB_OTG_HS_VMIDMT_GFSYNDR0                                                       (0x00000050)
#define   USB_OTG_HS_VMIDMT_GFSYNDR0___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_GFSYNDR0___POR                                                 0x00000000
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__MSSSELFAUTH___M                                      0x00000100
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__MSSSELFAUTH___S                                      8
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__NSATTR___M                                           0x00000020
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__NSATTR___S                                           5
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__NSSTATE___M                                          0x00000010
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__NSSTATE___S                                          4
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__WNR___M                                              0x00000002
#define   USB_OTG_HS_VMIDMT_GFSYNDR0__WNR___S                                              1
#define   USB_OTG_HS_VMIDMT_GFSYNDR0___M                                                   0x000001FE
#define   USB_OTG_HS_VMIDMT_GFSYNDR0___S                                                   1

#define USB_OTG_HS_VMIDMT_GFSYNDR1                                                       (0x00000054)
#define   USB_OTG_HS_VMIDMT_GFSYNDR1___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_GFSYNDR1___POR                                                 0x00000000
#define   USB_OTG_HS_VMIDMT_GFSYNDR1__MSDINDEX___M                                         0x1F000000
#define   USB_OTG_HS_VMIDMT_GFSYNDR1__MSDINDEX___S                                         24
#define   USB_OTG_HS_VMIDMT_GFSYNDR1__SSDINDEX___M                                         0x001F0000
#define   USB_OTG_HS_VMIDMT_GFSYNDR1__SSDINDEX___S                                         16
#define   USB_OTG_HS_VMIDMT_GFSYNDR1__STREAMINDEX___M                                      0x0000001F
#define   USB_OTG_HS_VMIDMT_GFSYNDR1__STREAMINDEX___S                                      0
#define   USB_OTG_HS_VMIDMT_GFSYNDR1___M                                                   0x1FFFFFFF
#define   USB_OTG_HS_VMIDMT_GFSYNDR1___S                                                   0

#define USB_OTG_HS_VMIDMT_GFSYNDR2                                                       (0x00000058)
#define   USB_OTG_HS_VMIDMT_GFSYNDR2___RWC                                                 QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_GFSYNDR2___POR                                                 0x00000000
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__ATID___M                                             0x3F000000
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__ATID___S                                             24
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__AVMID___M                                            0x001F0000
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__AVMID___S                                            16
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__ABID___M                                             0x0000E000
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__ABID___S                                             13
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__APID___M                                             0x00001F00
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__APID___S                                             8
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__AMID___M                                             0x000000FF
#define   USB_OTG_HS_VMIDMT_GFSYNDR2__AMID___S                                             0
#define   USB_OTG_HS_VMIDMT_GFSYNDR2___M                                                   0x3FFFFFFF
#define   USB_OTG_HS_VMIDMT_GFSYNDR2___S                                                   0

#define USB_OTG_HS_VMIDMT_VMIDMTCR0                                                      (0x00000090)
#define   USB_OTG_HS_VMIDMT_VMIDMTCR0___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_VMIDMTCR0___POR                                                0x00000001
#define   USB_OTG_HS_VMIDMT_VMIDMTCR0__CLKONOFFE___M                                       0x00000001
#define   USB_OTG_HS_VMIDMT_VMIDMTCR0__CLKONOFFE___S                                       0
#define   USB_OTG_HS_VMIDMT_VMIDMTCR0___M                                                  0x00000001
#define   USB_OTG_HS_VMIDMT_VMIDMTCR0___S                                                  0

#define USB_OTG_HS_VMIDMT_VMIDMTACR                                                      (0x0000009C)
#define   USB_OTG_HS_VMIDMT_VMIDMTACR___RWC                                                QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_VMIDMTACR___POR                                                0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_VMIDMTACR__RWE___M                                             0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_VMIDMTACR__RWE___S                                             0
#define   USB_OTG_HS_VMIDMT_VMIDMTACR___M                                                  0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_VMIDMTACR___S                                                  0

#define USB_OTG_HS_VMIDMT_NSCR0                                                          (0x00000400)
#define   USB_OTG_HS_VMIDMT_NSCR0___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_NSCR0___POR                                                    0x00000111
#define   USB_OTG_HS_VMIDMT_NSCR0__WACFG___M                                               0x0C000000
#define   USB_OTG_HS_VMIDMT_NSCR0__WACFG___S                                               26
#define   USB_OTG_HS_VMIDMT_NSCR0__RACFG___M                                               0x03000000
#define   USB_OTG_HS_VMIDMT_NSCR0__RACFG___S                                               24
#define   USB_OTG_HS_VMIDMT_NSCR0__SHCFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_NSCR0__SHCFG___S                                               22
#define   USB_OTG_HS_VMIDMT_NSCR0__SMCFCFG___M                                             0x00200000
#define   USB_OTG_HS_VMIDMT_NSCR0__SMCFCFG___S                                             21
#define   USB_OTG_HS_VMIDMT_NSCR0__MTCFG___M                                               0x00100000
#define   USB_OTG_HS_VMIDMT_NSCR0__MTCFG___S                                               20
#define   USB_OTG_HS_VMIDMT_NSCR0__MEMATTR___M                                             0x00070000
#define   USB_OTG_HS_VMIDMT_NSCR0__MEMATTR___S                                             16
#define   USB_OTG_HS_VMIDMT_NSCR0__VMIDPNE___M                                             0x00000800
#define   USB_OTG_HS_VMIDMT_NSCR0__VMIDPNE___S                                             11
#define   USB_OTG_HS_VMIDMT_NSCR0__USFCFG___M                                              0x00000400
#define   USB_OTG_HS_VMIDMT_NSCR0__USFCFG___S                                              10
#define   USB_OTG_HS_VMIDMT_NSCR0__GSE___M                                                 0x00000200
#define   USB_OTG_HS_VMIDMT_NSCR0__GSE___S                                                 9
#define   USB_OTG_HS_VMIDMT_NSCR0__STALLD___M                                              0x00000100
#define   USB_OTG_HS_VMIDMT_NSCR0__STALLD___S                                              8
#define   USB_OTG_HS_VMIDMT_NSCR0__TRANSIENTCFG___M                                        0x000000C0
#define   USB_OTG_HS_VMIDMT_NSCR0__TRANSIENTCFG___S                                        6
#define   USB_OTG_HS_VMIDMT_NSCR0__GCFGFIE___M                                             0x00000020
#define   USB_OTG_HS_VMIDMT_NSCR0__GCFGFIE___S                                             5
#define   USB_OTG_HS_VMIDMT_NSCR0__GCFGERE___M                                             0x00000010
#define   USB_OTG_HS_VMIDMT_NSCR0__GCFGERE___S                                             4
#define   USB_OTG_HS_VMIDMT_NSCR0__GFIE___M                                                0x00000004
#define   USB_OTG_HS_VMIDMT_NSCR0__GFIE___S                                                2
#define   USB_OTG_HS_VMIDMT_NSCR0__CLIENTPD___M                                            0x00000001
#define   USB_OTG_HS_VMIDMT_NSCR0__CLIENTPD___S                                            0
#define   USB_OTG_HS_VMIDMT_NSCR0___M                                                      0x0FFFFFFF
#define   USB_OTG_HS_VMIDMT_NSCR0___S                                                      0

#define USB_OTG_HS_VMIDMT_NSCR2                                                          (0x00000408)
#define   USB_OTG_HS_VMIDMT_NSCR2___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_NSCR2___POR                                                    0x00000000
#define   USB_OTG_HS_VMIDMT_NSCR2__BPVMID___M                                              0x0000001F
#define   USB_OTG_HS_VMIDMT_NSCR2__BPVMID___S                                              0
#define   USB_OTG_HS_VMIDMT_NSCR2___M                                                      0x0000001F
#define   USB_OTG_HS_VMIDMT_NSCR2___S                                                      0

#define USB_OTG_HS_VMIDMT_NSACR                                                          (0x00000410)
#define   USB_OTG_HS_VMIDMT_NSACR___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_NSACR___POR                                                    0x00000000
#define   USB_OTG_HS_VMIDMT_NSACR__BPRCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_NSACR__BPRCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_NSACR__BPRCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_NSACR__BPRCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_NSACR__BPRCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_NSACR__BPRCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_NSACR__BPREQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_NSACR__BPREQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_NSACR__BPREQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_NSACR__BPREQPRIORITY___S                                       0
#define   USB_OTG_HS_VMIDMT_NSACR___M                                                      0x7FFFFFFF
#define   USB_OTG_HS_VMIDMT_NSACR___S                                                      0

#define USB_OTG_HS_VMIDMT_NSGFAR0                                                        (0x00000440)
#define   USB_OTG_HS_VMIDMT_NSGFAR0___RWC                                                  QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_NSGFAR0___POR                                                  0x00000000
#define   USB_OTG_HS_VMIDMT_NSGFAR0__GFEA0___M                                             0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_NSGFAR0__GFEA0___S                                             0
#define   USB_OTG_HS_VMIDMT_NSGFAR0___M                                                    0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_NSGFAR0___S                                                    0

#define USB_OTG_HS_VMIDMT_NSGFSR                                                         (0x00000448)
#define   USB_OTG_HS_VMIDMT_NSGFSR___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_NSGFSR___POR                                                   0x00000000
#define   USB_OTG_HS_VMIDMT_NSGFSR__MULTI_CLIENT___M                                       0x80000000
#define   USB_OTG_HS_VMIDMT_NSGFSR__MULTI_CLIENT___S                                       31
#define   USB_OTG_HS_VMIDMT_NSGFSR__MULTI_CFG___M                                          0x40000000
#define   USB_OTG_HS_VMIDMT_NSGFSR__MULTI_CFG___S                                          30
#define   USB_OTG_HS_VMIDMT_NSGFSR__PF___M                                                 0x00000080
#define   USB_OTG_HS_VMIDMT_NSGFSR__PF___S                                                 7
#define   USB_OTG_HS_VMIDMT_NSGFSR__CAF___M                                                0x00000020
#define   USB_OTG_HS_VMIDMT_NSGFSR__CAF___S                                                5
#define   USB_OTG_HS_VMIDMT_NSGFSR__SMCF___M                                               0x00000004
#define   USB_OTG_HS_VMIDMT_NSGFSR__SMCF___S                                               2
#define   USB_OTG_HS_VMIDMT_NSGFSR__USF___M                                                0x00000002
#define   USB_OTG_HS_VMIDMT_NSGFSR__USF___S                                                1
#define   USB_OTG_HS_VMIDMT_NSGFSR___M                                                     0xFFFFFFFE
#define   USB_OTG_HS_VMIDMT_NSGFSR___S                                                     1

#define USB_OTG_HS_VMIDMT_NSGFSRRESTORE                                                  (0x0000044C)
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE___RWC                                            QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE___POR                                            0x00000000
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__MULTI_CLIENT___M                                0x80000000
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__MULTI_CLIENT___S                                31
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__MULTI_CFG___M                                   0x40000000
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__MULTI_CFG___S                                   30
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__PF___M                                          0x00000080
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__PF___S                                          7
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__CAF___M                                         0x00000020
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__CAF___S                                         5
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__SMCF___M                                        0x00000004
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__SMCF___S                                        2
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__USF___M                                         0x00000002
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE__USF___S                                         1
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE___M                                              0xFFFFFFFE
#define   USB_OTG_HS_VMIDMT_NSGFSRRESTORE___S                                              1

#define USB_OTG_HS_VMIDMT_NSGFSYNDR0                                                     (0x00000450)
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0___RWC                                               QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0___POR                                               0x00000000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__MSSSELFAUTH___M                                    0x00000100
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__MSSSELFAUTH___S                                    8
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__NSATTR___M                                         0x00000020
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__NSATTR___S                                         5
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__NSSTATE___M                                        0x00000010
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__NSSTATE___S                                        4
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__WNR___M                                            0x00000002
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0__WNR___S                                            1
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0___M                                                 0x000001FE
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR0___S                                                 1

#define USB_OTG_HS_VMIDMT_NSGFSYNDR1                                                     (0x00000454)
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1___RWC                                               QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1___POR                                               0x00000000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1__MSDINDEX___M                                       0x1F000000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1__MSDINDEX___S                                       24
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1__SSDINDEX___M                                       0x001F0000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1__SSDINDEX___S                                       16
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1__STREAMINDEX___M                                    0x0000001F
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1__STREAMINDEX___S                                    0
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1___M                                                 0x1FFFFFFF
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR1___S                                                 0

#define USB_OTG_HS_VMIDMT_NSGFSYNDR2                                                     (0x00000458)
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2___RWC                                               QCSR_REG_RO
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2___POR                                               0x00000000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__ATID___M                                           0x3F000000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__ATID___S                                           24
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__AVMID___M                                          0x001F0000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__AVMID___S                                          16
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__ABID___M                                           0x0000E000
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__ABID___S                                           13
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__APID___M                                           0x00001F00
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__APID___S                                           8
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__AMID___M                                           0x000000FF
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2__AMID___S                                           0
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2___M                                                 0x3FFFFFFF
#define   USB_OTG_HS_VMIDMT_NSGFSYNDR2___S                                                 0

#define USB_OTG_HS_VMIDMT_NSVMIDMTCR0                                                    (0x00000490)
#define   USB_OTG_HS_VMIDMT_NSVMIDMTCR0___RWC                                              QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_NSVMIDMTCR0___POR                                              0x00000001
#define   USB_OTG_HS_VMIDMT_NSVMIDMTCR0__CLKONOFFE___M                                     0x00000001
#define   USB_OTG_HS_VMIDMT_NSVMIDMTCR0__CLKONOFFE___S                                     0
#define   USB_OTG_HS_VMIDMT_NSVMIDMTCR0___M                                                0x00000001
#define   USB_OTG_HS_VMIDMT_NSVMIDMTCR0___S                                                0

#define USB_OTG_HS_VMIDMT_SSDR0                                                          (0x00000080)
#define   USB_OTG_HS_VMIDMT_SSDR0___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SSDR0___POR                                                    0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SSDR0__RWE___M                                                 0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SSDR0__RWE___S                                                 0
#define   USB_OTG_HS_VMIDMT_SSDR0___M                                                      0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SSDR0___S                                                      0

#define USB_OTG_HS_VMIDMT_MSDR0                                                          (0x00000480)
#define   USB_OTG_HS_VMIDMT_MSDR0___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_MSDR0___POR                                                    0x00000000
#define   USB_OTG_HS_VMIDMT_MSDR0__RWE___M                                                 0x0001FFFF
#define   USB_OTG_HS_VMIDMT_MSDR0__RWE___S                                                 0
#define   USB_OTG_HS_VMIDMT_MSDR0___M                                                      0x0001FFFF
#define   USB_OTG_HS_VMIDMT_MSDR0___S                                                      0

#define USB_OTG_HS_VMIDMT_MCR                                                            (0x00000494)
#define   USB_OTG_HS_VMIDMT_MCR___RWC                                                      QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_MCR___POR                                                      0x00000004
#define   USB_OTG_HS_VMIDMT_MCR__CLKONOFFE___M                                             0x00000004
#define   USB_OTG_HS_VMIDMT_MCR__CLKONOFFE___S                                             2
#define   USB_OTG_HS_VMIDMT_MCR__BPMSACFG___M                                              0x00000002
#define   USB_OTG_HS_VMIDMT_MCR__BPMSACFG___S                                              1
#define   USB_OTG_HS_VMIDMT_MCR__BPSMSACFG___M                                             0x00000001
#define   USB_OTG_HS_VMIDMT_MCR__BPSMSACFG___S                                             0
#define   USB_OTG_HS_VMIDMT_MCR___M                                                        0x00000007
#define   USB_OTG_HS_VMIDMT_MCR___S                                                        0

#define USB_OTG_HS_VMIDMT_S2VRn(n)                                            (0x00000C00+0x4*(n))
#define   USB_OTG_HS_VMIDMT_S2VRn_nMIN                         0
#define   USB_OTG_HS_VMIDMT_S2VRn_nMAX                         16
#define   USB_OTG_HS_VMIDMT_S2VRn_ELEM                         17
#define   USB_OTG_HS_VMIDMT_S2VRn___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VRn___POR                                                    0x00010000
#define   USB_OTG_HS_VMIDMT_S2VRn__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VRn__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VRn__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VRn__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VRn__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VRn__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VRn__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VRn__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VRn__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VRn__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VRn__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VRn__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VRn__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VRn__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VRn__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VRn__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VRn__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VRn__VMID___S                                                0
#define   USB_OTG_HS_VMIDMT_S2VRn___M                                                      0x3FFFFFFF
#define   USB_OTG_HS_VMIDMT_S2VRn___S                                                      0
#define USB_OTG_HS_VMIDMT_S2VR0                                                          (0x00000C00)
#define   USB_OTG_HS_VMIDMT_S2VR0___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR0__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR0__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR0__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR0__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR0__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR0__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR0__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR0__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR0__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR0__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR0__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR0__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR0__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR0__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR0__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR0__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR0__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR0__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR1                                                          (0x00000C04)
#define   USB_OTG_HS_VMIDMT_S2VR1___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR1__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR1__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR1__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR1__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR1__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR1__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR1__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR1__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR1__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR1__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR1__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR1__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR1__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR1__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR1__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR1__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR1__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR1__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR2                                                          (0x00000C08)
#define   USB_OTG_HS_VMIDMT_S2VR2___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR2__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR2__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR2__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR2__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR2__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR2__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR2__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR2__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR2__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR2__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR2__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR2__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR2__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR2__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR2__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR2__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR2__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR2__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR3                                                          (0x00000C0C)
#define   USB_OTG_HS_VMIDMT_S2VR3___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR3__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR3__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR3__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR3__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR3__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR3__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR3__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR3__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR3__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR3__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR3__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR3__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR3__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR3__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR3__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR3__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR3__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR3__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR4                                                          (0x00000C10)
#define   USB_OTG_HS_VMIDMT_S2VR4___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR4__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR4__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR4__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR4__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR4__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR4__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR4__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR4__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR4__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR4__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR4__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR4__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR4__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR4__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR4__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR4__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR4__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR4__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR5                                                          (0x00000C14)
#define   USB_OTG_HS_VMIDMT_S2VR5___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR5__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR5__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR5__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR5__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR5__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR5__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR5__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR5__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR5__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR5__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR5__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR5__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR5__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR5__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR5__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR5__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR5__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR5__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR6                                                          (0x00000C18)
#define   USB_OTG_HS_VMIDMT_S2VR6___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR6__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR6__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR6__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR6__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR6__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR6__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR6__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR6__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR6__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR6__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR6__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR6__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR6__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR6__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR6__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR6__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR6__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR6__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR7                                                          (0x00000C1C)
#define   USB_OTG_HS_VMIDMT_S2VR7___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR7__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR7__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR7__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR7__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR7__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR7__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR7__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR7__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR7__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR7__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR7__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR7__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR7__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR7__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR7__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR7__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR7__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR7__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR8                                                          (0x00000C20)
#define   USB_OTG_HS_VMIDMT_S2VR8___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR8__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR8__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR8__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR8__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR8__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR8__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR8__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR8__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR8__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR8__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR8__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR8__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR8__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR8__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR8__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR8__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR8__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR8__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR9                                                          (0x00000C24)
#define   USB_OTG_HS_VMIDMT_S2VR9___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR9__TRANSIENTCFG___M                                        0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR9__TRANSIENTCFG___S                                        28
#define   USB_OTG_HS_VMIDMT_S2VR9__WACFG___M                                               0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR9__WACFG___S                                               22
#define   USB_OTG_HS_VMIDMT_S2VR9__RACFG___M                                               0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR9__RACFG___S                                               20
#define   USB_OTG_HS_VMIDMT_S2VR9__NSCFG___M                                               0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR9__NSCFG___S                                               18
#define   USB_OTG_HS_VMIDMT_S2VR9__TYPE___M                                                0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR9__TYPE___S                                                16
#define   USB_OTG_HS_VMIDMT_S2VR9__MEMATTR___M                                             0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR9__MEMATTR___S                                             12
#define   USB_OTG_HS_VMIDMT_S2VR9__MTCFG___M                                               0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR9__MTCFG___S                                               11
#define   USB_OTG_HS_VMIDMT_S2VR9__SHCFG___M                                               0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR9__SHCFG___S                                               8
#define   USB_OTG_HS_VMIDMT_S2VR9__VMID___M                                                0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR9__VMID___S                                                0
#define USB_OTG_HS_VMIDMT_S2VR10                                                         (0x00000C28)
#define   USB_OTG_HS_VMIDMT_S2VR10___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR10__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR10__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR10__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR10__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR10__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR10__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR10__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR10__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR10__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR10__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR10__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR10__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR10__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR10__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR10__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR10__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR10__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR10__VMID___S                                               0
#define USB_OTG_HS_VMIDMT_S2VR11                                                         (0x00000C2C)
#define   USB_OTG_HS_VMIDMT_S2VR11___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR11__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR11__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR11__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR11__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR11__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR11__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR11__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR11__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR11__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR11__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR11__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR11__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR11__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR11__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR11__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR11__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR11__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR11__VMID___S                                               0
#define USB_OTG_HS_VMIDMT_S2VR12                                                         (0x00000C30)
#define   USB_OTG_HS_VMIDMT_S2VR12___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR12__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR12__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR12__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR12__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR12__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR12__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR12__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR12__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR12__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR12__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR12__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR12__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR12__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR12__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR12__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR12__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR12__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR12__VMID___S                                               0
#define USB_OTG_HS_VMIDMT_S2VR13                                                         (0x00000C34)
#define   USB_OTG_HS_VMIDMT_S2VR13___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR13__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR13__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR13__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR13__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR13__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR13__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR13__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR13__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR13__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR13__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR13__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR13__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR13__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR13__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR13__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR13__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR13__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR13__VMID___S                                               0
#define USB_OTG_HS_VMIDMT_S2VR14                                                         (0x00000C38)
#define   USB_OTG_HS_VMIDMT_S2VR14___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR14__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR14__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR14__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR14__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR14__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR14__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR14__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR14__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR14__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR14__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR14__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR14__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR14__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR14__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR14__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR14__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR14__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR14__VMID___S                                               0
#define USB_OTG_HS_VMIDMT_S2VR15                                                         (0x00000C3C)
#define   USB_OTG_HS_VMIDMT_S2VR15___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR15__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR15__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR15__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR15__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR15__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR15__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR15__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR15__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR15__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR15__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR15__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR15__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR15__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR15__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR15__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR15__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR15__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR15__VMID___S                                               0
#define USB_OTG_HS_VMIDMT_S2VR16                                                         (0x00000C40)
#define   USB_OTG_HS_VMIDMT_S2VR16___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_S2VR16__TRANSIENTCFG___M                                       0x30000000
#define   USB_OTG_HS_VMIDMT_S2VR16__TRANSIENTCFG___S                                       28
#define   USB_OTG_HS_VMIDMT_S2VR16__WACFG___M                                              0x00C00000
#define   USB_OTG_HS_VMIDMT_S2VR16__WACFG___S                                              22
#define   USB_OTG_HS_VMIDMT_S2VR16__RACFG___M                                              0x00300000
#define   USB_OTG_HS_VMIDMT_S2VR16__RACFG___S                                              20
#define   USB_OTG_HS_VMIDMT_S2VR16__NSCFG___M                                              0x000C0000
#define   USB_OTG_HS_VMIDMT_S2VR16__NSCFG___S                                              18
#define   USB_OTG_HS_VMIDMT_S2VR16__TYPE___M                                               0x00030000
#define   USB_OTG_HS_VMIDMT_S2VR16__TYPE___S                                               16
#define   USB_OTG_HS_VMIDMT_S2VR16__MEMATTR___M                                            0x00007000
#define   USB_OTG_HS_VMIDMT_S2VR16__MEMATTR___S                                            12
#define   USB_OTG_HS_VMIDMT_S2VR16__MTCFG___M                                              0x00000800
#define   USB_OTG_HS_VMIDMT_S2VR16__MTCFG___S                                              11
#define   USB_OTG_HS_VMIDMT_S2VR16__SHCFG___M                                              0x00000300
#define   USB_OTG_HS_VMIDMT_S2VR16__SHCFG___S                                              8
#define   USB_OTG_HS_VMIDMT_S2VR16__VMID___M                                               0x0000001F
#define   USB_OTG_HS_VMIDMT_S2VR16__VMID___S                                               0

#define USB_OTG_HS_VMIDMT_AS2VRn(n)                                           (0x00000E00+0x4*(n))
#define   USB_OTG_HS_VMIDMT_AS2VRn_nMIN                        0
#define   USB_OTG_HS_VMIDMT_AS2VRn_nMAX                        16
#define   USB_OTG_HS_VMIDMT_AS2VRn_ELEM                        17
#define   USB_OTG_HS_VMIDMT_AS2VRn___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VRn___POR                                                   0x00000000
#define   USB_OTG_HS_VMIDMT_AS2VRn__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VRn__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VRn__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VRn__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VRn__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VRn__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VRn__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VRn__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VRn__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VRn__REQPRIORITY___S                                        0
#define   USB_OTG_HS_VMIDMT_AS2VRn___M                                                     0x7FFFFFFF
#define   USB_OTG_HS_VMIDMT_AS2VRn___S                                                     0
#define USB_OTG_HS_VMIDMT_AS2VR0                                                         (0x00000E00)
#define   USB_OTG_HS_VMIDMT_AS2VR0___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR0__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR0__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR0__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR0__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR0__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR0__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR0__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR0__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR0__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR0__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR1                                                         (0x00000E04)
#define   USB_OTG_HS_VMIDMT_AS2VR1___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR1__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR1__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR1__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR1__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR1__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR1__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR1__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR1__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR1__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR1__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR2                                                         (0x00000E08)
#define   USB_OTG_HS_VMIDMT_AS2VR2___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR2__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR2__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR2__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR2__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR2__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR2__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR2__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR2__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR2__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR2__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR3                                                         (0x00000E0C)
#define   USB_OTG_HS_VMIDMT_AS2VR3___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR3__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR3__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR3__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR3__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR3__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR3__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR3__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR3__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR3__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR3__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR4                                                         (0x00000E10)
#define   USB_OTG_HS_VMIDMT_AS2VR4___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR4__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR4__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR4__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR4__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR4__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR4__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR4__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR4__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR4__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR4__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR5                                                         (0x00000E14)
#define   USB_OTG_HS_VMIDMT_AS2VR5___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR5__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR5__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR5__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR5__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR5__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR5__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR5__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR5__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR5__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR5__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR6                                                         (0x00000E18)
#define   USB_OTG_HS_VMIDMT_AS2VR6___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR6__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR6__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR6__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR6__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR6__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR6__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR6__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR6__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR6__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR6__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR7                                                         (0x00000E1C)
#define   USB_OTG_HS_VMIDMT_AS2VR7___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR7__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR7__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR7__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR7__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR7__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR7__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR7__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR7__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR7__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR7__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR8                                                         (0x00000E20)
#define   USB_OTG_HS_VMIDMT_AS2VR8___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR8__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR8__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR8__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR8__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR8__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR8__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR8__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR8__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR8__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR8__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR9                                                         (0x00000E24)
#define   USB_OTG_HS_VMIDMT_AS2VR9___RWC                                                   QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR9__RCNSH___M                                              0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR9__RCNSH___S                                              30
#define   USB_OTG_HS_VMIDMT_AS2VR9__RCISH___M                                              0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR9__RCISH___S                                              29
#define   USB_OTG_HS_VMIDMT_AS2VR9__RCOSH___M                                              0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR9__RCOSH___S                                              28
#define   USB_OTG_HS_VMIDMT_AS2VR9__REQPRIORITYCFG___M                                     0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR9__REQPRIORITYCFG___S                                     4
#define   USB_OTG_HS_VMIDMT_AS2VR9__REQPRIORITY___M                                        0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR9__REQPRIORITY___S                                        0
#define USB_OTG_HS_VMIDMT_AS2VR10                                                        (0x00000E28)
#define   USB_OTG_HS_VMIDMT_AS2VR10___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR10__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR10__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR10__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR10__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR10__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR10__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR10__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR10__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR10__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR10__REQPRIORITY___S                                       0
#define USB_OTG_HS_VMIDMT_AS2VR11                                                        (0x00000E2C)
#define   USB_OTG_HS_VMIDMT_AS2VR11___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR11__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR11__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR11__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR11__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR11__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR11__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR11__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR11__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR11__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR11__REQPRIORITY___S                                       0
#define USB_OTG_HS_VMIDMT_AS2VR12                                                        (0x00000E30)
#define   USB_OTG_HS_VMIDMT_AS2VR12___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR12__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR12__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR12__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR12__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR12__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR12__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR12__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR12__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR12__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR12__REQPRIORITY___S                                       0
#define USB_OTG_HS_VMIDMT_AS2VR13                                                        (0x00000E34)
#define   USB_OTG_HS_VMIDMT_AS2VR13___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR13__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR13__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR13__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR13__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR13__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR13__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR13__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR13__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR13__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR13__REQPRIORITY___S                                       0
#define USB_OTG_HS_VMIDMT_AS2VR14                                                        (0x00000E38)
#define   USB_OTG_HS_VMIDMT_AS2VR14___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR14__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR14__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR14__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR14__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR14__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR14__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR14__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR14__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR14__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR14__REQPRIORITY___S                                       0
#define USB_OTG_HS_VMIDMT_AS2VR15                                                        (0x00000E3C)
#define   USB_OTG_HS_VMIDMT_AS2VR15___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR15__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR15__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR15__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR15__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR15__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR15__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR15__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR15__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR15__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR15__REQPRIORITY___S                                       0
#define USB_OTG_HS_VMIDMT_AS2VR16                                                        (0x00000E40)
#define   USB_OTG_HS_VMIDMT_AS2VR16___RWC                                                  QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_AS2VR16__RCNSH___M                                             0x40000000
#define   USB_OTG_HS_VMIDMT_AS2VR16__RCNSH___S                                             30
#define   USB_OTG_HS_VMIDMT_AS2VR16__RCISH___M                                             0x20000000
#define   USB_OTG_HS_VMIDMT_AS2VR16__RCISH___S                                             29
#define   USB_OTG_HS_VMIDMT_AS2VR16__RCOSH___M                                             0x10000000
#define   USB_OTG_HS_VMIDMT_AS2VR16__RCOSH___S                                             28
#define   USB_OTG_HS_VMIDMT_AS2VR16__REQPRIORITYCFG___M                                    0x00000010
#define   USB_OTG_HS_VMIDMT_AS2VR16__REQPRIORITYCFG___S                                    4
#define   USB_OTG_HS_VMIDMT_AS2VR16__REQPRIORITY___M                                       0x00000003
#define   USB_OTG_HS_VMIDMT_AS2VR16__REQPRIORITY___S                                       0

#define USB_OTG_HS_VMIDMT_SMRn(n)                                             (0x00000800+0x4*(n))
#define   USB_OTG_HS_VMIDMT_SMRn_nMIN                          0
#define   USB_OTG_HS_VMIDMT_SMRn_nMAX                          16
#define   USB_OTG_HS_VMIDMT_SMRn_ELEM                          17
#define   USB_OTG_HS_VMIDMT_SMRn___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMRn___POR                                                     0x00000000
#define   USB_OTG_HS_VMIDMT_SMRn__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMRn__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMRn__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMRn__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMRn__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMRn__ID___S                                                   0
#define   USB_OTG_HS_VMIDMT_SMRn___M                                                       0xFFFFFFFF
#define   USB_OTG_HS_VMIDMT_SMRn___S                                                       0
#define USB_OTG_HS_VMIDMT_SMR0                                                           (0x00000800)
#define   USB_OTG_HS_VMIDMT_SMR0___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR0__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR0__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR0__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR0__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR0__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR0__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR1                                                           (0x00000804)
#define   USB_OTG_HS_VMIDMT_SMR1___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR1__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR1__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR1__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR1__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR1__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR1__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR2                                                           (0x00000808)
#define   USB_OTG_HS_VMIDMT_SMR2___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR2__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR2__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR2__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR2__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR2__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR2__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR3                                                           (0x0000080C)
#define   USB_OTG_HS_VMIDMT_SMR3___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR3__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR3__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR3__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR3__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR3__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR3__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR4                                                           (0x00000810)
#define   USB_OTG_HS_VMIDMT_SMR4___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR4__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR4__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR4__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR4__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR4__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR4__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR5                                                           (0x00000814)
#define   USB_OTG_HS_VMIDMT_SMR5___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR5__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR5__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR5__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR5__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR5__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR5__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR6                                                           (0x00000818)
#define   USB_OTG_HS_VMIDMT_SMR6___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR6__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR6__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR6__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR6__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR6__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR6__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR7                                                           (0x0000081C)
#define   USB_OTG_HS_VMIDMT_SMR7___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR7__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR7__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR7__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR7__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR7__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR7__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR8                                                           (0x00000820)
#define   USB_OTG_HS_VMIDMT_SMR8___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR8__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR8__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR8__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR8__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR8__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR8__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR9                                                           (0x00000824)
#define   USB_OTG_HS_VMIDMT_SMR9___RWC                                                     QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR9__VALID___M                                                0x80000000
#define   USB_OTG_HS_VMIDMT_SMR9__VALID___S                                                31
#define   USB_OTG_HS_VMIDMT_SMR9__MASK___M                                                 0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR9__MASK___S                                                 16
#define   USB_OTG_HS_VMIDMT_SMR9__ID___M                                                   0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR9__ID___S                                                   0
#define USB_OTG_HS_VMIDMT_SMR10                                                          (0x00000828)
#define   USB_OTG_HS_VMIDMT_SMR10___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR10__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR10__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR10__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR10__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR10__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR10__ID___S                                                  0
#define USB_OTG_HS_VMIDMT_SMR11                                                          (0x0000082C)
#define   USB_OTG_HS_VMIDMT_SMR11___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR11__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR11__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR11__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR11__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR11__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR11__ID___S                                                  0
#define USB_OTG_HS_VMIDMT_SMR12                                                          (0x00000830)
#define   USB_OTG_HS_VMIDMT_SMR12___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR12__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR12__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR12__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR12__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR12__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR12__ID___S                                                  0
#define USB_OTG_HS_VMIDMT_SMR13                                                          (0x00000834)
#define   USB_OTG_HS_VMIDMT_SMR13___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR13__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR13__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR13__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR13__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR13__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR13__ID___S                                                  0
#define USB_OTG_HS_VMIDMT_SMR14                                                          (0x00000838)
#define   USB_OTG_HS_VMIDMT_SMR14___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR14__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR14__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR14__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR14__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR14__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR14__ID___S                                                  0
#define USB_OTG_HS_VMIDMT_SMR15                                                          (0x0000083C)
#define   USB_OTG_HS_VMIDMT_SMR15___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR15__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR15__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR15__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR15__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR15__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR15__ID___S                                                  0
#define USB_OTG_HS_VMIDMT_SMR16                                                          (0x00000840)
#define   USB_OTG_HS_VMIDMT_SMR16___RWC                                                    QCSR_REG_RW
#define   USB_OTG_HS_VMIDMT_SMR16__VALID___M                                               0x80000000
#define   USB_OTG_HS_VMIDMT_SMR16__VALID___S                                               31
#define   USB_OTG_HS_VMIDMT_SMR16__MASK___M                                                0x001F0000
#define   USB_OTG_HS_VMIDMT_SMR16__MASK___S                                                16
#define   USB_OTG_HS_VMIDMT_SMR16__ID___M                                                  0x0000001F
#define   USB_OTG_HS_VMIDMT_SMR16__ID___S                                                  0

////////////////////////////////////////////////////////////////////////// END
#endif
