// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_EXPECT_NDP_H_
#define _TX_EXPECT_NDP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	feedback_type[0], reserved_0[1], nc_index[4:2], nc_override[5], reserved_1[31:6]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_EXPECT_NDP 1

struct tx_expect_ndp {
    volatile uint32_t feedback_type                   :  1, //[0]
                      reserved_0                      :  1, //[1]
                      nc_index                        :  3, //[4:2]
                      nc_override                     :  1, //[5]
                      reserved_1                      : 26; //[31:6]
};

/*

feedback_type
			
			<enum 0     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 1     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 0-1>

reserved_0
			
			Reserved - set to 0 by MAC and ignored by PHY.  <legal
			0>

nc_index
			
			Defines the dimension Nc for the beamforming feedback
			matrix. Nc_index values > 3 are not supported in Beeliner.
			
			<legal 0-3>

nc_override
			
			This bit is set if the PHY is required to override its
			internally-calculated Nc value with the one provided by the
			MAC in this TLV.  <legal 0-1>

reserved_1
			
			Reserved - set to 0 by MAC and ignored by PHY.  <legal
			0>
*/


/* Description		TX_EXPECT_NDP_0_FEEDBACK_TYPE
			
			<enum 0     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 1     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 0-1>
*/
#define TX_EXPECT_NDP_0_FEEDBACK_TYPE_OFFSET                         0x00000000
#define TX_EXPECT_NDP_0_FEEDBACK_TYPE_LSB                            0
#define TX_EXPECT_NDP_0_FEEDBACK_TYPE_MASK                           0x00000001

/* Description		TX_EXPECT_NDP_0_RESERVED_0
			
			Reserved - set to 0 by MAC and ignored by PHY.  <legal
			0>
*/
#define TX_EXPECT_NDP_0_RESERVED_0_OFFSET                            0x00000000
#define TX_EXPECT_NDP_0_RESERVED_0_LSB                               1
#define TX_EXPECT_NDP_0_RESERVED_0_MASK                              0x00000002

/* Description		TX_EXPECT_NDP_0_NC_INDEX
			
			Defines the dimension Nc for the beamforming feedback
			matrix. Nc_index values > 3 are not supported in Beeliner.
			
			<legal 0-3>
*/
#define TX_EXPECT_NDP_0_NC_INDEX_OFFSET                              0x00000000
#define TX_EXPECT_NDP_0_NC_INDEX_LSB                                 2
#define TX_EXPECT_NDP_0_NC_INDEX_MASK                                0x0000001c

/* Description		TX_EXPECT_NDP_0_NC_OVERRIDE
			
			This bit is set if the PHY is required to override its
			internally-calculated Nc value with the one provided by the
			MAC in this TLV.  <legal 0-1>
*/
#define TX_EXPECT_NDP_0_NC_OVERRIDE_OFFSET                           0x00000000
#define TX_EXPECT_NDP_0_NC_OVERRIDE_LSB                              5
#define TX_EXPECT_NDP_0_NC_OVERRIDE_MASK                             0x00000020

/* Description		TX_EXPECT_NDP_0_RESERVED_1
			
			Reserved - set to 0 by MAC and ignored by PHY.  <legal
			0>
*/
#define TX_EXPECT_NDP_0_RESERVED_1_OFFSET                            0x00000000
#define TX_EXPECT_NDP_0_RESERVED_1_LSB                               6
#define TX_EXPECT_NDP_0_RESERVED_1_MASK                              0xffffffc0


#endif // _TX_EXPECT_NDP_H_
