// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _RX_RESP_H_
#define _RX_RESP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	rx_ba_seqnum[11:0], rx_ba_tid[15:12], rx_pwr_mgmt[16], reserved_0[31:17]
//	1	rx_ba_bitmap_31_0[31:0]
//	2	rx_ba_bitmap_63_32[31:0]
//	3	ack_wb_timestamp[23:0], ack_location_timestamp[31:24]
//	4	ack_rssi_ant_31_0[31:0]
//	5	ack_rssi_ant_63_32[31:0]
//	6	ack_rssi_ant_95_64[31:0]
//	7	ack_rssi_ant_127_96[31:0]
//	8	ack_rssi_ant_135_128[7:0], frame_type[9:8], frame_subtype[13:10], agc_cbw[15:14], service_cbw[17:16], reserved_8[31:18]
//	9	phy_timestamp_1[31:0]
//	10	phy_timestamp_2[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_RX_RESP 11

struct rx_resp {
    volatile uint32_t rx_ba_seqnum                    : 12, //[11:0]
                      rx_ba_tid                       :  4, //[15:12]
                      rx_pwr_mgmt                     :  1, //[16]
                      reserved_0                      : 15; //[31:17]
    volatile uint32_t rx_ba_bitmap_31_0               : 32; //[31:0]
    volatile uint32_t rx_ba_bitmap_63_32              : 32; //[31:0]
    volatile uint32_t ack_wb_timestamp                : 24, //[23:0]
                      ack_location_timestamp          :  8; //[31:24]
    volatile uint32_t ack_rssi_ant_31_0               : 32; //[31:0]
    volatile uint32_t ack_rssi_ant_63_32              : 32; //[31:0]
    volatile uint32_t ack_rssi_ant_95_64              : 32; //[31:0]
    volatile uint32_t ack_rssi_ant_127_96             : 32; //[31:0]
    volatile uint32_t ack_rssi_ant_135_128            :  8, //[7:0]
                      frame_type                      :  2, //[9:8]
                      frame_subtype                   :  4, //[13:10]
                      agc_cbw                         :  2, //[15:14]
                      service_cbw                     :  2, //[17:16]
                      reserved_8                      : 14; //[31:18]
    volatile uint32_t phy_timestamp_1                 : 32; //[31:0]
    volatile uint32_t phy_timestamp_2                 : 32; //[31:0]
};

/*

rx_ba_seqnum
			
			Rx BA starting sequence number 

rx_ba_tid
			
			Rx BA TID

rx_pwr_mgmt
			
			Power Management bit extracted from the header of the
			received frame.
			
			TxSM forwards this information to Tx DMA (DCU) at the
			end of frame transmission. Also muxes it into the
			Observation bus.
			
			(Latched with lat_misc (extracted from frame header) and
			held until the beginning of next received frame
			(lat_1st_rssi)).

reserved_0
			
			Reserved: HW should fill with 0

rx_ba_bitmap_31_0
			
			Rx BA bitmap[31:0]

rx_ba_bitmap_63_32
			
			Rx BA bitmap[63:32]

ack_wb_timestamp
			
			ACK WB timestamp to be reported in Tx PPDU Status.

ack_location_timestamp
			

ack_rssi_ant_31_0
			
			Indicates RSSI information for the received ACK. TxSM
			uses it to update the RSSI fields of Tx PPDU Status.
			
			(RxSM latches this information at the start of a
			received frame. It is held until the beginning of the next
			Rx frame).

ack_rssi_ant_63_32
			
			ACK RSSI[63:32]

ack_rssi_ant_95_64
			
			ACK RSSI[95:64]

ack_rssi_ant_127_96
			
			ACK RSSI[127:96]

ack_rssi_ant_135_128
			
			ACK RSSI[135:128]

frame_type
			
			802.11 frame type field

frame_subtype
			
			802.11 frame subtype field

agc_cbw
			
			BW as detected by the AGC 
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Unsupported
			
			<valid 0-2>

service_cbw
			
			CBW field extracted from Service field
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Unsupported
			
			<valid 0-2>

reserved_8
			
			Reserved: HW should fill with 0

phy_timestamp_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.

phy_timestamp_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.
*/


/* Description		RX_RESP_0_RX_BA_SEQNUM
			
			Rx BA starting sequence number 
*/
#define RX_RESP_0_RX_BA_SEQNUM_OFFSET                                0x00000000
#define RX_RESP_0_RX_BA_SEQNUM_LSB                                   0
#define RX_RESP_0_RX_BA_SEQNUM_MASK                                  0x00000fff

/* Description		RX_RESP_0_RX_BA_TID
			
			Rx BA TID
*/
#define RX_RESP_0_RX_BA_TID_OFFSET                                   0x00000000
#define RX_RESP_0_RX_BA_TID_LSB                                      12
#define RX_RESP_0_RX_BA_TID_MASK                                     0x0000f000

/* Description		RX_RESP_0_RX_PWR_MGMT
			
			Power Management bit extracted from the header of the
			received frame.
			
			TxSM forwards this information to Tx DMA (DCU) at the
			end of frame transmission. Also muxes it into the
			Observation bus.
			
			(Latched with lat_misc (extracted from frame header) and
			held until the beginning of next received frame
			(lat_1st_rssi)).
*/
#define RX_RESP_0_RX_PWR_MGMT_OFFSET                                 0x00000000
#define RX_RESP_0_RX_PWR_MGMT_LSB                                    16
#define RX_RESP_0_RX_PWR_MGMT_MASK                                   0x00010000

/* Description		RX_RESP_0_RESERVED_0
			
			Reserved: HW should fill with 0
*/
#define RX_RESP_0_RESERVED_0_OFFSET                                  0x00000000
#define RX_RESP_0_RESERVED_0_LSB                                     17
#define RX_RESP_0_RESERVED_0_MASK                                    0xfffe0000

/* Description		RX_RESP_1_RX_BA_BITMAP_31_0
			
			Rx BA bitmap[31:0]
*/
#define RX_RESP_1_RX_BA_BITMAP_31_0_OFFSET                           0x00000004
#define RX_RESP_1_RX_BA_BITMAP_31_0_LSB                              0
#define RX_RESP_1_RX_BA_BITMAP_31_0_MASK                             0xffffffff

/* Description		RX_RESP_2_RX_BA_BITMAP_63_32
			
			Rx BA bitmap[63:32]
*/
#define RX_RESP_2_RX_BA_BITMAP_63_32_OFFSET                          0x00000008
#define RX_RESP_2_RX_BA_BITMAP_63_32_LSB                             0
#define RX_RESP_2_RX_BA_BITMAP_63_32_MASK                            0xffffffff

/* Description		RX_RESP_3_ACK_WB_TIMESTAMP
			
			ACK WB timestamp to be reported in Tx PPDU Status.
*/
#define RX_RESP_3_ACK_WB_TIMESTAMP_OFFSET                            0x0000000c
#define RX_RESP_3_ACK_WB_TIMESTAMP_LSB                               0
#define RX_RESP_3_ACK_WB_TIMESTAMP_MASK                              0x00ffffff

/* Description		RX_RESP_3_ACK_LOCATION_TIMESTAMP
			
*/
#define RX_RESP_3_ACK_LOCATION_TIMESTAMP_OFFSET                      0x0000000c
#define RX_RESP_3_ACK_LOCATION_TIMESTAMP_LSB                         24
#define RX_RESP_3_ACK_LOCATION_TIMESTAMP_MASK                        0xff000000

/* Description		RX_RESP_4_ACK_RSSI_ANT_31_0
			
			Indicates RSSI information for the received ACK. TxSM
			uses it to update the RSSI fields of Tx PPDU Status.
			
			(RxSM latches this information at the start of a
			received frame. It is held until the beginning of the next
			Rx frame).
*/
#define RX_RESP_4_ACK_RSSI_ANT_31_0_OFFSET                           0x00000010
#define RX_RESP_4_ACK_RSSI_ANT_31_0_LSB                              0
#define RX_RESP_4_ACK_RSSI_ANT_31_0_MASK                             0xffffffff

/* Description		RX_RESP_5_ACK_RSSI_ANT_63_32
			
			ACK RSSI[63:32]
*/
#define RX_RESP_5_ACK_RSSI_ANT_63_32_OFFSET                          0x00000014
#define RX_RESP_5_ACK_RSSI_ANT_63_32_LSB                             0
#define RX_RESP_5_ACK_RSSI_ANT_63_32_MASK                            0xffffffff

/* Description		RX_RESP_6_ACK_RSSI_ANT_95_64
			
			ACK RSSI[95:64]
*/
#define RX_RESP_6_ACK_RSSI_ANT_95_64_OFFSET                          0x00000018
#define RX_RESP_6_ACK_RSSI_ANT_95_64_LSB                             0
#define RX_RESP_6_ACK_RSSI_ANT_95_64_MASK                            0xffffffff

/* Description		RX_RESP_7_ACK_RSSI_ANT_127_96
			
			ACK RSSI[127:96]
*/
#define RX_RESP_7_ACK_RSSI_ANT_127_96_OFFSET                         0x0000001c
#define RX_RESP_7_ACK_RSSI_ANT_127_96_LSB                            0
#define RX_RESP_7_ACK_RSSI_ANT_127_96_MASK                           0xffffffff

/* Description		RX_RESP_8_ACK_RSSI_ANT_135_128
			
			ACK RSSI[135:128]
*/
#define RX_RESP_8_ACK_RSSI_ANT_135_128_OFFSET                        0x00000020
#define RX_RESP_8_ACK_RSSI_ANT_135_128_LSB                           0
#define RX_RESP_8_ACK_RSSI_ANT_135_128_MASK                          0x000000ff

/* Description		RX_RESP_8_FRAME_TYPE
			
			802.11 frame type field
*/
#define RX_RESP_8_FRAME_TYPE_OFFSET                                  0x00000020
#define RX_RESP_8_FRAME_TYPE_LSB                                     8
#define RX_RESP_8_FRAME_TYPE_MASK                                    0x00000300

/* Description		RX_RESP_8_FRAME_SUBTYPE
			
			802.11 frame subtype field
*/
#define RX_RESP_8_FRAME_SUBTYPE_OFFSET                               0x00000020
#define RX_RESP_8_FRAME_SUBTYPE_LSB                                  10
#define RX_RESP_8_FRAME_SUBTYPE_MASK                                 0x00003c00

/* Description		RX_RESP_8_AGC_CBW
			
			BW as detected by the AGC 
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Unsupported
			
			<valid 0-2>
*/
#define RX_RESP_8_AGC_CBW_OFFSET                                     0x00000020
#define RX_RESP_8_AGC_CBW_LSB                                        14
#define RX_RESP_8_AGC_CBW_MASK                                       0x0000c000

/* Description		RX_RESP_8_SERVICE_CBW
			
			CBW field extracted from Service field
			
			<enum_typedef tx_phy_desc bandwidth>
			
			<enum 0     20_mhz>
			
			<enum 1     40_mhz>
			
			<enum 2     80_mhz>
			
			<enum 3     160_mhz> Unsupported
			
			<valid 0-2>
*/
#define RX_RESP_8_SERVICE_CBW_OFFSET                                 0x00000020
#define RX_RESP_8_SERVICE_CBW_LSB                                    16
#define RX_RESP_8_SERVICE_CBW_MASK                                   0x00030000

/* Description		RX_RESP_8_RESERVED_8
			
			Reserved: HW should fill with 0
*/
#define RX_RESP_8_RESERVED_8_OFFSET                                  0x00000020
#define RX_RESP_8_RESERVED_8_LSB                                     18
#define RX_RESP_8_RESERVED_8_MASK                                    0xfffc0000

/* Description		RX_RESP_9_PHY_TIMESTAMP_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.
*/
#define RX_RESP_9_PHY_TIMESTAMP_1_OFFSET                             0x00000024
#define RX_RESP_9_PHY_TIMESTAMP_1_LSB                                0
#define RX_RESP_9_PHY_TIMESTAMP_1_MASK                               0xffffffff

/* Description		RX_RESP_10_PHY_TIMESTAMP_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.
*/
#define RX_RESP_10_PHY_TIMESTAMP_2_OFFSET                            0x00000028
#define RX_RESP_10_PHY_TIMESTAMP_2_LSB                               0
#define RX_RESP_10_PHY_TIMESTAMP_2_MASK                              0xffffffff


#endif // _RX_RESP_H_
