// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _TX_FES_STATUS_H_
#define _TX_FES_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], schedule_cmd_ring_id[20:16], fes_control_mode[22:21], number_of_users[24:23], user_id[27:25], fes_transmit_result[31:28]
//	1	fes_error_status[7:0], phy_err_status[11:8], phy_err_user_mask[15:12], transmit_fes_type[19:16], medium_prot_type[22:20], response_type[25:23], data_underflow_warning[27:26], reserved_1[31:28]
//	2	underflow_mpdu_cnt[5:0], qc_eosp_setting[6], fc_more_data_setting[7], fc_pwr_mgt_setting[8], mpdu_tx_cnt[15:9], underflow_byte_cnt[31:16]
//	3	start_seq_num[11:0], used_warm_tx[12], reserved_3[31:13]
//	4	seqnum_bitmap_31_0[31:0]
//	5	seqnum_bitmap_63_32[31:0]
//	6	response_frame_rcvd[2:0], ba_valid[3], ba_tid[7:4], reserved_6a[15:8], ba_start_seq_num[27:16], reserved_6b[31:28]
//	7	ba_bitmap_31_0[31:0]
//	8	ba_bitmap_63_32[31:0]
//	9	medium_prot_bandwidth[1:0], packet_bw[3:2], reserved_9[31:4]
//	10	prot_timestamp[31:0]
//	11	ppdu_timestamp[31:0]
//	12	prot_resp_sifs_timing[11:0], ppdu_resp_sifs_timing[23:12], reserved_12[31:24]
//	13	rtt_info[31:0]
//	14	ack_rssi_chain0_pri20[7:0], ack_rssi_chain0_sec20[15:8], ack_rssi_chain0_sec40[23:16], ack_rssi_chain0_sec80[31:24]
//	15	ack_rssi_chain1_pri20[7:0], ack_rssi_chain1_sec20[15:8], ack_rssi_chain1_sec40[23:16], ack_rssi_chain1_sec80[31:24]
//	16	ack_rssi_chain2_pri20[7:0], ack_rssi_chain2_sec20[15:8], ack_rssi_chain2_sec40[23:16], ack_rssi_chain2_sec80[31:24]
//	17	ack_rssi_chain3_pri20[7:0], ack_rssi_chain3_sec20[15:8], ack_rssi_chain3_sec40[23:16], ack_rssi_chain3_sec80[31:24]
//	18	ack_rssi_ave[7:0], reserved_18[31:8]
//	19	phy_timestamp_1[31:0]
//	20	phy_timestamp_2[31:0]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_TX_FES_STATUS 21

struct tx_fes_status {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      schedule_cmd_ring_id            :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      number_of_users                 :  2, //[24:23]
                      user_id                         :  3, //[27:25]
                      fes_transmit_result             :  4; //[31:28]
    volatile uint32_t fes_error_status                :  8, //[7:0]
                      phy_err_status                  :  4, //[11:8]
                      phy_err_user_mask               :  4, //[15:12]
                      transmit_fes_type               :  4, //[19:16]
                      medium_prot_type                :  3, //[22:20]
                      response_type                   :  3, //[25:23]
                      data_underflow_warning          :  2, //[27:26]
                      reserved_1                      :  4; //[31:28]
    volatile uint32_t underflow_mpdu_cnt              :  6, //[5:0]
                      qc_eosp_setting                 :  1, //[6]
                      fc_more_data_setting            :  1, //[7]
                      fc_pwr_mgt_setting              :  1, //[8]
                      mpdu_tx_cnt                     :  7, //[15:9]
                      underflow_byte_cnt              : 16; //[31:16]
    volatile uint32_t start_seq_num                   : 12, //[11:0]
                      used_warm_tx                    :  1, //[12]
                      reserved_3                      : 19; //[31:13]
    volatile uint32_t seqnum_bitmap_31_0              : 32; //[31:0]
    volatile uint32_t seqnum_bitmap_63_32             : 32; //[31:0]
    volatile uint32_t response_frame_rcvd             :  3, //[2:0]
                      ba_valid                        :  1, //[3]
                      ba_tid                          :  4, //[7:4]
                      reserved_6a                     :  8, //[15:8]
                      ba_start_seq_num                : 12, //[27:16]
                      reserved_6b                     :  4; //[31:28]
    volatile uint32_t ba_bitmap_31_0                  : 32; //[31:0]
    volatile uint32_t ba_bitmap_63_32                 : 32; //[31:0]
    volatile uint32_t medium_prot_bandwidth           :  2, //[1:0]
                      packet_bw                       :  2, //[3:2]
                      reserved_9                      : 28; //[31:4]
    volatile uint32_t prot_timestamp                  : 32; //[31:0]
    volatile uint32_t ppdu_timestamp                  : 32; //[31:0]
    volatile uint32_t prot_resp_sifs_timing           : 12, //[11:0]
                      ppdu_resp_sifs_timing           : 12, //[23:12]
                      reserved_12                     :  8; //[31:24]
    volatile uint32_t rtt_info                        : 32; //[31:0]
    volatile uint32_t ack_rssi_chain0_pri20           :  8, //[7:0]
                      ack_rssi_chain0_sec20           :  8, //[15:8]
                      ack_rssi_chain0_sec40           :  8, //[23:16]
                      ack_rssi_chain0_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_chain1_pri20           :  8, //[7:0]
                      ack_rssi_chain1_sec20           :  8, //[15:8]
                      ack_rssi_chain1_sec40           :  8, //[23:16]
                      ack_rssi_chain1_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_chain2_pri20           :  8, //[7:0]
                      ack_rssi_chain2_sec20           :  8, //[15:8]
                      ack_rssi_chain2_sec40           :  8, //[23:16]
                      ack_rssi_chain2_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_chain3_pri20           :  8, //[7:0]
                      ack_rssi_chain3_sec20           :  8, //[15:8]
                      ack_rssi_chain3_sec40           :  8, //[23:16]
                      ack_rssi_chain3_sec80           :  8; //[31:24]
    volatile uint32_t ack_rssi_ave                    :  8, //[7:0]
                      reserved_18                     : 24; //[31:8]
    volatile uint32_t phy_timestamp_1                 : 32; //[31:0]
    volatile uint32_t phy_timestamp_2                 : 32; //[31:0]
};

/*

schedule_id
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.

schedule_cmd_ring_id
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>

fes_control_mode
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>

number_of_users
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users

user_id
			
			The user ID for this FES status 
			
			0: User 0
			
			1: User 1
			
			2: User 2
			
			7-3: Reserved

fes_transmit_result
			
			Transmit result:
			
			0: Successful transmission of entire Frame exchange
			sequence
			
			1: No protection response frame received
			
			2: No PPDU response frame received. 
			
			3: Flush command received
			
			In case of transmitting self generated BAR, DataNull or
			QoSDataNull frame and no BAR or ACK frame is received this
			indication is also set
			
			4: MAC HW error resulting in abort: Error details
			located in fes_error_status field
			
			5: PHY error resulting in abort. Error details located
			in fes_error_status field
			
			15:6: Reserved

fes_error_status
			
			Field only valid when fes_transmit_result is set to 4:
			MAC HW error.
			
			
			
			0: Preamble Timeout
			
			1: CV timeout
			
			
			
			<legal 0-1>

phy_err_status
			
			Reason for early termination of TX packet by the PHY 
			
			<enum 1    error_tx_underrun> PHY ran out of transmit
			data due to transmit underrun
			
			<enum 2    error_tx_chain_mask_zero>
			
			<enum 3    error_tx_extra_sym_mismatch>
			
			<enum 4    error_tx_vht_length_not_multiple_of_3>
			
			<enum 5    error_tx_bw_is_gt_dyn_bw>
			
			<enum 6  error_tx_11b_rate_illegal>
			
			<enum 7  error_tx_legacy_rate_illegal>
			
			<enum 8  error_tx_ht_rate_illegal>
			
			<enum 9  error_tx_vht_rate_illegal>
			
			
			
			 <legal 1-9>

phy_err_user_mask
			
			Indicates which users this message relates to. This
			field is only valid for error conditions that are
			user-specific.
			
			
			
			<legal 0-7>

transmit_fes_type
			
			<enum 0 self_gen_bar> A self-generated BAR frame is
			transmitted. 
			
			SU transmission only.
			
			<enum 1 self_gen_data_null> A self-generated Data null
			frame is transmitted. SU transmission only.
			
			<enum 2 self_gen_qos_null> A self-generated QoS null
			frame is transmitted. SU transmission only.
			
			<enum 3 self_gen_cf_end> A self-generated CF-end frame
			is transmitted. SU transmission only
			
			<enum 4 regular_transmission>  A Scheduled SU
			transmission
			
			
			
			15-5 Reserved

medium_prot_type
			
			Self Gen Medium Protection type used
			
			0: No protection
			
			1: RTS (legacy)
			
			2: RTS (static bandwidth)
			
			3: RTS (dynamic bandwidth)
			
			4: CTS2Self
			
			5-7: Reserved
			
			
			
			Field only valid for user0 FES status.

response_type
			
			PPDU transmission Response type expected:
			
			0: No response expected
			
			1: ACK expected2: BA expected
			
			3: Action No Ack frame expected (after NDP)
			
			7-4: Reserved

data_underflow_warning
			
			Mac data underflow warning for this user
			
			0: No data underflow
			
			1: PCU experienced data underflow in between MPDUs
			
			2: PCU experienced data underflow within an MPDU
			
			3: Reserved

reserved_1
			
			<legal 0>

underflow_mpdu_cnt
			
			The MPDU count correctly received from TX DMA when the
			first underrun condition was detected

qc_eosp_setting
			
			This field indicates if TX PCU set the eosp bit in the
			QoS control field for this user (indicated in field
			User_Id.)
			
			0: No action
			
			1: eosp bit is set in all the transmitted frames. This
			is done upon request of the PDG.
			
			<legal all>

fc_more_data_setting
			
			This field indicates if TX PCU set the More data bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			
			
			0: No action
			
			1: More Data bit is set in all the transmitted frames.
			This is done upon request of the PDG.
			
			<legal all>

fc_pwr_mgt_setting
			
			This field indicates if TX PCU set the pwr_mgt  bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			0: pwr_mgt bit NOT set
			
			1: pwr_mgt bit is set
			
			<legal all>

mpdu_tx_cnt
			
			Number of MPDU frames transmitted 
			
			This is the actual amount of frame transmitted, taking
			underflow scenarios and transmit aborts due to BT
			coexistence into account.

underflow_byte_cnt
			
			The (A)MPDU byte count correctly received from TX DMA
			when the first underrun condition was detected

start_seq_num
			
			Indicates the sequence number of the head MPDU
			transmitted.

used_warm_tx
			
			If set indicates that this PPDU was transmitted with
			warm TX.

reserved_3
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

seqnum_bitmap_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap. 
			This field is used to specify the sequence numbers of all
			the MPDU in this PPDU based on the start_seq_num field
			<legal all>

seqnum_bitmap_63_32
			
			Upper 32 bits of the 64 bit sequence number bitmap.  See
			description for seq_num_bitmap_31_0. <legal all>

response_frame_rcvd
			
			0: No response frame received
			
			(In case of HW initiated transmissions, the QM should
			increase the retry counts  for the transmitted frames.)
			
			1: ACk frame received  (QM removes the head frame of the
			queue)
			
			2; BA frame received (QM removes the acknowledged frames
			(in BA bitmap) from the queue.
			
			3: Other
			
			7-4: Reserved
			
			(In case of HW transmit mode, field snooped by QM, to
			determine if frames should be removed from the queue)

ba_valid
			
			When set, all the BA related fields are valid

ba_tid
			
			Tid field of the BA frame

reserved_6a
			
			0

ba_start_seq_num
			
			Only valid when Response frame is BA frame
			
			The start sequence number in the BA frame

reserved_6b
			
			0

ba_bitmap_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.

ba_bitmap_63_32
			
			The upper 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.

medium_prot_bandwidth
			
			Indicates the bandwidth used to transmit the Medium
			protection frame. Only valid when field 'Medium_Prot_type'
			indicates
			
			0: 20 MHz
			
			1: 40 MHz
			
			2: 80 MHz
			
			3: 160 MHz (Not supported in WiFi 1.0)

packet_bw
			
			Indicates the bandwidth used to transmit data packet or
			self gen(non medium protection) frame.  Only valid if the
			packet bit is also set.
			
			0: 20 MHz
			
			1: 40 MHz
			
			2: 80 MHz
			
			3: 160 MHz (Not supported in WiFi 1.0)

reserved_9
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

prot_timestamp
			
			Global timer value at start of Protection transmission

ppdu_timestamp
			
			Global timer value at start of PPDU transmission

prot_resp_sifs_timing
			
			Number of 80Mhz clock cycles counted between RTS and CTS
			frames. Only valid if this protection was enabled

ppdu_resp_sifs_timing
			
			Number of 80Mhz clock cycles counted between main PPDU
			frame and response frame (ACK or BA). Only valid if this
			kind of response is expected

reserved_12
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

rtt_info
			
			Format defined in MAC_PHY interface

ack_rssi_chain0_pri20
			
			RSSI of Ack on chain 0 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain0_sec20
			
			RSSI of Ack on chain 0 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain0_sec40
			
			RSSI of Ack on chain 0 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain0_sec80
			
			RSSI of Ack on chain 0 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_pri20
			
			RSSI of Ack on chain 1 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_sec20
			
			RSSI of Ack on chain 1 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_sec40
			
			RSSI of Ack on chain 1 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain1_sec80
			
			RSSI of Ack on chain 1 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_pri20
			
			RSSI of Ack on chain 2 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_sec20
			
			RSSI of Ack on chain 2 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_sec40
			
			RSSI of Ack on chain 2 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain2_sec80
			
			RSSI of Ack on chain 2 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_pri20
			
			RSSI of Ack on chain 3 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_sec20
			
			RSSI of Ack on chain 3 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_sec40
			
			RSSI of Ack on chain 3 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_chain3_sec80
			
			RSSI of Ack on chain 3 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.

ack_rssi_ave
			
			RSSI of Ack of all active chains and bandwidths.
			
			Value of 0x80 indicates invalid.

reserved_18
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>

phy_timestamp_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.

phy_timestamp_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.
*/


/* Description		TX_FES_STATUS_0_SCHEDULE_ID
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.
*/
#define TX_FES_STATUS_0_SCHEDULE_ID_OFFSET                           0x00000000
#define TX_FES_STATUS_0_SCHEDULE_ID_LSB                              0
#define TX_FES_STATUS_0_SCHEDULE_ID_MASK                             0x0000ffff

/* Description		TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>
*/
#define TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID_OFFSET                  0x00000000
#define TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID_LSB                     16
#define TX_FES_STATUS_0_SCHEDULE_CMD_RING_ID_MASK                    0x001f0000

/* Description		TX_FES_STATUS_0_FES_CONTROL_MODE
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>
*/
#define TX_FES_STATUS_0_FES_CONTROL_MODE_OFFSET                      0x00000000
#define TX_FES_STATUS_0_FES_CONTROL_MODE_LSB                         21
#define TX_FES_STATUS_0_FES_CONTROL_MODE_MASK                        0x00600000

/* Description		TX_FES_STATUS_0_NUMBER_OF_USERS
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users
*/
#define TX_FES_STATUS_0_NUMBER_OF_USERS_OFFSET                       0x00000000
#define TX_FES_STATUS_0_NUMBER_OF_USERS_LSB                          23
#define TX_FES_STATUS_0_NUMBER_OF_USERS_MASK                         0x01800000

/* Description		TX_FES_STATUS_0_USER_ID
			
			The user ID for this FES status 
			
			0: User 0
			
			1: User 1
			
			2: User 2
			
			7-3: Reserved
*/
#define TX_FES_STATUS_0_USER_ID_OFFSET                               0x00000000
#define TX_FES_STATUS_0_USER_ID_LSB                                  25
#define TX_FES_STATUS_0_USER_ID_MASK                                 0x0e000000

/* Description		TX_FES_STATUS_0_FES_TRANSMIT_RESULT
			
			Transmit result:
			
			0: Successful transmission of entire Frame exchange
			sequence
			
			1: No protection response frame received
			
			2: No PPDU response frame received. 
			
			3: Flush command received
			
			In case of transmitting self generated BAR, DataNull or
			QoSDataNull frame and no BAR or ACK frame is received this
			indication is also set
			
			4: MAC HW error resulting in abort: Error details
			located in fes_error_status field
			
			5: PHY error resulting in abort. Error details located
			in fes_error_status field
			
			15:6: Reserved
*/
#define TX_FES_STATUS_0_FES_TRANSMIT_RESULT_OFFSET                   0x00000000
#define TX_FES_STATUS_0_FES_TRANSMIT_RESULT_LSB                      28
#define TX_FES_STATUS_0_FES_TRANSMIT_RESULT_MASK                     0xf0000000

/* Description		TX_FES_STATUS_1_FES_ERROR_STATUS
			
			Field only valid when fes_transmit_result is set to 4:
			MAC HW error.
			
			
			
			0: Preamble Timeout
			
			1: CV timeout
			
			
			
			<legal 0-1>
*/
#define TX_FES_STATUS_1_FES_ERROR_STATUS_OFFSET                      0x00000004
#define TX_FES_STATUS_1_FES_ERROR_STATUS_LSB                         0
#define TX_FES_STATUS_1_FES_ERROR_STATUS_MASK                        0x000000ff

/* Description		TX_FES_STATUS_1_PHY_ERR_STATUS
			
			Reason for early termination of TX packet by the PHY 
			
			<enum 1    error_tx_underrun> PHY ran out of transmit
			data due to transmit underrun
			
			<enum 2    error_tx_chain_mask_zero>
			
			<enum 3    error_tx_extra_sym_mismatch>
			
			<enum 4    error_tx_vht_length_not_multiple_of_3>
			
			<enum 5    error_tx_bw_is_gt_dyn_bw>
			
			<enum 6  error_tx_11b_rate_illegal>
			
			<enum 7  error_tx_legacy_rate_illegal>
			
			<enum 8  error_tx_ht_rate_illegal>
			
			<enum 9  error_tx_vht_rate_illegal>
			
			
			
			 <legal 1-9>
*/
#define TX_FES_STATUS_1_PHY_ERR_STATUS_OFFSET                        0x00000004
#define TX_FES_STATUS_1_PHY_ERR_STATUS_LSB                           8
#define TX_FES_STATUS_1_PHY_ERR_STATUS_MASK                          0x00000f00

/* Description		TX_FES_STATUS_1_PHY_ERR_USER_MASK
			
			Indicates which users this message relates to. This
			field is only valid for error conditions that are
			user-specific.
			
			
			
			<legal 0-7>
*/
#define TX_FES_STATUS_1_PHY_ERR_USER_MASK_OFFSET                     0x00000004
#define TX_FES_STATUS_1_PHY_ERR_USER_MASK_LSB                        12
#define TX_FES_STATUS_1_PHY_ERR_USER_MASK_MASK                       0x0000f000

/* Description		TX_FES_STATUS_1_TRANSMIT_FES_TYPE
			
			<enum 0 self_gen_bar> A self-generated BAR frame is
			transmitted. 
			
			SU transmission only.
			
			<enum 1 self_gen_data_null> A self-generated Data null
			frame is transmitted. SU transmission only.
			
			<enum 2 self_gen_qos_null> A self-generated QoS null
			frame is transmitted. SU transmission only.
			
			<enum 3 self_gen_cf_end> A self-generated CF-end frame
			is transmitted. SU transmission only
			
			<enum 4 regular_transmission>  A Scheduled SU
			transmission
			
			
			
			15-5 Reserved
*/
#define TX_FES_STATUS_1_TRANSMIT_FES_TYPE_OFFSET                     0x00000004
#define TX_FES_STATUS_1_TRANSMIT_FES_TYPE_LSB                        16
#define TX_FES_STATUS_1_TRANSMIT_FES_TYPE_MASK                       0x000f0000

/* Description		TX_FES_STATUS_1_MEDIUM_PROT_TYPE
			
			Self Gen Medium Protection type used
			
			0: No protection
			
			1: RTS (legacy)
			
			2: RTS (static bandwidth)
			
			3: RTS (dynamic bandwidth)
			
			4: CTS2Self
			
			5-7: Reserved
			
			
			
			Field only valid for user0 FES status.
*/
#define TX_FES_STATUS_1_MEDIUM_PROT_TYPE_OFFSET                      0x00000004
#define TX_FES_STATUS_1_MEDIUM_PROT_TYPE_LSB                         20
#define TX_FES_STATUS_1_MEDIUM_PROT_TYPE_MASK                        0x00700000

/* Description		TX_FES_STATUS_1_RESPONSE_TYPE
			
			PPDU transmission Response type expected:
			
			0: No response expected
			
			1: ACK expected2: BA expected
			
			3: Action No Ack frame expected (after NDP)
			
			7-4: Reserved
*/
#define TX_FES_STATUS_1_RESPONSE_TYPE_OFFSET                         0x00000004
#define TX_FES_STATUS_1_RESPONSE_TYPE_LSB                            23
#define TX_FES_STATUS_1_RESPONSE_TYPE_MASK                           0x03800000

/* Description		TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING
			
			Mac data underflow warning for this user
			
			0: No data underflow
			
			1: PCU experienced data underflow in between MPDUs
			
			2: PCU experienced data underflow within an MPDU
			
			3: Reserved
*/
#define TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING_OFFSET                0x00000004
#define TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING_LSB                   26
#define TX_FES_STATUS_1_DATA_UNDERFLOW_WARNING_MASK                  0x0c000000

/* Description		TX_FES_STATUS_1_RESERVED_1
			
			<legal 0>
*/
#define TX_FES_STATUS_1_RESERVED_1_OFFSET                            0x00000004
#define TX_FES_STATUS_1_RESERVED_1_LSB                               28
#define TX_FES_STATUS_1_RESERVED_1_MASK                              0xf0000000

/* Description		TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT
			
			The MPDU count correctly received from TX DMA when the
			first underrun condition was detected
*/
#define TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT_OFFSET                    0x00000008
#define TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT_LSB                       0
#define TX_FES_STATUS_2_UNDERFLOW_MPDU_CNT_MASK                      0x0000003f

/* Description		TX_FES_STATUS_2_QC_EOSP_SETTING
			
			This field indicates if TX PCU set the eosp bit in the
			QoS control field for this user (indicated in field
			User_Id.)
			
			0: No action
			
			1: eosp bit is set in all the transmitted frames. This
			is done upon request of the PDG.
			
			<legal all>
*/
#define TX_FES_STATUS_2_QC_EOSP_SETTING_OFFSET                       0x00000008
#define TX_FES_STATUS_2_QC_EOSP_SETTING_LSB                          6
#define TX_FES_STATUS_2_QC_EOSP_SETTING_MASK                         0x00000040

/* Description		TX_FES_STATUS_2_FC_MORE_DATA_SETTING
			
			This field indicates if TX PCU set the More data bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			
			
			0: No action
			
			1: More Data bit is set in all the transmitted frames.
			This is done upon request of the PDG.
			
			<legal all>
*/
#define TX_FES_STATUS_2_FC_MORE_DATA_SETTING_OFFSET                  0x00000008
#define TX_FES_STATUS_2_FC_MORE_DATA_SETTING_LSB                     7
#define TX_FES_STATUS_2_FC_MORE_DATA_SETTING_MASK                    0x00000080

/* Description		TX_FES_STATUS_2_FC_PWR_MGT_SETTING
			
			This field indicates if TX PCU set the pwr_mgt  bit in
			the Frame control field for this user (indicated in field
			User_Id.)
			
			0: pwr_mgt bit NOT set
			
			1: pwr_mgt bit is set
			
			<legal all>
*/
#define TX_FES_STATUS_2_FC_PWR_MGT_SETTING_OFFSET                    0x00000008
#define TX_FES_STATUS_2_FC_PWR_MGT_SETTING_LSB                       8
#define TX_FES_STATUS_2_FC_PWR_MGT_SETTING_MASK                      0x00000100

/* Description		TX_FES_STATUS_2_MPDU_TX_CNT
			
			Number of MPDU frames transmitted 
			
			This is the actual amount of frame transmitted, taking
			underflow scenarios and transmit aborts due to BT
			coexistence into account.
*/
#define TX_FES_STATUS_2_MPDU_TX_CNT_OFFSET                           0x00000008
#define TX_FES_STATUS_2_MPDU_TX_CNT_LSB                              9
#define TX_FES_STATUS_2_MPDU_TX_CNT_MASK                             0x0000fe00

/* Description		TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT
			
			The (A)MPDU byte count correctly received from TX DMA
			when the first underrun condition was detected
*/
#define TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT_OFFSET                    0x00000008
#define TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT_LSB                       16
#define TX_FES_STATUS_2_UNDERFLOW_BYTE_CNT_MASK                      0xffff0000

/* Description		TX_FES_STATUS_3_START_SEQ_NUM
			
			Indicates the sequence number of the head MPDU
			transmitted.
*/
#define TX_FES_STATUS_3_START_SEQ_NUM_OFFSET                         0x0000000c
#define TX_FES_STATUS_3_START_SEQ_NUM_LSB                            0
#define TX_FES_STATUS_3_START_SEQ_NUM_MASK                           0x00000fff

/* Description		TX_FES_STATUS_3_USED_WARM_TX
			
			If set indicates that this PPDU was transmitted with
			warm TX.
*/
#define TX_FES_STATUS_3_USED_WARM_TX_OFFSET                          0x0000000c
#define TX_FES_STATUS_3_USED_WARM_TX_LSB                             12
#define TX_FES_STATUS_3_USED_WARM_TX_MASK                            0x00001000

/* Description		TX_FES_STATUS_3_RESERVED_3
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_3_RESERVED_3_OFFSET                            0x0000000c
#define TX_FES_STATUS_3_RESERVED_3_LSB                               13
#define TX_FES_STATUS_3_RESERVED_3_MASK                              0xffffe000

/* Description		TX_FES_STATUS_4_SEQNUM_BITMAP_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap. 
			This field is used to specify the sequence numbers of all
			the MPDU in this PPDU based on the start_seq_num field
			<legal all>
*/
#define TX_FES_STATUS_4_SEQNUM_BITMAP_31_0_OFFSET                    0x00000010
#define TX_FES_STATUS_4_SEQNUM_BITMAP_31_0_LSB                       0
#define TX_FES_STATUS_4_SEQNUM_BITMAP_31_0_MASK                      0xffffffff

/* Description		TX_FES_STATUS_5_SEQNUM_BITMAP_63_32
			
			Upper 32 bits of the 64 bit sequence number bitmap.  See
			description for seq_num_bitmap_31_0. <legal all>
*/
#define TX_FES_STATUS_5_SEQNUM_BITMAP_63_32_OFFSET                   0x00000014
#define TX_FES_STATUS_5_SEQNUM_BITMAP_63_32_LSB                      0
#define TX_FES_STATUS_5_SEQNUM_BITMAP_63_32_MASK                     0xffffffff

/* Description		TX_FES_STATUS_6_RESPONSE_FRAME_RCVD
			
			0: No response frame received
			
			(In case of HW initiated transmissions, the QM should
			increase the retry counts  for the transmitted frames.)
			
			1: ACk frame received  (QM removes the head frame of the
			queue)
			
			2; BA frame received (QM removes the acknowledged frames
			(in BA bitmap) from the queue.
			
			3: Other
			
			7-4: Reserved
			
			(In case of HW transmit mode, field snooped by QM, to
			determine if frames should be removed from the queue)
*/
#define TX_FES_STATUS_6_RESPONSE_FRAME_RCVD_OFFSET                   0x00000018
#define TX_FES_STATUS_6_RESPONSE_FRAME_RCVD_LSB                      0
#define TX_FES_STATUS_6_RESPONSE_FRAME_RCVD_MASK                     0x00000007

/* Description		TX_FES_STATUS_6_BA_VALID
			
			When set, all the BA related fields are valid
*/
#define TX_FES_STATUS_6_BA_VALID_OFFSET                              0x00000018
#define TX_FES_STATUS_6_BA_VALID_LSB                                 3
#define TX_FES_STATUS_6_BA_VALID_MASK                                0x00000008

/* Description		TX_FES_STATUS_6_BA_TID
			
			Tid field of the BA frame
*/
#define TX_FES_STATUS_6_BA_TID_OFFSET                                0x00000018
#define TX_FES_STATUS_6_BA_TID_LSB                                   4
#define TX_FES_STATUS_6_BA_TID_MASK                                  0x000000f0

/* Description		TX_FES_STATUS_6_RESERVED_6A
			
			0
*/
#define TX_FES_STATUS_6_RESERVED_6A_OFFSET                           0x00000018
#define TX_FES_STATUS_6_RESERVED_6A_LSB                              8
#define TX_FES_STATUS_6_RESERVED_6A_MASK                             0x0000ff00

/* Description		TX_FES_STATUS_6_BA_START_SEQ_NUM
			
			Only valid when Response frame is BA frame
			
			The start sequence number in the BA frame
*/
#define TX_FES_STATUS_6_BA_START_SEQ_NUM_OFFSET                      0x00000018
#define TX_FES_STATUS_6_BA_START_SEQ_NUM_LSB                         16
#define TX_FES_STATUS_6_BA_START_SEQ_NUM_MASK                        0x0fff0000

/* Description		TX_FES_STATUS_6_RESERVED_6B
			
			0
*/
#define TX_FES_STATUS_6_RESERVED_6B_OFFSET                           0x00000018
#define TX_FES_STATUS_6_RESERVED_6B_LSB                              28
#define TX_FES_STATUS_6_RESERVED_6B_MASK                             0xf0000000

/* Description		TX_FES_STATUS_7_BA_BITMAP_31_0
			
			The Lower 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.
*/
#define TX_FES_STATUS_7_BA_BITMAP_31_0_OFFSET                        0x0000001c
#define TX_FES_STATUS_7_BA_BITMAP_31_0_LSB                           0
#define TX_FES_STATUS_7_BA_BITMAP_31_0_MASK                          0xffffffff

/* Description		TX_FES_STATUS_8_BA_BITMAP_63_32
			
			The upper 32 bits of the 64 bit sequence number bitmap
			of the BAR frame.
*/
#define TX_FES_STATUS_8_BA_BITMAP_63_32_OFFSET                       0x00000020
#define TX_FES_STATUS_8_BA_BITMAP_63_32_LSB                          0
#define TX_FES_STATUS_8_BA_BITMAP_63_32_MASK                         0xffffffff

/* Description		TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH
			
			Indicates the bandwidth used to transmit the Medium
			protection frame. Only valid when field 'Medium_Prot_type'
			indicates
			
			0: 20 MHz
			
			1: 40 MHz
			
			2: 80 MHz
			
			3: 160 MHz (Not supported in WiFi 1.0)
*/
#define TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH_OFFSET                 0x00000024
#define TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH_LSB                    0
#define TX_FES_STATUS_9_MEDIUM_PROT_BANDWIDTH_MASK                   0x00000003

/* Description		TX_FES_STATUS_9_PACKET_BW
			
			Indicates the bandwidth used to transmit data packet or
			self gen(non medium protection) frame.  Only valid if the
			packet bit is also set.
			
			0: 20 MHz
			
			1: 40 MHz
			
			2: 80 MHz
			
			3: 160 MHz (Not supported in WiFi 1.0)
*/
#define TX_FES_STATUS_9_PACKET_BW_OFFSET                             0x00000024
#define TX_FES_STATUS_9_PACKET_BW_LSB                                2
#define TX_FES_STATUS_9_PACKET_BW_MASK                               0x0000000c

/* Description		TX_FES_STATUS_9_RESERVED_9
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_9_RESERVED_9_OFFSET                            0x00000024
#define TX_FES_STATUS_9_RESERVED_9_LSB                               4
#define TX_FES_STATUS_9_RESERVED_9_MASK                              0xfffffff0

/* Description		TX_FES_STATUS_10_PROT_TIMESTAMP
			
			Global timer value at start of Protection transmission
*/
#define TX_FES_STATUS_10_PROT_TIMESTAMP_OFFSET                       0x00000028
#define TX_FES_STATUS_10_PROT_TIMESTAMP_LSB                          0
#define TX_FES_STATUS_10_PROT_TIMESTAMP_MASK                         0xffffffff

/* Description		TX_FES_STATUS_11_PPDU_TIMESTAMP
			
			Global timer value at start of PPDU transmission
*/
#define TX_FES_STATUS_11_PPDU_TIMESTAMP_OFFSET                       0x0000002c
#define TX_FES_STATUS_11_PPDU_TIMESTAMP_LSB                          0
#define TX_FES_STATUS_11_PPDU_TIMESTAMP_MASK                         0xffffffff

/* Description		TX_FES_STATUS_12_PROT_RESP_SIFS_TIMING
			
			Number of 80Mhz clock cycles counted between RTS and CTS
			frames. Only valid if this protection was enabled
*/
#define TX_FES_STATUS_12_PROT_RESP_SIFS_TIMING_OFFSET                0x00000030
#define TX_FES_STATUS_12_PROT_RESP_SIFS_TIMING_LSB                   0
#define TX_FES_STATUS_12_PROT_RESP_SIFS_TIMING_MASK                  0x00000fff

/* Description		TX_FES_STATUS_12_PPDU_RESP_SIFS_TIMING
			
			Number of 80Mhz clock cycles counted between main PPDU
			frame and response frame (ACK or BA). Only valid if this
			kind of response is expected
*/
#define TX_FES_STATUS_12_PPDU_RESP_SIFS_TIMING_OFFSET                0x00000030
#define TX_FES_STATUS_12_PPDU_RESP_SIFS_TIMING_LSB                   12
#define TX_FES_STATUS_12_PPDU_RESP_SIFS_TIMING_MASK                  0x00fff000

/* Description		TX_FES_STATUS_12_RESERVED_12
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_12_RESERVED_12_OFFSET                          0x00000030
#define TX_FES_STATUS_12_RESERVED_12_LSB                             24
#define TX_FES_STATUS_12_RESERVED_12_MASK                            0xff000000

/* Description		TX_FES_STATUS_13_RTT_INFO
			
			Format defined in MAC_PHY interface
*/
#define TX_FES_STATUS_13_RTT_INFO_OFFSET                             0x00000034
#define TX_FES_STATUS_13_RTT_INFO_LSB                                0
#define TX_FES_STATUS_13_RTT_INFO_MASK                               0xffffffff

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN0_PRI20
			
			RSSI of Ack on chain 0 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_PRI20_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_PRI20_LSB                   0
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC20
			
			RSSI of Ack on chain 0 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC20_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC20_LSB                   8
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC40
			
			RSSI of Ack on chain 0 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC40_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC40_LSB                   16
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC80
			
			RSSI of Ack on chain 0 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC80_OFFSET                0x00000038
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC80_LSB                   24
#define TX_FES_STATUS_14_ACK_RSSI_CHAIN0_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN1_PRI20
			
			RSSI of Ack on chain 1 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_PRI20_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_PRI20_LSB                   0
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC20
			
			RSSI of Ack on chain 1 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC20_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC20_LSB                   8
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC40
			
			RSSI of Ack on chain 1 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC40_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC40_LSB                   16
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC80
			
			RSSI of Ack on chain 1 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC80_OFFSET                0x0000003c
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC80_LSB                   24
#define TX_FES_STATUS_15_ACK_RSSI_CHAIN1_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN2_PRI20
			
			RSSI of Ack on chain 2 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_PRI20_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_PRI20_LSB                   0
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC20
			
			RSSI of Ack on chain 2 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC20_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC20_LSB                   8
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC40
			
			RSSI of Ack on chain 2 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC40_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC40_LSB                   16
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC80
			
			RSSI of Ack on chain 2 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC80_OFFSET                0x00000040
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC80_LSB                   24
#define TX_FES_STATUS_16_ACK_RSSI_CHAIN2_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_17_ACK_RSSI_CHAIN3_PRI20
			
			RSSI of Ack on chain 3 of primary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_PRI20_OFFSET                0x00000044
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_PRI20_LSB                   0
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_PRI20_MASK                  0x000000ff

/* Description		TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC20
			
			RSSI of Ack on chain 3 of secondary 20 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC20_OFFSET                0x00000044
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC20_LSB                   8
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC20_MASK                  0x0000ff00

/* Description		TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC40
			
			RSSI of Ack on chain 3 of secondary 40 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC40_OFFSET                0x00000044
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC40_LSB                   16
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC40_MASK                  0x00ff0000

/* Description		TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC80
			
			RSSI of Ack on chain 3 of secondary 80 MHz bandwidth. 
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC80_OFFSET                0x00000044
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC80_LSB                   24
#define TX_FES_STATUS_17_ACK_RSSI_CHAIN3_SEC80_MASK                  0xff000000

/* Description		TX_FES_STATUS_18_ACK_RSSI_AVE
			
			RSSI of Ack of all active chains and bandwidths.
			
			Value of 0x80 indicates invalid.
*/
#define TX_FES_STATUS_18_ACK_RSSI_AVE_OFFSET                         0x00000048
#define TX_FES_STATUS_18_ACK_RSSI_AVE_LSB                            0
#define TX_FES_STATUS_18_ACK_RSSI_AVE_MASK                           0x000000ff

/* Description		TX_FES_STATUS_18_RESERVED_18
			
			Generator should set to 0, consumer shall ignore. 
			<legal 0>
*/
#define TX_FES_STATUS_18_RESERVED_18_OFFSET                          0x00000048
#define TX_FES_STATUS_18_RESERVED_18_LSB                             8
#define TX_FES_STATUS_18_RESERVED_18_MASK                            0xffffff00

/* Description		TX_FES_STATUS_19_PHY_TIMESTAMP_1
			
			The PHY timestamp in the AMPI of the most recent rising
			edge of rx_clear_pri.  This field should set to 0 by the PHY
			and should be updated by the AMPI before being forwarded to
			the rest of the MAC.
*/
#define TX_FES_STATUS_19_PHY_TIMESTAMP_1_OFFSET                      0x0000004c
#define TX_FES_STATUS_19_PHY_TIMESTAMP_1_LSB                         0
#define TX_FES_STATUS_19_PHY_TIMESTAMP_1_MASK                        0xffffffff

/* Description		TX_FES_STATUS_20_PHY_TIMESTAMP_2
			
			The PHY timestamp in the AMPI of the rising edge of
			rx_clear_pri prior to the one reported in phy_timestamp_1. 
			This field should set to 0 by the PHY and should be updated
			by the AMPI before being forwarded to the rest of the MAC.
*/
#define TX_FES_STATUS_20_PHY_TIMESTAMP_2_OFFSET                      0x00000050
#define TX_FES_STATUS_20_PHY_TIMESTAMP_2_LSB                         0
#define TX_FES_STATUS_20_PHY_TIMESTAMP_2_MASK                        0xffffffff


#endif // _TX_FES_STATUS_H_
