/*
 * ambhw/adc.h
 *
 * History:
 *	2006/12/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2006-2008, Ambarella, Inc.
 */

#ifndef __AMBHW__ADC__
#define __AMBHW__ADC__

#include <ambhw/chip.h>
#include <ambhw/busaddr.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/

#if (CHIP_REV == A1)
#define	ADC_MAX_RESOLUTION	8
#elif (CHIP_REV == A2) || (CHIP_REV == A3) ||	\
      (CHIP_REV == A2S) || (CHIP_REV == A2M) || (CHIP_REV == A2Q) || \
      (CHIP_REV == A5S) || (CHIP_REV == A5L)
#define	ADC_MAX_RESOLUTION	10
#elif (CHIP_REV == A7)  || (CHIP_REV == I1) || (CHIP_REV == A7L)
#define	ADC_MAX_RESOLUTION	12
#else
#define	ADC_MAX_RESOLUTION	16
#endif

#if (CHIP_REV == A5) || (CHIP_REV == A6) || (CHIP_REV == A7L)
#define ADC_NUM_CHANNELS	8
#elif (CHIP_REV == A7)
#define ADC_NUM_CHANNELS	6
#elif (CHIP_REV == I1)
#define ADC_NUM_CHANNELS	10
#else
#define ADC_NUM_CHANNELS	4
#endif

#if (CHIP_REV == A5) || (CHIP_REV == A6) || (CHIP_REV == A5S) || \
    (CHIP_REV == A7) || (CHIP_REV == I1) || (CHIP_REV == A7L)	
#define ADC_SUPPORT_THRESHOLD_INT	1
#else
#define ADC_SUPPORT_THRESHOLD_INT	0
#endif

#if (CHIP_REV == A7) 
#define ADC_SUPPORT_GYRO_MODE		1
#else
#define ADC_SUPPORT_GYRO_MODE		0
#endif

#if (CHIP_REV == I1)
#define ADC_SUPPORT_THERMAL_		1
#else
#define ADC_SUPPORT_THERMAL_		0
#endif

/****************************************************/
/* Controller registers definitions                 */
/****************************************************/

#define ADC_CONTROL_OFFSET		0x00

#if (CHIP_REV == A5S) || (CHIP_REV == A5L)
#define ADC_DATA0_OFFSET		0x10
#define ADC_DATA1_OFFSET		0x04
#define ADC_DATA2_OFFSET		0x08
#define ADC_DATA3_OFFSET		0x0c
#else 
#define ADC_DATA0_OFFSET		0x04
#define ADC_DATA1_OFFSET		0x08
#define ADC_DATA2_OFFSET		0x0c
#define ADC_DATA3_OFFSET		0x10
#endif

#define ADC_RESET_OFFSET		0x14
#define ADC_COUNTER_OFFSET		0x14	/* A7, I1 */
#define ADC_ENABLE_OFFSET		0x18
#define ADC_CHAN0_INTR_OFFSET		0x44
#define ADC_CHAN1_INTR_OFFSET		0x48
#define ADC_CHAN2_INTR_OFFSET		0x4c
#define ADC_CHAN3_INTR_OFFSET		0x50

#if (CHIP_REV == I1) || (CHIP_REV == A7L) 
#define ADC_DATA4_OFFSET		0x100
#define ADC_DATA5_OFFSET		0x104
#define ADC_DATA6_OFFSET		0x108
#define ADC_DATA7_OFFSET		0x10c
#define ADC_CHAN4_INTR_OFFSET		0x110
#define ADC_CHAN5_INTR_OFFSET		0x114
#define ADC_CHAN6_INTR_OFFSET		0x118
#define ADC_CHAN7_INTR_OFFSET		0x11c
#else
#define ADC_DATA4_OFFSET		0x54
#define ADC_DATA5_OFFSET		0x58
#define ADC_DATA6_OFFSET		0x5c
#define ADC_DATA7_OFFSET		0x60
#define ADC_CHAN4_INTR_OFFSET		0x64
#define ADC_CHAN5_INTR_OFFSET		0x68
#define ADC_CHAN6_INTR_OFFSET		0x6c
#define ADC_CHAN7_INTR_OFFSET		0x70
#endif

#define ADC_DATA8_OFFSET		0x60
#define ADC_DATA9_OFFSET		0x70
#define ADC_CHAN8_INTR_OFFSET		0x120
#define ADC_CHAN9_INTR_OFFSET		0x124
#define ADC_THERMAL_DATA_OFFSET		0x128
#define ADC_THERMAL_INTR_OFFSET		0x12c

/* A7 */
#define ADC_DATA4_SAMPLE0_OFFSET	0x60
#define ADC_DATA4_SAMPLE1_OFFSET	0x64
#define ADC_DATA4_SAMPLE2_OFFSET	0x68
#define ADC_DATA4_SAMPLE3_OFFSET	0x6c
#define ADC_DATA5_SAMPLE0_OFFSET	0x70
#define ADC_DATA5_SAMPLE1_OFFSET	0x74
#define ADC_DATA5_SAMPLE2_OFFSET	0x78
#define ADC_DATA5_SAMPLE3_OFFSET	0x5c

#define ADC_CONTROL_REG			ADC_REG(ADC_CONTROL_OFFSET)
#define ADC_RESET_REG			ADC_REG(ADC_RESET_OFFSET)
#define ADC_COUNTER_REG			ADC_REG(ADC_COUNTER_OFFSET) 
#define ADC_ENABLE_REG			ADC_REG(ADC_ENABLE_OFFSET)

#define ADC_DATA0_REG			ADC_REG(ADC_DATA0_OFFSET)
#define ADC_DATA1_REG			ADC_REG(ADC_DATA1_OFFSET)
#define ADC_DATA2_REG			ADC_REG(ADC_DATA2_OFFSET)
#define ADC_DATA3_REG			ADC_REG(ADC_DATA3_OFFSET)
#define ADC_DATA4_REG			ADC_REG(ADC_DATA4_OFFSET)
#define ADC_DATA5_REG			ADC_REG(ADC_DATA5_OFFSET)
#define ADC_DATA6_REG			ADC_REG(ADC_DATA6_OFFSET)
#define ADC_DATA7_REG			ADC_REG(ADC_DATA7_OFFSET)
#define ADC_DATA8_REG			ADC_REG(ADC_DATA8_OFFSET)
#define ADC_DATA9_REG			ADC_REG(ADC_DATA9_OFFSET)

#define ADC_CHAN0_INTR_REG		ADC_REG(ADC_CHAN0_INTR_OFFSET)
#define ADC_CHAN1_INTR_REG		ADC_REG(ADC_CHAN1_INTR_OFFSET)
#define ADC_CHAN2_INTR_REG		ADC_REG(ADC_CHAN2_INTR_OFFSET)
#define ADC_CHAN3_INTR_REG		ADC_REG(ADC_CHAN3_INTR_OFFSET)
#define ADC_CHAN4_INTR_REG		ADC_REG(ADC_CHAN4_INTR_OFFSET)
#define ADC_CHAN5_INTR_REG		ADC_REG(ADC_CHAN5_INTR_OFFSET)
#define ADC_CHAN6_INTR_REG		ADC_REG(ADC_CHAN6_INTR_OFFSET)
#define ADC_CHAN7_INTR_REG		ADC_REG(ADC_CHAN7_INTR_OFFSET)
#define ADC_CHAN8_INTR_REG		ADC_REG(ADC_CHAN8_INTR_OFFSET)
#define ADC_CHAN9_INTR_REG		ADC_REG(ADC_CHAN9_INTR_OFFSET)

#define ADC_DATA4_SAMPLE0_REG		ADC_REG(ADC_DATA4_SAMPLE0_OFFSET)
#define ADC_DATA4_SAMPLE1_REG		ADC_REG(ADC_DATA4_SAMPLE1_OFFSET)
#define ADC_DATA4_SAMPLE2_REG		ADC_REG(ADC_DATA4_SAMPLE2_OFFSET)
#define ADC_DATA4_SAMPLE3_REG		ADC_REG(ADC_DATA4_SAMPLE3_OFFSET)
#define ADC_DATA5_SAMPLE0_REG		ADC_REG(ADC_DATA5_SAMPLE0_OFFSET)
#define ADC_DATA5_SAMPLE1_REG		ADC_REG(ADC_DATA5_SAMPLE1_OFFSET)
#define ADC_DATA5_SAMPLE2_REG		ADC_REG(ADC_DATA5_SAMPLE2_OFFSET)
#define ADC_DATA5_SAMPLE3_REG		ADC_REG(ADC_DATA5_SAMPLE3_OFFSET)

#define ADC_THERMAL_DATA_REG		ADC_REG(ADC_THERMAL_DATA_OFFSET)
#define ADC_THERMAL_INTR_REG		ADC_REG(ADC_THERMAL_INTR_OFFSET)

/* ADC_CONTROL_REG */
#define ADC_CONTROL_GYRO_OVERSAMPLE(x)	(((x) & 0x3) << 4)
#define ADC_CONTROL_GYRO_SAMPLE_MODE	0x08
#define ADC_CONTROL_MODE		0x04
#define ADC_CONTROL_START		0x02
#define ADC_CONTROL_STATUS		0x01

#if (CHIP_REV == A5)
#define ADC_HI_THRESHOLD_EN		(0x1 << 21)
#define ADC_LO_THRESHOLD_EN		(0x1 << 20)
#else 
#define ADC_HI_THRESHOLD_EN		(0x1 << 31)
#define ADC_LO_THRESHOLD_EN		(0x1 << 30)
#endif

#define ADC_THRESHOLD_INT_HI		1
#define ADC_THRESHOLD_INT_LO		0

#if (CHIP_REV == A5)
#define ADC_VAL_HI(x)			((x) << 10)
#else
#define ADC_VAL_HI(x)			((x) << 15)
#endif

#endif

