/*
 * tlv320dac31.c  ----  DAC3100 ALSA Soc Audio Driver
 *
 * History:
 *      2012/05/03 - [ Johnson Diao ] created file
 *
 * Copyright (C) 2004-2012, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef _DAC31_H
#define _DAC31_H

/* dac31 register space */
#define DAC31_CACHEREGNUM  256

/* 8 bit mask value */
#define dac3100_8BITS_MASK              0xFF

/* Serial data bus uses I2S mode (Default mode) */
#define dac3100_I2S_MODE				0x00
#define dac3100_DSP_MODE				0x01
#define dac3100_RIGHT_JUSTIFIED_MODE	0x02
#define dac3100_LEFT_JUSTIFIED_MODE	0x03

/* Audio data word length = 16-bits (default setting) */
#define dac3100_WORD_LEN_16BITS		0x00
#define dac3100_WORD_LEN_20BITS		0x01
#define dac3100_WORD_LEN_24BITS		0x02
#define dac3100_WORD_LEN_32BITS		0x03

#define ENABLE_DAC				(0x03 << 6)
#define ENABLE_NDAC				(0x01 << 7)
#define ENABLE_MDAC				(0x01 << 7)
#define ENABLE_BCLK				(0x01 << 7)

/* shift value for CLK_REG_3 register */
#define CLK_REG_3_SHIFT					6
/* shift value for DAC_OSR_MSB register */
#define DAC_OSR_MSB_SHIFT				4
/* number of codec specific register for configuration */
#define NO_FEATURE_REGS     			2

/* ****************** Page 0 Registers **************************************/
/* Page select register */
#define	PAGE_SELECT			    0

/* Software reset register */
#define	RESET				    1

/* OT FLAG register */
#define OT_FLAG				    3

/* CLOCK-GEN MUXING */
#define	CLK_REG_1			    4

/* PLL P,R VALUE*/
#define	CLK_REG_2			    5

/* PLL J VALUE */
#define	CLK_REG_3			    6

/* PLL D-VALUE MSB */
#define	CLK_REG_4			    7

/* PLL D-VALUE LSB */
#define	CLK_REG_5			    8

/* DAC NDAC_VALUE */
#define	NDAC_CLK_REG_6		        11

/* DAC MDAC_VALUE */
#define	MDAC_CLK_REG_7		        12

/* DAC DOSR_VAL MSB */
#define DAC_OSR_MSB	13

/* DAC DOSR_VAL LSB */
#define DAC_OSR_LSB	14

/* CLKOUT MUX */
#define CLK_MUX_REG_9	25

/* clkout m_val */
#define CLK_REG_10	26

/* codec interface control 1 */
#define INTERFACE_SET_REG_1	27

/* DATA-SLOT AFFSET  */
#define AIS_REG_2	28

/* CODEC INTERFACE CONTROL 2 */
#define AIS_REG_3	29

/* BCLK N_VAL */
#define CLK_REG_11	30

/* CODEC SECONDARY INTERFACE CONTROL 1 */
#define AIS_REG_4	31

/* CODEC SECONDARY INTERFACE CONTROL 2 */
#define AIS_REG_5	32

/* CODEC SECONDARY INTERFACE CONTROL 3 */
#define AIS_REG_6	33

/* I2C BUS CONDITION */
#define I2C_FLAG	34

/* DAC FLAG REGISTER 1 */
#define DAC_FLAG_1	37

/* DAC FLAG REGISTER 2*/
#define DAC_FLAG_2	38

/* overflow flags */
#define OVERFLOW_FLAG	39

/* DAC INTERRUPT FLAG STICKY BITS*/
#define	INTR_FLAG_1	44

/* DAC INTERRUPT FLAG  */
#define INTR_FLAG_2	46

/* INT1 CONTROL REGISTER */
#define	INT1_CTRL	48

/* INT2 CONTROL REGISTER */
#define INT2_CTRL	49

/* GPIO1 PIN CONTROL */
#define GPIO1_CTRL	51

/* DIN CONTROL */
#define DIN_CTL	54

/* DAC PROCESS BLOCK SELECTION */
#define DAC_INSTRUCTION_SET	60

/* DAC DATA-PATH SETUP */
#define DAC_CHN_REG	63

/* DAC VOLUME CONTROL */
#define DAC_MUTE_CTRL_REG	64

/* DAC LEFT VOLUME CONTROL */
#define LDAC_VOL	65

/* DAC RIGHT VOLUME CONTROL */
#define RDAC_VOL	66

/* HEADSET DETECTION */
#define HS_DETECT	67

/* DRC CONTROL 1 */
#define DRC_CTRL_1	68

/* DRC CONTROL 2 */
#define DRC_CTRL_2	69

/* DRC CONTROL 3 */
#define DRC_CTRL_3	70

/* LEFT BEEP GENERATOR */
#define BEEP_GEN_L	71

/* RIGHT BEEP GENERATOR */
#define BEEP_GEN_R	72

/* BEEP LENGTH MSB */
#define BEEP_LEN_MSB	73

/* BEEP LENGHT MIDDLE BITS */
#define BEEP_LEN_MID 74

/* BEEP LENGHT LSB */
#define BEEP_LEN_LSB	75

/* BEEP SIN MSB */
#define BEEP_SINX_MSB	76

/* BEEP SIN LSB */
#define BEEP_SINX_LSB	77

/* BEEP COS MSB */
#define BEEP_COSX_MSB	78

/* BEEP COS LSB */
#define BEEP_COSX_LSB	79

/* VOL/MICDET PIN SAR ADC-VOLUME CONTROL */
#define VOL_MICDECT_ADC	116

/* VOL/MICDET-PIN GAIN */
#define VOL_MICDECT_GAIN	117

/****************************PAGE 1 *******************/
#define PAGE_1				        128
/* headphone and speaker amplifier error control  */
#define DAC31_HPSPERR	(PAGE_1 + 30)

/* HEADPHONE DRIVER  */
#define	HPHONE_DRIVERS	(PAGE_1 +31)

/* CLASS-D SPEAKER AMPLIFIER */
#define CLASS_D_SPK	(PAGE_1 +32)

/* HP OUTPUT DRIVE POP REMOVAL SET */
#define HP_OUT_DRIVERS		(PAGE_1 +33)

/* OUTPUT DRIVER PGA RAMP-DOWN PERIOD CONTROL  */
#define PGA_RAMP	(PAGE_1 +34)

/* DAC_L DAC_R OUT MIXER */
#define DAC_MIXER_ROUTING	(PAGE_1 +35)

/* LEFT ANALOG VOL TO HPL */
#define LEFT_ANALOG_HPL	(PAGE_1 +36)

/* RIGHT ANALOG VOL TO HPR */
#define RIGHT_ANALOG_HPR	(PAGE_1 +37)

/* LEFT ANALOG VOL TO SPK */
#define LEFT_ANALOG_SPL	(PAGE_1 +38)

/* HPL DRIVER */
#define HPL_DRIVER	(PAGE_1 +40)

/* HPR DRIVER */
#define HPR_DRIVER	(PAGE_1 +41)

/* class-d speaker driver */
#define SPL_DRIVER	(PAGE_1 +42)

/* HP DRIVER */
#define HP_DRIVER_CONTROL	(PAGE_1 +44)

/* micbias */
#define	MICBIAS_CTRL	(PAGE_1 +46)

/* INPUT CM SETTING */
#define MICPGA_CM	(PAGE_1 +50)

/*************************************** PAGE 3 ********************************************/
#define PAGE_3				        (128 * 3)
/* TIME CLOCK MCLK */
#define	TIMER_MCLK_DIV	(PAGE_3+16)
/************************************** PAGE 8 ********************************************/
#define	PAGE_8   (128*8)
#define DAC31_COERAM (PAGE_8 + 1)

#define DAC31_REG_END  (-1)

/*
 *----------------------------------------------------------------------------
 * @struct  dac3100_configs |
 *          dac3100 initialization data which has register offset and register
 *          value.
 * @field   u16 | reg_offset |
 *          dac3100 Register offsets required for initialization..
 * @field   u8 | reg_val |
 *          value to set the dac3100 register to initialize the dac3100
 *----------------------------------------------------------------------------
 */
struct dac3100_configs {
	u8 reg_offset;
	u8 reg_val;
};


/*
 *----------------------------------------------------------------------------
 * @struct  dac3100_rate_divs |
 *          Setting up the values to get different freqencies
 *
 * @field   u32 | mclk |
 *          Master clock
 * @field   u32 | rate |
 *          sample rate
 * @field   u8 | p_val |
 *          value of p in PLL
 * @field   u32 | pll_j |
 *          value for pll_j
 * @field   u32 | pll_d |
 *          value for pll_d
 * @field   u32 | dosr |
 *          value to store dosr
 * @field   u32 | ndac |
 *          value for ndac
 * @field   u32 | mdac |
 *          value for mdac
 * @field   u32 | blck_N |
 *          value for block N
 * @field   u32 | aic3254_configs |
 *          configurations for dac3100 register value
 *----------------------------------------------------------------------------
 */
struct dac3100_rate_divs {
	u32 mclk;
	u32 rate;
	u8 p_val;
	u8 pll_j;
	u16 pll_d;
	u16 dosr;
	u8 ndac;
	u8 mdac;
	u8 blck_N;
	struct dac3100_configs codec_specific_regs[NO_FEATURE_REGS];
};



#endif



