/******************************************************************************
*
* Copyright (C) 2014 Hisilicon Technologies Co., Ltd.  All rights reserved. 
*
* This program is confidential and proprietary to Hisilicon  Technologies Co., Ltd. (Hisilicon), 
* and may not be copied, reproduced, modified, disclosed to others, published or used, in
* whole or in part, without the express prior written permission of Hisilicon.
*
******************************************************************************
File Name	    : hi_jpeg_api.h
Version		    : Initial Draft
Author		    : 
Created		    : 2014/06/20
Description	    : The user will use this api to realize some function
Function List 	: 

			  		  
History       	:
Date				Author        		Modification
2014/06/20		    y00181162  		    Created file      	
******************************************************************************/

#ifndef __HI_JPEG_API_H__
#define __HI_JPEG_API_H__


/*********************************add include here******************************/

#include "jpeglib.h"
#include "hi_type.h"

/*****************************************************************************/


#ifdef __cplusplus
#if __cplusplus
   extern "C" 
{
#endif
#endif /* __cplusplus */


     /***************************** Macro Definition ******************************/
	 /** \addtogroup	  JPEG */
	 /** @{ */	/** <!--[JPEG]*/

	 /** Maximum number of data components */
	 /** CNcomment:ݷ CNend */
     #define MAX_PIXEL_COMPONENT_NUM            3
	 /** Maximum column number of hor coef */
	 /** CNcomment:ˮƽϵ CNend */
     #define MAX_HORCOEF_COL                     8
	 /** Maximum row number of hor coef */
	 /** CNcomment:ˮƽϵ CNend */
     #define MAX_HORCOEF_ROW                     4
	 /** Maximum column number of ver coef */
	 /** CNcomment:ֱϵ CNend */
	 #define MAX_VERCOEF_COL                     4
	 /** Maximum row number of ver coef */
	 /** CNcomment:ֱϵ CNend */
     #define MAX_VERCOEF_ROW                     4
	 /** Maximum column number of csc coef */
	 /** CNcomment:cscϵ CNend */
	 #define MAX_CSCCOEF_COL                     3
	 /** Maximum row number of csc coef */
	 /** CNcomment:cscϵ CNend */
     #define MAX_CSCCOEF_ROW                     3

     /** @} */  /** <!-- ==== Macro Definition end ==== */

	 /*************************** Enum Definition ****************************/
    /****************************************************************************/
	/*							   jpeg enum    					            */
	/****************************************************************************/
	
	/** \addtogroup	  JPEG */
	/** @{ */	/** <!--[JPEG]*/

	/** enum of the input jpeg color space */
    /** CNcomment:jpegͼƬʽ CNend */
	typedef enum hiHI_JPEG_FMT_E
	{
		JPEG_FMT_YUV400	    = 0,   /**< yuv400     */
		JPEG_FMT_YUV420	    = 1,   /**< yuv420     */
		JPEG_FMT_YUV422_21    = 2,   /**< yuv422_21  */
		JPEG_FMT_YUV422_12    = 3,   /**< yuv422_12  */
		JPEG_FMT_YUV444	    = 4,   /**< yuv444     */
		JPEG_FMT_YCCK   	    = 5,   /**< YCCK       */
		JPEG_FMT_CMYK   	    = 6,   /**< CMYK       */
		JPEG_FMT_BUTT	
	}HI_JPEG_FMT_E;

	/** enum of mem check type */
    /** CNcomment:ڴʣж CNend */
	typedef enum hiHI_JPEG_MEMCHECK_E
	{
		JPEG_MEMCHECK_MEMSIZE    = 0,   /**< ڴС   */
		JPEG_MEMCHECK_RESOLUTION = 1,   /**< ֱ     */
		JPEG_MEMCHECK_BUTT	
	}HI_JPEG_MEMCHECK_E;

    /** @} */  /** <!-- ==== enum Definition end ==== */
	
	/*************************** Structure Definition ****************************/
    /****************************************************************************/
	/*							   jpeg api structure    					    */
	/****************************************************************************/
	
	/** \addtogroup	  JPEG */
	/** @{ */	/** <!--[JPEG]*/

	/** Structure of Rectangle */
    /** CNcomment: CNend */
	typedef struct hiJPEG_RECT_S
	{
		HI_S32 x, y;
		HI_S32 w, h;
	}HI_JPEG_RECT_S;

	/** Structure of the output yuvsp/rgb/yuv package message, only support 1/2/4/8/ scale */
	/** CNcomment:yuvsp/rgb/yuv pacekage Ϣֻ֧1/2/4/8 CNend */
	typedef struct hiJPEG_SURFACE_S
	{
		 HI_CHAR* pOutPhy[MAX_PIXEL_COMPONENT_NUM];        /**< output physic address,0 is luminance or rgb buf, 1 is chroma buf    *//**<CNcomment:ַ0yrgbַ1Ϊɫȵַ CNend     */
		 HI_CHAR* pOutVir[MAX_PIXEL_COMPONENT_NUM];        /**< output virtual address,0 is luminance or rgb buf, 1 is chroma buf   *//**<CNcomment:ַ0yrgbַ1Ϊɫȵַ CNend     */
		 HI_U32   u32OutStride[MAX_PIXEL_COMPONENT_NUM];   /**< output stride                     *//**<CNcomment:м CNend      */
         HI_BOOL  bUserPhyMem;                             /**< if use user physic memeory         *//**<CNcomment:Ƿʹûڴ CNend  */
	
	}HI_JPEG_SURFACE_S;
	
	/** Structure of the output message */
	/** CNcomment:Ϣ CNend */
	typedef struct hiJPEG_SURFACE_DESCRIPTION_S
	{
		 HI_JPEG_SURFACE_S	 stOutSurface; /**< output  surface   *//**<CNcomment:Ϣ CNend       */
		 HI_JPEG_RECT_S      stCropRect;   /**< output crop size  *//**<CNcomment:ü CNend   */
		 HI_BOOL bCrop;                    /**<  if crop           *//**<CNcomment:Ƿü CNend      */
	}HI_JPEG_SURFACE_DESCRIPTION_S;


	/** Structure of output argb sampler and filte message */
	/** CNcomment:argb˲Ϣ CNend */
    typedef struct hiJPEG_DEC_COEF_S
    {
        HI_BOOL bEnHorMedian;                                  /**< if set hor median filter           *//**<CNcomment:Ƿˮƽֵ˲ CNend        */
		HI_BOOL bEnVerMedian;                                  /**< if set ver median filter           *//**<CNcomment:Ƿֱֵ˲ CNend        */
        HI_BOOL bSetHorSampleCoef;                             /**< if set hor sample coef            *//**<CNcomment:Ƿˮƽ CNend    */
		HI_BOOL bSetVerSampleCoef;                             /**< if set ver sample coef            *//**<CNcomment:Ƿôֱ CNend    */
		HI_BOOL bSetCSCCoef;                                   /**< if set csc coef                    *//**<CNcomment:ǷCSC CNend         */
		HI_S16  s16HorCoef[MAX_HORCOEF_ROW][MAX_HORCOEF_COL];  /**< set chrome hor sampler coefficient  *//**<CNcomment:ɫϲˮƽ˲ϵ CNend */
		HI_S16  s16VerCoef[MAX_VERCOEF_ROW][MAX_VERCOEF_COL];  /**< set chrome ver sampler coefficient  *//**<CNcomment:ɫϲֱ˲ϵ CNend */
		HI_S16  s16CSCCoef[MAX_CSCCOEF_ROW][MAX_CSCCOEF_COL];  /**< set csc coefficient                 *//**<CNcomment:ɫռתϵ CNend       */
    }HI_JPEG_DEC_COEF_S;


	/** Structure of the input and output jpeg width and height,input jpeg format */
	/** CNcomment:jpegļԭʼСԼСԭʼͼƬʽ CNend */
	typedef struct hiJPEG_INFO_S
	{
	     HI_U32  u32Width[MAX_PIXEL_COMPONENT_NUM];     /**< 0 input and output rgb width and lu width,1 is ch width    *//**<CNcomment:0ͽrgbͼƬȻ߽yuvspȿȣ1Ϊɫȿ CNend */
		 HI_U32  u32Height[MAX_PIXEL_COMPONENT_NUM];    /**< 0 input and output rgb height and lu width,1 is ch height  *//**<CNcomment:0ͽrgbͼƬ߶Ȼ߽yuvspȸ߶ȣ1Ϊɫȸ߶ CNend */
		 HI_U32  u32OutStride[MAX_PIXEL_COMPONENT_NUM]; /**< 0 output rgb stride and lu stride,1 is ch stride           *//**<CNcomment:0rgbyubspм࣬1Ϊɫм CNend             */
		 HI_U32  u32OutSize[MAX_PIXEL_COMPONENT_NUM];   /**< 0 output rgb size and lu size,1 is ch size		         *//**<CNcomment:0rgbyubspĴС1ΪɫȴС CNend            			  */
		 HI_JPEG_FMT_E enFmt;  /**< the input format  *//**<CNcomment:ͼƬʽ CNend      */
		 HI_BOOL bOutInfo;     /**< false is get input information and the other get output information   *//**<CNcomment:FALSEȡϢTRUEȡϢ CNend */
	}HI_JPEG_INFO_S;


	/** Structure of the leave memsize that jpeg decode can used */
	/** CNcomment:jpegʹõڴСϢ CNend */
	typedef struct hiJPEG_MEMSIZE_INFO_S
	{
	     HI_U32  u32MemSize;      /**< the memsize  *//**<CNcomment:ʣڴС CNend */
		 HI_U32  u32Width;		   /**< limit width  *//**<CNcomment:ƿ CNend */
		 HI_U32  u32Height;		   /**< limit height *//**<CNcomment:Ƹ CNend */
		 HI_JPEG_MEMCHECK_E eCheckType; /**< limit type *//**<CNcomment:ͨ CNend */
	}HI_JPEG_MEMSIZE_INFO_S;
	
	/** @} */  /** <!-- ==== Structure Definition End ==== */
	
    /********************** Global Variable declaration **************************/
 
    /******************************* API declaration *****************************/


	/** \addtogroup	  JPEG */
	/** @{ */	/** <!--[JPEG]*/
	

	/** 
	\brief Sets dec output message. CNcomment:ýϢ CNend
	\attention \n
	HI_JPEG_SetOutDesc should have called create jpeg decoder.set the output address \n
	and output stride,set whether crop, set crop rect \n
	CNcomment:ڴ֮֮ǰøýӿڣҪýַ \n
	          м࣬ǷüԼӦĲü CNend\n

	\param[in]	cinfo. CNcomment: CNend
	\param[in]	*pstSurfaceDesc. CNcomment:Ϣ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetOutDesc
	*/
	HI_S32	HI_JPEG_SetOutDesc(const struct jpeg_decompress_struct *cinfo, const HI_JPEG_SURFACE_DESCRIPTION_S *pstSurfaceDesc);

	/** 
	\brief Get Jpeg information. CNcomment:ȡjpegͼƬϢ CNend
	\attention \n
	if you want to get input format and input width and input height,you should set bOutInfo false.\n
    others you can get the information as follows: output rgb widht/height/stride/size or output \n
    yuvsp lu width/height/stride/size and ch width/height/stride/size.\n
	you call this function should after read header and set the ouput parameter.\n
	CNcomment:bOutInfoóFALSEʱ򣬿ԻȡͼƬĿȺ͸߶ԼظʽóTRUE \n
	          ʱԻȡϢҪǽRGBȡ/߶/м/С,Ҫǽyuvsp\n
	          ԻȡȺɫȵĿ/߶/м/СϢ CNend\n

	\param[in]	cinfo. CNcomment: CNend
	\param[out]	pJpegInfo.  CNcomment:jpegϢ  CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_GetJpegInfo
	*/
	HI_S32  HI_JPEG_GetJpegInfo(j_decompress_ptr cinfo, HI_JPEG_INFO_S *pJpegInfo);


	/** 
	\brief set jpeg dec inflexion. CNcomment:Ӳֵ֧£ӲĹյ CNend
	\attention \n
	HI_JPEG_SetInflexion should have called jpeg_create_decompress.if no call this \n
	function,use the default flexion \n
	CNcomment:ڴ֮øúҪûùյ㣬ʹĬϵĹյС CNend\n

	\param[in]	cinfo. CNcomment: CNend
	\param[in]	u32flexionSize. CNcomment:ҪõĽյС CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetInflexion
	*/
	HI_S32 HI_JPEG_SetInflexion(const struct jpeg_decompress_struct *cinfo, const HI_U32 u32flexionSize);
	

	/** 
	\brief get jpeg dec inflexion. CNcomment:ȡӲĹյ CNend
	\attention \n
	HI_JPEG_GetInflexion should have called jpeg_create_decompress.\n
	CNcomment:ڵHI_JPEG_GetInflexion֮ǰѾ˽ CNend\n

	\param[in]	cinfo. CNcomment: CNend
	\param[out]	pu32flexionSize. CNcomment:յС CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetInflexion
	*/
	HI_S32 HI_JPEG_GetInflexion(const struct jpeg_decompress_struct *cinfo, HI_U32 *pu32flexionSize);
	

	/** 
	\brief set jpeg dec coef when output argb. CNcomment:ڽARGBϵ CNend
	\attention \n
	HI_JPEG_SetDecCoef should have called jpeg_create_decompress.set whether horizontal \n
	and vertical fliter,whether set horizontal and ver sample, whether set csc coefficient, \n
	and set there coefficient.if no call this function, use the default parameter. \n
	CNcomment:ڴ֮øúҪǷֱˮƽ˲Ƿôֱˮƽ \n
	          ϵǷCSSϵӦϵҪûеøúʹĬֵ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[in]	*pstDecCoef. CNcomment:ϵ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetDecCoef
	*/
	HI_S32 HI_JPEG_SetDecCoef(const struct jpeg_decompress_struct *cinfo, const HI_JPEG_DEC_COEF_S *pstDecCoef);


	/** 
	\brief get jpeg dec coef when output argb. CNcomment:ڽARGB»ȡõϵ CNend
	\attention \n
	HI_JPEG_GetDecCoef should have called HI_JPEG_SetDecCoef.\n
	CNcomment:ڵHI_JPEG_GetDecCoef֮ǰѾHI_JPEG_SetDecCoef CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[out]	pstOutDecCoef. CNcomment:ϵ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_GetDecCoef
	*/
	HI_S32 HI_JPEG_GetDecCoef(const struct jpeg_decompress_struct *cinfo, HI_JPEG_DEC_COEF_S *pstOutDecCoef);


	/** 
	\brief set alpha value. CNcomment:alphaֵ CNend
	\attention \n
	HI_JPEG_SetAlpha should have called jpeg_create_decompress.when decode output \n
	argb8888 and argb8888,we can call this function,if no call it,use the default value. \n
	CNcomment:ڴ֮øúΪARGB8888ABGR8888ʱ \n
	øúҪûеøúʹĬϵֵ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[in]	s32Alpha. CNcomment:alphaֵ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetAlpha
	*/
	HI_S32 HI_JPEG_SetAlpha(const struct jpeg_decompress_struct *cinfo, const HI_U32 u32Alpha);


	/** 
	\brief set stream from flag of use phy mem  or virtual mem. CNcomment:ڴϢ CNend
	\attention \n
	if want to use this function,should call between create decompress and 
	jpeg_stdio_src or jpeg_mem_src.if not call this we should check\n
	CNcomment:Ҫãڴ֮ǰãûеøýӿҲпڴ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[in]	pStreamPhyAddr. CNcomment:ַ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetStreamPhyMem
	*/
	 HI_S32 HI_JPEG_SetStreamPhyMem(const struct jpeg_decompress_struct *cinfo, HI_CHAR* pStreamPhyAddr);

	/** 
	\brief set stream mem information. CNcomment:ڴϢ CNend
	\attention \n
	if want to use this function,should call before call
	jpeg_stdio_src or jpeg_mem_src.if not call this we should check\n
	CNcomment:Ҫãjpeg_mem_src֮ǰ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[in]	pPhyStremBuf.         CNcomment:bufferʼַ CNend
	\param[in]	u32StremBufLen.       CNcomment:bufferС         CNend
	\param[in]	pVirSaveReturnBuf.    CNcomment:bufferʼַ CNend
	\param[in]	s32StrmReturnSize.    CNcomment:С           CNend
	\param[in]	bStreamBufNeedReturn. CNcomment:bufferǷ     CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetBufInfo
	*/
	HI_S32 HI_JPEG_SetBufInfo(const struct jpeg_decompress_struct *cinfo,HI_CHAR* pPhyStremBuf,HI_U32 u32StremBufLen, HI_CHAR* pVirSaveReturnBuf,HI_S32 s32StrmReturnSize,HI_BOOL bStreamBufNeedReturn);

	/** 
	\brief set if dec output yuv420sp. CNcomment:Ƿͳһyuv420spʶ CNend
	\attention \n
	HI_JPEG_SetYCbCr420spFlag should have called jpeg_create_decompress.\n
	CNcomment:ڵHI_JPEG_SetYCbCr420spFlag֮ǰѾ˽ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[in]	bOutYCbCr420sp. CNcomment:Ƿͳһyuv420spʽ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetYCbCr420spFlag
	*/
	HI_S32 HI_JPEG_SetYCbCr420spFlag(const struct jpeg_decompress_struct *cinfo,const HI_BOOL bOutYCbCr420sp);


	/** 
	\brief set if output lu pixle sum value. CNcomment:Ƿͳֵʶ CNend
	\attention \n
	HI_JPEG_SetLuPixSumFlag should have called jpeg_create_decompress.\n
	CNcomment:ڵHI_JPEG_SetLuPixSumFlag֮ǰѾ˽ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[in]	bLuPixSum. CNcomment:Ƿͳֵʶ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetLuPixSumFlag
	*/
	HI_S32 HI_JPEG_SetLuPixSumFlag(const struct jpeg_decompress_struct *cinfo,const HI_BOOL bLuPixSum);

	/** 
	\brief get lu pixle sum value. CNcomment:ȡֵ CNend
	\attention \n
	If you want to get the luminance value, you can call this function, \n
	but you should call it after jpeg_start_decompress and have call HI_JPEG_SetLuPixSumFlag.\n
	CNcomment:ҪõֵԵøújpeg_start_decompress֮öҽ \n
	          ֮ǰҪHI_JPEG_SetLuPixSumFlag CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[out]	u64LuPixSum. CNcomment:ֵ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_GetLuPixSum
	*/
	HI_S32 HI_JPEG_GetLuPixSum(const struct jpeg_decompress_struct *cinfo,HI_U64 *u64LuPixSum);


	/** 
	\brief get jpeg dec time. CNcomment:ȡjpegʱ CNend
	\attention \n
	If you want to know how much the decode cost time ,you can call HI_JPEG_GetDecTime, \n
	but should have called it after jpeg_finish_decompress.\n
	CNcomment:Ҫ뿴뻨˶ʱԵøúڽ֮ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[out]	pu32DecTime. CNcomment:ʱ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_GetDecTime
	*/
	HI_S32 HI_JPEG_GetDecTime(const struct jpeg_decompress_struct *cinfo, HI_U32 *pu32DecTime);


	
	/** 
	\brief set the leave memory size. CNcomment:ʣڴСԹʹ CNend
	\attention \n
	should have called it after  create jpeg decoder.\n
	CNcomment:ڴ֮ CNend\n
	
	\param[in]	cinfo. CNcomment: CNend
	\param[int] sMemSizeInfo. CNcomment:ڴϢ CNend
	
	\retval ::HI_SUCCESS 
	\retval ::HI_FAILURE
	
	\see \n
	::HI_JPEG_SetLeaveMemSize
	*/
	HI_S32 HI_JPEG_SetLeaveMemSize(const struct jpeg_decompress_struct *cinfo, HI_JPEG_MEMSIZE_INFO_S sMemSizeInfo);

	/** @} */  /** <!-- ==== API Declaration End ==== */

    /****************************************************************************/



#ifdef __cplusplus
    
#if __cplusplus
   
}
#endif
#endif /* __cplusplus */

#endif /* __HI_JPEG_API_H__*/
